/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Source;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMException;
import org.apache.xml.dtm.DTMFilter;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.dtm.DTMManager;
import org.apache.xml.dtm.DTMWSFilter;
import org.apache.xml.dtm.ref.DTMDefaultBase;
import org.apache.xml.dtm.ref.DTMNodeProxy;
import org.apache.xml.dtm.ref.ExpandedNameTable;
import org.apache.xml.dtm.ref.IncrementalSAXSource;
import org.apache.xml.dtm.ref.IncrementalSAXSource_Filter;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTM;
import org.apache.xml.dtm.ref.dom2dtm.DOM2DTMdefaultNamespaceDeclarationNode;
import org.apache.xml.dtm.ref.sax2dtm.SAX2DTM;
import org.apache.xml.dtm.ref.sax2dtm.SAX2RTFDTM;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.SuballocatedIntVector;
import org.apache.xml.utils.SystemIDResolver;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xml.utils.XMLReaderManager;
import org.apache.xml.utils.XMLStringFactory;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Node;
import org.xml.sax.ContentHandler;
import org.xml.sax.DTDHandler;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;

public class DTMManagerDefault
extends DTMManager {
    private static final boolean DUMPTREE = false;
    private static final boolean DEBUG = false;
    public DTM[] m_dtms = new DTM[256];
    public int[] a = new int[256];
    public XMLReaderManager m_readerManager = null;
    private ExpandedNameTable m_expandedNameTable = new ExpandedNameTable();

    public synchronized void addDTM(DTM dTM, int n2) {
        this.addDTM(dTM, n2, 0);
    }

    public synchronized void addDTM(DTM dTM, int n2, int n3) {
        if (n2 >= 65536) {
            throw new DTMException(XMLMessages.createXMLMessage("ER_NO_DTMIDS_AVAIL", null));
        }
        int n4 = this.m_dtms.length;
        if (n4 <= n2) {
            int n5 = Math.min(n2 + 256, 65536);
            DTM[] dTMArray = new DTM[n5];
            System.arraycopy(this.m_dtms, 0, dTMArray, 0, n4);
            this.m_dtms = dTMArray;
            int[] nArray = new int[n5];
            System.arraycopy(this.a, 0, nArray, 0, n4);
            this.a = nArray;
        }
        this.m_dtms[n2] = dTM;
        this.a[n2] = n3;
        dTM.documentRegistration();
    }

    public synchronized int getFirstFreeDTMID() {
        int n2 = this.m_dtms.length;
        int n3 = 1;
        while (n3 < n2) {
            if (null == this.m_dtms[n3]) {
                return n3;
            }
            ++n3;
        }
        return n2;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public synchronized DTM getDTM(Source source, boolean bl2, DTMWSFilter dTMWSFilter, boolean bl3, boolean bl4) {
        Object object;
        XMLReader xMLReader;
        block31: {
            Object object2;
            block30: {
                boolean bl5;
                XMLStringFactory xMLStringFactory = this.m_xsf;
                int n2 = this.getFirstFreeDTMID();
                int n3 = n2 << 16;
                if (null != source && source instanceof DOMSource) {
                    DOM2DTM dOM2DTM = new DOM2DTM((DTMManager)this, (DOMSource)source, n3, dTMWSFilter, xMLStringFactory, bl4);
                    this.addDTM(dOM2DTM, n2, 0);
                    return dOM2DTM;
                }
                boolean bl6 = null != source ? source instanceof SAXSource : true;
                boolean bl7 = bl5 = null != source ? source instanceof StreamSource : false;
                if (!bl6 && !bl5) {
                    throw new DTMException(XMLMessages.createXMLMessage("ER_NOT_SUPPORTED", new Object[]{source}));
                }
                xMLReader = null;
                try {
                    boolean bl8;
                    Object object3;
                    InputSource inputSource;
                    if (null == source) {
                        inputSource = null;
                    } else {
                        xMLReader = this.getXMLReader(source);
                        inputSource = SAXSource.sourceToInputSource(source);
                        object3 = inputSource.getSystemId();
                        if (null != object3) {
                            try {
                                object3 = SystemIDResolver.getAbsoluteURI((String)object3);
                            }
                            catch (Exception exception) {
                                System.err.println("Can not absolutize URL: " + (String)object3);
                            }
                            inputSource.setSystemId((String)object3);
                        }
                    }
                    object3 = source == null && bl2 && !bl3 && !bl4 ? new SAX2RTFDTM(this, source, n3, dTMWSFilter, xMLStringFactory, bl4) : new SAX2DTM(this, source, n3, dTMWSFilter, xMLStringFactory, bl4);
                    this.addDTM((DTM)object3, n2, 0);
                    boolean bl9 = bl8 = null != xMLReader && xMLReader.getClass().getName().equals("org.apache.xerces.parsers.SAXParser");
                    if (bl8) {
                        bl3 = true;
                    }
                    if (DTMManager.m_incremental && bl3) {
                        Object object4;
                        object = null;
                        if (bl8) {
                            try {
                                object = (IncrementalSAXSource)Class.forName("org.apache.xml.dtm.ref.IncrementalSAXSource_Xerces").newInstance();
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                                object = null;
                            }
                        }
                        if (object == null) {
                            if (null == xMLReader) {
                                object = new IncrementalSAXSource_Filter();
                            } else {
                                object4 = new IncrementalSAXSource_Filter();
                                ((IncrementalSAXSource_Filter)object4).setXMLReader(xMLReader);
                                object = object4;
                            }
                        }
                        ((SAX2DTM)object3).setIncrementalSAXSource((IncrementalSAXSource)object);
                        if (null == inputSource) {
                            object4 = object3;
                            Object var19_26 = null;
                            this.releaseXMLReader(xMLReader);
                            return object4;
                        }
                        if (null == xMLReader.getErrorHandler()) {
                            xMLReader.setErrorHandler((ErrorHandler)object3);
                        }
                        xMLReader.setDTDHandler((DTDHandler)object3);
                        try {
                            object.startParse(inputSource);
                        }
                        catch (RuntimeException runtimeException) {
                            ((SAX2DTM)object3).clearCoRoutine();
                            throw runtimeException;
                        }
                        catch (Exception exception) {
                            ((SAX2DTM)object3).clearCoRoutine();
                            throw new WrappedRuntimeException(exception);
                        }
                    }
                    if (null == xMLReader) {
                        object2 = object3;
                        break block30;
                    }
                    xMLReader.setContentHandler((ContentHandler)object3);
                    xMLReader.setDTDHandler((DTDHandler)object3);
                    if (null == xMLReader.getErrorHandler()) {
                        xMLReader.setErrorHandler((ErrorHandler)object3);
                    }
                    try {
                        xMLReader.setProperty("http://xml.org/sax/properties/lexical-handler", object3);
                    }
                    catch (SAXNotRecognizedException sAXNotRecognizedException) {
                    }
                    catch (SAXNotSupportedException sAXNotSupportedException) {
                        // empty catch block
                    }
                    try {
                        xMLReader.parse(inputSource);
                    }
                    catch (RuntimeException runtimeException) {
                        ((SAX2DTM)object3).clearCoRoutine();
                        throw runtimeException;
                    }
                    catch (Exception exception) {
                        ((SAX2DTM)object3).clearCoRoutine();
                        throw new WrappedRuntimeException(exception);
                    }
                    object = object3;
                    break block31;
                }
                catch (Throwable throwable) {
                    Object var19_29 = null;
                    this.releaseXMLReader(xMLReader);
                    throw throwable;
                }
            }
            Object var19_27 = null;
            this.releaseXMLReader(xMLReader);
            return object2;
        }
        Object var19_28 = null;
        this.releaseXMLReader(xMLReader);
        return object;
    }

    public synchronized int getDTMHandleFromNode(Node node) {
        int n2;
        Object object;
        if (null == node) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_NODE_NON_NULL", null));
        }
        if (node instanceof DTMNodeProxy) {
            return ((DTMNodeProxy)node).getDTMNodeNumber();
        }
        int n3 = this.m_dtms.length;
        int n4 = 0;
        while (n4 < n3) {
            int n5;
            object = this.m_dtms[n4];
            if (null != object && object instanceof DOM2DTM && (n5 = ((DOM2DTM)object).getHandleOfNode(node)) != -1) {
                return n5;
            }
            ++n4;
        }
        object = node;
        Node node2 = object.getNodeType() == 2 ? ((Attr)object).getOwnerElement() : object.getParentNode();
        while (node2 != null) {
            object = node2;
            node2 = node2.getParentNode();
        }
        DOM2DTM dOM2DTM = (DOM2DTM)this.getDTM(new DOMSource((Node)object), false, null, true, true);
        if (node instanceof DOM2DTMdefaultNamespaceDeclarationNode) {
            n2 = dOM2DTM.getHandleOfNode(((Attr)node).getOwnerElement());
            n2 = dOM2DTM.getAttributeNode(n2, node.getNamespaceURI(), node.getLocalName());
        } else {
            n2 = dOM2DTM.getHandleOfNode(node);
        }
        if (-1 == n2) {
            throw new RuntimeException(XMLMessages.createXMLMessage("ER_COULD_NOT_RESOLVE_NODE", null));
        }
        return n2;
    }

    public synchronized XMLReader getXMLReader(Source source) {
        try {
            XMLReader xMLReader;
            XMLReader xMLReader2 = xMLReader = source instanceof SAXSource ? ((SAXSource)source).getXMLReader() : null;
            if (null == xMLReader) {
                if (this.m_readerManager == null) {
                    this.m_readerManager = XMLReaderManager.getInstance();
                }
                xMLReader = this.m_readerManager.getXMLReader();
            }
            return xMLReader;
        }
        catch (SAXException sAXException) {
            throw new DTMException(sAXException.getMessage(), sAXException);
        }
    }

    public synchronized void releaseXMLReader(XMLReader xMLReader) {
        if (this.m_readerManager != null) {
            this.m_readerManager.releaseXMLReader(xMLReader);
        }
    }

    public synchronized DTM getDTM(int n2) {
        try {
            return this.m_dtms[n2 >>> 16];
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            if (n2 == -1) {
                return null;
            }
            throw arrayIndexOutOfBoundsException;
        }
    }

    public synchronized int getDTMIdentity(DTM dTM) {
        if (dTM instanceof DTMDefaultBase) {
            DTMDefaultBase dTMDefaultBase = (DTMDefaultBase)dTM;
            if (dTMDefaultBase.getManager() == this) {
                return dTMDefaultBase.getDTMIDs().elementAt(0);
            }
            return -1;
        }
        int n2 = this.m_dtms.length;
        int n3 = 0;
        while (n3 < n2) {
            DTM dTM2 = this.m_dtms[n3];
            if (dTM2 == dTM && this.a[n3] == 0) {
                return n3 << 16;
            }
            ++n3;
        }
        return -1;
    }

    public synchronized boolean release(DTM dTM, boolean bl2) {
        if (dTM instanceof SAX2DTM) {
            ((SAX2DTM)dTM).clearCoRoutine();
        }
        if (dTM instanceof DTMDefaultBase) {
            SuballocatedIntVector suballocatedIntVector = ((DTMDefaultBase)dTM).getDTMIDs();
            int n2 = suballocatedIntVector.size() - 1;
            while (n2 >= 0) {
                this.m_dtms[suballocatedIntVector.elementAt((int)n2) >>> 16] = null;
                --n2;
            }
        } else {
            int n3 = this.getDTMIdentity(dTM);
            if (n3 >= 0) {
                this.m_dtms[n3 >>> 16] = null;
            }
        }
        dTM.documentRelease();
        return true;
    }

    public synchronized DTM createDocumentFragment() {
        try {
            DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
            documentBuilderFactory.setNamespaceAware(true);
            DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
            Document document = documentBuilder.newDocument();
            DocumentFragment documentFragment = document.createDocumentFragment();
            return this.getDTM(new DOMSource(documentFragment), true, null, false, false);
        }
        catch (Exception exception) {
            throw new DTMException(exception);
        }
    }

    public synchronized DTMIterator createDTMIterator(int n2, DTMFilter dTMFilter, boolean bl2) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(String string, PrefixResolver prefixResolver) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(int n2) {
        return null;
    }

    public synchronized DTMIterator createDTMIterator(Object object, int n2) {
        return null;
    }

    public ExpandedNameTable getExpandedNameTable(DTM dTM) {
        return this.m_expandedNameTable;
    }
}

