/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.dtm.ref;

import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMDOMException;
import org.apache.xml.dtm.ref.DTMChildIterNodeList;
import org.apache.xml.dtm.ref.DTMNamedNodeMap;
import org.w3c.dom.Attr;
import org.w3c.dom.CDATASection;
import org.w3c.dom.Comment;
import org.w3c.dom.DOMException;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.DocumentType;
import org.w3c.dom.Element;
import org.w3c.dom.EntityReference;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.ProcessingInstruction;
import org.w3c.dom.Text;

public class DTMNodeProxy
implements Node,
Document,
Text,
Element,
Attr,
ProcessingInstruction,
Comment,
DocumentFragment {
    public DTM dtm;
    public int a;
    public static final DOMImplementation b = new DTMNodeProxyImplementation();

    public DTMNodeProxy(DTM dTM, int n2) {
        this.dtm = dTM;
        this.a = n2;
    }

    public final DTM getDTM() {
        return this.dtm;
    }

    public final int getDTMNodeNumber() {
        return this.a;
    }

    public final boolean equals(Node node) {
        try {
            DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
            return dTMNodeProxy.a == this.a && dTMNodeProxy.dtm == this.dtm;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean equals(Object object) {
        try {
            return this.equals((Node)object);
        }
        catch (ClassCastException classCastException) {
            return false;
        }
    }

    public final boolean sameNodeAs(Node node) {
        if (!(node instanceof DTMNodeProxy)) {
            return false;
        }
        DTMNodeProxy dTMNodeProxy = (DTMNodeProxy)node;
        return this.dtm == dTMNodeProxy.dtm && this.a == dTMNodeProxy.a;
    }

    public final String getNodeName() {
        return this.dtm.getNodeName(this.a);
    }

    public final String getTarget() {
        return this.dtm.getNodeName(this.a);
    }

    public final String getLocalName() {
        return this.dtm.getLocalName(this.a);
    }

    public final String getPrefix() {
        return this.dtm.getPrefix(this.a);
    }

    public final void setPrefix(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final String getNamespaceURI() {
        return this.dtm.getNamespaceURI(this.a);
    }

    public final boolean supports(String string, String string2) {
        return b.hasFeature(string, string2);
    }

    public final boolean isSupported(String string, String string2) {
        return b.hasFeature(string, string2);
    }

    public final String getNodeValue() throws DOMException {
        return this.dtm.getNodeValue(this.a);
    }

    public final String getStringValue() throws DOMException {
        return this.dtm.getStringValue(this.a).toString();
    }

    public final void setNodeValue(String string) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final short getNodeType() {
        return this.dtm.getNodeType(this.a);
    }

    public final Node getParentNode() {
        if (this.getNodeType() == 2) {
            return null;
        }
        int n2 = this.dtm.getParent(this.a);
        return n2 == -1 ? null : this.dtm.getNode(n2);
    }

    public final Node getOwnerNode() {
        int n2 = this.dtm.getParent(this.a);
        return n2 == -1 ? null : this.dtm.getNode(n2);
    }

    public final NodeList getChildNodes() {
        return new DTMChildIterNodeList(this.dtm, this.a);
    }

    public final Node getFirstChild() {
        int n2 = this.dtm.getFirstChild(this.a);
        return n2 == -1 ? null : this.dtm.getNode(n2);
    }

    public final Node getLastChild() {
        int n2 = this.dtm.getLastChild(this.a);
        return n2 == -1 ? null : this.dtm.getNode(n2);
    }

    public final Node getPreviousSibling() {
        int n2 = this.dtm.getPreviousSibling(this.a);
        return n2 == -1 ? null : this.dtm.getNode(n2);
    }

    public final Node getNextSibling() {
        if (this.dtm.getNodeType(this.a) == 2) {
            return null;
        }
        int n2 = this.dtm.getNextSibling(this.a);
        return n2 == -1 ? null : this.dtm.getNode(n2);
    }

    public final NamedNodeMap getAttributes() {
        return new DTMNamedNodeMap(this.dtm, this.a);
    }

    public boolean hasAttribute(String string) {
        return -1 != this.dtm.getAttributeNode(this.a, null, string);
    }

    public boolean hasAttributeNS(String string, String string2) {
        return -1 != this.dtm.getAttributeNode(this.a, string2, string);
    }

    public final Document getOwnerDocument() {
        return (Document)this.dtm.getNode(this.dtm.getOwnerDocument(this.a));
    }

    public final Node insertBefore(Node node, Node node2) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node replaceChild(Node node, Node node2) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node removeChild(Node node) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Node appendChild(Node node) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final boolean hasChildNodes() {
        return -1 != this.dtm.getFirstChild(this.a);
    }

    public final Node cloneNode(boolean bl2) {
        throw new DTMDOMException(9);
    }

    public final DocumentType getDoctype() {
        return null;
    }

    public final DOMImplementation getImplementation() {
        return b;
    }

    public final Element getDocumentElement() {
        int n2 = this.dtm.getDocument();
        int n3 = -1;
        int n4 = this.dtm.getFirstChild(n2);
        while (n4 != -1) {
            switch (this.dtm.getNodeType(n4)) {
                case 1: {
                    if (n3 != -1) {
                        n3 = -1;
                        n4 = this.dtm.getLastChild(n2);
                        break;
                    }
                    n3 = n4;
                    break;
                }
                case 7: 
                case 8: 
                case 10: {
                    break;
                }
                default: {
                    n3 = -1;
                    n4 = this.dtm.getLastChild(n2);
                }
            }
            n4 = this.dtm.getNextSibling(n4);
        }
        if (n3 == -1) {
            throw new DTMDOMException(9);
        }
        return (Element)this.dtm.getNode(n3);
    }

    public final Element createElement(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final DocumentFragment createDocumentFragment() {
        throw new DTMDOMException(9);
    }

    public final Text createTextNode(String string) {
        throw new DTMDOMException(9);
    }

    public final Comment createComment(String string) {
        throw new DTMDOMException(9);
    }

    public final CDATASection createCDATASection(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final ProcessingInstruction createProcessingInstruction(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr createAttribute(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final EntityReference createEntityReference(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final NodeList getElementsByTagName(String string) {
        throw new DTMDOMException(9);
    }

    public final Node importNode(Node node, boolean bl2) throws DOMException {
        throw new DTMDOMException(7);
    }

    public final Element createElementNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr createAttributeNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final NodeList getElementsByTagNameNS(String string, String string2) {
        throw new DTMDOMException(9);
    }

    public final Element getElementById(String string) {
        throw new DTMDOMException(9);
    }

    public final Text splitText(int n2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final String getData() throws DOMException {
        return this.dtm.getNodeValue(this.a);
    }

    public final void setData(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final int getLength() {
        return this.dtm.getNodeValue(this.a).length();
    }

    public final String substringData(int n2, int n3) throws DOMException {
        return this.getData().substring(n2, n2 + n3);
    }

    public final void appendData(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void insertData(int n2, String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void deleteData(int n2, int n3) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void replaceData(int n2, int n3, String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final String getTagName() {
        return this.dtm.getNodeName(this.a);
    }

    public final String getAttribute(String string) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.a);
        Node node = dTMNamedNodeMap.getNamedItem(string);
        return null == node ? null : node.getNodeValue();
    }

    public final void setAttribute(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void removeAttribute(String string) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr getAttributeNode(String string) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.a);
        return (Attr)dTMNamedNodeMap.getNamedItem(string);
    }

    public final Attr setAttributeNode(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr removeAttributeNode(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public boolean hasAttributes() {
        return -1 != this.dtm.getFirstAttribute(this.a);
    }

    public final void normalize() {
        throw new DTMDOMException(9);
    }

    public final String getAttributeNS(String string, String string2) {
        DTMNamedNodeMap dTMNamedNodeMap = new DTMNamedNodeMap(this.dtm, this.a);
        Node node = dTMNamedNodeMap.getNamedItemNS(string, string2);
        return null == node ? null : node.getNodeValue();
    }

    public final void setAttributeNS(String string, String string2, String string3) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final void removeAttributeNS(String string, String string2) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final Attr getAttributeNodeNS(String string, String string2) {
        throw new DTMDOMException(9);
    }

    public final Attr setAttributeNodeNS(Attr attr) throws DOMException {
        throw new DTMDOMException(9);
    }

    public final String getName() {
        return this.dtm.getNodeName(this.a);
    }

    public final boolean getSpecified() {
        return true;
    }

    public final String getValue() {
        return this.dtm.getNodeValue(this.a);
    }

    public final void setValue(String string) {
        throw new DTMDOMException(9);
    }

    public final Element getOwnerElement() {
        if (this.getNodeType() != 2) {
            return null;
        }
        int n2 = this.dtm.getParent(this.a);
        return n2 == -1 ? null : (Element)this.dtm.getNode(n2);
    }

    public Node adoptNode(Node node) throws DOMException {
        throw new DTMDOMException(9);
    }

    public String getEncoding() {
        throw new DTMDOMException(9);
    }

    public void setEncoding(String string) {
        throw new DTMDOMException(9);
    }

    public boolean getStandalone() {
        throw new DTMDOMException(9);
    }

    public void setStandalone(boolean bl2) {
        throw new DTMDOMException(9);
    }

    public boolean getStrictErrorChecking() {
        throw new DTMDOMException(9);
    }

    public void setStrictErrorChecking(boolean bl2) {
        throw new DTMDOMException(9);
    }

    public String getVersion() {
        throw new DTMDOMException(9);
    }

    public void setVersion(String string) {
        throw new DTMDOMException(9);
    }

    public static class DTMNodeProxyImplementation
    implements DOMImplementation {
        public DocumentType createDocumentType(String string, String string2, String string3) {
            throw new DTMDOMException(9);
        }

        public Document createDocument(String string, String string2, DocumentType documentType) {
            throw new DTMDOMException(9);
        }

        public boolean hasFeature(String string, String string2) {
            return !(!"CORE".equals(string.toUpperCase()) && !"XML".equals(string.toUpperCase()) || !"1.0".equals(string2) && !"2.0".equals(string2));
        }
    }
}

