/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.serializer;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.util.Properties;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.serializer.CharInfo;
import org.apache.xml.serializer.ElemContext;
import org.apache.xml.serializer.ElemDesc;
import org.apache.xml.serializer.Encodings;
import org.apache.xml.serializer.NamespaceMappings;
import org.apache.xml.serializer.OutputPropertiesFactory;
import org.apache.xml.serializer.OutputPropertyUtils;
import org.apache.xml.serializer.SerializerBase;
import org.apache.xml.serializer.ToStream;
import org.apache.xml.utils.Trie;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class ToHTMLStream
extends ToStream {
    public boolean m_inDTD = false;
    private boolean m_inBlockElem = false;
    public static final CharInfo m_htmlcharInfo = CharInfo.getCharInfo(CharInfo.HTML_ENTITIES_RESOURCE, "html");
    public static final Trie h = new Trie();
    private static final ElemDesc m_dummy;
    private boolean m_specialEscapeURLs = true;
    private boolean m_omitMetaTag = false;

    public void setSpecialEscapeURLs(boolean bl2) {
        this.m_specialEscapeURLs = bl2;
    }

    public void setOmitMetaTag(boolean bl2) {
        this.m_omitMetaTag = bl2;
    }

    public void setOutputFormat(Properties properties) {
        this.m_specialEscapeURLs = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}use-url-escaping", properties);
        this.m_omitMetaTag = OutputPropertyUtils.getBooleanProperty("{http://xml.apache.org/xalan}omit-meta-tag", properties);
        super.setOutputFormat(properties);
    }

    private final boolean getSpecialEscapeURLs() {
        return this.m_specialEscapeURLs;
    }

    private final boolean getOmitMetaTag() {
        return this.m_omitMetaTag;
    }

    public static final ElemDesc getElemDesc(String string) {
        Object object = h.get(string);
        if (null != object) {
            return (ElemDesc)object;
        }
        return m_dummy;
    }

    public ToHTMLStream() {
        this.m_charInfo = m_htmlcharInfo;
        this.m_prefixMap = new NamespaceMappings();
    }

    public void startDocumentInternal() throws SAXException {
        super.startDocumentInternal();
        this.m_needToCallStartDocument = false;
        this.a = true;
        this.f = false;
        this.setOmitXMLDeclaration(true);
        if (this.a) {
            String string = this.getDoctypeSystem();
            String string2 = this.getDoctypePublic();
            if (null != string || null != string2) {
                Writer writer = this.m_writer;
                try {
                    writer.write("<!DOCTYPE HTML");
                    if (null != string2) {
                        writer.write(" PUBLIC \"");
                        writer.write(string2);
                        writer.write(34);
                    }
                    if (null != string) {
                        if (null == string2) {
                            writer.write(" SYSTEM \"");
                        } else {
                            writer.write(34);
                        }
                        writer.write(string);
                        writer.write(34);
                    }
                    writer.write(62);
                    this.outputLineSep();
                }
                catch (IOException iOException) {
                    throw new SAXException(iOException);
                }
            }
        }
        this.a = false;
    }

    public final void endDocument() throws SAXException {
        this.flushPending();
        if (this.m_doIndent && !this.m_isprevtext) {
            try {
                this.outputLineSep();
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        this.flushWriter();
        if (this.m_tracer != null) {
            super.fireEndDoc();
        }
    }

    public void startElement(String string, String string2, String string3, Attributes attributes) throws SAXException {
        ElemContext elemContext = this.m_elemContext;
        if (elemContext.d) {
            this.closeStartTag();
            elemContext.d = false;
        } else if (this.m_cdataTagOpen) {
            this.closeCDATA();
            this.m_cdataTagOpen = false;
        } else if (this.m_needToCallStartDocument) {
            this.startDocumentInternal();
            this.m_needToCallStartDocument = false;
        }
        if (null != string && string.length() > 0) {
            super.startElement(string, string2, string3, attributes);
            return;
        }
        try {
            ElemDesc elemDesc = ToHTMLStream.getElemDesc(string3);
            int n2 = elemDesc.getFlags();
            if (this.m_doIndent) {
                boolean bl2;
                boolean bl3 = bl2 = (n2 & 8) != 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (null != elemContext.e && (!this.m_inBlockElem || bl2)) {
                    this.f = true;
                    this.indent();
                }
                boolean bl4 = this.m_inBlockElem = !bl2;
            }
            if (attributes != null) {
                this.addAttributes(attributes);
            }
            this.m_isprevtext = false;
            Writer writer = this.m_writer;
            writer.write(60);
            writer.write(string3);
            if (this.m_tracer != null) {
                this.firePseudoAttributes();
            }
            if ((n2 & 2) != 0) {
                this.m_elemContext = elemContext.a();
                this.m_elemContext.e = string3;
                this.m_elemContext.b = elemDesc;
                return;
            }
            this.m_elemContext = elemContext = elemContext.a(string, string2, string3);
            elemContext.b = elemDesc;
            boolean bl5 = elemContext.g = (n2 & 0x100) != 0;
            if ((n2 & 0x400000) != 0) {
                this.closeStartTag();
                elemContext.d = false;
                if (!this.m_omitMetaTag) {
                    if (this.m_doIndent) {
                        this.indent();
                    }
                    writer.write("<META http-equiv=\"Content-Type\" content=\"text/html; charset=");
                    String string4 = this.getEncoding();
                    String string5 = Encodings.getMimeEncoding(string4);
                    writer.write(string5);
                    writer.write("\">");
                }
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string, String string2, String string3) throws SAXException {
        if (this.m_cdataTagOpen) {
            this.closeCDATA();
        }
        if (null != string && string.length() > 0) {
            super.endElement(string, string2, string3);
            return;
        }
        try {
            int n2;
            boolean bl2;
            ElemContext elemContext = this.m_elemContext;
            ElemDesc elemDesc = elemContext.b;
            int n3 = elemDesc.getFlags();
            boolean bl3 = bl2 = (n3 & 2) != 0;
            if (this.m_doIndent) {
                boolean bl4 = (n3 & 8) != 0;
                n2 = 0;
                if (this.m_ispreserve) {
                    this.m_ispreserve = false;
                } else if (this.m_doIndent && (!this.m_inBlockElem || bl4)) {
                    this.f = true;
                    n2 = 1;
                }
                if (!elemContext.d && n2 != 0) {
                    this.indent(elemContext.h - 1);
                }
                this.m_inBlockElem = !bl4;
            }
            Writer writer = this.m_writer;
            if (!elemContext.d) {
                writer.write("</");
                writer.write(string3);
                writer.write(62);
            } else {
                if (this.m_tracer != null) {
                    super.fireStartElem(string3);
                }
                if ((n2 = this.m_attributes.getLength()) > 0) {
                    this.processAttributes(this.m_writer, n2);
                    this.m_attributes.clear();
                }
                if (!bl2) {
                    writer.write("></");
                    writer.write(string3);
                    writer.write(62);
                } else {
                    writer.write(62);
                }
            }
            if ((n3 & 0x200000) != 0) {
                this.m_ispreserve = true;
            }
            this.m_isprevtext = false;
            if (this.m_tracer != null) {
                super.fireEndElem(string3);
            }
            if (bl2) {
                this.m_elemContext = elemContext.f;
                return;
            }
            if (!elemContext.d && this.m_doIndent && !this.m_preserves.isEmpty()) {
                this.m_preserves.pop();
            }
            this.m_elemContext = elemContext.f;
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void processAttribute(Writer writer, String string, String string2, ElemDesc elemDesc) throws IOException {
        writer.write(32);
        if ((string2.length() == 0 || string2.equalsIgnoreCase(string)) && elemDesc != null && elemDesc.isAttrFlagSet(string, 4)) {
            writer.write(string);
        } else {
            writer.write(string);
            writer.write("=\"");
            if (elemDesc != null && elemDesc.isAttrFlagSet(string, 2)) {
                this.writeAttrURI(writer, string2, this.m_specialEscapeURLs);
            } else {
                this.writeAttrString(writer, string2, this.getEncoding());
            }
            writer.write(34);
        }
    }

    private boolean isASCIIDigit(char c2) {
        return c2 >= '0' && c2 <= '9';
    }

    private static String makeHHString(int n2) {
        String string = Integer.toHexString(n2).toUpperCase();
        if (string.length() == 1) {
            string = "0" + string;
        }
        return string;
    }

    private boolean isHHSign(String string) {
        boolean bl2 = true;
        try {
            char c2 = (char)Integer.parseInt(string, 16);
        }
        catch (NumberFormatException numberFormatException) {
            bl2 = false;
        }
        return bl2;
    }

    public void writeAttrURI(Writer writer, String string, boolean bl2) throws IOException {
        int n2 = string.length();
        if (n2 > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n3 = 0;
        int n4 = 0;
        char c2 = '\u0000';
        int n5 = 0;
        while (n5 < n2) {
            c2 = cArray[n5];
            if (c2 < ' ' || c2 > '~') {
                if (n4 > 0) {
                    writer.write(cArray, n3, n4);
                    n4 = 0;
                }
                if (bl2) {
                    int n6;
                    int n7;
                    int n8;
                    if (c2 <= '\u007f') {
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(c2));
                    } else if (c2 <= '\u07ff') {
                        n8 = c2 >> 6 | 0xC0;
                        n7 = c2 & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n8));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n7));
                    } else if (ToStream.a(c2)) {
                        n8 = c2 & 0x3FF;
                        n7 = (n8 & 0x3C0) >> 6;
                        n6 = n7 + 1;
                        int n9 = (n8 & 0x3C) >> 2;
                        int n10 = (n8 & 3) << 4 & 0x30;
                        c2 = cArray[++n5];
                        int n11 = c2 & 0x3FF;
                        int n12 = n11 & 0x3F;
                        int n13 = 0xF0 | n6 >> 2;
                        int n14 = 0x80 | (n6 & 3) << 4 & 0x30 | n9;
                        int n15 = 0x80 | (n10 |= (n11 & 0x3C0) >> 6);
                        int n16 = 0x80 | n12;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n13));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n14));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n15));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n16));
                    } else {
                        n8 = c2 >> 12 | 0xE0;
                        n7 = (c2 & 0xFC0) >> 6 | 0x80;
                        n6 = c2 & 0x3F | 0x80;
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n8));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n7));
                        writer.write(37);
                        writer.write(ToHTMLStream.makeHHString(n6));
                    }
                } else if (this.escapingNotNeeded(c2)) {
                    writer.write(c2);
                } else {
                    writer.write("&#");
                    writer.write(Integer.toString(c2));
                    writer.write(59);
                }
                n3 = n5 + 1;
            } else if (c2 == '\"') {
                if (n4 > 0) {
                    writer.write(cArray, n3, n4);
                    n4 = 0;
                }
                if (bl2) {
                    writer.write("%22");
                } else {
                    writer.write("&quot;");
                }
                n3 = n5 + 1;
            } else {
                ++n4;
            }
            ++n5;
        }
        if (n4 > 1) {
            if (n3 == 0) {
                writer.write(string);
            } else {
                writer.write(cArray, n3, n4);
            }
        } else if (n4 == 1) {
            writer.write(c2);
        }
    }

    public void writeAttrString(Writer writer, String string, String string2) throws IOException {
        int n2 = string.length();
        if (n2 > this.m_attrBuff.length) {
            this.m_attrBuff = new char[n2 * 2 + 1];
        }
        string.getChars(0, n2, this.m_attrBuff, 0);
        char[] cArray = this.m_attrBuff;
        int n3 = 0;
        int n4 = 0;
        char c2 = '\u0000';
        int n5 = 0;
        while (n5 < n2) {
            c2 = cArray[n5];
            if (this.escapingNotNeeded(c2) && !this.m_charInfo.isSpecialAttrChar(c2)) {
                ++n4;
            } else if ('<' == c2 || '>' == c2) {
                ++n4;
            } else if ('&' == c2 && n5 + 1 < n2 && '{' == cArray[n5 + 1]) {
                ++n4;
            } else {
                int n6;
                if (n4 > 0) {
                    writer.write(cArray, n3, n4);
                    n4 = 0;
                }
                if (n5 != (n6 = this.accumDefaultEntity(writer, c2, n5, cArray, n2, false, false))) {
                    n5 = n6 - 1;
                } else {
                    String string3;
                    if (ToStream.a(c2)) {
                        this.writeUTF16Surrogate(c2, cArray, n5, n2);
                        ++n5;
                    }
                    if (null != (string3 = this.m_charInfo.getEntityNameForChar(c2))) {
                        writer.write(38);
                        writer.write(string3);
                        writer.write(59);
                    } else if (this.escapingNotNeeded(c2)) {
                        writer.write(c2);
                    } else {
                        writer.write("&#");
                        writer.write(Integer.toString(c2));
                        writer.write(59);
                    }
                }
                n3 = n5 + 1;
            }
            ++n5;
        }
        if (n4 > 1) {
            if (n3 == 0) {
                writer.write(string);
            } else {
                writer.write(cArray, n3, n4);
            }
        } else if (n4 == 1) {
            writer.write(c2);
        }
    }

    public final void characters(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_elemContext.g) {
            try {
                if (this.m_elemContext.d) {
                    this.closeStartTag();
                    this.m_elemContext.d = false;
                }
                this.m_ispreserve = true;
                this.a(cArray, n2, n3, false, this.m_lineSepUse);
                if (this.m_tracer != null) {
                    super.fireCharEvent(cArray, n2, n3);
                }
                return;
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        }
        super.characters(cArray, n2, n3);
    }

    public final void cdata(char[] cArray, int n2, int n3) throws SAXException {
        if (null != this.m_elemContext.e && (this.m_elemContext.e.equalsIgnoreCase("SCRIPT") || this.m_elemContext.e.equalsIgnoreCase("STYLE"))) {
            try {
                if (this.m_elemContext.d) {
                    this.closeStartTag();
                    this.m_elemContext.d = false;
                }
                this.m_ispreserve = true;
                if (this.shouldIndent()) {
                    this.indent();
                }
                this.a(cArray, n2, n3, true, this.m_lineSepUse);
            }
            catch (IOException iOException) {
                throw new SAXException(XMLMessages.createXMLMessage("ER_OIERROR", null), iOException);
            }
        } else {
            super.cdata(cArray, n2, n3);
        }
    }

    public void processingInstruction(String string, String string2) throws SAXException {
        this.flushPending();
        if (string.equals("javax.xml.transform.disable-output-escaping")) {
            this.startNonEscaping();
        } else if (string.equals("javax.xml.transform.enable-output-escaping")) {
            this.endNonEscaping();
        } else {
            try {
                if (this.m_elemContext.d) {
                    this.closeStartTag();
                    this.m_elemContext.d = false;
                } else if (this.m_needToCallStartDocument) {
                    this.startDocumentInternal();
                }
                if (this.shouldIndent()) {
                    this.indent();
                }
                Writer writer = this.m_writer;
                writer.write("<?");
                writer.write(string);
                if (string2.length() > 0 && !Character.isSpaceChar(string2.charAt(0))) {
                    writer.write(32);
                }
                writer.write(string2);
                writer.write(62);
                if (this.m_elemContext.h <= 0) {
                    this.outputLineSep();
                }
                this.f = true;
            }
            catch (IOException iOException) {
                throw new SAXException(iOException);
            }
        }
        if (this.m_tracer != null) {
            super.fireEscapingEvent(string, string2);
        }
    }

    public final void entityReference(String string) throws SAXException {
        try {
            Writer writer = this.m_writer;
            writer.write(38);
            writer.write(string);
            writer.write(59);
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public final void endElement(String string) throws SAXException {
        this.endElement(null, null, string);
    }

    public void processAttributes(Writer writer, int n2) throws IOException, SAXException {
        int n3 = 0;
        while (n3 < n2) {
            this.processAttribute(writer, this.m_attributes.getQName(n3), this.m_attributes.getValue(n3), this.m_elemContext.b);
            ++n3;
        }
    }

    public void closeStartTag() throws SAXException {
        try {
            int n2;
            if (this.m_tracer != null) {
                super.fireStartElem(this.m_elemContext.e);
            }
            if ((n2 = this.m_attributes.getLength()) > 0) {
                this.processAttributes(this.m_writer, n2);
                this.m_attributes.clear();
            }
            this.m_writer.write(62);
            if (this.m_cdataSectionElements != null) {
                this.m_elemContext.i = this.isCdataSection();
            }
            if (this.m_doIndent) {
                this.m_isprevtext = false;
                this.m_preserves.push(this.m_ispreserve);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public synchronized void init(OutputStream outputStream, Properties properties) throws UnsupportedEncodingException {
        if (null == properties) {
            properties = OutputPropertiesFactory.getDefaultMethodProperties("html");
        }
        super.init(outputStream, properties, false);
    }

    public void setOutputStream(OutputStream outputStream) {
        try {
            Properties properties = null == this.m_format ? OutputPropertiesFactory.getDefaultMethodProperties("html") : this.m_format;
            this.init(outputStream, properties, true);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    public void namespaceAfterStartElement(String string, String string2) throws SAXException {
        String string3;
        if (this.m_elemContext.c == null && (string3 = SerializerBase.getPrefixPart(this.m_elemContext.e)) == null && "".equals(string)) {
            this.m_elemContext.c = string2;
        }
        this.startPrefixMapping(string, string2, false);
    }

    public void startDTD(String string, String string2, String string3) throws SAXException {
        this.m_inDTD = true;
        super.startDTD(string, string2, string3);
    }

    public void endDTD() throws SAXException {
        this.m_inDTD = false;
    }

    public void attributeDecl(String string, String string2, String string3, String string4, String string5) throws SAXException {
    }

    public void elementDecl(String string, String string2) throws SAXException {
    }

    public void internalEntityDecl(String string, String string2) throws SAXException {
    }

    public void externalEntityDecl(String string, String string2, String string3) throws SAXException {
    }

    public void addUniqueAttribute(String string, String string2, int n2) throws SAXException {
        try {
            Writer writer = this.m_writer;
            if ((n2 & 1) > 0 && ToHTMLStream.m_htmlcharInfo.a) {
                writer.write(32);
                writer.write(string);
                writer.write("=\"");
                writer.write(string2);
                writer.write(34);
            } else if ((n2 & 2) > 0 && (string2.length() == 0 || string2.equalsIgnoreCase(string))) {
                writer.write(32);
                writer.write(string);
            } else {
                writer.write(32);
                writer.write(string);
                writer.write("=\"");
                if ((n2 & 4) > 0) {
                    this.writeAttrURI(writer, string2, this.m_specialEscapeURLs);
                } else {
                    this.writeAttrString(writer, string2, this.getEncoding());
                }
                writer.write(34);
            }
        }
        catch (IOException iOException) {
            throw new SAXException(iOException);
        }
    }

    public void comment(char[] cArray, int n2, int n3) throws SAXException {
        if (this.m_inDTD) {
            return;
        }
        super.comment(cArray, n2, n3);
    }

    public boolean reset() {
        boolean bl2 = super.reset();
        if (!bl2) {
            return false;
        }
        this.initToHTMLStream();
        return true;
    }

    private void initToHTMLStream() {
        this.m_inBlockElem = false;
        this.m_inDTD = false;
        this.m_omitMetaTag = false;
        this.m_specialEscapeURLs = true;
    }

    static {
        h.put("BASEFONT", new ElemDesc(2));
        h.put("FRAME", new ElemDesc(10));
        h.put("FRAMESET", new ElemDesc(8));
        h.put("NOFRAMES", new ElemDesc(8));
        h.put("ISINDEX", new ElemDesc(10));
        h.put("APPLET", new ElemDesc(0x200000));
        h.put("CENTER", new ElemDesc(8));
        h.put("DIR", new ElemDesc(8));
        h.put("MENU", new ElemDesc(8));
        h.put("TT", new ElemDesc(4096));
        h.put("I", new ElemDesc(4096));
        h.put("B", new ElemDesc(4096));
        h.put("BIG", new ElemDesc(4096));
        h.put("SMALL", new ElemDesc(4096));
        h.put("EM", new ElemDesc(8192));
        h.put("STRONG", new ElemDesc(8192));
        h.put("DFN", new ElemDesc(8192));
        h.put("CODE", new ElemDesc(8192));
        h.put("SAMP", new ElemDesc(8192));
        h.put("KBD", new ElemDesc(8192));
        h.put("VAR", new ElemDesc(8192));
        h.put("CITE", new ElemDesc(8192));
        h.put("ABBR", new ElemDesc(8192));
        h.put("ACRONYM", new ElemDesc(8192));
        h.put("SUP", new ElemDesc(98304));
        h.put("SUB", new ElemDesc(98304));
        h.put("SPAN", new ElemDesc(98304));
        h.put("BDO", new ElemDesc(98304));
        h.put("BR", new ElemDesc(98314));
        h.put("BODY", new ElemDesc(8));
        h.put("ADDRESS", new ElemDesc(56));
        h.put("DIV", new ElemDesc(56));
        h.put("A", new ElemDesc(32768));
        h.put("MAP", new ElemDesc(98312));
        h.put("AREA", new ElemDesc(10));
        h.put("LINK", new ElemDesc(131082));
        h.put("IMG", new ElemDesc(2195458));
        h.put("OBJECT", new ElemDesc(2326528));
        h.put("PARAM", new ElemDesc(2));
        h.put("HR", new ElemDesc(58));
        h.put("P", new ElemDesc(56));
        h.put("H1", new ElemDesc(262152));
        h.put("H2", new ElemDesc(262152));
        h.put("H3", new ElemDesc(262152));
        h.put("H4", new ElemDesc(262152));
        h.put("H5", new ElemDesc(262152));
        h.put("H6", new ElemDesc(262152));
        h.put("PRE", new ElemDesc(0x100008));
        h.put("Q", new ElemDesc(98304));
        h.put("BLOCKQUOTE", new ElemDesc(56));
        h.put("INS", new ElemDesc(0));
        h.put("DEL", new ElemDesc(0));
        h.put("DL", new ElemDesc(56));
        h.put("DT", new ElemDesc(8));
        h.put("DD", new ElemDesc(8));
        h.put("OL", new ElemDesc(524296));
        h.put("UL", new ElemDesc(524296));
        h.put("LI", new ElemDesc(8));
        h.put("FORM", new ElemDesc(8));
        h.put("LABEL", new ElemDesc(16384));
        h.put("INPUT", new ElemDesc(18434));
        h.put("SELECT", new ElemDesc(18432));
        h.put("OPTGROUP", new ElemDesc(0));
        h.put("OPTION", new ElemDesc(0));
        h.put("TEXTAREA", new ElemDesc(18432));
        h.put("FIELDSET", new ElemDesc(24));
        h.put("LEGEND", new ElemDesc(0));
        h.put("BUTTON", new ElemDesc(18432));
        h.put("TABLE", new ElemDesc(56));
        h.put("CAPTION", new ElemDesc(8));
        h.put("THEAD", new ElemDesc(8));
        h.put("TFOOT", new ElemDesc(8));
        h.put("TBODY", new ElemDesc(8));
        h.put("COLGROUP", new ElemDesc(8));
        h.put("COL", new ElemDesc(10));
        h.put("TR", new ElemDesc(8));
        h.put("TH", new ElemDesc(0));
        h.put("TD", new ElemDesc(0));
        h.put("HEAD", new ElemDesc(0x400008));
        h.put("TITLE", new ElemDesc(8));
        h.put("BASE", new ElemDesc(10));
        h.put("META", new ElemDesc(131082));
        h.put("STYLE", new ElemDesc(131336));
        h.put("SCRIPT", new ElemDesc(229632));
        h.put("NOSCRIPT", new ElemDesc(56));
        h.put("HTML", new ElemDesc(8));
        h.put("FONT", new ElemDesc(4096));
        h.put("S", new ElemDesc(4096));
        h.put("STRIKE", new ElemDesc(4096));
        h.put("U", new ElemDesc(4096));
        h.put("NOBR", new ElemDesc(4096));
        h.put("IFRAME", new ElemDesc(56));
        h.put("LAYER", new ElemDesc(56));
        h.put("ILAYER", new ElemDesc(56));
        ElemDesc elemDesc = (ElemDesc)h.get("AREA");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NOHREF", 4);
        elemDesc = (ElemDesc)h.get("BASE");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)h.get("BLOCKQUOTE");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)h.get("Q");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)h.get("INS");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)h.get("DEL");
        elemDesc.setAttr("CITE", 2);
        elemDesc = (ElemDesc)h.get("A");
        elemDesc.setAttr("HREF", 2);
        elemDesc.setAttr("NAME", 2);
        elemDesc = (ElemDesc)h.get("LINK");
        elemDesc.setAttr("HREF", 2);
        elemDesc = (ElemDesc)h.get("INPUT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("CHECKED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)h.get("SELECT");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("MULTIPLE", 4);
        elemDesc = (ElemDesc)h.get("OPTGROUP");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)h.get("OPTION");
        elemDesc.setAttr("SELECTED", 4);
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)h.get("TEXTAREA");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc.setAttr("READONLY", 4);
        elemDesc = (ElemDesc)h.get("BUTTON");
        elemDesc.setAttr("DISABLED", 4);
        elemDesc = (ElemDesc)h.get("SCRIPT");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("FOR", 2);
        elemDesc.setAttr("DEFER", 4);
        elemDesc = (ElemDesc)h.get("IMG");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("ISMAP", 4);
        elemDesc = (ElemDesc)h.get("OBJECT");
        elemDesc.setAttr("CLASSID", 2);
        elemDesc.setAttr("CODEBASE", 2);
        elemDesc.setAttr("DATA", 2);
        elemDesc.setAttr("ARCHIVE", 2);
        elemDesc.setAttr("USEMAP", 2);
        elemDesc.setAttr("DECLARE", 4);
        elemDesc = (ElemDesc)h.get("FORM");
        elemDesc.setAttr("ACTION", 2);
        elemDesc = (ElemDesc)h.get("HEAD");
        elemDesc.setAttr("PROFILE", 2);
        elemDesc = (ElemDesc)h.get("FRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)h.get("IFRAME");
        elemDesc.setAttr("SRC", 2);
        elemDesc.setAttr("LONGDESC", 2);
        elemDesc = (ElemDesc)h.get("LAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)h.get("ILAYER");
        elemDesc.setAttr("SRC", 2);
        elemDesc = (ElemDesc)h.get("DIV");
        elemDesc.setAttr("SRC", 2);
        m_dummy = new ElemDesc(8);
    }
}

