/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;

public class NodeVector
implements Serializable,
Cloneable {
    private int m_blocksize;
    private int[] m_map;
    public int m_firstFree = 0;
    private int m_mapSize;

    public NodeVector() {
        this.m_blocksize = 32;
        this.m_mapSize = 0;
    }

    public NodeVector(int n2) {
        this.m_blocksize = n2;
        this.m_mapSize = 0;
    }

    public Object clone() throws CloneNotSupportedException {
        NodeVector nodeVector = (NodeVector)super.clone();
        if (null != this.m_map && this.m_map == nodeVector.m_map) {
            nodeVector.m_map = new int[this.m_map.length];
            System.arraycopy(this.m_map, 0, nodeVector.m_map, 0, this.m_map.length);
        }
        return nodeVector;
    }

    public int size() {
        return this.m_firstFree;
    }

    public void addElement(int n2) {
        if (this.m_firstFree + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[this.m_firstFree] = n2;
        ++this.m_firstFree;
    }

    public final void push(int n2) {
        int n3 = this.m_firstFree;
        if (n3 + 1 >= this.m_mapSize) {
            if (null == this.m_map) {
                this.m_map = new int[this.m_blocksize];
                this.m_mapSize = this.m_blocksize;
            } else {
                this.m_mapSize += this.m_blocksize;
                int[] nArray = new int[this.m_mapSize];
                System.arraycopy(this.m_map, 0, nArray, 0, n3 + 1);
                this.m_map = nArray;
            }
        }
        this.m_map[n3] = n2;
        this.m_firstFree = ++n3;
    }

    public final int pop() {
        --this.m_firstFree;
        int n2 = this.m_map[this.m_firstFree];
        this.m_map[this.m_firstFree] = -1;
        return n2;
    }

    public final int popAndTop() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
        return this.m_firstFree == 0 ? -1 : this.m_map[this.m_firstFree - 1];
    }

    public final void popQuick() {
        --this.m_firstFree;
        this.m_map[this.m_firstFree] = -1;
    }

    public final int peepOrNull() {
        return null != this.m_map && this.m_firstFree > 0 ? this.m_map[this.m_firstFree - 1] : -1;
    }

    public final void pushPair(int n2, int n3) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 2 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree);
            this.m_map = nArray;
        }
        this.m_map[this.m_firstFree] = n2;
        this.m_map[this.m_firstFree + 1] = n3;
        this.m_firstFree += 2;
    }

    public final void popPair() {
        this.m_firstFree -= 2;
        this.m_map[this.m_firstFree] = -1;
        this.m_map[this.m_firstFree + 1] = -1;
    }

    public final void setTail(int n2) {
        this.m_map[this.m_firstFree - 1] = n2;
    }

    public final void setTailSub1(int n2) {
        this.m_map[this.m_firstFree - 2] = n2;
    }

    public final int peepTail() {
        return this.m_map[this.m_firstFree - 1];
    }

    public final int peepTailSub1() {
        return this.m_map[this.m_firstFree - 2];
    }

    public void insertInOrder(int n2) {
        int n3 = 0;
        while (n3 < this.m_firstFree) {
            if (n2 < this.m_map[n3]) {
                this.insertElementAt(n2, n3);
                return;
            }
            ++n3;
        }
        this.addElement(n2);
    }

    public void insertElementAt(int n2, int n3) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        } else if (this.m_firstFree + 1 >= this.m_mapSize) {
            this.m_mapSize += this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + 1);
            this.m_map = nArray;
        }
        if (n3 <= this.m_firstFree - 1) {
            System.arraycopy(this.m_map, n3, this.m_map, n3 + 1, this.m_firstFree - n3);
        }
        this.m_map[n3] = n2;
        ++this.m_firstFree;
    }

    public void appendNodes(NodeVector nodeVector) {
        int n2 = nodeVector.size();
        if (null == this.m_map) {
            this.m_mapSize = n2 + this.m_blocksize;
            this.m_map = new int[this.m_mapSize];
        } else if (this.m_firstFree + n2 >= this.m_mapSize) {
            this.m_mapSize += n2 + this.m_blocksize;
            int[] nArray = new int[this.m_mapSize];
            System.arraycopy(this.m_map, 0, nArray, 0, this.m_firstFree + n2);
            this.m_map = nArray;
        }
        System.arraycopy(nodeVector.m_map, 0, this.m_map, this.m_firstFree, n2);
        this.m_firstFree += n2;
    }

    public void removeAllElements() {
        if (null == this.m_map) {
            return;
        }
        int n2 = 0;
        while (n2 < this.m_firstFree) {
            this.m_map[n2] = -1;
            ++n2;
        }
        this.m_firstFree = 0;
    }

    public void RemoveAllNoClear() {
        if (null == this.m_map) {
            return;
        }
        this.m_firstFree = 0;
    }

    public boolean removeElement(int n2) {
        if (null == this.m_map) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.m_firstFree) {
            int n4 = this.m_map[n3];
            if (n4 == n2) {
                if (n3 > this.m_firstFree) {
                    System.arraycopy(this.m_map, n3 + 1, this.m_map, n3 - 1, this.m_firstFree - n3);
                } else {
                    this.m_map[n3] = -1;
                }
                --this.m_firstFree;
                return true;
            }
            ++n3;
        }
        return false;
    }

    public void removeElementAt(int n2) {
        if (null == this.m_map) {
            return;
        }
        if (n2 > this.m_firstFree) {
            System.arraycopy(this.m_map, n2 + 1, this.m_map, n2 - 1, this.m_firstFree - n2);
        } else {
            this.m_map[n2] = -1;
        }
    }

    public void setElementAt(int n2, int n3) {
        if (null == this.m_map) {
            this.m_map = new int[this.m_blocksize];
            this.m_mapSize = this.m_blocksize;
        }
        if (n3 == -1) {
            this.addElement(n2);
        }
        this.m_map[n3] = n2;
    }

    public int elementAt(int n2) {
        if (null == this.m_map) {
            return -1;
        }
        return this.m_map[n2];
    }

    public boolean contains(int n2) {
        if (null == this.m_map) {
            return false;
        }
        int n3 = 0;
        while (n3 < this.m_firstFree) {
            int n4 = this.m_map[n3];
            if (n4 == n2) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public int indexOf(int n2, int n3) {
        if (null == this.m_map) {
            return -1;
        }
        int n4 = n3;
        while (n4 < this.m_firstFree) {
            int n5 = this.m_map[n4];
            if (n5 == n2) {
                return n4;
            }
            ++n4;
        }
        return -1;
    }

    public int indexOf(int n2) {
        if (null == this.m_map) {
            return -1;
        }
        int n3 = 0;
        while (n3 < this.m_firstFree) {
            int n4 = this.m_map[n3];
            if (n4 == n2) {
                return n3;
            }
            ++n3;
        }
        return -1;
    }

    /*
     * Unable to fully structure code
     */
    public void sort(int[] var1_1, int var2_2, int var3_3) throws Exception {
        var4_4 = var2_2;
        var5_5 = var3_3;
        if (var4_4 >= var5_5) {
            return;
        }
        if (var4_4 == var5_5 - 1) {
            if (var1_1[var4_4] > var1_1[var5_5]) {
                var6_6 = var1_1[var4_4];
                var1_1[var4_4] = var1_1[var5_5];
                var1_1[var5_5] = var6_6;
            }
            return;
        }
        var6_7 = var1_1[(var4_4 + var5_5) / 2];
        var1_1[(var4_4 + var5_5) / 2] = var1_1[var5_5];
        var1_1[var5_5] = var6_7;
        ** GOTO lbl25
        {
            ++var4_4;
            do {
                if (var1_1[var4_4] <= var6_7 && var4_4 < var5_5) continue block0;
                while (var6_7 <= var1_1[var5_5] && var4_4 < var5_5) {
                    --var5_5;
                }
                if (var4_4 >= var5_5) continue;
                var7_8 = var1_1[var4_4];
                var1_1[var4_4] = var1_1[var5_5];
                var1_1[var5_5] = var7_8;
lbl25:
                // 3 sources

            } while (var4_4 < var5_5);
        }
        var1_1[var3_3] = var1_1[var5_5];
        var1_1[var5_5] = var6_7;
        this.sort(var1_1, var2_2, var4_4 - 1);
        this.sort(var1_1, var5_5 + 1, var3_3);
    }

    public void sort() throws Exception {
        this.sort(this.m_map, 0, this.m_firstFree - 1);
    }
}

