/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xml.utils;

import java.io.Serializable;
import java.util.Stack;
import java.util.StringTokenizer;
import org.apache.xml.res.XMLMessages;
import org.apache.xml.utils.NameSpace;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.XMLChar;
import org.w3c.dom.Element;

public class QName
implements Serializable {
    public String _localName;
    public String _namespaceURI;
    public String _prefix;
    public static final String S_XMLNAMESPACEURI = "http://www.w3.org/XML/1998/namespace";
    private int m_hashCode;

    public QName() {
    }

    public QName(String string, String string2) {
        this(string, string2, false);
    }

    public QName(String string, String string2, boolean bl2) {
        if (string2 == null) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_NULL", null));
        }
        if (bl2 && !XMLChar.isValidNCName(string2)) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_INVALID", null));
        }
        this._namespaceURI = string;
        this._localName = string2;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, String string2, String string3) {
        this(string, string2, string3, false);
    }

    public QName(String string, String string2, String string3, boolean bl2) {
        if (string3 == null) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_NULL", null));
        }
        if (bl2) {
            if (!XMLChar.isValidNCName(string3)) {
                throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_INVALID", null));
            }
            if (null != string2 && !XMLChar.isValidNCName(string2)) {
                throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_PREFIX_INVALID", null));
            }
        }
        this._namespaceURI = string;
        this._prefix = string2;
        this._localName = string3;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string) {
        this(string, false);
    }

    public QName(String string, boolean bl2) {
        if (string == null) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_NULL", null));
        }
        if (bl2 && !XMLChar.isValidNCName(string)) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_INVALID", null));
        }
        this._namespaceURI = null;
        this._localName = string;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, Stack stack) {
        this(string, stack, false);
    }

    public QName(String string, Stack stack, boolean bl2) {
        String string2 = null;
        String string3 = null;
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string3 = string.substring(0, n2);
            if (string3.equals("xml")) {
                string2 = S_XMLNAMESPACEURI;
            } else {
                if (string3.equals("xmlns")) {
                    return;
                }
                int n3 = stack.size();
                int n4 = n3 - 1;
                while (n4 >= 0) {
                    NameSpace nameSpace = (NameSpace)stack.elementAt(n4);
                    while (null != nameSpace) {
                        if (null != nameSpace.m_prefix && string3.equals(nameSpace.m_prefix)) {
                            string2 = nameSpace.m_uri;
                            n4 = -1;
                            break;
                        }
                        nameSpace = nameSpace.m_next;
                    }
                    --n4;
                }
            }
            if (null == string2) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_PREFIX_MUST_RESOLVE", new Object[]{string3}));
            }
        }
        String string4 = this._localName = n2 < 0 ? string : string.substring(n2 + 1);
        if (bl2 && (this._localName == null || !XMLChar.isValidNCName(this._localName))) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_INVALID", null));
        }
        this._namespaceURI = string2;
        this._prefix = string3;
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, Element element, PrefixResolver prefixResolver) {
        this(string, element, prefixResolver, false);
    }

    public QName(String string, Element element, PrefixResolver prefixResolver, boolean bl2) {
        this._namespaceURI = null;
        int n2 = string.indexOf(58);
        if (n2 > 0 && null != element) {
            String string2;
            this._prefix = string2 = string.substring(0, n2);
            if (string2.equals("xml")) {
                this._namespaceURI = S_XMLNAMESPACEURI;
            } else {
                if (string2.equals("xmlns")) {
                    return;
                }
                this._namespaceURI = prefixResolver.getNamespaceForPrefix(string2, element);
            }
            if (null == this._namespaceURI) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_PREFIX_MUST_RESOLVE", new Object[]{string2}));
            }
        }
        String string3 = this._localName = n2 < 0 ? string : string.substring(n2 + 1);
        if (bl2 && (this._localName == null || !XMLChar.isValidNCName(this._localName))) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_INVALID", null));
        }
        this.m_hashCode = this.toString().hashCode();
    }

    public QName(String string, PrefixResolver prefixResolver) {
        this(string, prefixResolver, false);
    }

    public QName(String string, PrefixResolver prefixResolver, boolean bl2) {
        String string2 = null;
        this._namespaceURI = null;
        int n2 = string.indexOf(58);
        if (n2 > 0) {
            string2 = string.substring(0, n2);
            this._namespaceURI = string2.equals("xml") ? S_XMLNAMESPACEURI : prefixResolver.getNamespaceForPrefix(string2);
            if (null == this._namespaceURI) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_PREFIX_MUST_RESOLVE", new Object[]{string2}));
            }
            this._localName = string.substring(n2 + 1);
        } else {
            if (n2 == 0) {
                throw new RuntimeException(XMLMessages.createXMLMessage("ER_NAME_CANT_START_WITH_COLON", null));
            }
            this._localName = string;
        }
        if (bl2 && (this._localName == null || !XMLChar.isValidNCName(this._localName))) {
            throw new IllegalArgumentException(XMLMessages.createXMLMessage("ER_ARG_LOCALNAME_INVALID", null));
        }
        this.m_hashCode = this.toString().hashCode();
        this._prefix = string2;
    }

    public String getNamespaceURI() {
        return this._namespaceURI;
    }

    public String getPrefix() {
        return this._prefix;
    }

    public String getLocalName() {
        return this._localName;
    }

    public String toString() {
        return this._prefix != null ? this._prefix + ":" + this._localName : (this._namespaceURI != null ? "{" + this._namespaceURI + "}" + this._localName : this._localName);
    }

    public String toNamespacedString() {
        return this._namespaceURI != null ? "{" + this._namespaceURI + "}" + this._localName : this._localName;
    }

    public String getNamespace() {
        return this.getNamespaceURI();
    }

    public String getLocalPart() {
        return this.getLocalName();
    }

    public int hashCode() {
        return this.m_hashCode;
    }

    public boolean equals(String string, String string2) {
        String string3 = this.getNamespaceURI();
        return this.getLocalName().equals(string2) && (null != string3 && null != string ? string3.equals(string) : null == string3 && null == string);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof QName) {
            QName qName = (QName)object;
            String string = this.getNamespaceURI();
            String string2 = qName.getNamespaceURI();
            return this.getLocalName().equals(qName.getLocalName()) && (null != string && null != string2 ? string.equals(string2) : null == string && null == string2);
        }
        return false;
    }

    public static QName getQNameFromString(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, "{}", false);
        String string2 = stringTokenizer.nextToken();
        String string3 = stringTokenizer.hasMoreTokens() ? stringTokenizer.nextToken() : null;
        QName qName = null == string3 ? new QName(null, string2) : new QName(string2, string3);
        return qName;
    }

    public static boolean isXMLNSDecl(String string) {
        return string.startsWith("xmlns") && (string.equals("xmlns") || string.startsWith("xmlns:"));
    }

    public static String getPrefixFromXMLNSDecl(String string) {
        int n2 = string.indexOf(58);
        return n2 >= 0 ? string.substring(n2 + 1) : "";
    }

    public static String getLocalPart(String string) {
        int n2 = string.indexOf(58);
        return n2 < 0 ? string : string.substring(n2 + 1);
    }

    public static String getPrefixPart(String string) {
        int n2 = string.indexOf(58);
        return n2 >= 0 ? string.substring(0, n2) : "";
    }
}

