/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.PrefixResolverDefault;
import org.apache.xpath.XPath;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.traversal.NodeIterator;

public class CachedXPathAPI {
    public XPathContext xpathSupport;

    public CachedXPathAPI() {
        this.xpathSupport = new XPathContext();
    }

    public CachedXPathAPI(CachedXPathAPI cachedXPathAPI) {
        this.xpathSupport = cachedXPathAPI.xpathSupport;
    }

    public XPathContext getXPathContext() {
        return this.xpathSupport;
    }

    public Node selectSingleNode(Node node, String string) throws TransformerException {
        return this.selectSingleNode(node, string, node);
    }

    public Node selectSingleNode(Node node, String string, Node node2) throws TransformerException {
        NodeIterator nodeIterator = this.selectNodeIterator(node, string, node2);
        return nodeIterator.nextNode();
    }

    public NodeIterator selectNodeIterator(Node node, String string) throws TransformerException {
        return this.selectNodeIterator(node, string, node);
    }

    public NodeIterator selectNodeIterator(Node node, String string, Node node2) throws TransformerException {
        XObject xObject = this.eval(node, string, node2);
        return xObject.nodeset();
    }

    public NodeList selectNodeList(Node node, String string) throws TransformerException {
        return this.selectNodeList(node, string, node);
    }

    public NodeList selectNodeList(Node node, String string, Node node2) throws TransformerException {
        XObject xObject = this.eval(node, string, node2);
        return xObject.nodelist();
    }

    public XObject eval(Node node, String string) throws TransformerException {
        return this.eval(node, string, node);
    }

    public XObject eval(Node node, String string, Node node2) throws TransformerException {
        PrefixResolverDefault prefixResolverDefault = new PrefixResolverDefault(node2.getNodeType() == 9 ? ((Document)node2).getDocumentElement() : node2);
        XPath xPath = new XPath(string, null, prefixResolverDefault, 0, null);
        int n2 = this.xpathSupport.getDTMHandleFromNode(node);
        return xPath.execute(this.xpathSupport, n2, (PrefixResolver)prefixResolverDefault);
    }

    public XObject eval(Node node, String string, PrefixResolver prefixResolver) throws TransformerException {
        XPath xPath = new XPath(string, null, prefixResolver, 0, null);
        XPathContext xPathContext = new XPathContext();
        int n2 = xPathContext.getDTMHandleFromNode(node);
        return xPath.execute(xPathContext, n2, prefixResolver);
    }
}

