/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath;

import javax.xml.transform.TransformerException;
import org.apache.xalan.templates.ElemTemplateElement;
import org.apache.xalan.templates.ElemVariable;
import org.apache.xalan.templates.Stylesheet;
import org.apache.xml.utils.PrefixResolver;
import org.apache.xml.utils.QName;
import org.apache.xpath.XPathContext;
import org.apache.xpath.objects.XObject;
import org.apache.xpath.res.XPATHMessages;

public class VariableStack
implements Cloneable {
    public static final int CLEARLIMITATION = 1024;
    public XObject[] d = new XObject[8192];
    public int b;
    private int _currentFrameBottom;
    public int[] a = new int[4096];
    public int c;
    private static XObject[] m_nulls = new XObject[1024];

    public VariableStack() {
        this.reset();
    }

    public synchronized Object clone() throws CloneNotSupportedException {
        VariableStack variableStack = (VariableStack)super.clone();
        variableStack.d = (XObject[])this.d.clone();
        variableStack.a = (int[])this.a.clone();
        return variableStack;
    }

    public XObject elementAt(int n2) {
        return this.d[n2];
    }

    public int size() {
        return this.b;
    }

    public void reset() {
        this.b = 0;
        this.c = 0;
        this.a[this.c++] = 0;
        this.d = new XObject[this.d.length];
    }

    public void setStackFrame(int n2) {
        this._currentFrameBottom = n2;
    }

    public int getStackFrame() {
        return this._currentFrameBottom;
    }

    public int link(int n2) {
        Object[] objectArray;
        this._currentFrameBottom = this.b;
        this.b += n2;
        if (this.b >= this.d.length) {
            objectArray = new XObject[this.d.length + 4096 + n2];
            System.arraycopy(this.d, 0, objectArray, 0, this.d.length);
            this.d = objectArray;
        }
        if (this.c + 1 >= this.a.length) {
            objectArray = new int[this.a.length + 2048];
            System.arraycopy(this.a, 0, objectArray, 0, this.a.length);
            this.a = (int[])objectArray;
        }
        this.a[this.c++] = this._currentFrameBottom;
        return this._currentFrameBottom;
    }

    public void unlink() {
        this.b = this.a[--this.c];
        this._currentFrameBottom = this.a[this.c - 1];
    }

    public void unlink(int n2) {
        this.b = this.a[--this.c];
        this._currentFrameBottom = n2;
    }

    public void setLocalVariable(int n2, XObject xObject) {
        this.d[n2 + this._currentFrameBottom] = xObject;
    }

    public void setLocalVariable(int n2, XObject xObject, int n3) {
        this.d[n2 + n3] = xObject;
    }

    public XObject getLocalVariable(XPathContext xPathContext, int n2) throws TransformerException {
        XObject xObject = this.d[n2 += this._currentFrameBottom];
        if (null == xObject) {
            throw new TransformerException(XPATHMessages.createXPATHMessage("ER_VARIABLE_ACCESSED_BEFORE_BIND", null), xPathContext.getSAXLocator());
        }
        if (xObject.getType() == 600) {
            this.d[n2] = xObject.execute(xPathContext);
            return this.d[n2];
        }
        return xObject;
    }

    public XObject getLocalVariable(int n2, int n3) throws TransformerException {
        XObject xObject = this.d[n2 += n3];
        return xObject;
    }

    public XObject getLocalVariable(XPathContext xPathContext, int n2, boolean bl2) throws TransformerException {
        XObject xObject = this.d[n2 += this._currentFrameBottom];
        if (null == xObject) {
            throw new TransformerException(XPATHMessages.createXPATHMessage("ER_VARIABLE_ACCESSED_BEFORE_BIND", null), xPathContext.getSAXLocator());
        }
        if (xObject.getType() == 600) {
            this.d[n2] = xObject.execute(xPathContext);
            return this.d[n2];
        }
        return bl2 ? xObject : xObject.getFresh();
    }

    public boolean isLocalSet(int n2) throws TransformerException {
        return this.d[n2 + this._currentFrameBottom] != null;
    }

    public void clearLocalSlots(int n2, int n3) {
        System.arraycopy(m_nulls, 0, this.d, n2 += this._currentFrameBottom, n3);
    }

    public void setGlobalVariable(int n2, XObject xObject) {
        this.d[n2] = xObject;
    }

    public XObject getGlobalVariable(XPathContext xPathContext, int n2) throws TransformerException {
        XObject xObject = this.d[n2];
        if (xObject.getType() == 600) {
            this.d[n2] = xObject.execute(xPathContext);
            return this.d[n2];
        }
        return xObject;
    }

    public XObject getGlobalVariable(XPathContext xPathContext, int n2, boolean bl2) throws TransformerException {
        XObject xObject = this.d[n2];
        if (xObject.getType() == 600) {
            this.d[n2] = xObject.execute(xPathContext);
            return this.d[n2];
        }
        return bl2 ? xObject : xObject.getFresh();
    }

    public XObject getVariableOrParam(XPathContext xPathContext, QName qName) throws TransformerException {
        PrefixResolver prefixResolver = xPathContext.getNamespaceContext();
        if (prefixResolver instanceof ElemTemplateElement) {
            ElemVariable elemVariable;
            ElemTemplateElement elemTemplateElement = (ElemTemplateElement)prefixResolver;
            if (!(elemTemplateElement instanceof Stylesheet)) {
                while (!(elemTemplateElement.getParentNode() instanceof Stylesheet)) {
                    ElemTemplateElement elemTemplateElement2 = elemTemplateElement;
                    while (null != (elemTemplateElement = elemTemplateElement.getPreviousSiblingElem())) {
                        if (!(elemTemplateElement instanceof ElemVariable) || !(elemVariable = (ElemVariable)elemTemplateElement).getName().equals(qName)) continue;
                        return this.getLocalVariable(xPathContext, elemVariable.getIndex());
                    }
                    elemTemplateElement = elemTemplateElement2.getParentElem();
                }
            }
            if (null != (elemVariable = elemTemplateElement.getStylesheetRoot().getVariableOrParamComposed(qName))) {
                return this.getGlobalVariable(xPathContext, elemVariable.getIndex());
            }
        }
        throw new TransformerException(XPATHMessages.createXPATHMessage("ER_VAR_NOT_RESOLVABLE", new Object[]{qName.toString()}));
    }
}

