/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Vector;
import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTM;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.Expression;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.HasPositionalPredChecker;
import org.apache.xpath.axes.IteratorPool;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.PathComponent;
import org.apache.xpath.axes.UnionChildIterator;
import org.apache.xpath.axes.WalkerFactory;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;

public class UnionPathIterator
extends LocPathIterator
implements Cloneable,
DTMIterator,
Serializable,
PathComponent {
    public LocPathIterator[] m_exprs;
    public DTMIterator[] m_iterators;

    public UnionPathIterator() {
        this.m_iterators = null;
        this.m_exprs = null;
    }

    public void setRoot(int n2, Object object) {
        super.setRoot(n2, object);
        try {
            if (null != this.m_exprs) {
                int n3 = this.m_exprs.length;
                DTMIterator[] dTMIteratorArray = new DTMIterator[n3];
                int n4 = 0;
                while (n4 < n3) {
                    DTMIterator dTMIterator;
                    dTMIteratorArray[n4] = dTMIterator = this.m_exprs[n4].asIterator(this.m_execContext, n2);
                    dTMIterator.nextNode();
                    ++n4;
                }
                this.m_iterators = dTMIteratorArray;
            }
        }
        catch (Exception exception) {
            throw new WrappedRuntimeException(exception);
        }
    }

    public void addIterator(DTMIterator dTMIterator) {
        if (null == this.m_iterators) {
            this.m_iterators = new DTMIterator[1];
            this.m_iterators[0] = dTMIterator;
        } else {
            DTMIterator[] dTMIteratorArray = this.m_iterators;
            int n2 = this.m_iterators.length;
            this.m_iterators = new DTMIterator[n2 + 1];
            System.arraycopy(dTMIteratorArray, 0, this.m_iterators, 0, n2);
            this.m_iterators[n2] = dTMIterator;
        }
        dTMIterator.nextNode();
        if (dTMIterator instanceof Expression) {
            ((Expression)((Object)dTMIterator)).exprSetParent(this);
        }
    }

    public void detach() {
        if (this.m_allowDetach && null != this.m_iterators) {
            int n2 = this.m_iterators.length;
            int n3 = 0;
            while (n3 < n2) {
                this.m_iterators[n3].detach();
                ++n3;
            }
            this.m_iterators = null;
        }
    }

    public UnionPathIterator(Compiler compiler, int n2) throws TransformerException {
        n2 = OpMap.getFirstChildPos(n2);
        this.loadLocationPaths(compiler, n2, 0);
    }

    public static LocPathIterator createUnionIterator(Compiler compiler, int n2) throws TransformerException {
        LocPathIterator locPathIterator;
        UnionPathIterator unionPathIterator = new UnionPathIterator(compiler, n2);
        int n3 = unionPathIterator.m_exprs.length;
        boolean bl2 = true;
        int n4 = 0;
        while (n4 < n3) {
            locPathIterator = unionPathIterator.m_exprs[n4];
            if (locPathIterator.getAxis() != 3) {
                bl2 = false;
                break;
            }
            if (HasPositionalPredChecker.check(locPathIterator)) {
                bl2 = false;
                break;
            }
            ++n4;
        }
        if (bl2) {
            locPathIterator = new UnionChildIterator();
            int n5 = 0;
            while (n5 < n3) {
                LocPathIterator locPathIterator2 = unionPathIterator.m_exprs[n5];
                ((UnionChildIterator)locPathIterator).addNodeTest(locPathIterator2);
                ++n5;
            }
            return locPathIterator;
        }
        return unionPathIterator;
    }

    public int getAnalysisBits() {
        int n2 = 0;
        if (this.m_exprs != null) {
            int n3 = this.m_exprs.length;
            int n4 = 0;
            while (n4 < n3) {
                int n5 = this.m_exprs[n4].getAnalysisBits();
                n2 |= n5;
                ++n4;
            }
        }
        return n2;
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, TransformerException {
        try {
            objectInputStream.defaultReadObject();
            this.m_clones = new IteratorPool(this);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new TransformerException(classNotFoundException);
        }
    }

    public Object clone() throws CloneNotSupportedException {
        UnionPathIterator unionPathIterator = (UnionPathIterator)super.clone();
        return unionPathIterator;
    }

    public LocPathIterator createDTMIterator(Compiler compiler, int n2) throws TransformerException {
        LocPathIterator locPathIterator = (LocPathIterator)WalkerFactory.newDTMIterator(compiler, n2, compiler.getLocationPathDepth() <= 0);
        return locPathIterator;
    }

    public void loadLocationPaths(Compiler compiler, int n2, int n3) throws TransformerException {
        int n4 = compiler.getOp(n2);
        if (n4 == 28) {
            this.loadLocationPaths(compiler, compiler.getNextOpPos(n2), n3 + 1);
            this.m_exprs[n3] = this.createDTMIterator(compiler, n2);
            this.m_exprs[n3].exprSetParent(this);
        } else {
            switch (n4) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    this.loadLocationPaths(compiler, compiler.getNextOpPos(n2), n3 + 1);
                    WalkingIterator walkingIterator = new WalkingIterator(compiler.getNamespaceContext());
                    walkingIterator.exprSetParent(this);
                    if (compiler.getLocationPathDepth() <= 0) {
                        walkingIterator.setIsTopLevel(true);
                    }
                    walkingIterator.m_firstWalker = new FilterExprWalker(walkingIterator);
                    walkingIterator.m_firstWalker.init(compiler, n2, n4);
                    this.m_exprs[n3] = walkingIterator;
                    break;
                }
                default: {
                    this.m_exprs = new LocPathIterator[n3];
                }
            }
        }
    }

    public int nextNode() {
        if (this.m_foundLast) {
            return -1;
        }
        int n2 = -1;
        if (null != this.m_iterators) {
            int n3 = this.m_iterators.length;
            int n4 = -1;
            int n5 = 0;
            while (n5 < n3) {
                int n6 = this.m_iterators[n5].getCurrentNode();
                if (-1 != n6) {
                    if (-1 == n2) {
                        n4 = n5;
                        n2 = n6;
                    } else if (n6 == n2) {
                        this.m_iterators[n5].nextNode();
                    } else {
                        DTM dTM = this.getDTM(n6);
                        if (dTM.isNodeAfter(n6, n2)) {
                            n4 = n5;
                            n2 = n6;
                        }
                    }
                }
                ++n5;
            }
            if (-1 != n2) {
                this.m_iterators[n4].nextNode();
                this.incrementCurrentPos();
            } else {
                this.m_foundLast = true;
            }
        }
        this.m_lastFetched = n2;
        return n2;
    }

    public void fixupVariables(Vector vector, int n2) {
        int n3 = 0;
        while (n3 < this.m_exprs.length) {
            this.m_exprs[n3].fixupVariables(vector, n2);
            ++n3;
        }
    }

    public int getAxis() {
        return -1;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        if (xPathVisitor.visitUnionPath(expressionOwner, this) && null != this.m_exprs) {
            int n2 = this.m_exprs.length;
            int n3 = 0;
            while (n3 < n2) {
                this.m_exprs[n3].callVisitors(new iterOwner(this, n3), xPathVisitor);
                ++n3;
            }
        }
    }

    public boolean deepEquals(Expression expression) {
        if (!super.deepEquals(expression)) {
            return false;
        }
        UnionPathIterator unionPathIterator = (UnionPathIterator)expression;
        if (null != this.m_exprs) {
            int n2 = this.m_exprs.length;
            if (null == unionPathIterator.m_exprs || unionPathIterator.m_exprs.length != n2) {
                return false;
            }
            int n3 = 0;
            while (n3 < n2) {
                if (!this.m_exprs[n3].deepEquals(unionPathIterator.m_exprs[n3])) {
                    return false;
                }
                ++n3;
            }
        } else if (null != unionPathIterator.m_exprs) {
            return false;
        }
        return true;
    }

    public class iterOwner
    implements ExpressionOwner {
        public int a;
        private final UnionPathIterator this$0;

        public iterOwner(UnionPathIterator unionPathIterator, int n2) {
            this.this$0 = unionPathIterator;
            this.a = n2;
        }

        public Expression getExpression() {
            return this.this$0.m_exprs[this.a];
        }

        public void setExpression(Expression expression) {
            if (!(expression instanceof LocPathIterator)) {
                WalkingIterator walkingIterator = new WalkingIterator(this.this$0.getPrefixResolver());
                FilterExprWalker filterExprWalker = new FilterExprWalker(walkingIterator);
                walkingIterator.setFirstWalker(filterExprWalker);
                filterExprWalker.setInnerExpression(expression);
                walkingIterator.exprSetParent(this.this$0);
                filterExprWalker.exprSetParent(walkingIterator);
                expression.exprSetParent(filterExprWalker);
                expression = walkingIterator;
            } else {
                expression.exprSetParent(this.this$0);
            }
            this.this$0.m_exprs[this.a] = (LocPathIterator)expression;
        }
    }
}

