/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.axes;

import javax.xml.transform.TransformerException;
import org.apache.xml.dtm.DTMIterator;
import org.apache.xpath.Expression;
import org.apache.xpath.axes.AttributeIterator;
import org.apache.xpath.axes.AxesWalker;
import org.apache.xpath.axes.ChildIterator;
import org.apache.xpath.axes.ChildTestIterator;
import org.apache.xpath.axes.DescendantIterator;
import org.apache.xpath.axes.FilterExprWalker;
import org.apache.xpath.axes.LocPathIterator;
import org.apache.xpath.axes.MatchPatternIterator;
import org.apache.xpath.axes.OneStepIterator;
import org.apache.xpath.axes.OneStepIteratorForward;
import org.apache.xpath.axes.ReverseAxesWalker;
import org.apache.xpath.axes.SelfIteratorNoPredicate;
import org.apache.xpath.axes.WalkingIterator;
import org.apache.xpath.axes.WalkingIteratorSorted;
import org.apache.xpath.compiler.Compiler;
import org.apache.xpath.compiler.OpMap;
import org.apache.xpath.patterns.FunctionPattern;
import org.apache.xpath.patterns.StepPattern;
import org.apache.xpath.res.XPATHMessages;

public class WalkerFactory {
    public static final int BITS_COUNT = 255;
    public static final int BITS_RESERVED = 3840;
    public static final int BIT_PREDICATE = 4096;
    public static final int BIT_ANCESTOR = 8192;
    public static final int BIT_ANCESTOR_OR_SELF = 16384;
    public static final int BIT_ATTRIBUTE = 32768;
    public static final int BIT_CHILD = 65536;
    public static final int BIT_DESCENDANT = 131072;
    public static final int BIT_DESCENDANT_OR_SELF = 262144;
    public static final int BIT_FOLLOWING = 524288;
    public static final int BIT_FOLLOWING_SIBLING = 0x100000;
    public static final int BIT_NAMESPACE = 0x200000;
    public static final int BIT_PARENT = 0x400000;
    public static final int BIT_PRECEDING = 0x800000;
    public static final int BIT_PRECEDING_SIBLING = 0x1000000;
    public static final int BIT_SELF = 0x2000000;
    public static final int BIT_FILTER = 0x4000000;
    public static final int BIT_ROOT = 0x8000000;
    public static final int BITMASK_TRAVERSES_OUTSIDE_SUBTREE = 234381312;
    public static final int BIT_BACKWARDS_SELF = 0x10000000;
    public static final int BIT_ANY_DESCENDANT_FROM_ROOT = 0x20000000;
    public static final int BIT_NODETEST_ANY = 0x40000000;
    public static final int BIT_MATCH_PATTERN = Integer.MIN_VALUE;

    public static AxesWalker a(WalkingIterator walkingIterator, Compiler compiler, int n2, int n3) throws TransformerException {
        int n4;
        AxesWalker axesWalker = null;
        AxesWalker axesWalker2 = null;
        int n5 = WalkerFactory.analyze(compiler, n2, n3);
        while (-1 != (n4 = compiler.getOp(n2))) {
            AxesWalker axesWalker3 = WalkerFactory.createDefaultWalker(compiler, n2, walkingIterator, n5);
            axesWalker3.init(compiler, n2, n4);
            axesWalker3.exprSetParent(walkingIterator);
            if (null == axesWalker) {
                axesWalker = axesWalker3;
            } else {
                axesWalker2.setNextWalker(axesWalker3);
                axesWalker3.setPrevWalker(axesWalker2);
            }
            axesWalker2 = axesWalker3;
            n2 = compiler.getNextStepPos(n2);
            if (n2 < 0) break;
        }
        return axesWalker;
    }

    public static boolean isSet(int n2, int n3) {
        return 0 != (n2 & n3);
    }

    public static void diagnoseIterator(String string, int n2, Compiler compiler) {
        System.out.println(compiler.toString() + ", " + string + ", " + Integer.toBinaryString(n2) + ", " + WalkerFactory.getAnalysisString(n2));
    }

    public static DTMIterator newDTMIterator(Compiler compiler, int n2, boolean bl2) throws TransformerException {
        int n3 = OpMap.getFirstChildPos(n2);
        int n4 = WalkerFactory.analyze(compiler, n3, 0);
        boolean bl3 = WalkerFactory.isOneStep(n4);
        LocPathIterator locPathIterator = bl3 && WalkerFactory.walksSelfOnly(n4) && WalkerFactory.isWild(n4) && !WalkerFactory.hasPredicate(n4) ? new SelfIteratorNoPredicate(compiler, n2, n4) : (WalkerFactory.walksChildrenOnly(n4) && bl3 ? (WalkerFactory.isWild(n4) && !WalkerFactory.hasPredicate(n4) ? new ChildIterator(compiler, n2, n4) : new ChildTestIterator(compiler, n2, n4)) : (bl3 && WalkerFactory.walksAttributes(n4) ? new AttributeIterator(compiler, n2, n4) : (bl3 && !WalkerFactory.walksFilteredList(n4) ? (!WalkerFactory.walksNamespaces(n4) && (WalkerFactory.walksInDocOrder(n4) || WalkerFactory.isSet(n4, 0x400000)) ? new OneStepIteratorForward(compiler, n2, n4) : new OneStepIterator(compiler, n2, n4)) : (WalkerFactory.isOptimizableForDescendantIterator(compiler, n3, 0) ? new DescendantIterator(compiler, n2, n4) : (WalkerFactory.isNaturalDocOrder(compiler, n3, 0, n4) ? new WalkingIterator(compiler, n2, n4, true) : new WalkingIteratorSorted(compiler, n2, n4, true))))));
        if (locPathIterator instanceof LocPathIterator) {
            ((LocPathIterator)locPathIterator).setIsTopLevel(bl2);
        }
        return locPathIterator;
    }

    public static int getAxisFromStep(Compiler compiler, int n2) throws TransformerException {
        int n3 = compiler.getOp(n2);
        switch (n3) {
            case 43: {
                return 6;
            }
            case 44: {
                return 7;
            }
            case 46: {
                return 11;
            }
            case 47: {
                return 12;
            }
            case 45: {
                return 10;
            }
            case 49: {
                return 9;
            }
            case 37: {
                return 0;
            }
            case 38: {
                return 1;
            }
            case 39: {
                return 2;
            }
            case 50: {
                return 19;
            }
            case 40: {
                return 3;
            }
            case 42: {
                return 5;
            }
            case 41: {
                return 4;
            }
            case 48: {
                return 13;
            }
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                return 20;
            }
        }
        throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", new Object[]{Integer.toString(n3)}));
    }

    public static int getAnalysisBitFromAxes(int n2) {
        switch (n2) {
            case 0: {
                return 8192;
            }
            case 1: {
                return 16384;
            }
            case 2: {
                return 32768;
            }
            case 3: {
                return 65536;
            }
            case 4: {
                return 131072;
            }
            case 5: {
                return 262144;
            }
            case 6: {
                return 524288;
            }
            case 7: {
                return 0x100000;
            }
            case 8: 
            case 9: {
                return 0x200000;
            }
            case 10: {
                return 0x400000;
            }
            case 11: {
                return 0x800000;
            }
            case 12: {
                return 0x1000000;
            }
            case 13: {
                return 0x2000000;
            }
            case 14: {
                return 262144;
            }
            case 16: 
            case 17: 
            case 18: {
                return 0x20000000;
            }
            case 19: {
                return 0x8000000;
            }
            case 20: {
                return 0x4000000;
            }
        }
        return 0x4000000;
    }

    public static boolean a(Compiler compiler, int n2) {
        int n3 = n2 + compiler.getOp(n2 + 1) - 1;
        n2 = OpMap.getFirstChildPos(n2);
        int n4 = compiler.getOp(n2);
        switch (n4) {
            case 1: 
            case 2: {
                return true;
            }
        }
        int n5 = 0;
        int n6 = ++n2;
        while (n6 < n3) {
            int n7 = n6 + 2;
            int n8 = compiler.getOp(n7);
            boolean bl2 = WalkerFactory.b(compiler, n7);
            if (bl2) {
                return true;
            }
            n6 = compiler.getNextOpPos(n6);
            ++n5;
        }
        return false;
    }

    public static boolean b(Compiler compiler, int n2) {
        int n3 = compiler.getOp(n2);
        int n4 = n2 + 2;
        switch (n3) {
            case 26: {
                if (!WalkerFactory.b(compiler, n4)) break;
                return true;
            }
            case 21: 
            case 22: 
            case 27: 
            case 28: {
                break;
            }
            case 25: {
                boolean bl2 = WalkerFactory.a(compiler, n2);
                if (!bl2) break;
                return true;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                int n5 = OpMap.getFirstChildPos(n3);
                int n6 = compiler.getNextOpPos(n5);
                boolean bl3 = WalkerFactory.b(compiler, n5);
                if (bl3) {
                    return true;
                }
                bl3 = WalkerFactory.b(compiler, n6);
                if (!bl3) break;
                return true;
            }
            default: {
                return true;
            }
        }
        return false;
    }

    public static boolean mightBeProximate(Compiler compiler, int n2, int n3) throws TransformerException {
        boolean bl2 = false;
        switch (n3) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n4 = compiler.getArgLength(n2);
                break;
            }
            default: {
                int n4 = compiler.getArgLengthOfStep(n2);
            }
        }
        int n5 = compiler.getFirstPredicateOpPos(n2);
        int n6 = 0;
        while (29 == compiler.getOp(n5)) {
            ++n6;
            int n7 = n5 + 2;
            int n8 = compiler.getOp(n7);
            switch (n8) {
                case 22: {
                    return true;
                }
                case 28: {
                    break;
                }
                case 19: 
                case 27: {
                    return true;
                }
                case 25: {
                    boolean bl3 = WalkerFactory.a(compiler, n7);
                    if (!bl3) break;
                    return true;
                }
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: {
                    int n9 = OpMap.getFirstChildPos(n7);
                    int n10 = compiler.getNextOpPos(n9);
                    boolean bl3 = WalkerFactory.b(compiler, n9);
                    if (bl3) {
                        return true;
                    }
                    bl3 = WalkerFactory.b(compiler, n10);
                    if (!bl3) break;
                    return true;
                }
                default: {
                    return true;
                }
            }
            n5 = compiler.getNextOpPos(n5);
        }
        return bl2;
    }

    private static boolean isOptimizableForDescendantIterator(Compiler compiler, int n2, int n3) throws TransformerException {
        int n4;
        int n5 = 0;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        int n6 = 1033;
        while (-1 != (n4 = compiler.getOp(n2))) {
            if (n6 != 1033 && n6 != 35) {
                return false;
            }
            if (++n5 > 3) {
                return false;
            }
            boolean bl5 = WalkerFactory.mightBeProximate(compiler, n2, n4);
            if (bl5) {
                return false;
            }
            switch (n4) {
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 37: 
                case 38: 
                case 39: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 51: 
                case 52: 
                case 53: {
                    return false;
                }
                case 50: {
                    if (1 == n5) break;
                    return false;
                }
                case 40: {
                    if (bl4 || bl2 && bl3) break;
                    return false;
                }
                case 42: {
                    bl4 = true;
                }
                case 41: {
                    if (3 == n5) {
                        return false;
                    }
                    bl2 = true;
                    break;
                }
                case 48: {
                    if (1 != n5) {
                        return false;
                    }
                    bl3 = true;
                    break;
                }
                default: {
                    throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", new Object[]{Integer.toString(n4)}));
                }
            }
            n6 = compiler.getStepTestType(n2);
            int n7 = compiler.getNextStepPos(n2);
            if (n7 < 0) break;
            if (-1 != compiler.getOp(n7) && compiler.countPredicates(n2) > 0) {
                return false;
            }
            n2 = n7;
        }
        return true;
    }

    private static int analyze(Compiler compiler, int n2, int n3) throws TransformerException {
        int n4;
        int n5 = 0;
        int n6 = 0;
        while (-1 != (n4 = compiler.getOp(n2))) {
            ++n5;
            boolean bl2 = WalkerFactory.a(compiler, n2, n4);
            if (bl2) {
                n6 |= 0x1000;
            }
            switch (n4) {
                case 22: 
                case 23: 
                case 24: 
                case 25: {
                    n6 |= 0x4000000;
                    break;
                }
                case 50: {
                    n6 |= 0x8000000;
                    break;
                }
                case 37: {
                    n6 |= 0x2000;
                    break;
                }
                case 38: {
                    n6 |= 0x4000;
                    break;
                }
                case 39: {
                    n6 |= 0x8000;
                    break;
                }
                case 49: {
                    n6 |= 0x200000;
                    break;
                }
                case 40: {
                    n6 |= 0x10000;
                    break;
                }
                case 41: {
                    n6 |= 0x20000;
                    break;
                }
                case 42: {
                    if (2 == n5 && 0x8000000 == n6) {
                        n6 |= 0x20000000;
                    }
                    n6 |= 0x40000;
                    break;
                }
                case 43: {
                    n6 |= 0x80000;
                    break;
                }
                case 44: {
                    n6 |= 0x100000;
                    break;
                }
                case 46: {
                    n6 |= 0x800000;
                    break;
                }
                case 47: {
                    n6 |= 0x1000000;
                    break;
                }
                case 45: {
                    n6 |= 0x400000;
                    break;
                }
                case 48: {
                    n6 |= 0x2000000;
                    break;
                }
                case 51: {
                    n6 |= 0x80008000;
                    break;
                }
                case 52: {
                    n6 |= 0x80002000;
                    break;
                }
                case 53: {
                    n6 |= 0x80400000;
                    break;
                }
                default: {
                    throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", new Object[]{Integer.toString(n4)}));
                }
            }
            if (1033 == compiler.getOp(n2 + 3)) {
                n6 |= 0x40000000;
            }
            if ((n2 = compiler.getNextStepPos(n2)) < 0) break;
        }
        return n6 |= n5 & 0xFF;
    }

    public static boolean isDownwardAxisOfMany(int n2) {
        return 5 == n2 || 4 == n2 || 6 == n2 || 11 == n2;
    }

    private static StepPattern createDefaultStepPattern(Compiler compiler, int n2, MatchPatternIterator matchPatternIterator, int n3, StepPattern stepPattern, StepPattern stepPattern2) throws TransformerException {
        int n4;
        int n5;
        int n6 = compiler.getOp(n2);
        boolean bl2 = false;
        int n7 = n3 & 0xFF;
        boolean bl3 = true;
        int n8 = OpMap.getFirstChildPos(n2);
        int n9 = compiler.getWhatToShow(n2);
        StepPattern stepPattern3 = null;
        switch (n6) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                Expression expression;
                bl3 = false;
                switch (n6) {
                    case 22: 
                    case 23: 
                    case 24: 
                    case 25: {
                        expression = compiler.compile(n2);
                        break;
                    }
                    default: {
                        expression = compiler.compile(n2 + 2);
                    }
                }
                n5 = 20;
                n4 = 20;
                stepPattern3 = new FunctionPattern(expression, n5, n4);
                bl2 = true;
                break;
            }
            case 50: {
                n9 = 1280;
                n5 = 19;
                n4 = 19;
                stepPattern3 = new StepPattern(1280, n5, n4);
                break;
            }
            case 39: {
                n9 = 2;
                n5 = 10;
                n4 = 2;
                break;
            }
            case 49: {
                n9 = 4096;
                n5 = 10;
                n4 = 9;
                break;
            }
            case 37: {
                n5 = 4;
                n4 = 0;
                break;
            }
            case 40: {
                n5 = 10;
                n4 = 3;
                break;
            }
            case 38: {
                n5 = 5;
                n4 = 1;
                break;
            }
            case 48: {
                n5 = 13;
                n4 = 13;
                break;
            }
            case 45: {
                n5 = 3;
                n4 = 10;
                break;
            }
            case 47: {
                n5 = 7;
                n4 = 12;
                break;
            }
            case 46: {
                n5 = 6;
                n4 = 11;
                break;
            }
            case 44: {
                n5 = 12;
                n4 = 7;
                break;
            }
            case 43: {
                n5 = 11;
                n4 = 6;
                break;
            }
            case 42: {
                n5 = 1;
                n4 = 5;
                break;
            }
            case 41: {
                n5 = 0;
                n4 = 4;
                break;
            }
            default: {
                throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", new Object[]{Integer.toString(n6)}));
            }
        }
        if (null == stepPattern3) {
            n9 = compiler.getWhatToShow(n2);
            stepPattern3 = new StepPattern(n9, compiler.getStepNS(n2), compiler.getStepLocalName(n2), n5, n4);
        }
        int n10 = compiler.getFirstPredicateOpPos(n2);
        stepPattern3.setPredicates(compiler.getCompiledPredicates(n10));
        return stepPattern3;
    }

    public static boolean a(Compiler compiler, int n2, int n3) throws TransformerException {
        switch (n3) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                int n4 = compiler.getArgLength(n2);
                break;
            }
            default: {
                int n5 = compiler.getArgLengthOfStep(n2);
            }
        }
        int n6 = compiler.getFirstPredicateOpPos(n2);
        int n7 = compiler.countPredicates(n6);
        return n7 > 0;
    }

    private static AxesWalker createDefaultWalker(Compiler compiler, int n2, WalkingIterator walkingIterator, int n3) {
        AxesWalker axesWalker = null;
        int n4 = compiler.getOp(n2);
        boolean bl2 = false;
        int n5 = n3 & 0xFF;
        boolean bl3 = true;
        switch (n4) {
            case 22: 
            case 23: 
            case 24: 
            case 25: {
                bl3 = false;
                axesWalker = new FilterExprWalker(walkingIterator);
                bl2 = true;
                break;
            }
            case 50: {
                axesWalker = new AxesWalker(walkingIterator, 19);
                break;
            }
            case 37: {
                bl3 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 0);
                break;
            }
            case 38: {
                bl3 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 1);
                break;
            }
            case 39: {
                axesWalker = new AxesWalker(walkingIterator, 2);
                break;
            }
            case 49: {
                axesWalker = new AxesWalker(walkingIterator, 9);
                break;
            }
            case 40: {
                axesWalker = new AxesWalker(walkingIterator, 3);
                break;
            }
            case 41: {
                bl3 = false;
                axesWalker = new AxesWalker(walkingIterator, 4);
                break;
            }
            case 42: {
                bl3 = false;
                axesWalker = new AxesWalker(walkingIterator, 5);
                break;
            }
            case 43: {
                bl3 = false;
                axesWalker = new AxesWalker(walkingIterator, 6);
                break;
            }
            case 44: {
                bl3 = false;
                axesWalker = new AxesWalker(walkingIterator, 7);
                break;
            }
            case 46: {
                bl3 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 11);
                break;
            }
            case 47: {
                bl3 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 12);
                break;
            }
            case 45: {
                bl3 = false;
                axesWalker = new ReverseAxesWalker(walkingIterator, 10);
                break;
            }
            case 48: {
                axesWalker = new AxesWalker(walkingIterator, 13);
                break;
            }
            default: {
                throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", new Object[]{Integer.toString(n4)}));
            }
        }
        if (bl2) {
            axesWalker.initNodeTest(-1);
        } else {
            int n6 = compiler.getWhatToShow(n2);
            if (0 == (n6 & 0x1043) || n6 == -1) {
                axesWalker.initNodeTest(n6);
            } else {
                axesWalker.initNodeTest(n6, compiler.getStepNS(n2), compiler.getStepLocalName(n2));
            }
        }
        return axesWalker;
    }

    public static String getAnalysisString(int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("count: " + WalkerFactory.getStepCount(n2) + " ");
        if ((n2 & 0x40000000) != 0) {
            stringBuffer.append("NTANY|");
        }
        if ((n2 & 0x1000) != 0) {
            stringBuffer.append("PRED|");
        }
        if ((n2 & 0x2000) != 0) {
            stringBuffer.append("ANC|");
        }
        if ((n2 & 0x4000) != 0) {
            stringBuffer.append("ANCOS|");
        }
        if ((n2 & 0x8000) != 0) {
            stringBuffer.append("ATTR|");
        }
        if ((n2 & 0x10000) != 0) {
            stringBuffer.append("CH|");
        }
        if ((n2 & 0x20000) != 0) {
            stringBuffer.append("DESC|");
        }
        if ((n2 & 0x40000) != 0) {
            stringBuffer.append("DESCOS|");
        }
        if ((n2 & 0x80000) != 0) {
            stringBuffer.append("FOL|");
        }
        if ((n2 & 0x100000) != 0) {
            stringBuffer.append("FOLS|");
        }
        if ((n2 & 0x200000) != 0) {
            stringBuffer.append("NS|");
        }
        if ((n2 & 0x400000) != 0) {
            stringBuffer.append("P|");
        }
        if ((n2 & 0x800000) != 0) {
            stringBuffer.append("PREC|");
        }
        if ((n2 & 0x1000000) != 0) {
            stringBuffer.append("PRECS|");
        }
        if ((n2 & 0x2000000) != 0) {
            stringBuffer.append(".|");
        }
        if ((n2 & 0x4000000) != 0) {
            stringBuffer.append("FLT|");
        }
        if ((n2 & 0x8000000) != 0) {
            stringBuffer.append("R|");
        }
        return stringBuffer.toString();
    }

    public static boolean hasPredicate(int n2) {
        return 0 != (n2 & 0x1000);
    }

    public static boolean isWild(int n2) {
        return 0 != (n2 & 0x40000000);
    }

    public static boolean walksAncestors(int n2) {
        return WalkerFactory.isSet(n2, 24576);
    }

    public static boolean walksAttributes(int n2) {
        return 0 != (n2 & 0x8000);
    }

    public static boolean walksNamespaces(int n2) {
        return 0 != (n2 & 0x200000);
    }

    public static boolean walksChildren(int n2) {
        return 0 != (n2 & 0x10000);
    }

    public static boolean walksDescendants(int n2) {
        return WalkerFactory.isSet(n2, 393216);
    }

    public static boolean walksSubtree(int n2) {
        return WalkerFactory.isSet(n2, 458752);
    }

    public static boolean walksSubtreeOnlyMaybeAbsolute(int n2) {
        return WalkerFactory.walksSubtree(n2) && !WalkerFactory.walksExtraNodes(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2);
    }

    public static boolean walksSubtreeOnly(int n2) {
        return WalkerFactory.walksSubtreeOnlyMaybeAbsolute(n2) && !WalkerFactory.isAbsolute(n2);
    }

    public static boolean walksFilteredList(int n2) {
        return WalkerFactory.isSet(n2, 0x4000000);
    }

    public static boolean walksSubtreeOnlyFromRootOrContext(int n2) {
        return WalkerFactory.walksSubtree(n2) && !WalkerFactory.walksExtraNodes(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && !WalkerFactory.isSet(n2, 0x4000000);
    }

    public static boolean walksInDocOrder(int n2) {
        return (WalkerFactory.walksSubtreeOnlyMaybeAbsolute(n2) || WalkerFactory.walksExtraNodesOnly(n2) || WalkerFactory.walksFollowingOnlyMaybeAbsolute(n2)) && !WalkerFactory.isSet(n2, 0x4000000);
    }

    public static boolean walksFollowingOnlyMaybeAbsolute(int n2) {
        return WalkerFactory.isSet(n2, 35127296) && !WalkerFactory.walksSubtree(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2);
    }

    public static boolean walksUp(int n2) {
        return WalkerFactory.isSet(n2, 0x406000);
    }

    public static boolean walksSideways(int n2) {
        return WalkerFactory.isSet(n2, 26738688);
    }

    public static boolean walksExtraNodes(int n2) {
        return WalkerFactory.isSet(n2, 0x208000);
    }

    public static boolean walksExtraNodesOnly(int n2) {
        return WalkerFactory.walksExtraNodes(n2) && !WalkerFactory.isSet(n2, 0x2000000) && !WalkerFactory.walksSubtree(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && !WalkerFactory.isAbsolute(n2);
    }

    public static boolean isAbsolute(int n2) {
        return WalkerFactory.isSet(n2, 0xC000000);
    }

    public static boolean walksChildrenOnly(int n2) {
        return WalkerFactory.walksChildren(n2) && !WalkerFactory.isSet(n2, 0x2000000) && !WalkerFactory.walksExtraNodes(n2) && !WalkerFactory.walksDescendants(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && (!WalkerFactory.isAbsolute(n2) || WalkerFactory.isSet(n2, 0x8000000));
    }

    public static boolean walksChildrenAndExtraAndSelfOnly(int n2) {
        return WalkerFactory.walksChildren(n2) && !WalkerFactory.walksDescendants(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && (!WalkerFactory.isAbsolute(n2) || WalkerFactory.isSet(n2, 0x8000000));
    }

    public static boolean walksDescendantsAndExtraAndSelfOnly(int n2) {
        return !WalkerFactory.walksChildren(n2) && WalkerFactory.walksDescendants(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && (!WalkerFactory.isAbsolute(n2) || WalkerFactory.isSet(n2, 0x8000000));
    }

    public static boolean walksSelfOnly(int n2) {
        return WalkerFactory.isSet(n2, 0x2000000) && !WalkerFactory.walksSubtree(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && !WalkerFactory.isAbsolute(n2);
    }

    public static boolean walksUpOnly(int n2) {
        return !WalkerFactory.walksSubtree(n2) && WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && !WalkerFactory.isAbsolute(n2);
    }

    public static boolean walksDownOnly(int n2) {
        return WalkerFactory.walksSubtree(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && !WalkerFactory.isAbsolute(n2);
    }

    public static boolean walksDownExtraOnly(int n2) {
        return WalkerFactory.walksSubtree(n2) && WalkerFactory.walksExtraNodes(n2) && !WalkerFactory.walksUp(n2) && !WalkerFactory.walksSideways(n2) && !WalkerFactory.isAbsolute(n2);
    }

    public static boolean canSkipSubtrees(int n2) {
        return WalkerFactory.isSet(n2, 65536) | WalkerFactory.walksSideways(n2);
    }

    public static boolean canCrissCross(int n2) {
        if (WalkerFactory.walksSelfOnly(n2)) {
            return false;
        }
        if (WalkerFactory.walksDownOnly(n2) && !WalkerFactory.canSkipSubtrees(n2)) {
            return false;
        }
        if (WalkerFactory.walksChildrenAndExtraAndSelfOnly(n2)) {
            return false;
        }
        if (WalkerFactory.walksDescendantsAndExtraAndSelfOnly(n2)) {
            return false;
        }
        if (WalkerFactory.walksUpOnly(n2)) {
            return false;
        }
        if (WalkerFactory.walksExtraNodesOnly(n2)) {
            return false;
        }
        return WalkerFactory.walksSubtree(n2) && (WalkerFactory.walksSideways(n2) || WalkerFactory.walksUp(n2) || WalkerFactory.canSkipSubtrees(n2));
    }

    public static boolean isNaturalDocOrder(int n2) {
        if (WalkerFactory.canCrissCross(n2) || WalkerFactory.isSet(n2, 0x200000) || WalkerFactory.walksFilteredList(n2)) {
            return false;
        }
        return WalkerFactory.walksInDocOrder(n2);
    }

    private static boolean isNaturalDocOrder(Compiler compiler, int n2, int n3, int n4) throws TransformerException {
        int n5;
        if (WalkerFactory.canCrissCross(n4)) {
            return false;
        }
        if (WalkerFactory.isSet(n4, 0x200000)) {
            return false;
        }
        if (WalkerFactory.isSet(n4, 0x180000) && WalkerFactory.isSet(n4, 0x1800000)) {
            return false;
        }
        int n6 = 0;
        boolean bl2 = false;
        int n7 = 0;
        while (-1 != (n5 = compiler.getOp(n2))) {
            int n8;
            ++n6;
            switch (n5) {
                case 39: 
                case 51: {
                    if (bl2) {
                        return false;
                    }
                    String string = compiler.getStepLocalName(n2);
                    if (!string.equals("*")) break;
                    bl2 = true;
                    break;
                }
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 37: 
                case 38: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 49: 
                case 52: 
                case 53: {
                    if (n7 > 0) {
                        return false;
                    }
                    ++n7;
                }
                case 40: 
                case 48: 
                case 50: {
                    if (!bl2) break;
                    return false;
                }
                default: {
                    throw new RuntimeException(XPATHMessages.createXPATHMessage("ER_NULL_ERROR_HANDLER", new Object[]{Integer.toString(n5)}));
                }
            }
            if ((n8 = compiler.getNextStepPos(n2)) < 0) break;
            n2 = n8;
        }
        return true;
    }

    public static boolean isOneStep(int n2) {
        return (n2 & 0xFF) == 1;
    }

    public static int getStepCount(int n2) {
        return n2 & 0xFF;
    }
}

