/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xpath.objects;

import javax.xml.transform.TransformerException;
import org.apache.xml.utils.WrappedRuntimeException;
import org.apache.xpath.ExpressionOwner;
import org.apache.xpath.XPathContext;
import org.apache.xpath.XPathVisitor;
import org.apache.xpath.objects.XObject;

public class XNumber
extends XObject {
    public double a;

    public XNumber(double d2) {
        this.a = d2;
    }

    public XNumber(Number number) {
        this.a = number.doubleValue();
        this.m_obj = number;
    }

    public int getType() {
        return 2;
    }

    public String getTypeString() {
        return "#NUMBER";
    }

    public double num() {
        return this.a;
    }

    public double num(XPathContext xPathContext) throws TransformerException {
        return this.a;
    }

    public boolean bool() {
        return !Double.isNaN(this.a) && this.a != 0.0;
    }

    /*
     * Unable to fully structure code
     */
    public String str() {
        if (Double.isNaN(this.a)) {
            return "NaN";
        }
        if (Double.isInfinite(this.a)) {
            if (this.a > 0.0) {
                return "Infinity";
            }
            return "-Infinity";
        }
        var1_1 = this.a;
        var3_2 = Double.toString(var1_1);
        if (var3_2.charAt((var4_3 = var3_2.length()) - 2) == '.' && var3_2.charAt(var4_3 - 1) == '0') {
            if ((var3_2 = var3_2.substring(0, var4_3 - 2)).equals("-0")) {
                return "0";
            }
            return var3_2;
        }
        var5_4 = var3_2.indexOf(69);
        if (var5_4 < 0) {
            if (var3_2.charAt(var4_3 - 1) == '0') {
                return var3_2.substring(0, var4_3 - 1);
            }
            return var3_2;
        }
        var6_5 = Integer.parseInt(var3_2.substring(var5_4 + 1));
        if (var3_2.charAt(0) == '-') {
            var7_6 = "-";
            var3_2 = var3_2.substring(1);
            --var5_4;
        } else {
            var7_6 = "";
        }
        var8_7 = var5_4 - 2;
        if (var6_5 < var8_7) ** GOTO lbl29
        return var7_6 + var3_2.substring(0, 1) + var3_2.substring(2, var5_4) + XNumber.zeros(var6_5 - var8_7);
lbl-1000:
        // 1 sources

        {
            --var5_4;
lbl29:
            // 2 sources

            ** while (var3_2.charAt((int)(var5_4 - 1)) == '0')
        }
lbl30:
        // 1 sources

        if (var6_5 > 0) {
            return var7_6 + var3_2.substring(0, 1) + var3_2.substring(2, 2 + var6_5) + "." + var3_2.substring(2 + var6_5, var5_4);
        }
        return var7_6 + "0." + XNumber.zeros(-1 - var6_5) + var3_2.substring(0, 1) + var3_2.substring(2, var5_4);
    }

    private static String zeros(int n2) {
        if (n2 < 1) {
            return "";
        }
        char[] cArray = new char[n2];
        int n3 = 0;
        while (n3 < n2) {
            cArray[n3] = 48;
            ++n3;
        }
        return new String(cArray);
    }

    public Object object() {
        if (null == this.m_obj) {
            this.m_obj = new Double(this.a);
        }
        return this.m_obj;
    }

    public boolean equals(XObject xObject) {
        int n2 = xObject.getType();
        try {
            if (n2 == 4) {
                return xObject.equals(this);
            }
            if (n2 == 1) {
                return xObject.bool() == this.bool();
            }
            return this.a == xObject.num();
        }
        catch (TransformerException transformerException) {
            throw new WrappedRuntimeException(transformerException);
        }
    }

    public boolean isStableNumber() {
        return true;
    }

    public void callVisitors(ExpressionOwner expressionOwner, XPathVisitor xPathVisitor) {
        xPathVisitor.visitNumberLiteral(expressionOwner, this);
    }
}

