/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public abstract class AbstractMethodDeclaration
extends ASTNode
implements ProblemSeverities,
ReferenceContext {
    public MethodScope scope;
    public char[] selector;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int modifiers;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public Argument[] arguments;
    public TypeReference[] thrownExceptions;
    public Statement[] statements;
    public int explicitDeclarations;
    public MethodBinding binding;
    public boolean ignoreFurtherInvestigation = false;
    public boolean needFreeReturn = false;
    public Javadoc javadoc;
    public int bodyStart;
    public int bodyEnd = -1;
    public CompilationResult compilationResult;
    public boolean errorInSignature = false;

    public AbstractMethodDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n2, IProblem iProblem) {
        switch (n2) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, iProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, iProblem);
            }
            case 8: {
                throw new AbortType(this.compilationResult, iProblem);
            }
        }
        throw new AbortMethod(this.compilationResult, iProblem);
    }

    public abstract void analyseCode(ClassScope var1, InitializationFlowContext var2, FlowInfo var3);

    public void bindArguments() {
        if (this.arguments != null) {
            if (this.binding == null) {
                int n2 = 0;
                int n3 = this.arguments.length;
                while (n2 < n3) {
                    this.arguments[n2].bind(this.scope, null, true);
                    ++n2;
                }
                return;
            }
            boolean bl2 = this.binding.isAbstract() || this.binding.isNative();
            int n4 = 0;
            int n5 = this.arguments.length;
            while (n4 < n5) {
                Argument argument = this.arguments[n4];
                argument.bind(this.scope, this.binding.parameters[n4], bl2);
                if (argument.annotations != null) {
                    this.binding.tagBits |= 0x400L;
                }
                ++n4;
            }
        }
    }

    public void bindThrownExceptions() {
        block9: {
            if (this.thrownExceptions == null || this.binding == null || this.binding.thrownExceptions == null) break block9;
            int n2 = this.binding.thrownExceptions.length;
            int n3 = this.thrownExceptions.length;
            if (n2 == n3) {
                int n4 = 0;
                while (n4 < n2) {
                    this.thrownExceptions[n4].resolvedType = this.binding.thrownExceptions[n4];
                    ++n4;
                }
            } else {
                int n5 = 0;
                int n6 = 0;
                while (n6 < n3 && n5 < n2) {
                    TypeReference typeReference = this.thrownExceptions[n6];
                    ReferenceBinding referenceBinding = this.binding.thrownExceptions[n5];
                    char[][] cArray = referenceBinding.compoundName;
                    if (cArray != null) {
                        if (typeReference instanceof SingleTypeReference) {
                            int n7 = cArray.length;
                            char[] cArray2 = typeReference.getTypeName()[0];
                            if (CharOperation.equals(cArray2, cArray[n7 - 1])) {
                                typeReference.resolvedType = referenceBinding;
                                ++n5;
                            }
                        } else if (CharOperation.equals(typeReference.getTypeName(), cArray)) {
                            typeReference.resolvedType = referenceBinding;
                            ++n5;
                        }
                    }
                    ++n6;
                }
            }
        }
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        int n2 = 0;
        classFile.codeStream.wideMode = false;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            IProblem[] iProblemArray = this.scope.referenceCompilationUnit().compilationResult.getProblems();
            int n3 = iProblemArray.length;
            IProblem[] iProblemArray2 = new IProblem[n3];
            System.arraycopy(iProblemArray, 0, iProblemArray2, 0, n3);
            classFile.addProblemMethod(this, this.binding, iProblemArray2);
            return;
        }
        try {
            n2 = classFile.contentsOffset;
            this.generateCode(classFile);
        }
        catch (AbortMethod abortMethod) {
            if (abortMethod.compilationResult == CodeStream.RESTART_IN_WIDE_MODE) {
                try {
                    classFile.contentsOffset = n2;
                    --classFile.methodCount;
                    classFile.codeStream.wideMode = true;
                    this.generateCode(classFile);
                }
                catch (AbortMethod abortMethod2) {
                    IProblem[] iProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
                    int n4 = iProblemArray.length;
                    IProblem[] iProblemArray3 = new IProblem[n4];
                    System.arraycopy(iProblemArray, 0, iProblemArray3, 0, n4);
                    classFile.addProblemMethod(this, this.binding, iProblemArray3, n2);
                }
            }
            IProblem[] iProblemArray = this.scope.referenceCompilationUnit().compilationResult.getAllProblems();
            int n5 = iProblemArray.length;
            IProblem[] iProblemArray4 = new IProblem[n5];
            System.arraycopy(iProblemArray, 0, iProblemArray4, 0, n5);
            classFile.addProblemMethod(this, this.binding, iProblemArray4, n2);
        }
    }

    public void generateCode(ClassFile classFile) {
        classFile.generateMethodInfoHeader(this.binding);
        int n2 = classFile.contentsOffset;
        int n3 = classFile.generateMethodInfoAttribute(this.binding);
        if (!this.binding.isNative() && !this.binding.isAbstract()) {
            int n4;
            int n5;
            int n6 = classFile.contentsOffset;
            classFile.generateCodeAttributeHeader();
            CodeStream codeStream = classFile.codeStream;
            codeStream.reset(this, classFile);
            this.scope.computeLocalVariablePositions(this.binding.isStatic() ? 0 : 1, codeStream);
            if (this.arguments != null) {
                n5 = 0;
                n4 = this.arguments.length;
                while (n5 < n4) {
                    LocalVariableBinding localVariableBinding = this.arguments[n5].binding;
                    codeStream.addVisibleLocalVariable(localVariableBinding);
                    localVariableBinding.recordInitializationStartPC(0);
                    ++n5;
                }
            }
            if (this.statements != null) {
                n5 = 0;
                n4 = this.statements.length;
                while (n5 < n4) {
                    this.statements[n5].generateCode(this.scope, codeStream);
                    ++n5;
                }
            }
            if (this.needFreeReturn) {
                codeStream.return_();
            }
            codeStream.exitUserScope(this.scope);
            codeStream.recordPositionsFrom(0, this.declarationSourceEnd);
            classFile.completeCodeAttribute(n6);
            ++n3;
        } else {
            this.checkArgumentsSize();
        }
        classFile.completeMethodInfo(n2, n3);
        if (this.ignoreFurtherInvestigation) {
            throw new AbortMethod(this.scope.referenceCompilationUnit().compilationResult, null);
        }
    }

    private void checkArgumentsSize() {
        TypeBinding[] typeBindingArray = this.binding.parameters;
        int n2 = 1;
        int n3 = 0;
        int n4 = typeBindingArray.length;
        while (n3 < n4) {
            TypeBinding typeBinding = typeBindingArray[n3];
            n2 = typeBinding == LongBinding || typeBinding == DoubleBinding ? (n2 += 2) : ++n2;
            if (n2 > 255) {
                this.scope.problemReporter().noMoreAvailableSpaceForArgument(this.scope.locals[n3], this.scope.locals[n3].declaration);
            }
            ++n3;
        }
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public boolean isAbstract() {
        if (this.binding != null) {
            return this.binding.isAbstract();
        }
        return (this.modifiers & 0x400) != 0;
    }

    public boolean isAnnotationMethod() {
        return false;
    }

    public boolean isClinit() {
        return false;
    }

    public boolean isConstructor() {
        return false;
    }

    public boolean isDefaultConstructor() {
        return false;
    }

    public boolean isInitializationMethod() {
        return false;
    }

    public boolean isMethod() {
        return false;
    }

    public boolean isNative() {
        if (this.binding != null) {
            return this.binding.isNative();
        }
        return (this.modifiers & 0x100) != 0;
    }

    public boolean isStatic() {
        if (this.binding != null) {
            return this.binding.isStatic();
        }
        return (this.modifiers & 8) != 0;
    }

    public abstract void parseStatements(Parser var1, CompilationUnitDeclaration var2);

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        int n3;
        TypeParameter[] typeParameterArray;
        if (this.javadoc != null) {
            this.javadoc.print(n2, stringBuffer);
        }
        AbstractMethodDeclaration.printIndent(n2, stringBuffer);
        AbstractMethodDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            AbstractMethodDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        if ((typeParameterArray = this.typeParameters()) != null) {
            stringBuffer.append('<');
            n3 = typeParameterArray.length - 1;
            int n4 = 0;
            while (n4 < n3) {
                typeParameterArray[n4].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n4;
            }
            typeParameterArray[n3].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        this.printReturnType(0, stringBuffer).append(this.selector).append('(');
        if (this.arguments != null) {
            n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append(')');
        if (this.thrownExceptions != null) {
            stringBuffer.append(" throws ");
            n3 = 0;
            while (n3 < this.thrownExceptions.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.thrownExceptions[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        this.printBody(n2 + 1, stringBuffer);
        return stringBuffer;
    }

    public StringBuffer printBody(int n2, StringBuffer stringBuffer) {
        if (this.isAbstract() || (this.modifiers & 0x1000000) != 0) {
            return stringBuffer.append(';');
        }
        stringBuffer.append(" {");
        if (this.statements != null) {
            int n3 = 0;
            while (n3 < this.statements.length) {
                stringBuffer.append('\n');
                this.statements[n3].printStatement(n2, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append('\n');
        AbstractMethodDeclaration.printIndent(n2 == 0 ? 0 : n2 - 1, stringBuffer).append('}');
        return stringBuffer;
    }

    public StringBuffer printReturnType(int n2, StringBuffer stringBuffer) {
        return stringBuffer;
    }

    public void resolve(ClassScope classScope) {
        if (this.binding == null) {
            this.ignoreFurtherInvestigation = true;
        }
        try {
            this.bindArguments();
            this.bindThrownExceptions();
            this.resolveJavadoc();
            AbstractMethodDeclaration.resolveAnnotations(this.scope, this.annotations, this.binding);
            this.resolveStatements();
        }
        catch (AbortMethod abortMethod) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void resolveJavadoc() {
        if (this.binding == null) {
            return;
        }
        if (this.javadoc != null) {
            this.javadoc.resolve(this.scope);
            return;
        }
        if (this.binding.declaringClass != null && !this.binding.declaringClass.isLocalType()) {
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, this.binding.modifiers);
        }
    }

    public void resolveStatements() {
        if (this.statements != null) {
            int n2 = 0;
            int n3 = this.statements.length;
            while (n2 < n3) {
                this.statements[n2].resolve(this.scope);
                ++n2;
            }
        } else if ((this.bits & 8) != 0) {
            this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd + 1);
        }
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
    }

    public TypeParameter[] typeParameters() {
        return null;
    }
}

