/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.Reference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;

public abstract class Annotation
extends Expression {
    public static final MemberValuePair[] a = new MemberValuePair[0];
    public int declarationSourceEnd;
    public Binding recipient;
    public TypeReference type;

    public static long getRetentionPolicy(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CLASS)) break;
                return 0x100000000000L;
            }
            case 'S': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_SOURCE)) break;
                return 0x80000000000L;
            }
            case 'R': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_RUNTIME)) break;
                return 0x180000000000L;
            }
        }
        return 0L;
    }

    public static long getTargetElementType(char[] cArray) {
        if (cArray == null || cArray.length == 0) {
            return 0L;
        }
        switch (cArray[0]) {
            case 'A': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_ANNOTATION_TYPE)) break;
                return 0x20000000000L;
            }
            case 'C': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_CONSTRUCTOR)) break;
                return 0x8000000000L;
            }
            case 'F': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_FIELD)) break;
                return 0x1000000000L;
            }
            case 'L': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_LOCAL_VARIABLE)) break;
                return 0x10000000000L;
            }
            case 'M': {
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_METHOD)) break;
                return 0x2000000000L;
            }
            case 'P': {
                if (CharOperation.equals(cArray, TypeConstants.UPPER_PARAMETER)) {
                    return 0x4000000000L;
                }
                if (!CharOperation.equals(cArray, TypeConstants.UPPER_PACKAGE)) break;
                return 0x40000000000L;
            }
            case 'T': {
                if (!CharOperation.equals(cArray, TypeConstants.TYPE)) break;
                return 0x800000000L;
            }
        }
        return 0L;
    }

    private long detectStandardAnnotation(Scope scope, ReferenceBinding referenceBinding, MemberValuePair memberValuePair) {
        long l2 = 0L;
        switch (referenceBinding.id) {
            case 48: {
                FieldBinding fieldBinding;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 51) break;
                l2 |= Annotation.getRetentionPolicy(fieldBinding.name);
                break;
            }
            case 50: {
                FieldBinding fieldBinding;
                l2 |= 0x400000000L;
                if (memberValuePair == null) break;
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n2 = 0;
                    int n3 = expressionArray.length;
                    while (n2 < n3) {
                        FieldBinding fieldBinding2;
                        Expression expression2 = expressionArray[n2];
                        if ((expression2.bits & 3) == 1 && (fieldBinding2 = ((Reference)expression2).fieldBinding()) != null && fieldBinding2.declaringClass.id == 52) {
                            long l3 = Annotation.getTargetElementType(fieldBinding2.name);
                            if ((l2 & l3) != 0L) {
                                scope.problemReporter().duplicateTargetInTargetAnnotation(referenceBinding, (NameReference)expression2);
                            } else {
                                l2 |= l3;
                            }
                        }
                        ++n2;
                    }
                    break;
                }
                if ((expression.bits & 3) != 1 || (fieldBinding = ((Reference)expression).fieldBinding()) == null || fieldBinding.declaringClass.id != 52) break;
                l2 |= Annotation.getTargetElementType(fieldBinding.name);
                break;
            }
            case 44: {
                l2 |= 0x200000000000L;
                break;
            }
            case 45: {
                l2 |= 0x400000000000L;
                break;
            }
            case 46: {
                l2 |= 0x800000000000L;
                break;
            }
            case 47: {
                l2 |= 0x1000000000000L;
                break;
            }
            case 49: {
                l2 |= 0x2000000000000L;
            }
        }
        return l2;
    }

    public abstract MemberValuePair[] memberValuePairs();

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append('@');
        this.type.printExpression(0, stringBuffer);
        return stringBuffer;
    }

    public void recordSuppressWarnings(Scope scope, int n2, int n3, boolean bl2) {
        long l2 = 0L;
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        int n4 = 0;
        int n5 = memberValuePairArray.length;
        block0: while (n4 < n5) {
            MemberValuePair memberValuePair = memberValuePairArray[n4];
            if (CharOperation.equals(memberValuePair.name, TypeConstants.VALUE)) {
                Expression expression = memberValuePair.value;
                if (expression instanceof ArrayInitializer) {
                    ArrayInitializer arrayInitializer = (ArrayInitializer)expression;
                    Expression[] expressionArray = arrayInitializer.expressions;
                    if (expressionArray == null) break;
                    int n6 = 0;
                    int n7 = expressionArray.length;
                    while (n6 < n7) {
                        Constant constant = expressionArray[n6].constant;
                        if (constant != Constant.NotAConstant && constant.typeID() == 11) {
                            long l3 = CompilerOptions.warningTokenToIrritant(constant.stringValue());
                            if (l3 != 0L) {
                                if (((l2 |= l3) ^ 0xFFFFFFFFFFFFFFFFL) == 0L) {
                                    break block0;
                                }
                            } else {
                                scope.problemReporter().unhandledWarningToken(expressionArray[n6]);
                            }
                        }
                        ++n6;
                    }
                    break;
                }
                Constant constant = expression.constant;
                if (constant == Constant.NotAConstant || constant.typeID() != 11) break;
                long l4 = CompilerOptions.warningTokenToIrritant(constant.stringValue());
                if (l4 != 0L) {
                    if (((l2 |= l4) ^ 0xFFFFFFFFFFFFFFFFL) != 0L) break;
                    break;
                }
                scope.problemReporter().unhandledWarningToken(expression);
                break;
            }
            ++n4;
        }
        if (bl2 && l2 != 0L) {
            scope.referenceCompilationUnit().compilationResult.recordSuppressWarnings(l2, n2, n3);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public TypeBinding resolveType(BlockScope blockScope) {
        long l2;
        this.constant = NotAConstant;
        TypeBinding typeBinding = this.type.resolveType(blockScope);
        if (typeBinding == null) {
            return null;
        }
        this.resolvedType = typeBinding;
        if (!typeBinding.isAnnotationType()) {
            blockScope.problemReporter().typeMismatchError(typeBinding, blockScope.getJavaLangAnnotationAnnotation(), this.type);
            return null;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        MemberValuePair[] memberValuePairArray = this.memberValuePairs();
        MemberValuePair memberValuePair = null;
        int n2 = memberValuePairArray.length;
        MemberValuePair[] memberValuePairArray2 = new MemberValuePair[n2];
        System.arraycopy(memberValuePairArray, 0, memberValuePairArray2, 0, n2);
        int n3 = 0;
        int n4 = methodBindingArray.length;
        while (n3 < n4) {
            block28: {
                MethodBinding methodBinding = methodBindingArray[n3];
                char[] cArray = methodBinding.selector;
                boolean bl2 = false;
                int n5 = 0;
                while (n5 < n2) {
                    char[] cArray2;
                    MemberValuePair memberValuePair2 = memberValuePairArray2[n5];
                    if (memberValuePair2 != null && CharOperation.equals(cArray2 = memberValuePair2.name, cArray)) {
                        if (memberValuePair == null && CharOperation.equals(cArray2, TypeConstants.VALUE)) {
                            memberValuePair = memberValuePair2;
                        }
                        memberValuePair2.binding = methodBinding;
                        memberValuePair2.resolveTypeExpecting(blockScope, methodBinding.returnType);
                        memberValuePairArray2[n5] = null;
                        bl2 = true;
                        boolean bl3 = false;
                        int n6 = n5 + 1;
                        while (n6 < n2) {
                            MemberValuePair memberValuePair3 = memberValuePairArray2[n6];
                            if (memberValuePair3 != null && CharOperation.equals(memberValuePair3.name, cArray)) {
                                bl3 = true;
                                blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, memberValuePair3);
                                memberValuePair3.binding = methodBinding;
                                memberValuePair3.resolveTypeExpecting(blockScope, methodBinding.returnType);
                                memberValuePairArray2[n6] = null;
                            }
                            ++n6;
                        }
                        if (bl3) {
                            blockScope.problemReporter().duplicateAnnotationValue(referenceBinding, memberValuePair2);
                            break block28;
                        }
                    }
                    ++n5;
                }
                if (!bl2 && (methodBinding.modifiers & 0x20000) == 0) {
                    blockScope.problemReporter().missingValueForAnnotationMember(this, cArray);
                }
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n2) {
            if (memberValuePairArray2[n3] != null) {
                blockScope.problemReporter().undefinedAnnotationValue(referenceBinding, memberValuePairArray2[n3]);
            }
            ++n3;
        }
        long l3 = this.detectStandardAnnotation(blockScope, referenceBinding, memberValuePair);
        blockScope.referenceCompilationUnit().compilationResult.recordSuppressWarnings(256L, this.sourceStart, this.declarationSourceEnd);
        if (this.recipient == null) return this.resolvedType;
        if (l3 != 0L) {
            switch (this.recipient.kind()) {
                case 16: {
                    ((PackageBinding)this.recipient).tagBits |= l3;
                    break;
                }
                case 4: 
                case 2052: 
                case 4100: {
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)this.recipient;
                    sourceTypeBinding.tagBits |= l3;
                    if ((l3 & 0x2000000000000L) == 0L) break;
                    TypeDeclaration typeDeclaration = sourceTypeBinding.scope.referenceContext;
                    this.recordSuppressWarnings(blockScope, typeDeclaration.declarationSourceStart, typeDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
                case 8: {
                    MethodBinding methodBinding = (MethodBinding)this.recipient;
                    methodBinding.tagBits |= l3;
                    if ((l3 & 0x2000000000000L) == 0L) break;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)methodBinding.declaringClass;
                    AbstractMethodDeclaration abstractMethodDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(methodBinding);
                    this.recordSuppressWarnings(blockScope, abstractMethodDeclaration.declarationSourceStart, abstractMethodDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
                case 1: {
                    FieldBinding fieldBinding = (FieldBinding)this.recipient;
                    fieldBinding.tagBits |= l3;
                    if ((l3 & 0x2000000000000L) == 0L) break;
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)fieldBinding.declaringClass;
                    FieldDeclaration fieldDeclaration = sourceTypeBinding.scope.referenceContext.declarationOf(fieldBinding);
                    this.recordSuppressWarnings(blockScope, fieldDeclaration.declarationSourceStart, fieldDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
                case 2: {
                    LocalVariableBinding localVariableBinding = (LocalVariableBinding)this.recipient;
                    localVariableBinding.tagBits |= l3;
                    if ((l3 & 0x2000000000000L) == 0L) break;
                    LocalDeclaration localDeclaration = localVariableBinding.declaration;
                    this.recordSuppressWarnings(blockScope, localDeclaration.declarationSourceStart, localDeclaration.declarationSourceEnd, blockScope.compilerOptions().suppressWarnings);
                    break;
                }
            }
        }
        if (((l2 = referenceBinding.getAnnotationTagBits()) & 0x7FC00000000L) == 0L) {
            return this.resolvedType;
        }
        switch (this.recipient.kind()) {
            case 16: {
                if ((l2 & 0x40000000000L) == 0L) break;
                return this.resolvedType;
            }
            case 4: 
            case 2052: {
                if (!(((ReferenceBinding)this.recipient).isAnnotationType() ? (l2 & 0x20800000000L) != 0L : (l2 & 0x800000000L) != 0L)) break;
                return this.resolvedType;
            }
            case 8: {
                if (!(((MethodBinding)this.recipient).isConstructor() ? (l2 & 0x8000000000L) != 0L : (l2 & 0x2000000000L) != 0L)) break;
                return this.resolvedType;
            }
            case 1: {
                if ((l2 & 0x1000000000L) == 0L) break;
                return this.resolvedType;
            }
            case 2: {
                if (!(((LocalVariableBinding)this.recipient).isArgument ? (l2 & 0x4000000000L) != 0L : (referenceBinding.tagBits & 0x10000000000L) != 0L)) break;
                return this.resolvedType;
            }
        }
        blockScope.problemReporter().disallowedTargetForAnnotation(this);
        return this.resolvedType;
    }

    public abstract void traverse(ASTVisitor var1, BlockScope var2);

    public abstract void traverse(ASTVisitor var1, CompilationUnitScope var2);
}

