/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayInitializer;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ArrayAllocationExpression
extends Expression {
    public TypeReference type;
    public Expression[] dimensions;
    public ArrayInitializer initializer;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        int n2 = 0;
        int n3 = this.dimensions.length;
        while (n2 < n3) {
            Expression expression = this.dimensions[n2];
            if (expression != null) {
                flowInfo = expression.analyseCode(blockScope, flowContext, flowInfo);
            }
            ++n2;
        }
        if (this.initializer != null) {
            return this.initializer.analyseCode(blockScope, flowContext, flowInfo);
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (this.initializer != null) {
            this.initializer.generateCode(blockScope, codeStream, bl2);
            return;
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = this.dimensions.length;
        while (n4 < n5) {
            if (this.dimensions[n4] != null) {
                this.dimensions[n4].generateCode(blockScope, codeStream, true);
                ++n3;
            }
            ++n4;
        }
        if (this.resolvedType.dimensions() == 1) {
            codeStream.newArray((ArrayBinding)this.resolvedType);
        } else {
            codeStream.multianewarray(this.resolvedType, n3);
        }
        if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append("new ");
        this.type.print(0, stringBuffer);
        int n3 = 0;
        while (n3 < this.dimensions.length) {
            if (this.dimensions[n3] == null) {
                stringBuffer.append("[]");
            } else {
                stringBuffer.append('[');
                this.dimensions[n3].printExpression(0, stringBuffer);
                stringBuffer.append(']');
            }
            ++n3;
        }
        if (this.initializer != null) {
            this.initializer.printExpression(0, stringBuffer);
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = this.type.resolveType(blockScope, true);
        this.constant = Constant.NotAConstant;
        if (typeBinding == VoidBinding) {
            blockScope.problemReporter().cannotAllocateVoidArray(this);
            typeBinding = null;
        }
        int n2 = -1;
        int n3 = this.dimensions.length;
        while (--n3 >= 0) {
            if (this.dimensions[n3] != null) {
                if (n2 >= 0) continue;
                n2 = n3;
                continue;
            }
            if (n2 <= 0) continue;
            blockScope.problemReporter().incorrectLocationForNonEmptyDimension(this, n2);
            break;
        }
        if (this.initializer == null) {
            if (n2 < 0) {
                blockScope.problemReporter().mustDefineDimensionsOrInitializer(this);
            }
            if (typeBinding != null && !typeBinding.isReifiable()) {
                blockScope.problemReporter().illegalGenericArray(typeBinding, this);
            }
        } else if (n2 >= 0) {
            blockScope.problemReporter().cannotDefineDimensionsAndInitializer(this);
        }
        n3 = 0;
        while (n3 <= n2) {
            TypeBinding typeBinding2;
            if (this.dimensions[n3] != null && (typeBinding2 = this.dimensions[n3].resolveTypeExpecting(blockScope, IntBinding)) != null) {
                this.dimensions[n3].computeConversion(blockScope, IntBinding, typeBinding2);
            }
            ++n3;
        }
        if (typeBinding != null) {
            if (this.dimensions.length > 255) {
                blockScope.problemReporter().tooManyDimensions(this);
            }
            this.resolvedType = blockScope.createArrayType(typeBinding, this.dimensions.length);
            if (this.initializer != null && this.initializer.resolveTypeExpecting(blockScope, this.resolvedType) != null) {
                this.initializer.binding = (ArrayBinding)this.resolvedType;
            }
        }
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2 = this.dimensions.length;
            this.type.traverse(aSTVisitor, blockScope);
            int n3 = 0;
            while (n3 < n2) {
                if (this.dimensions[n3] != null) {
                    this.dimensions[n3].traverse(aSTVisitor, blockScope);
                }
                ++n3;
            }
            if (this.initializer != null) {
                this.initializer.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

