/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;

public class ArrayInitializer
extends Expression {
    public Expression[] expressions;
    public ArrayBinding binding;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.expressions != null) {
            int n2 = 0;
            int n3 = this.expressions.length;
            while (n2 < n3) {
                flowInfo = this.expressions[n2].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n2;
            }
        }
        return flowInfo;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2;
        block13: {
            n2 = codeStream.position;
            int n3 = this.expressions == null ? 0 : this.expressions.length;
            codeStream.generateInlinedValue(n3);
            codeStream.newArray(this.binding);
            if (this.expressions == null) break block13;
            int n4 = this.binding.dimensions > 1 ? -1 : this.binding.leafComponentType.id;
            int n5 = 0;
            while (n5 < n3) {
                block15: {
                    Expression expression;
                    block14: {
                        expression = this.expressions[n5];
                        if (expression.constant == NotAConstant) break block14;
                        switch (n4) {
                            case 2: 
                            case 3: 
                            case 4: 
                            case 7: 
                            case 10: {
                                if (expression.constant.longValue() != 0L) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n5);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n4, false);
                                    break;
                                }
                                break block15;
                            }
                            case 8: 
                            case 9: {
                                double d2 = expression.constant.doubleValue();
                                if (d2 == -0.0 || d2 != 0.0) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n5);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n4, false);
                                    break;
                                }
                                break block15;
                            }
                            case 5: {
                                if (expression.constant.booleanValue()) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n5);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n4, false);
                                    break;
                                }
                                break block15;
                            }
                            default: {
                                if (!(expression instanceof NullLiteral)) {
                                    codeStream.dup();
                                    codeStream.generateInlinedValue(n5);
                                    expression.generateCode(blockScope, codeStream, true);
                                    codeStream.arrayAtPut(n4, false);
                                    break;
                                }
                                break block15;
                            }
                        }
                        break block15;
                    }
                    if (!(expression instanceof NullLiteral)) {
                        codeStream.dup();
                        codeStream.generateInlinedValue(n5);
                        expression.generateCode(blockScope, codeStream, true);
                        codeStream.arrayAtPut(n4, false);
                    }
                }
                ++n5;
            }
        }
        if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            codeStream.pop();
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        stringBuffer.append('{');
        if (this.expressions != null) {
            int n3 = 20;
            int n4 = 0;
            while (n4 < this.expressions.length) {
                if (n4 > 0) {
                    stringBuffer.append(", ");
                }
                this.expressions[n4].printExpression(0, stringBuffer);
                if (--n3 == 0) {
                    stringBuffer.append('\n');
                    ArrayInitializer.printIndent(n2 + 1, stringBuffer);
                    n3 = 20;
                }
                ++n4;
            }
        }
        return stringBuffer.append('}');
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        TypeIds typeIds;
        TypeBinding typeBinding2;
        this.constant = NotAConstant;
        if ((this.bits & 1) == 0 && ((typeBinding2 = typeBinding.leafComponentType()).isBoundParameterizedType() || typeBinding2.isGenericType() || typeBinding2.isTypeVariable())) {
            blockScope.problemReporter().illegalGenericArray(typeBinding2, this);
        }
        if (typeBinding.isArrayType()) {
            this.binding = (ArrayBinding)typeBinding;
            this.resolvedType = this.binding;
            if (this.expressions == null) {
                return this.binding;
            }
            typeBinding2 = this.binding.elementsType();
            int n2 = 0;
            int n3 = this.expressions.length;
            while (n2 < n3) {
                TypeBinding typeBinding3;
                Expression expression = this.expressions[n2];
                TypeBinding typeBinding4 = typeBinding3 = expression instanceof ArrayInitializer ? expression.resolveTypeExpecting(blockScope, typeBinding2) : expression.resolveType(blockScope);
                if (typeBinding3 == null) {
                    return null;
                }
                if (typeBinding2 != typeBinding3) {
                    blockScope.compilationUnitScope().recordTypeConversion(typeBinding2, typeBinding3);
                }
                if (expression.isConstantValueOfTypeAssignableToType(typeBinding3, typeBinding2) || typeBinding2.isBaseType() && BaseTypeBinding.isWidening(typeBinding2.id, typeBinding3.id) || typeBinding3.isCompatibleWith(typeBinding2)) {
                    expression.computeConversion(blockScope, typeBinding2, typeBinding3);
                } else if (blockScope.isBoxingCompatibleWith(typeBinding3, typeBinding2) || typeBinding3.isBaseType() && blockScope.compilerOptions().sourceLevel >= 0x310000L && !typeBinding2.isBaseType() && expression.isConstantValueOfTypeAssignableToType(typeBinding3, blockScope.environment().computeBoxingType(typeBinding2))) {
                    expression.computeConversion(blockScope, typeBinding2, typeBinding3);
                } else {
                    blockScope.problemReporter().typeMismatchError(typeBinding3, typeBinding2, expression);
                    return null;
                }
                ++n2;
            }
            return this.binding;
        }
        typeBinding2 = null;
        int n4 = 1;
        if (this.expressions == null) {
            typeBinding2 = blockScope.getJavaLangObject();
        } else {
            typeIds = this.expressions[0];
            while (typeIds != null && typeIds instanceof ArrayInitializer) {
                ++n4;
                Expression[] expressionArray = ((ArrayInitializer)typeIds).expressions;
                if (expressionArray == null) {
                    typeBinding2 = blockScope.getJavaLangObject();
                    typeIds = null;
                    break;
                }
                typeIds = ((ArrayInitializer)typeIds).expressions[0];
            }
            if (typeIds != null) {
                typeBinding2 = ((Expression)typeIds).resolveType(blockScope);
            }
        }
        if (typeBinding2 != null) {
            typeIds = blockScope.createArrayType(typeBinding2, n4);
            blockScope.problemReporter().typeMismatchError((TypeBinding)typeIds, typeBinding, this);
        }
        return null;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.expressions != null) {
            int n2 = this.expressions.length;
            int n3 = 0;
            while (n3 < n2) {
                this.expressions[n3].traverse(aSTVisitor, blockScope);
                ++n3;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

