/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.OperatorExpression;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class BinaryExpression
extends OperatorExpression {
    public Expression left;
    public Expression right;
    public Constant optimizedBooleanConstant;

    public BinaryExpression(Expression expression, Expression expression2, int n2) {
        this.left = expression;
        this.right = expression2;
        this.bits |= n2 << 6;
        this.sourceStart = expression.sourceStart;
        this.sourceEnd = expression2.sourceEnd;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return this.right.analyseCode(blockScope, flowContext, this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
    }

    public void computeConstant(BlockScope blockScope, int n2, int n3) {
        if (this.left.constant != Constant.NotAConstant && this.right.constant != Constant.NotAConstant) {
            try {
                this.constant = Constant.computeConstantOperation(this.left.constant, n2, (this.bits & 0xFC0) >> 6, this.right.constant, n3);
            }
            catch (ArithmeticException arithmeticException) {
                this.constant = Constant.NotAConstant;
            }
        } else {
            this.constant = Constant.NotAConstant;
            this.optimizedBooleanConstant(n2, (this.bits & 0xFC0) >> 6, n3);
        }
    }

    public Constant optimizedBooleanConstant() {
        return this.optimizedBooleanConstant == null ? this.constant : this.optimizedBooleanConstant;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (this.constant != Constant.NotAConstant) {
            if (bl2) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        this.bits |= 0x20;
        switch ((this.bits & 0xFC0) >> 6) {
            case 14: {
                switch (this.bits & 0xF) {
                    case 11: {
                        codeStream.generateStringConcatenationAppend(blockScope, this.left, this.right);
                        if (bl2) break;
                        codeStream.pop();
                        break;
                    }
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.iadd();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ladd();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.dadd();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.fadd();
                    }
                }
                break;
            }
            case 13: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.isub();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lsub();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.dsub();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.fsub();
                    }
                }
                break;
            }
            case 15: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.imul();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lmul();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.dmul();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.fmul();
                    }
                }
                break;
            }
            case 9: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.idiv();
                        if (bl2) break;
                        codeStream.pop();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.ldiv();
                        if (bl2) break;
                        codeStream.pop2();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ddiv();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.fdiv();
                    }
                }
                break;
            }
            case 16: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.irem();
                        if (bl2) break;
                        codeStream.pop();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, true);
                        this.right.generateCode(blockScope, codeStream, true);
                        codeStream.lrem();
                        if (bl2) break;
                        codeStream.pop2();
                        break;
                    }
                    case 8: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.drem();
                        break;
                    }
                    case 9: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.frem();
                    }
                }
                break;
            }
            case 2: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(blockScope, codeStream, false);
                            if (!bl2) break;
                            codeStream.iconst_0();
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(blockScope, codeStream, false);
                            if (!bl2) break;
                            codeStream.iconst_0();
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.iand();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(blockScope, codeStream, false);
                            if (!bl2) break;
                            codeStream.lconst_0();
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(blockScope, codeStream, false);
                            if (!bl2) break;
                            codeStream.lconst_0();
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.land();
                        break;
                    }
                    case 5: {
                        Label label = new Label(codeStream);
                        this.generateOptimizedLogicalAnd(blockScope, codeStream, null, label, bl2);
                        if (!label.hasForwardReferences()) break;
                        if (bl2) {
                            codeStream.iconst_1();
                            if ((this.bits & 0x10) != 0) {
                                codeStream.generateImplicitConversion(this.implicitConversion);
                                codeStream.generateReturnBytecode(this);
                                label.place();
                                codeStream.iconst_0();
                                break;
                            }
                            Label label2 = new Label(codeStream);
                            codeStream.goto_(label2);
                            codeStream.decrStackSize(1);
                            label.place();
                            codeStream.iconst_0();
                            label2.place();
                            break;
                        }
                        label.place();
                    }
                }
                break;
            }
            case 3: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ior();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lor();
                        break;
                    }
                    case 5: {
                        Label label = new Label(codeStream);
                        this.generateOptimizedLogicalOr(blockScope, codeStream, null, label, bl2);
                        if (!label.hasForwardReferences()) break;
                        if (bl2) {
                            codeStream.iconst_1();
                            if ((this.bits & 0x10) != 0) {
                                codeStream.generateImplicitConversion(this.implicitConversion);
                                codeStream.generateReturnBytecode(this);
                                label.place();
                                codeStream.iconst_0();
                                break;
                            }
                            Label label3 = new Label(codeStream);
                            codeStream.goto_(label3);
                            codeStream.decrStackSize(1);
                            label.place();
                            codeStream.iconst_0();
                            label3.place();
                            break;
                        }
                        label.place();
                    }
                }
                break;
            }
            case 8: {
                switch (this.bits & 0xF) {
                    case 10: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 10 && this.left.constant.intValue() == 0) {
                            this.right.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 10 && this.right.constant.intValue() == 0) {
                            this.left.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ixor();
                        break;
                    }
                    case 7: {
                        if (this.left.constant != Constant.NotAConstant && this.left.constant.typeID() == 7 && this.left.constant.longValue() == 0L) {
                            this.right.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        if (this.right.constant != Constant.NotAConstant && this.right.constant.typeID() == 7 && this.right.constant.longValue() == 0L) {
                            this.left.generateCode(blockScope, codeStream, bl2);
                            break;
                        }
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lxor();
                        break;
                    }
                    case 5: {
                        Label label = new Label(codeStream);
                        this.generateOptimizedLogicalXor(blockScope, codeStream, null, label, bl2);
                        if (!label.hasForwardReferences()) break;
                        if (bl2) {
                            codeStream.iconst_1();
                            if ((this.bits & 0x10) != 0) {
                                codeStream.generateImplicitConversion(this.implicitConversion);
                                codeStream.generateReturnBytecode(this);
                                label.place();
                                codeStream.iconst_0();
                                break;
                            }
                            Label label4 = new Label(codeStream);
                            codeStream.goto_(label4);
                            codeStream.decrStackSize(1);
                            label.place();
                            codeStream.iconst_0();
                            label4.place();
                            break;
                        }
                        label.place();
                    }
                }
                break;
            }
            case 10: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ishl();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lshl();
                    }
                }
                break;
            }
            case 17: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.ishr();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lshr();
                    }
                }
                break;
            }
            case 19: {
                switch (this.bits & 0xF) {
                    case 10: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.iushr();
                        break;
                    }
                    case 7: {
                        this.left.generateCode(blockScope, codeStream, bl2);
                        this.right.generateCode(blockScope, codeStream, bl2);
                        if (!bl2) break;
                        codeStream.lushr();
                    }
                }
                break;
            }
            case 6: {
                Label label = new Label(codeStream);
                this.generateOptimizedGreaterThan(blockScope, codeStream, null, label, bl2);
                if (!bl2) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    label.place();
                    codeStream.iconst_0();
                    break;
                }
                Label label5 = new Label(codeStream);
                codeStream.goto_(label5);
                codeStream.decrStackSize(1);
                label.place();
                codeStream.iconst_0();
                label5.place();
                break;
            }
            case 7: {
                Label label = new Label(codeStream);
                this.generateOptimizedGreaterThanOrEqual(blockScope, codeStream, null, label, bl2);
                if (!bl2) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    label.place();
                    codeStream.iconst_0();
                    break;
                }
                Label label6 = new Label(codeStream);
                codeStream.goto_(label6);
                codeStream.decrStackSize(1);
                label.place();
                codeStream.iconst_0();
                label6.place();
                break;
            }
            case 4: {
                Label label = new Label(codeStream);
                this.generateOptimizedLessThan(blockScope, codeStream, null, label, bl2);
                if (!bl2) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    label.place();
                    codeStream.iconst_0();
                    break;
                }
                Label label7 = new Label(codeStream);
                codeStream.goto_(label7);
                codeStream.decrStackSize(1);
                label.place();
                codeStream.iconst_0();
                label7.place();
                break;
            }
            case 5: {
                Label label = new Label(codeStream);
                this.generateOptimizedLessThanOrEqual(blockScope, codeStream, null, label, bl2);
                if (!bl2) break;
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    label.place();
                    codeStream.iconst_0();
                    break;
                }
                Label label8 = new Label(codeStream);
                codeStream.goto_(label8);
                codeStream.decrStackSize(1);
                label.place();
                codeStream.iconst_0();
                label8.place();
            }
        }
        if (bl2) {
            codeStream.generateImplicitConversion(this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            super.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
            return;
        }
        switch ((this.bits & 0xFC0) >> 6) {
            case 4: {
                this.generateOptimizedLessThan(blockScope, codeStream, label, label2, bl2);
                return;
            }
            case 5: {
                this.generateOptimizedLessThanOrEqual(blockScope, codeStream, label, label2, bl2);
                return;
            }
            case 6: {
                this.generateOptimizedGreaterThan(blockScope, codeStream, label, label2, bl2);
                return;
            }
            case 7: {
                this.generateOptimizedGreaterThanOrEqual(blockScope, codeStream, label, label2, bl2);
                return;
            }
            case 2: {
                this.generateOptimizedLogicalAnd(blockScope, codeStream, label, label2, bl2);
                return;
            }
            case 3: {
                this.generateOptimizedLogicalOr(blockScope, codeStream, label, label2, bl2);
                return;
            }
            case 8: {
                this.generateOptimizedLogicalXor(blockScope, codeStream, label, label2, bl2);
                return;
            }
        }
        super.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
    }

    public void generateOptimizedGreaterThan(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        int n2 = (this.left.implicitConversion & 0xFF) >> 4;
        if (n2 == 10) {
            if (this.left.constant != NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.iflt(label);
                        }
                    } else if (label == null) {
                        codeStream.ifge(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
            if (this.right.constant != NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifgt(label);
                        }
                    } else if (label == null) {
                        codeStream.ifle(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    switch (n2) {
                        case 10: {
                            codeStream.if_icmpgt(label);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifgt(label);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifgt(label);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifgt(label);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                    return;
                }
            } else if (label == null) {
                switch (n2) {
                    case 10: {
                        codeStream.if_icmple(label2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifle(label2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifle(label2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifle(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedGreaterThanOrEqual(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        int n2 = (this.left.implicitConversion & 0xFF) >> 4;
        if (n2 == 10) {
            if (this.left.constant != NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifle(label);
                        }
                    } else if (label == null) {
                        codeStream.ifgt(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
            if (this.right.constant != NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifge(label);
                        }
                    } else if (label == null) {
                        codeStream.iflt(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    switch (n2) {
                        case 10: {
                            codeStream.if_icmpge(label);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifge(label);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifge(label);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifge(label);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                    return;
                }
            } else if (label == null) {
                switch (n2) {
                    case 10: {
                        codeStream.if_icmplt(label2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.iflt(label2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.iflt(label2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.iflt(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedLessThan(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        int n2 = (this.left.implicitConversion & 0xFF) >> 4;
        if (n2 == 10) {
            if (this.left.constant != NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifgt(label);
                        }
                    } else if (label == null) {
                        codeStream.ifle(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
            if (this.right.constant != NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.iflt(label);
                        }
                    } else if (label == null) {
                        codeStream.ifge(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    switch (n2) {
                        case 10: {
                            codeStream.if_icmplt(label);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpg();
                            codeStream.iflt(label);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.iflt(label);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpg();
                            codeStream.iflt(label);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                    return;
                }
            } else if (label == null) {
                switch (n2) {
                    case 10: {
                        codeStream.if_icmpge(label2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpg();
                        codeStream.ifge(label2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifge(label2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpg();
                        codeStream.ifge(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedLessThanOrEqual(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        int n2 = (this.left.implicitConversion & 0xFF) >> 4;
        if (n2 == 10) {
            if (this.left.constant != NotAConstant && this.left.constant.intValue() == 0) {
                this.right.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifge(label);
                        }
                    } else if (label == null) {
                        codeStream.iflt(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
            if (this.right.constant != NotAConstant && this.right.constant.intValue() == 0) {
                this.left.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifle(label);
                        }
                    } else if (label == null) {
                        codeStream.ifgt(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    switch (n2) {
                        case 10: {
                            codeStream.if_icmple(label);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpg();
                            codeStream.ifle(label);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifle(label);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpg();
                            codeStream.ifle(label);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                    return;
                }
            } else if (label == null) {
                switch (n2) {
                    case 10: {
                        codeStream.if_icmpgt(label2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpg();
                        codeStream.ifgt(label2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifgt(label2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpg();
                        codeStream.ifgt(label2);
                    }
                }
                codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                return;
            }
        }
    }

    public void generateOptimizedLogicalAnd(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    if ((this.bits & 0x20) != 0) {
                        this.right.generateCode(blockScope, codeStream, bl2);
                    } else {
                        this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
                    }
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    Label label3 = new Label(codeStream);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    label3.place();
                    if (bl2) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_0();
                        } else if (label2 != null) {
                            codeStream.goto_(label2);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != NotAConstant) {
                if (constant.booleanValue()) {
                    if ((this.bits & 0x20) != 0) {
                        this.left.generateCode(blockScope, codeStream, bl2);
                    } else {
                        this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
                    }
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                } else {
                    Label label4 = new Label(codeStream);
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label4, label2, false);
                    label4.place();
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    if (bl2) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_0();
                        } else if (label2 != null) {
                            codeStream.goto_(label2);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            codeStream.iand();
            if ((this.bits & 0x20) == 0) {
                if (label2 == null) {
                    if (label != null) {
                        codeStream.ifne(label);
                    }
                } else if (label == null) {
                    codeStream.ifeq(label2);
                }
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
    }

    public void generateOptimizedLogicalOr(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    Label label3 = new Label(codeStream);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label3, false);
                    label3.place();
                    if (bl2) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_1();
                        } else if (label != null) {
                            codeStream.goto_(label);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    if ((this.bits & 0x20) != 0) {
                        this.right.generateCode(blockScope, codeStream, bl2);
                    } else {
                        this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
                    }
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != NotAConstant) {
                if (constant.booleanValue()) {
                    Label label4 = new Label(codeStream);
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label4, false);
                    label4.place();
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    if (bl2) {
                        if ((this.bits & 0x20) != 0) {
                            codeStream.iconst_1();
                        } else if (label != null) {
                            codeStream.goto_(label);
                        }
                    }
                    codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
                } else {
                    if ((this.bits & 0x20) != 0) {
                        this.left.generateCode(blockScope, codeStream, bl2);
                    } else {
                        this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
                    }
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            codeStream.ior();
            if ((this.bits & 0x20) == 0) {
                if (label2 == null) {
                    if (label != null) {
                        codeStream.ifne(label);
                    }
                } else if (label == null) {
                    codeStream.ifeq(label2);
                }
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
    }

    public void generateOptimizedLogicalXor(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if ((this.left.implicitConversion & 0xF) == 5) {
            Constant constant = this.left.optimizedBooleanConstant();
            if (constant != NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label2, label, bl2);
                } else {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                    if ((this.bits & 0x20) != 0) {
                        this.right.generateCode(blockScope, codeStream, bl2);
                    } else {
                        this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
                    }
                }
                return;
            }
            constant = this.right.optimizedBooleanConstant();
            if (constant != NotAConstant) {
                if (constant.booleanValue()) {
                    this.left.generateOptimizedBoolean(blockScope, codeStream, label2, label, bl2);
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                } else {
                    if ((this.bits & 0x20) != 0) {
                        this.left.generateCode(blockScope, codeStream, bl2);
                    } else {
                        this.left.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
                    }
                    this.right.generateOptimizedBoolean(blockScope, codeStream, label, label2, false);
                }
                return;
            }
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            codeStream.ixor();
            if ((this.bits & 0x20) == 0) {
                if (label2 == null) {
                    if (label != null) {
                        codeStream.ifne(label);
                    }
                } else if (label == null) {
                    codeStream.ifeq(label2);
                }
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n2) {
        if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != NotAConstant) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
                codeStream.invokeStringConcatenationAppendForType(this.implicitConversion & 0xF);
            } else {
                int n3 = codeStream.position;
                this.left.generateOptimizedStringConcatenation(blockScope, codeStream, this.left.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n3, this.left.sourceStart);
                n3 = codeStream.position;
                this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n3, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringConcatenation(blockScope, codeStream, n2);
        }
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n2) {
        if ((this.bits & 0xFC0) >> 6 == 14 && (this.bits & 0xF) == 11) {
            if (this.constant != NotAConstant) {
                codeStream.newStringContatenation();
                codeStream.dup();
                codeStream.ldc(this.constant.stringValue());
                codeStream.invokeStringConcatenationStringConstructor();
            } else {
                int n3 = codeStream.position;
                this.left.generateOptimizedStringConcatenationCreation(blockScope, codeStream, this.left.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n3, this.left.sourceStart);
                n3 = codeStream.position;
                this.right.generateOptimizedStringConcatenation(blockScope, codeStream, this.right.implicitConversion & 0xF);
                codeStream.recordPositionsFrom(n3, this.right.sourceStart);
            }
        } else {
            super.generateOptimizedStringConcatenationCreation(blockScope, codeStream, n2);
        }
    }

    public boolean isCompactableOperation() {
        return true;
    }

    public void optimizedBooleanConstant(int n2, int n3, int n4) {
        switch (n3) {
            case 2: {
                if (n2 != 5 || n4 != 5) {
                    return;
                }
            }
            case 0: {
                Constant constant = this.left.optimizedBooleanConstant();
                if (constant != NotAConstant) {
                    if (!constant.booleanValue()) {
                        this.optimizedBooleanConstant = constant;
                        return;
                    }
                    constant = this.right.optimizedBooleanConstant();
                    if (constant != NotAConstant) {
                        this.optimizedBooleanConstant = constant;
                    }
                    return;
                }
                constant = this.right.optimizedBooleanConstant();
                if (constant != NotAConstant && !constant.booleanValue()) {
                    this.optimizedBooleanConstant = constant;
                }
                return;
            }
            case 3: {
                if (n2 != 5 || n4 != 5) {
                    return;
                }
            }
            case 1: {
                Constant constant = this.left.optimizedBooleanConstant();
                if (constant != NotAConstant) {
                    if (constant.booleanValue()) {
                        this.optimizedBooleanConstant = constant;
                        return;
                    }
                    constant = this.right.optimizedBooleanConstant();
                    if (constant != NotAConstant) {
                        this.optimizedBooleanConstant = constant;
                    }
                    return;
                }
                constant = this.right.optimizedBooleanConstant();
                if (constant == NotAConstant || !constant.booleanValue()) break;
                this.optimizedBooleanConstant = constant;
            }
        }
    }

    public StringBuffer printExpressionNoParenthesis(int n2, StringBuffer stringBuffer) {
        this.left.printExpression(n2, stringBuffer).append(' ').append(this.operatorToString()).append(' ');
        return this.right.printExpression(0, stringBuffer);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        boolean bl2;
        boolean bl3 = this.left instanceof CastExpression;
        if (bl3) {
            this.left.bits |= 0x20;
        }
        TypeBinding typeBinding = this.left.resolveType(blockScope);
        boolean bl4 = this.right instanceof CastExpression;
        if (bl4) {
            this.right.bits |= 0x20;
        }
        TypeBinding typeBinding2 = this.right.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            this.constant = Constant.NotAConstant;
            return null;
        }
        int n2 = typeBinding.id;
        int n3 = typeBinding2.id;
        boolean bl5 = bl2 = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        if (bl2) {
            if (!typeBinding.isBaseType() && n3 != 11 && n3 != 12) {
                n2 = blockScope.environment().computeBoxingType((TypeBinding)typeBinding).id;
            }
            if (!typeBinding2.isBaseType() && n2 != 11 && n2 != 12) {
                n3 = blockScope.environment().computeBoxingType((TypeBinding)typeBinding2).id;
            }
        }
        if (n2 > 15 || n3 > 15) {
            if (n2 == 11) {
                n3 = 1;
            } else if (n3 == 11) {
                n2 = 1;
            } else {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding, typeBinding2);
                return null;
            }
        }
        if ((this.bits & 0xFC0) >> 6 == 14) {
            if (n2 == 11) {
                this.left.computeConversion(blockScope, typeBinding, typeBinding);
                if (typeBinding2.isArrayType() && ((ArrayBinding)typeBinding2).elementsType() == CharBinding) {
                    blockScope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.right);
                }
            }
            if (n3 == 11) {
                this.right.computeConversion(blockScope, typeBinding2, typeBinding2);
                if (typeBinding.isArrayType() && ((ArrayBinding)typeBinding).elementsType() == CharBinding) {
                    blockScope.problemReporter().signalNoImplicitStringConversionForCharArrayExpression(this.left);
                }
            }
        }
        int n4 = (this.bits & 0xFC0) >> 6;
        int n5 = OperatorSignatures[n4][(n2 << 4) + n3];
        this.left.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n5 >>> 16 & 0xF), typeBinding);
        this.right.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n5 >>> 8 & 0xF), typeBinding2);
        this.bits |= n5 & 0xF;
        switch (n5 & 0xF) {
            case 5: {
                this.resolvedType = BooleanBinding;
                break;
            }
            case 3: {
                this.resolvedType = ByteBinding;
                break;
            }
            case 2: {
                this.resolvedType = CharBinding;
                break;
            }
            case 8: {
                this.resolvedType = DoubleBinding;
                break;
            }
            case 9: {
                this.resolvedType = FloatBinding;
                break;
            }
            case 10: {
                this.resolvedType = IntBinding;
                break;
            }
            case 7: {
                this.resolvedType = LongBinding;
                break;
            }
            case 11: {
                this.resolvedType = blockScope.getJavaLangString();
                break;
            }
            default: {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding, typeBinding2);
                return null;
            }
        }
        if (bl3 || bl4) {
            CastExpression.checkNeedForArgumentCasts(blockScope, n4, n5, this.left, n2, bl3, this.right, n3, bl4);
        }
        this.computeConstant(blockScope, n2, n3);
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.left.traverse(aSTVisitor, blockScope);
            this.right.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

