/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class CharLiteral
extends NumberLiteral {
    public char a;

    public CharLiteral(char[] cArray, int n2, int n3) {
        super(cArray, n2, n3);
        this.computeValue();
    }

    public void computeConstant() {
        this.constant = Constant.fromValue(this.a);
    }

    private void computeValue() {
        this.a = this.d[1];
        if (this.a != '\\') {
            return;
        }
        char c2 = this.d[2];
        switch (c2) {
            case 'b': {
                this.a = (char)8;
                break;
            }
            case 't': {
                this.a = (char)9;
                break;
            }
            case 'n': {
                this.a = (char)10;
                break;
            }
            case 'f': {
                this.a = (char)12;
                break;
            }
            case 'r': {
                this.a = (char)13;
                break;
            }
            case '\"': {
                this.a = (char)34;
                break;
            }
            case '\'': {
                this.a = (char)39;
                break;
            }
            case '\\': {
                this.a = (char)92;
                break;
            }
            default: {
                int n2 = Character.getNumericValue(c2);
                c2 = this.d[3];
                if (c2 == '\'') {
                    this.a = (char)n2;
                    this.constant = Constant.fromValue(this.a);
                    break;
                }
                n2 = n2 * 8 + Character.getNumericValue(c2);
                c2 = this.d[4];
                if (c2 != '\'') {
                    n2 = n2 * 8 + Character.getNumericValue(c2);
                }
                this.a = (char)n2;
            }
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (bl2) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return CharBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

