/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class DoStatement
extends Statement {
    public Expression condition;
    public Statement action;
    private Label breakLabel;
    private Label continueLabel;
    public int a = -1;

    public DoStatement(Expression expression, Statement statement, int n2, int n3) {
        this.sourceStart = n2;
        this.sourceEnd = n3;
        this.condition = expression;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        LoopingFlowContext loopingFlowContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, blockScope);
        Constant constant = this.condition.constant;
        boolean bl2 = constant != NotAConstant && constant.booleanValue();
        constant = this.condition.optimizedBooleanConstant();
        boolean bl3 = constant != NotAConstant && constant.booleanValue();
        boolean bl4 = constant != NotAConstant && !constant.booleanValue();
        int n2 = flowInfo.reachMode();
        FlowInfo flowInfo2 = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        if (!(this.action == null || this.action.isEmptyBlock() || (flowInfo2 = this.action.analyseCode(blockScope, loopingFlowContext, flowInfo2)).isReachable() || loopingFlowContext.initsOnContinue.isReachable())) {
            this.continueLabel = null;
        }
        flowInfo2.setReachMode(n2);
        flowInfo2 = this.condition.analyseCode(blockScope, loopingFlowContext, this.action == null ? flowInfo2 : flowInfo2.mergedWith(loopingFlowContext.initsOnContinue));
        if (!bl4 && this.continueLabel != null) {
            loopingFlowContext.complainOnDeferredChecks(blockScope, flowInfo2);
        }
        FlowInfo flowInfo3 = FlowInfo.mergedOptimizedBranches(loopingFlowContext.initsOnBreak, bl3, flowInfo2.initsWhenFalse().addInitializationsFrom(flowInfo), false, !bl2);
        this.a = blockScope.methodScope().recordInitializationStates(flowInfo3);
        return flowInfo3;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n2 = codeStream.position;
        Label label = new Label(codeStream);
        label.place();
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.action != null) {
            this.action.generateCode(blockScope, codeStream);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            this.condition.generateOptimizedBoolean(blockScope, codeStream, label, null, true);
        }
        this.breakLabel.place();
        if (this.a != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.a);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        DoStatement.printIndent(n2, stringBuffer).append("do");
        if (this.action == null) {
            stringBuffer.append(" ;\n");
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n2 + 1, stringBuffer).append('\n');
        }
        stringBuffer.append("while (");
        return this.condition.printExpression(0, stringBuffer).append(");");
    }

    public void resolve(BlockScope blockScope) {
        TypeBinding typeBinding = this.condition.resolveTypeExpecting(blockScope, BooleanBinding);
        this.condition.computeConversion(blockScope, typeBinding, typeBinding);
        if (this.action != null) {
            this.action.resolve(blockScope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            if (this.action != null) {
                this.action.traverse(aSTVisitor, blockScope);
            }
            this.condition.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

