/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.BinaryExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NullLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class EqualExpression
extends BinaryExpression {
    public EqualExpression(Expression expression, Expression expression2, int n2) {
        super(expression, expression2, n2);
    }

    public void checkNullComparison(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo flowInfo2, FlowInfo flowInfo3) {
        LocalVariableBinding localVariableBinding = this.left.localVariableBinding();
        if (localVariableBinding != null) {
            this.checkVariableComparison(blockScope, flowContext, flowInfo, flowInfo2, flowInfo3, localVariableBinding, this.right.nullStatus(flowInfo), this.left);
        }
        if ((localVariableBinding = this.right.localVariableBinding()) != null) {
            this.checkVariableComparison(blockScope, flowContext, flowInfo, flowInfo2, flowInfo3, localVariableBinding, this.left.nullStatus(flowInfo), this.right);
        }
    }

    private void checkVariableComparison(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo flowInfo2, FlowInfo flowInfo3, LocalVariableBinding localVariableBinding, int n2, Expression expression) {
        switch (n2) {
            case 1: {
                flowContext.recordUsingNullReference(blockScope, localVariableBinding, expression, 1, flowInfo);
                if ((this.bits & 0xFC0) >> 6 == 18) {
                    flowInfo2.markAsDefinitelyNull(localVariableBinding);
                    flowInfo3.markAsDefinitelyNonNull(localVariableBinding);
                    break;
                }
                flowInfo2.markAsDefinitelyNonNull(localVariableBinding);
                flowInfo3.markAsDefinitelyNull(localVariableBinding);
                break;
            }
            case -1: {
                flowContext.recordUsingNullReference(blockScope, localVariableBinding, expression, -1, flowInfo);
                if ((this.bits & 0xFC0) >> 6 != 18) break;
                flowInfo2.markAsDefinitelyNonNull(localVariableBinding);
            }
        }
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if ((this.bits & 0xFC0) >> 6 == 18) {
            if (this.left.constant != NotAConstant && this.left.constant.typeID() == 5) {
                if (this.left.constant.booleanValue()) {
                    return this.right.analyseCode(blockScope, flowContext, flowInfo);
                }
                return this.right.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
            }
            if (this.right.constant != NotAConstant && this.right.constant.typeID() == 5) {
                if (this.right.constant.booleanValue()) {
                    return this.left.analyseCode(blockScope, flowContext, flowInfo);
                }
                return this.left.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
            }
            return this.right.analyseCode(blockScope, flowContext, this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).unconditionalInits();
        }
        if (this.left.constant != NotAConstant && this.left.constant.typeID() == 5) {
            if (!this.left.constant.booleanValue()) {
                return this.right.analyseCode(blockScope, flowContext, flowInfo);
            }
            return this.right.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
        }
        if (this.right.constant != NotAConstant && this.right.constant.typeID() == 5) {
            if (!this.right.constant.booleanValue()) {
                return this.left.analyseCode(blockScope, flowContext, flowInfo);
            }
            return this.left.analyseCode(blockScope, flowContext, flowInfo).asNegatedCondition();
        }
        return this.right.analyseCode(blockScope, flowContext, this.left.analyseCode(blockScope, flowContext, flowInfo).unconditionalInits()).asNegatedCondition().unconditionalInits();
    }

    public final void computeConstant(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (this.left.constant != NotAConstant && this.right.constant != NotAConstant) {
            this.constant = Constant.computeConstantOperationEQUAL_EQUAL(this.left.constant, typeBinding.id, this.right.constant, typeBinding2.id);
            if ((this.bits & 0xFC0) >> 6 == 29) {
                this.constant = Constant.fromValue(!this.constant.booleanValue());
            }
        } else {
            this.constant = NotAConstant;
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        if (this.constant != NotAConstant) {
            int n2 = codeStream.position;
            if (bl2) {
                codeStream.generateConstant(this.constant, this.implicitConversion);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        this.bits |= 0x20;
        Label label = new Label(codeStream);
        this.generateOptimizedBoolean(blockScope, codeStream, null, label, bl2);
        if (label.hasForwardReferences()) {
            if (bl2) {
                codeStream.iconst_1();
                if ((this.bits & 0x10) != 0) {
                    codeStream.generateImplicitConversion(this.implicitConversion);
                    codeStream.generateReturnBytecode(this);
                    label.place();
                    codeStream.iconst_0();
                } else {
                    Label label2 = new Label(codeStream);
                    codeStream.goto_(label2);
                    codeStream.decrStackSize(1);
                    label.place();
                    codeStream.iconst_0();
                    label2.place();
                }
                codeStream.generateImplicitConversion(this.implicitConversion);
            } else {
                label.place();
            }
        }
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if (this.constant != Constant.NotAConstant) {
            super.generateOptimizedBoolean(blockScope, codeStream, label, label2, bl2);
            return;
        }
        if ((this.bits & 0xFC0) >> 6 == 18) {
            if ((this.left.implicitConversion & 0xF) == 5) {
                this.generateOptimizedBooleanEqual(blockScope, codeStream, label, label2, bl2);
            } else {
                this.generateOptimizedNonBooleanEqual(blockScope, codeStream, label, label2, bl2);
            }
        } else if ((this.left.implicitConversion & 0xF) == 5) {
            this.generateOptimizedBooleanEqual(blockScope, codeStream, label2, label, bl2);
        } else {
            this.generateOptimizedNonBooleanEqual(blockScope, codeStream, label2, label, bl2);
        }
    }

    public void generateOptimizedBooleanEqual(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if (this.left.constant != NotAConstant) {
            boolean bl3 = this.left.constant.booleanValue();
            this.right.generateOptimizedBoolean(blockScope, codeStream, bl3 ? label : label2, bl3 ? label2 : label, bl2);
            return;
        }
        if (this.right.constant != NotAConstant) {
            boolean bl4 = this.right.constant.booleanValue();
            this.left.generateOptimizedBoolean(blockScope, codeStream, bl4 ? label : label2, bl4 ? label2 : label, bl2);
            return;
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    codeStream.if_icmpeq(label);
                }
            } else if (label == null) {
                codeStream.if_icmpne(label2);
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, codeStream.position);
    }

    public void generateOptimizedNonBooleanEqual(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        int n2 = codeStream.position;
        Constant constant = this.right.constant;
        if (constant != NotAConstant && (this.left.implicitConversion & 0xFF) >> 4 == 10 && constant.intValue() == 0) {
            this.left.generateCode(blockScope, codeStream, bl2);
            if (bl2) {
                if (label2 == null) {
                    if (label != null) {
                        codeStream.ifeq(label);
                    }
                } else if (label == null) {
                    codeStream.ifne(label2);
                }
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        constant = this.left.constant;
        if (constant != NotAConstant && (this.left.implicitConversion & 0xFF) >> 4 == 10 && constant.intValue() == 0) {
            this.right.generateCode(blockScope, codeStream, bl2);
            if (bl2) {
                if (label2 == null) {
                    if (label != null) {
                        codeStream.ifeq(label);
                    }
                } else if (label == null) {
                    codeStream.ifne(label2);
                }
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        if (this.right instanceof NullLiteral) {
            if (this.left instanceof NullLiteral) {
                if (bl2) {
                    if ((this.bits & 0x20) != 0) {
                        if ((this.bits & 0xFC0) >> 6 == 18) {
                            codeStream.iconst_1();
                        } else {
                            codeStream.iconst_0();
                        }
                    } else if (label2 == null && label != null) {
                        codeStream.goto_(label);
                    }
                }
            } else {
                this.left.generateCode(blockScope, codeStream, bl2);
                if (bl2) {
                    if (label2 == null) {
                        if (label != null) {
                            codeStream.ifnull(label);
                        }
                    } else if (label == null) {
                        codeStream.ifnonnull(label2);
                    }
                }
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        if (this.left instanceof NullLiteral) {
            this.right.generateCode(blockScope, codeStream, bl2);
            if (bl2) {
                if (label2 == null) {
                    if (label != null) {
                        codeStream.ifnull(label);
                    }
                } else if (label == null) {
                    codeStream.ifnonnull(label2);
                }
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        this.left.generateCode(blockScope, codeStream, bl2);
        this.right.generateCode(blockScope, codeStream, bl2);
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    switch ((this.left.implicitConversion & 0xFF) >> 4) {
                        case 10: {
                            codeStream.if_icmpeq(label);
                            break;
                        }
                        case 9: {
                            codeStream.fcmpl();
                            codeStream.ifeq(label);
                            break;
                        }
                        case 7: {
                            codeStream.lcmp();
                            codeStream.ifeq(label);
                            break;
                        }
                        case 8: {
                            codeStream.dcmpl();
                            codeStream.ifeq(label);
                            break;
                        }
                        default: {
                            codeStream.if_acmpeq(label);
                            break;
                        }
                    }
                }
            } else if (label == null) {
                switch ((this.left.implicitConversion & 0xFF) >> 4) {
                    case 10: {
                        codeStream.if_icmpne(label2);
                        break;
                    }
                    case 9: {
                        codeStream.fcmpl();
                        codeStream.ifne(label2);
                        break;
                    }
                    case 7: {
                        codeStream.lcmp();
                        codeStream.ifne(label2);
                        break;
                    }
                    case 8: {
                        codeStream.dcmpl();
                        codeStream.ifne(label2);
                        break;
                    }
                    default: {
                        codeStream.if_acmpne(label2);
                    }
                }
            }
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        boolean bl2 = this.left instanceof CastExpression;
        if (bl2) {
            this.left.bits |= 0x20;
        }
        TypeBinding typeBinding = this.left.resolveType(blockScope);
        boolean bl3 = this.right instanceof CastExpression;
        if (bl3) {
            this.right.bits |= 0x20;
        }
        TypeBinding typeBinding2 = this.right.resolveType(blockScope);
        if (typeBinding == null || typeBinding2 == null) {
            this.constant = NotAConstant;
            return null;
        }
        boolean bl4 = blockScope.compilerOptions().sourceLevel >= 0x310000L;
        TypeBinding typeBinding3 = typeBinding;
        TypeBinding typeBinding4 = typeBinding2;
        if (bl4) {
            if (typeBinding3 != NullBinding && typeBinding3.isBaseType()) {
                if (!typeBinding4.isBaseType()) {
                    typeBinding4 = blockScope.environment().computeBoxingType(typeBinding4);
                }
            } else if (typeBinding4 != NullBinding && typeBinding4.isBaseType()) {
                typeBinding3 = blockScope.environment().computeBoxingType(typeBinding3);
            }
        }
        if (typeBinding3.isBaseType() && typeBinding4.isBaseType()) {
            int n2 = typeBinding3.id;
            int n3 = typeBinding4.id;
            int n4 = OperatorSignatures[18][(n2 << 4) + n3];
            this.left.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 16 & 0xF), typeBinding);
            this.right.computeConversion(blockScope, TypeBinding.wellKnownType(blockScope, n4 >>> 8 & 0xF), typeBinding2);
            this.bits |= n4 & 0xF;
            if ((n4 & 0xF) == 0) {
                this.constant = Constant.NotAConstant;
                blockScope.problemReporter().invalidOperator(this, typeBinding3, typeBinding4);
                return null;
            }
            if (bl2 || bl3) {
                CastExpression.checkNeedForArgumentCasts(blockScope, 18, n4, this.left, typeBinding3.id, bl2, this.right, typeBinding4.id, bl3);
            }
            this.computeConstant(typeBinding3, typeBinding4);
            this.resolvedType = BooleanBinding;
            return this.resolvedType;
        }
        if (!(typeBinding3.isBaseType() && typeBinding3 != NullBinding || typeBinding4.isBaseType() && typeBinding4 != NullBinding || !this.checkCastTypesCompatibility(blockScope, typeBinding3, typeBinding4, null) && !this.checkCastTypesCompatibility(blockScope, typeBinding4, typeBinding3, null))) {
            boolean bl5;
            if (typeBinding4.id == 11 && typeBinding3.id == 11) {
                this.computeConstant(typeBinding3, typeBinding4);
            } else {
                this.constant = NotAConstant;
            }
            ReferenceBinding referenceBinding = blockScope.getJavaLangObject();
            this.left.computeConversion(blockScope, referenceBinding, typeBinding3);
            this.right.computeConversion(blockScope, referenceBinding, typeBinding4);
            boolean bl6 = (this.left.bits & 0x4000) != 0;
            boolean bl7 = bl5 = (this.right.bits & 0x4000) != 0;
            if (bl6 || bl5) {
                TypeBinding typeBinding5;
                TypeBinding typeBinding6 = bl6 ? ((CastExpression)this.left).expression.resolvedType : typeBinding3;
                TypeBinding typeBinding7 = typeBinding5 = bl5 ? ((CastExpression)this.right).expression.resolvedType : typeBinding4;
                if (this.checkCastTypesCompatibility(blockScope, typeBinding6, typeBinding5, null) || this.checkCastTypesCompatibility(blockScope, typeBinding5, typeBinding6, null)) {
                    if (bl6) {
                        blockScope.problemReporter().unnecessaryCast((CastExpression)this.left);
                    }
                    if (bl5) {
                        blockScope.problemReporter().unnecessaryCast((CastExpression)this.right);
                    }
                }
            }
            this.resolvedType = BooleanBinding;
            return this.resolvedType;
        }
        this.constant = NotAConstant;
        blockScope.problemReporter().notCompatibleTypesError(this, typeBinding3, typeBinding4);
        return null;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.left.traverse(aSTVisitor, blockScope);
            this.right.traverse(aSTVisitor, blockScope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

