/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;

public abstract class Expression
extends Statement {
    public Constant constant;
    public int implicitConversion;
    public TypeBinding resolvedType;

    public static final boolean isConstantValueRepresentable(Constant constant, int n2, int n3) {
        if (n3 == n2) {
            return true;
        }
        switch (n3) {
            case 2: {
                switch (n2) {
                    case 2: {
                        return true;
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.charValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.charValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.charValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.charValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.charValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.charValue();
                    }
                }
                return false;
            }
            case 9: {
                switch (n2) {
                    case 2: {
                        return (float)constant.charValue() == constant.floatValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.floatValue();
                    }
                    case 9: {
                        return true;
                    }
                    case 10: {
                        return (float)constant.intValue() == constant.floatValue();
                    }
                    case 4: {
                        return (float)constant.shortValue() == constant.floatValue();
                    }
                    case 3: {
                        return (float)constant.byteValue() == constant.floatValue();
                    }
                    case 7: {
                        return (float)constant.longValue() == constant.floatValue();
                    }
                }
                return false;
            }
            case 8: {
                switch (n2) {
                    case 2: {
                        return (double)constant.charValue() == constant.doubleValue();
                    }
                    case 8: {
                        return true;
                    }
                    case 9: {
                        return (double)constant.floatValue() == constant.doubleValue();
                    }
                    case 10: {
                        return (double)constant.intValue() == constant.doubleValue();
                    }
                    case 4: {
                        return (double)constant.shortValue() == constant.doubleValue();
                    }
                    case 3: {
                        return (double)constant.byteValue() == constant.doubleValue();
                    }
                    case 7: {
                        return (double)constant.longValue() == constant.doubleValue();
                    }
                }
                return false;
            }
            case 3: {
                switch (n2) {
                    case 2: {
                        return constant.charValue() == constant.byteValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.byteValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.byteValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.byteValue();
                    }
                    case 4: {
                        return constant.shortValue() == constant.byteValue();
                    }
                    case 3: {
                        return true;
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.byteValue();
                    }
                }
                return false;
            }
            case 4: {
                switch (n2) {
                    case 2: {
                        return constant.charValue() == constant.shortValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.shortValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.shortValue();
                    }
                    case 10: {
                        return constant.intValue() == constant.shortValue();
                    }
                    case 4: {
                        return true;
                    }
                    case 3: {
                        return constant.byteValue() == constant.shortValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.shortValue();
                    }
                }
                return false;
            }
            case 10: {
                switch (n2) {
                    case 2: {
                        return constant.charValue() == constant.intValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.intValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.intValue();
                    }
                    case 10: {
                        return true;
                    }
                    case 4: {
                        return constant.shortValue() == constant.intValue();
                    }
                    case 3: {
                        return constant.byteValue() == constant.intValue();
                    }
                    case 7: {
                        return constant.longValue() == (long)constant.intValue();
                    }
                }
                return false;
            }
            case 7: {
                switch (n2) {
                    case 2: {
                        return (long)constant.charValue() == constant.longValue();
                    }
                    case 8: {
                        return constant.doubleValue() == (double)constant.longValue();
                    }
                    case 9: {
                        return constant.floatValue() == (float)constant.longValue();
                    }
                    case 10: {
                        return (long)constant.intValue() == constant.longValue();
                    }
                    case 4: {
                        return (long)constant.shortValue() == constant.longValue();
                    }
                    case 3: {
                        return (long)constant.byteValue() == constant.longValue();
                    }
                    case 7: {
                        return true;
                    }
                }
                return false;
            }
        }
        return false;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        return flowInfo;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, boolean bl2) {
        return this.analyseCode(blockScope, flowContext, flowInfo);
    }

    public final boolean checkCastTypesCompatibility(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, Expression expression) {
        boolean bl2;
        if (typeBinding == null || typeBinding2 == null) {
            return true;
        }
        boolean bl3 = bl2 = scope.compilerOptions().sourceLevel >= 0x310000L;
        if (typeBinding.isBaseType()) {
            if (typeBinding2.isBaseType()) {
                if (typeBinding2 == typeBinding) {
                    if (expression != null) {
                        this.constant = expression.constant;
                    }
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                boolean bl4 = false;
                if (typeBinding2.isCompatibleWith(typeBinding) || (bl4 = BaseTypeBinding.isNarrowing(typeBinding.id, typeBinding2.id))) {
                    if (expression != null) {
                        expression.implicitConversion = (typeBinding.id << 4) + typeBinding2.id;
                        if (expression.constant != Constant.NotAConstant) {
                            this.constant = expression.constant.castTo(expression.implicitConversion);
                        }
                    }
                    if (!bl4) {
                        this.tagAsUnnecessaryCast(scope, typeBinding);
                    }
                    return true;
                }
            } else if (bl2 && scope.environment().computeBoxingType(typeBinding2).isCompatibleWith(typeBinding)) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
                return true;
            }
            return false;
        }
        if (bl2 && typeBinding2.isBaseType() && scope.environment().computeBoxingType(typeBinding2).isCompatibleWith(typeBinding)) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
            return true;
        }
        switch (typeBinding2.kind()) {
            case 132: {
                if (typeBinding2 == NullBinding) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                return false;
            }
            case 68: {
                if (typeBinding == typeBinding2) {
                    this.tagAsUnnecessaryCast(scope, typeBinding);
                    return true;
                }
                switch (typeBinding.kind()) {
                    case 68: {
                        TypeBinding typeBinding3 = ((ArrayBinding)typeBinding).elementsType();
                        TypeBinding typeBinding4 = ((ArrayBinding)typeBinding2).elementsType();
                        if (typeBinding4.isBaseType() || typeBinding3.isBaseType()) {
                            if (typeBinding3 == typeBinding4) {
                                this.tagAsNeedCheckCast();
                                return true;
                            }
                            return false;
                        }
                        return this.checkCastTypesCompatibility(scope, typeBinding3, typeBinding4, expression);
                    }
                    case 4100: {
                        if (typeBinding2 instanceof ReferenceBinding) {
                            ReferenceBinding referenceBinding = ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(typeBinding);
                            if (referenceBinding == null) {
                                this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding, true);
                            }
                        } else {
                            this.checkUnsafeCast(scope, typeBinding, typeBinding2, null, true);
                        }
                        return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
                    }
                }
                switch (typeBinding.id) {
                    case 36: 
                    case 37: {
                        this.tagAsNeedCheckCast();
                        return true;
                    }
                    case 1: {
                        this.tagAsUnnecessaryCast(scope, typeBinding);
                        return true;
                    }
                }
                return false;
            }
            case 4100: {
                ReferenceBinding referenceBinding;
                if (typeBinding instanceof ReferenceBinding && (referenceBinding = ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(typeBinding)) != null) {
                    return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding, false);
                }
                return this.checkCastTypesCompatibility(scope, typeBinding, ((TypeVariableBinding)typeBinding2).upperBound(), expression);
            }
            case 516: {
                ReferenceBinding referenceBinding;
                if (typeBinding instanceof ReferenceBinding && (referenceBinding = ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(typeBinding)) != null) {
                    return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding, false);
                }
                return this.checkCastTypesCompatibility(scope, typeBinding, ((WildcardBinding)typeBinding2).bound, expression);
            }
        }
        if (typeBinding2.isInterface()) {
            ReferenceBinding referenceBinding;
            switch (typeBinding.kind()) {
                case 68: {
                    switch (typeBinding2.id) {
                        case 36: 
                        case 37: {
                            this.tagAsNeedCheckCast();
                            return true;
                        }
                    }
                    return false;
                }
                case 4100: {
                    ReferenceBinding referenceBinding2 = ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(typeBinding);
                    if (referenceBinding2 == null) {
                        this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding2, true);
                    }
                    return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
                }
            }
            if (typeBinding.isInterface()) {
                ReferenceBinding referenceBinding3 = (ReferenceBinding)typeBinding2;
                ReferenceBinding referenceBinding4 = referenceBinding3.findSuperTypeWithSameErasure(typeBinding);
                if (referenceBinding4 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, referenceBinding3, referenceBinding4, false);
                }
                this.tagAsNeedCheckCast();
                referenceBinding4 = ((ReferenceBinding)typeBinding).findSuperTypeWithSameErasure(referenceBinding3);
                if (referenceBinding4 != null) {
                    return this.checkUnsafeCast(scope, typeBinding, referenceBinding3, referenceBinding4, true);
                }
                if (bl2) {
                    if (referenceBinding3.hasIncompatibleSuperType((ReferenceBinding)typeBinding)) {
                        return false;
                    }
                } else {
                    MethodBinding[] methodBindingArray = this.getAllInheritedMethods((ReferenceBinding)typeBinding);
                    MethodBinding[] methodBindingArray2 = this.getAllInheritedMethods((ReferenceBinding)typeBinding2);
                    int n2 = methodBindingArray2.length;
                    int n3 = 0;
                    int n4 = methodBindingArray.length;
                    while (n3 < n4) {
                        int n5 = 0;
                        while (n5 < n2) {
                            if (methodBindingArray[n3].returnType != methodBindingArray2[n5].returnType && CharOperation.equals(methodBindingArray[n3].selector, methodBindingArray2[n5].selector) && methodBindingArray[n3].areParametersEqual(methodBindingArray2[n5])) {
                                return false;
                            }
                            ++n5;
                        }
                        ++n3;
                    }
                }
                return true;
            }
            if (typeBinding.id == 1) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
                return true;
            }
            if (((ReferenceBinding)typeBinding).isFinal() && (referenceBinding = ((ReferenceBinding)typeBinding).findSuperTypeWithSameErasure(typeBinding2)) == null) {
                return false;
            }
            if (bl2 && ((ReferenceBinding)typeBinding).hasIncompatibleSuperType((ReferenceBinding)typeBinding2)) {
                return false;
            }
            this.tagAsNeedCheckCast();
            return true;
        }
        switch (typeBinding.kind()) {
            case 68: {
                if (typeBinding2.id == 1) {
                    this.checkUnsafeCast(scope, typeBinding, typeBinding2, typeBinding2, true);
                    this.tagAsNeedCheckCast();
                    return true;
                }
                return false;
            }
            case 4100: {
                ReferenceBinding referenceBinding = ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(typeBinding);
                if (referenceBinding == null) {
                    this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding, true);
                }
                return this.checkCastTypesCompatibility(scope, ((TypeVariableBinding)typeBinding).upperBound(), typeBinding2, expression);
            }
        }
        if (typeBinding.isInterface()) {
            ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding2;
            ReferenceBinding referenceBinding5 = referenceBinding.findSuperTypeWithSameErasure(typeBinding);
            if (referenceBinding.isFinal()) {
                if (referenceBinding5 == null || !((TypeBinding)referenceBinding5).isCompatibleWith(typeBinding)) {
                    return false;
                }
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding5, false);
            }
            if (referenceBinding5 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding5, false);
            }
            this.tagAsNeedCheckCast();
            referenceBinding5 = ((ReferenceBinding)typeBinding).findSuperTypeWithSameErasure(typeBinding2);
            if (referenceBinding5 != null) {
                return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding5, true);
            }
            return !bl2 || !referenceBinding.hasIncompatibleSuperType((ReferenceBinding)typeBinding);
        }
        ReferenceBinding referenceBinding = ((ReferenceBinding)typeBinding2).findSuperTypeWithSameErasure(typeBinding);
        if (referenceBinding != null) {
            if (expression != null && typeBinding.id == 11) {
                this.constant = expression.constant;
            }
            return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding, false);
        }
        referenceBinding = ((ReferenceBinding)typeBinding).findSuperTypeWithSameErasure(typeBinding2);
        if (referenceBinding != null) {
            this.tagAsNeedCheckCast();
            return this.checkUnsafeCast(scope, typeBinding, typeBinding2, referenceBinding, true);
        }
        return false;
    }

    public FlowInfo checkNullStatus(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, int n2) {
        LocalVariableBinding localVariableBinding = this.localVariableBinding();
        if (localVariableBinding != null) {
            switch (n2) {
                case 1: {
                    flowContext.recordUsingNullReference(blockScope, localVariableBinding, this, 1, flowInfo);
                    flowInfo.markAsDefinitelyNull(localVariableBinding);
                    break;
                }
                case -1: {
                    flowContext.recordUsingNullReference(blockScope, localVariableBinding, this, -1, flowInfo);
                    flowInfo.markAsDefinitelyNonNull(localVariableBinding);
                    break;
                }
            }
        }
        return flowInfo;
    }

    private MethodBinding[] getAllInheritedMethods(ReferenceBinding referenceBinding) {
        ArrayList arrayList = new ArrayList();
        this.getAllInheritedMethods0(referenceBinding, arrayList);
        return arrayList.toArray(new MethodBinding[arrayList.size()]);
    }

    private void getAllInheritedMethods0(ReferenceBinding referenceBinding, ArrayList arrayList) {
        if (!referenceBinding.isInterface()) {
            return;
        }
        MethodBinding[] methodBindingArray = referenceBinding.methods();
        int n2 = 0;
        int n3 = methodBindingArray.length;
        while (n2 < n3) {
            arrayList.add(methodBindingArray[n2]);
            ++n2;
        }
        ReferenceBinding[] referenceBindingArray = referenceBinding.superInterfaces();
        n3 = 0;
        int n4 = referenceBindingArray.length;
        while (n3 < n4) {
            this.getAllInheritedMethods0(referenceBindingArray[n3], arrayList);
            ++n3;
        }
    }

    public void checkNullComparison(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo, FlowInfo flowInfo2, FlowInfo flowInfo3) {
    }

    public boolean checkUnsafeCast(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2, TypeBinding typeBinding3, boolean bl2) {
        if (typeBinding3 == typeBinding) {
            if (!bl2) {
                this.tagAsUnnecessaryCast(scope, typeBinding);
            }
            return true;
        }
        if (typeBinding3 != null && (typeBinding.isBoundParameterizedType() || typeBinding.isGenericType() || typeBinding2.isBoundParameterizedType() || typeBinding2.isGenericType()) && typeBinding3.isProvablyDistinctFrom(bl2 ? typeBinding2 : typeBinding, 0)) {
            return false;
        }
        if (!bl2) {
            this.tagAsUnnecessaryCast(scope, typeBinding);
        }
        return true;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        int n2;
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.implicitConversion != 0) {
            return;
        }
        if (typeBinding != NullBinding && typeBinding.isBaseType()) {
            if (!typeBinding2.isBaseType()) {
                TypeBinding typeBinding3 = scope.environment().computeBoxingType(typeBinding2);
                this.implicitConversion = 1024;
                scope.problemReporter().autoboxing(this, typeBinding2, typeBinding);
                typeBinding2 = typeBinding3;
            }
        } else if (typeBinding2 != NullBinding && typeBinding2.isBaseType()) {
            TypeBinding typeBinding4 = scope.environment().computeBoxingType(typeBinding);
            if (typeBinding4 == typeBinding) {
                typeBinding4 = typeBinding2;
            }
            this.implicitConversion = 0x200 | (typeBinding4.id << 4) + typeBinding2.id;
            scope.problemReporter().autoboxing(this, typeBinding2, scope.environment().computeBoxingType(typeBinding4));
            return;
        }
        if ((n2 = typeBinding2.id) == Integer.MAX_VALUE) {
            n2 = typeBinding2.erasure().id == 11 ? 11 : 1;
        }
        int n3 = typeBinding.id;
        switch (n3) {
            case 2: 
            case 3: 
            case 4: {
                this.implicitConversion |= 160 + n2;
                break;
            }
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                this.implicitConversion |= (n3 << 4) + n2;
            }
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, false);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        if (this.constant == NotAConstant) {
            throw new ShouldNotImplement(Messages.ast_missingCode);
        }
        int n2 = codeStream.position;
        codeStream.generateConstant(this.constant, this.implicitConversion);
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void generateOptimizedBoolean(BlockScope blockScope, CodeStream codeStream, Label label, Label label2, boolean bl2) {
        if (this.constant != Constant.NotAConstant && this.constant.typeID() == 5) {
            int n2 = codeStream.position;
            if (this.constant.booleanValue()) {
                if (bl2 && label2 == null && label != null) {
                    codeStream.goto_(label);
                }
            } else if (bl2 && label2 != null && label == null) {
                codeStream.goto_(label2);
            }
            codeStream.recordPositionsFrom(n2, this.sourceStart);
            return;
        }
        this.generateCode(blockScope, codeStream, bl2);
        int n3 = codeStream.position;
        if (bl2) {
            if (label2 == null) {
                if (label != null) {
                    codeStream.ifne(label);
                }
            } else if (label == null) {
                codeStream.ifeq(label2);
            }
        }
        codeStream.updateLastRecordedEndPC(blockScope, n3);
    }

    public void generateOptimizedStringConcatenation(BlockScope blockScope, CodeStream codeStream, int n2) {
        if (n2 == 11 && this.constant != NotAConstant && this.constant.stringValue().length() == 0) {
            return;
        }
        this.generateCode(blockScope, codeStream, true);
        codeStream.invokeStringConcatenationAppendForType(n2);
    }

    public void generateOptimizedStringConcatenationCreation(BlockScope blockScope, CodeStream codeStream, int n2) {
        codeStream.newStringContatenation();
        codeStream.dup();
        switch (n2) {
            case 0: 
            case 1: {
                codeStream.invokeStringConcatenationDefaultConstructor();
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringConcatenationAppendForType(1);
                return;
            }
            case 11: 
            case 12: {
                if (this.constant != NotAConstant) {
                    String string = this.constant.stringValue();
                    if (string.length() == 0) {
                        codeStream.invokeStringConcatenationDefaultConstructor();
                        return;
                    }
                    codeStream.ldc(string);
                    break;
                }
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(1);
                break;
            }
            default: {
                this.generateCode(blockScope, codeStream, true);
                codeStream.invokeStringValueOf(n2);
            }
        }
        codeStream.invokeStringConcatenationStringConstructor();
    }

    public boolean isCompactableOperation() {
        return false;
    }

    public boolean isConstantValueOfTypeAssignableToType(TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (this.constant == Constant.NotAConstant) {
            return false;
        }
        if (typeBinding == typeBinding2) {
            return true;
        }
        if (typeBinding.isBaseType() && typeBinding2.isBaseType() && (typeBinding == IntBinding || BaseTypeBinding.isWidening(10, typeBinding.id)) && BaseTypeBinding.isNarrowing(typeBinding2.id, 10)) {
            return Expression.isConstantValueRepresentable(this.constant, typeBinding.id, typeBinding2.id);
        }
        return false;
    }

    public boolean isTypeReference() {
        return false;
    }

    public int nullStatus(FlowInfo flowInfo) {
        if (this.constant != null && this.constant != NotAConstant) {
            return -1;
        }
        LocalVariableBinding localVariableBinding = this.localVariableBinding();
        if (localVariableBinding != null) {
            if (flowInfo.isDefinitelyNull(localVariableBinding)) {
                return 1;
            }
            if (flowInfo.isDefinitelyNonNull(localVariableBinding)) {
                return -1;
            }
            return 0;
        }
        return -1;
    }

    public Constant optimizedBooleanConstant() {
        return this.constant;
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        Expression.printIndent(n2, stringBuffer);
        return this.printExpression(n2, stringBuffer);
    }

    public abstract StringBuffer printExpression(int var1, StringBuffer var2);

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        return this.print(n2, stringBuffer).append(";");
    }

    public void resolve(BlockScope blockScope) {
        this.resolveType(blockScope);
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        return null;
    }

    public TypeBinding resolveType(ClassScope classScope) {
        return null;
    }

    public TypeBinding resolveTypeExpecting(BlockScope blockScope, TypeBinding typeBinding) {
        this.setExpectedType(typeBinding);
        TypeBinding typeBinding2 = this.resolveType(blockScope);
        if (typeBinding2 == null) {
            return null;
        }
        if (typeBinding2 == typeBinding) {
            return typeBinding2;
        }
        if (!typeBinding2.isCompatibleWith(typeBinding)) {
            if (blockScope.isBoxingCompatibleWith(typeBinding2, typeBinding)) {
                this.computeConversion(blockScope, typeBinding, typeBinding2);
            } else {
                blockScope.problemReporter().typeMismatchError(typeBinding2, typeBinding, this);
                return null;
            }
        }
        return typeBinding2;
    }

    public void setExpectedType(TypeBinding typeBinding) {
    }

    public void tagAsUnnecessaryCast(Scope scope, TypeBinding typeBinding) {
    }

    public void tagAsNeedCheckCast() {
    }

    public Expression toTypeReference() {
        return this;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
    }

    public LocalVariableBinding localVariableBinding() {
        return null;
    }
}

