/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.util.FloatUtil;

public class FloatLiteral
extends NumberLiteral {
    public float a;
    public static final float b = Float.intBitsToFloat(1);

    public FloatLiteral(char[] cArray, int n2, int n3) {
        super(cArray, n2, n3);
    }

    public void computeConstant() {
        Float f2;
        try {
            f2 = Float.valueOf(String.valueOf(this.d));
        }
        catch (NumberFormatException numberFormatException) {
            try {
                float f3 = FloatUtil.valueOfHexFloatLiteral(this.d);
                if (f3 == Float.POSITIVE_INFINITY) {
                    return;
                }
                if (Float.isNaN(f3)) {
                    return;
                }
                this.a = f3;
                this.constant = Constant.fromValue(f3);
            }
            catch (NumberFormatException numberFormatException2) {}
            return;
        }
        float f4 = f2.floatValue();
        if (f4 > Float.MAX_VALUE) {
            return;
        }
        if (f4 < Float.MIN_VALUE) {
            boolean bl2 = false;
            int n2 = 0;
            block10: while (n2 < this.d.length) {
                switch (this.d[n2]) {
                    case '.': 
                    case '0': {
                        break;
                    }
                    case 'X': 
                    case 'x': {
                        bl2 = true;
                        break;
                    }
                    case 'D': 
                    case 'E': 
                    case 'F': 
                    case 'd': 
                    case 'e': 
                    case 'f': {
                        if (!bl2) break block10;
                        return;
                    }
                    case 'P': 
                    case 'p': {
                        break block10;
                    }
                    default: {
                        return;
                    }
                }
                ++n2;
            }
        }
        this.a = f4;
        this.constant = Constant.fromValue(this.a);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (bl2) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return FloatBinding;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

