/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.EmptyStatement;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.LoopingFlowContext;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class ForStatement
extends Statement {
    public Statement[] initializations;
    public Expression condition;
    public Statement[] increments;
    public Statement action;
    public boolean neededScope;
    public BlockScope scope;
    private Label breakLabel;
    private Label continueLabel;
    public int c = -1;
    public int a = -1;
    public int b = -1;

    public ForStatement(Statement[] statementArray, Expression expression, Statement[] statementArray2, Statement statement, boolean bl2, int n2, int n3) {
        this.sourceStart = n2;
        this.sourceEnd = n3;
        this.initializations = statementArray;
        this.condition = expression;
        this.increments = statementArray2;
        this.action = statement;
        if (statement instanceof EmptyStatement) {
            statement.bits |= 1;
        }
        this.neededScope = bl2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        Object object;
        FlowInfo flowInfo2;
        LoopingFlowContext loopingFlowContext;
        FlowInfo flowInfo3;
        int n2;
        this.breakLabel = new Label();
        this.continueLabel = new Label();
        if (this.initializations != null) {
            int n3 = 0;
            n2 = this.initializations.length;
            while (n3 < n2) {
                flowInfo = this.initializations[n3].analyseCode(this.scope, flowContext, flowInfo);
                ++n3;
            }
        }
        this.c = blockScope.methodScope().recordInitializationStates(flowInfo);
        Constant constant = this.condition == null ? null : this.condition.constant;
        n2 = constant != null && (constant == NotAConstant || !constant.booleanValue()) ? 0 : 1;
        boolean bl2 = constant != null && constant != NotAConstant && !constant.booleanValue();
        constant = this.condition == null ? null : this.condition.optimizedBooleanConstant();
        boolean bl3 = constant == null || constant != NotAConstant && constant.booleanValue();
        boolean bl4 = constant != null && constant != NotAConstant && !constant.booleanValue();
        LoopingFlowContext loopingFlowContext2 = null;
        FlowInfo flowInfo4 = flowInfo.copy().unconditionalInits().discardNullRelatedInitializations();
        if (this.condition != null && n2 == 0) {
            loopingFlowContext2 = new LoopingFlowContext(flowContext, this, null, null, this.scope);
            flowInfo4 = this.condition.analyseCode(this.scope, loopingFlowContext2, flowInfo4);
        }
        if (this.action == null || this.action.isEmptyBlock() && blockScope.compilerOptions().complianceLevel <= 0x2F0000L) {
            if (loopingFlowContext2 != null) {
                loopingFlowContext2.complainOnDeferredChecks(this.scope, flowInfo4);
            }
            if (n2 != 0) {
                return FlowInfo.DEAD_END;
            }
            if (bl2) {
                this.continueLabel = null;
            }
            flowInfo3 = flowInfo4.initsWhenTrue().copy().unconditionalInits().discardNullRelatedInitializations();
            loopingFlowContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
        } else {
            loopingFlowContext = new LoopingFlowContext(flowContext, this, this.breakLabel, this.continueLabel, this.scope);
            flowInfo2 = flowInfo4.initsWhenTrue();
            this.a = blockScope.methodScope().recordInitializationStates(flowInfo2);
            if (bl2) {
                flowInfo3 = FlowInfo.DEAD_END;
            } else {
                flowInfo3 = flowInfo2.copy().unconditionalInits().discardNullRelatedInitializations();
                if (bl4) {
                    ((FlowInfo)flowInfo3).setReachMode(1);
                }
            }
            if (!this.action.complainIfUnreachable(flowInfo3, this.scope, false)) {
                flowInfo3 = this.action.analyseCode(this.scope, loopingFlowContext, flowInfo3);
            }
            if (!((FlowInfo)flowInfo3).isReachable() && !loopingFlowContext.initsOnContinue.isReachable()) {
                this.continueLabel = null;
            } else {
                if (loopingFlowContext2 != null) {
                    loopingFlowContext2.complainOnDeferredChecks(this.scope, flowInfo4);
                }
                flowInfo3 = ((FlowInfo)flowInfo3).mergedWith(loopingFlowContext.initsOnContinue.unconditionalInits());
                loopingFlowContext.complainOnDeferredChecks(this.scope, flowInfo3);
            }
        }
        flowInfo2 = flowInfo4.initsWhenFalse();
        flowInfo2.addInitializationsFrom(flowInfo);
        if (this.continueLabel != null) {
            if (this.increments != null) {
                object = new LoopingFlowContext(flowContext, this, null, null, this.scope);
                int n4 = 0;
                int n5 = this.increments.length;
                while (n4 < n5) {
                    flowInfo3 = this.increments[n4].analyseCode(this.scope, (FlowContext)object, flowInfo3);
                    ++n4;
                }
                ((LoopingFlowContext)object).complainOnDeferredChecks(this.scope, flowInfo3);
            }
            flowInfo2.addPotentialInitializationsFrom(((FlowInfo)flowInfo3).unconditionalInits());
        }
        object = FlowInfo.mergedOptimizedBranches(loopingFlowContext.initsOnBreak, bl3, flowInfo2, bl4, n2 == 0);
        this.b = blockScope.methodScope().recordInitializationStates((FlowInfo)object);
        return object;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        int n2;
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        int n3 = codeStream.position;
        if (this.initializations != null) {
            int n4 = 0;
            int n5 = this.initializations.length;
            while (n4 < n5) {
                this.initializations[n4].generateCode(this.scope, codeStream);
                ++n4;
            }
        }
        Label label = new Label(codeStream);
        Label label2 = new Label(codeStream);
        this.breakLabel.initialize(codeStream);
        if (this.continueLabel != null) {
            this.continueLabel.initialize(codeStream);
        }
        if (this.condition != null && this.condition.constant == NotAConstant && (this.action != null && !this.action.isEmptyBlock() || this.increments != null)) {
            n2 = codeStream.position;
            codeStream.goto_(label2);
            codeStream.recordPositionsFrom(n2, this.condition.sourceStart);
        }
        label.place();
        if (this.action != null) {
            if (this.a != -1) {
                codeStream.addDefinitelyAssignedVariables(blockScope, this.a);
            }
            this.action.generateCode(this.scope, codeStream);
        }
        if (this.continueLabel != null) {
            this.continueLabel.place();
            if (this.increments != null) {
                n2 = 0;
                int n6 = this.increments.length;
                while (n2 < n6) {
                    this.increments[n2].generateCode(this.scope, codeStream);
                    ++n2;
                }
            }
        }
        if (this.c != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.c);
        }
        label2.place();
        if (this.condition != null && this.condition.constant == NotAConstant) {
            this.condition.generateOptimizedBoolean(this.scope, codeStream, label, null, true);
        } else if (this.continueLabel != null) {
            codeStream.goto_(label);
        }
        this.breakLabel.place();
        if (this.neededScope) {
            codeStream.exitUserScope(this.scope);
        }
        if (this.b != -1) {
            codeStream.removeNotDefinitelyAssignedVariables(blockScope, this.b);
            codeStream.addDefinitelyAssignedVariables(blockScope, this.b);
        }
        codeStream.recordPositionsFrom(n3, this.sourceStart);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        int n3;
        ForStatement.printIndent(n2, stringBuffer).append("for (");
        if (this.initializations != null) {
            n3 = 0;
            while (n3 < this.initializations.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.initializations[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append("; ");
        if (this.condition != null) {
            this.condition.printExpression(0, stringBuffer);
        }
        stringBuffer.append("; ");
        if (this.increments != null) {
            n3 = 0;
            while (n3 < this.increments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.increments[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append(") ");
        if (this.action == null) {
            stringBuffer.append(';');
        } else {
            stringBuffer.append('\n');
            this.action.printStatement(n2 + 1, stringBuffer);
        }
        return stringBuffer.append(';');
    }

    public void resolve(BlockScope blockScope) {
        int n2;
        BlockScope blockScope2 = this.scope = this.neededScope ? new BlockScope(blockScope) : blockScope;
        if (this.initializations != null) {
            int n3 = 0;
            n2 = this.initializations.length;
            while (n3 < n2) {
                this.initializations[n3].resolve(this.scope);
                ++n3;
            }
        }
        if (this.condition != null) {
            TypeBinding typeBinding = this.condition.resolveTypeExpecting(this.scope, BooleanBinding);
            this.condition.computeConversion(this.scope, typeBinding, typeBinding);
        }
        if (this.increments != null) {
            int n4 = 0;
            n2 = this.increments.length;
            while (n4 < n2) {
                this.increments[n4].resolve(this.scope);
                ++n4;
            }
        }
        if (this.action != null) {
            this.action.resolve(this.scope);
        }
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2;
            int n3;
            if (this.initializations != null) {
                n3 = this.initializations.length;
                n2 = 0;
                while (n2 < n3) {
                    this.initializations[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.condition != null) {
                this.condition.traverse(aSTVisitor, this.scope);
            }
            if (this.increments != null) {
                n3 = this.increments.length;
                n2 = 0;
                while (n2 < n3) {
                    this.increments[n2].traverse(aSTVisitor, this.scope);
                    ++n2;
                }
            }
            if (this.action != null) {
                this.action.traverse(aSTVisitor, this.scope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

