/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.NumberLiteral;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class IntLiteral
extends NumberLiteral {
    public int value;
    public static final IntLiteral One = new IntLiteral(new char[]{'1'}, 0, 0, 1);
    public static final Constant a = new DoubleConstant(Double.POSITIVE_INFINITY);

    public IntLiteral(char[] cArray, int n2, int n3) {
        super(cArray, n2, n3);
    }

    public IntLiteral(char[] cArray, int n2, int n3, int n4) {
        this(cArray, n2, n3);
        this.value = n4;
    }

    public IntLiteral(int n2) {
        super(null, 0, 0);
        this.constant = Constant.fromValue(n2);
        this.value = n2;
    }

    public void computeConstant() {
        long l2 = Integer.MAX_VALUE;
        if (this == One) {
            this.constant = Constant.One;
            return;
        }
        int n2 = this.d.length;
        long l3 = 0L;
        if (this.d[0] == '0') {
            int n3;
            int n4;
            int n5;
            l2 = 0xFFFFFFFFL;
            if (n2 == 1) {
                this.constant = Constant.fromValue(0);
                return;
            }
            if (this.d[1] == 'x' || this.d[1] == 'X') {
                n5 = 4;
                n4 = 2;
                n3 = 16;
            } else {
                n5 = 3;
                n4 = 1;
                n3 = 8;
            }
            while (this.d[n4] == '0') {
                if (++n4 != n2) continue;
                this.value = (int)l3;
                this.constant = Constant.fromValue(this.value);
                return;
            }
            while (n4 < n2) {
                int n6;
                if ((n6 = Character.digit(this.d[n4++], n3)) < 0) {
                    this.constant = a;
                    return;
                }
                if ((l3 = l3 << n5 | (long)n6) <= l2) continue;
                return;
            }
        } else {
            int n7 = 0;
            while (n7 < n2) {
                int n8 = Character.digit(this.d[n7], 10);
                if (n8 < 0) {
                    this.constant = a;
                    return;
                }
                if ((l3 = 10L * l3 + (long)n8) > l2) {
                    return;
                }
                ++n7;
            }
        }
        this.value = (int)l3;
        this.constant = Constant.fromValue(this.value);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        if (bl2) {
            codeStream.generateConstant(this.constant, this.implicitConversion);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public TypeBinding literalType(BlockScope blockScope) {
        return IntBinding;
    }

    public final boolean mayRepresentMIN_VALUE() {
        return this.d.length == 10 && this.d[0] == '2' && this.d[1] == '1' && this.d[2] == '4' && this.d[3] == '7' && this.d[4] == '4' && this.d[5] == '8' && this.d[6] == '3' && this.d[7] == '6' && this.d[8] == '4' && this.d[9] == '8';
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        TypeBinding typeBinding = super.resolveType(blockScope);
        if (this.constant == a) {
            this.constant = NotAConstant;
            blockScope.problemReporter().constantOutOfFormat(this);
            this.resolvedType = null;
            return null;
        }
        return typeBinding;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        if (this.d == null) {
            return stringBuffer.append(String.valueOf(this.value));
        }
        return super.printExpression(n2, stringBuffer);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }
}

