/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.NameReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedSuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.impl.CompilerOptions;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemMethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class MessageSend
extends Expression
implements InvocationSite {
    public Expression receiver;
    public char[] selector;
    public Expression[] arguments;
    public MethodBinding binding;
    public MethodBinding codegenBinding;
    public MethodBinding a;
    public TypeBinding expectedType;
    public long nameSourcePosition;
    public TypeBinding actualReceiverType;
    public TypeBinding valueCast;
    public TypeReference[] typeArguments;
    public TypeBinding[] genericTypeArguments;

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        boolean bl2 = !this.binding.isStatic();
        flowInfo = this.receiver.analyseCode(blockScope, flowContext, flowInfo, bl2).unconditionalInits();
        if (bl2) {
            this.receiver.checkNullStatus(blockScope, flowContext, flowInfo, -1);
        }
        if (this.arguments != null) {
            int n2 = this.arguments.length;
            int n3 = 0;
            while (n3 < n2) {
                flowInfo = this.arguments[n3].analyseCode(blockScope, flowContext, flowInfo).unconditionalInits();
                ++n3;
            }
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions != NoExceptions) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo, blockScope);
        }
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public void computeConversion(Scope scope, TypeBinding typeBinding, TypeBinding typeBinding2) {
        if (typeBinding == null || typeBinding2 == null) {
            return;
        }
        if (this.binding != null && this.binding.isValidBinding()) {
            MethodBinding methodBinding = this.binding.original();
            if (methodBinding != this.binding) {
                if ((methodBinding.returnType.tagBits & 0x20000000L) != 0L && typeBinding.id != 1) {
                    TypeBinding typeBinding3 = !typeBinding2.isBaseType() && typeBinding.isBaseType() ? typeBinding2 : typeBinding;
                    this.valueCast = methodBinding.returnType.genericCast(typeBinding3);
                }
            } else if (this.actualReceiverType.isArrayType() && typeBinding.id != 1 && this.binding.parameters == NoParameters && scope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
                this.valueCast = typeBinding;
            }
        }
        super.computeConversion(scope, typeBinding, typeBinding2);
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        boolean bl3 = this.codegenBinding.isStatic();
        if (!bl3 && (this.bits & 0x1FE0) != 0 && this.receiver.isImplicitThis()) {
            ReferenceBinding referenceBinding = blockScope.enclosingSourceType().enclosingTypeAt((this.bits & 0x1FE0) >> 5);
            Object[] objectArray = blockScope.getEmulationPath(referenceBinding, true, false);
            codeStream.generateOuterAccess(objectArray, this, referenceBinding, blockScope);
        } else {
            this.receiver.generateCode(blockScope, codeStream, !bl3);
            codeStream.recordPositionsFrom(n2, this.sourceStart);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (this.a == null) {
            if (bl3) {
                codeStream.invokestatic(this.codegenBinding);
            } else if (this.receiver.isSuper() || this.codegenBinding.isPrivate()) {
                codeStream.invokespecial(this.codegenBinding);
            } else if (this.codegenBinding.declaringClass.isInterface()) {
                codeStream.invokeinterface(this.codegenBinding);
            } else {
                codeStream.invokevirtual(this.codegenBinding);
            }
        } else {
            codeStream.invokestatic(this.a);
        }
        if (bl2) {
            if (this.valueCast != null) {
                codeStream.checkcast(this.valueCast);
            }
            codeStream.generateImplicitConversion(this.implicitConversion);
        } else {
            switch (this.binding.returnType.id) {
                case 7: 
                case 8: {
                    codeStream.pop2();
                    break;
                }
                case 6: {
                    break;
                }
                default: {
                    codeStream.pop();
                }
            }
        }
        codeStream.recordPositionsFrom(n2, (int)(this.nameSourcePosition >>> 32));
    }

    public TypeBinding[] genericTypeArguments() {
        return this.genericTypeArguments;
    }

    public boolean isSuperAccess() {
        return this.receiver.isSuper();
    }

    public boolean isTypeAccess() {
        return this.receiver != null && this.receiver.isTypeReference();
    }

    public void manageSyntheticAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        ClassFileConstants classFileConstants;
        if (!flowInfo.isReachable()) {
            return;
        }
        this.codegenBinding = this.binding.original();
        if (this.binding.isPrivate()) {
            if (blockScope.enclosingSourceType() != this.codegenBinding.declaringClass) {
                this.a = ((SourceTypeBinding)this.codegenBinding.declaringClass).addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                return;
            }
        } else {
            if (this.receiver instanceof QualifiedSuperReference) {
                SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((QualifiedSuperReference)this.receiver).a;
                this.a = sourceTypeBinding.addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                return;
            }
            if (this.binding.isProtected() && (this.bits & 0x1FE0) != 0) {
                classFileConstants = blockScope.enclosingSourceType();
                if (this.codegenBinding.declaringClass.getPackage() != ((ReferenceBinding)classFileConstants).getPackage()) {
                    SourceTypeBinding sourceTypeBinding = (SourceTypeBinding)((ReferenceBinding)classFileConstants).enclosingTypeAt((this.bits & 0x1FE0) >> 5);
                    this.a = sourceTypeBinding.addSyntheticMethod(this.codegenBinding, this.isSuperAccess());
                    blockScope.problemReporter().needToEmulateMethodAccess(this.codegenBinding, this);
                    return;
                }
            }
        }
        if (this.binding.declaringClass != this.actualReceiverType && !this.actualReceiverType.isArrayType()) {
            classFileConstants = blockScope.compilerOptions();
            if (!((((CompilerOptions)classFileConstants).targetJDK < 0x2E0000L || ((CompilerOptions)classFileConstants).complianceLevel < 0x300000L && this.receiver.isImplicitThis() && this.codegenBinding.isStatic() || this.binding.declaringClass.id == 1) && this.binding.declaringClass.canBeSeenBy(blockScope))) {
                this.codegenBinding = blockScope.enclosingSourceType().getUpdatedMethodBinding(this.codegenBinding, (ReferenceBinding)this.actualReceiverType.erasure());
            }
        }
    }

    public int nullStatus(FlowInfo flowInfo) {
        return 0;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        int n3;
        if (!this.receiver.isImplicitThis()) {
            this.receiver.printExpression(0, stringBuffer).append('.');
        }
        if (this.typeArguments != null) {
            stringBuffer.append('<');
            n3 = this.typeArguments.length - 1;
            int n4 = 0;
            while (n4 < n3) {
                this.typeArguments[n4].print(0, stringBuffer);
                stringBuffer.append(", ");
                ++n4;
            }
            this.typeArguments[n3].print(0, stringBuffer);
            stringBuffer.append('>');
        }
        stringBuffer.append(this.selector).append('(');
        if (this.arguments != null) {
            n3 = 0;
            while (n3 < this.arguments.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.arguments[n3].printExpression(0, stringBuffer);
                ++n3;
            }
        }
        return stringBuffer.append(')');
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        int n2;
        boolean bl2;
        this.constant = NotAConstant;
        boolean bl3 = false;
        boolean bl4 = false;
        if (this.receiver instanceof CastExpression) {
            this.receiver.bits |= 0x20;
            bl3 = true;
        }
        this.actualReceiverType = this.receiver.resolveType(blockScope);
        if (bl3 && this.actualReceiverType != null && ((CastExpression)this.receiver).expression.resolvedType == this.actualReceiverType) {
            blockScope.problemReporter().unnecessaryCast((CastExpression)this.receiver);
        }
        if (this.typeArguments != null) {
            int n3 = this.typeArguments.length;
            bl2 = false;
            this.genericTypeArguments = new TypeBinding[n3];
            n2 = 0;
            while (n2 < n3) {
                this.genericTypeArguments[n2] = this.typeArguments[n2].resolveType(blockScope, true);
                if (this.genericTypeArguments[n2] == null) {
                    bl2 = true;
                }
                ++n2;
            }
            if (bl2) {
                return null;
            }
        }
        TypeBinding[] typeBindingArray = NoParameters;
        if (this.arguments != null) {
            bl2 = false;
            n2 = this.arguments.length;
            typeBindingArray = new TypeBinding[n2];
            int n4 = 0;
            while (n4 < n2) {
                Expression expression = this.arguments[n4];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl4 = true;
                }
                if ((typeBindingArray[n4] = expression.resolveType(blockScope)) == null) {
                    bl2 = true;
                }
                ++n4;
            }
            if (bl2) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding = blockScope.findMethod((ReferenceBinding)this.actualReceiverType, this.selector, new TypeBinding[0], this);
                }
                return null;
            }
        }
        if (this.actualReceiverType == null) {
            return null;
        }
        if (this.actualReceiverType.isBaseType()) {
            blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
            return null;
        }
        MethodBinding methodBinding = this.binding = this.receiver.isImplicitThis() ? blockScope.getImplicitMethod(this.selector, typeBindingArray, this) : blockScope.getMethod(this.actualReceiverType, this.selector, typeBindingArray, this);
        if (!this.binding.isValidBinding()) {
            if (this.binding.declaringClass == null) {
                if (this.actualReceiverType instanceof ReferenceBinding) {
                    this.binding.declaringClass = (ReferenceBinding)this.actualReceiverType;
                } else {
                    blockScope.problemReporter().errorNoMethodFor(this, this.actualReceiverType, typeBindingArray);
                    return null;
                }
            }
            blockScope.problemReporter().invalidMethod(this, this.binding);
            MethodBinding methodBinding2 = ((ProblemMethodBinding)this.binding).closestMatch;
            switch (this.binding.problemId()) {
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 10: {
                    if (methodBinding2 == null) break;
                    this.resolvedType = methodBinding2.returnType;
                }
            }
            if (methodBinding2 != null) {
                this.binding = methodBinding2;
                if ((methodBinding2.isPrivate() || methodBinding2.declaringClass.isLocalType()) && !blockScope.isDefinedInMethod(methodBinding2)) {
                    methodBinding2.original().modifiers |= 0x8000000;
                }
            }
            return this.resolvedType;
        }
        if (!this.binding.isStatic()) {
            if (this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0) {
                blockScope.problemReporter().mustUseAStaticMethod(this, this.binding);
            } else {
                ReferenceBinding referenceBinding;
                TypeBinding typeBinding = this.actualReceiverType.erasure();
                if (typeBinding instanceof ReferenceBinding && (referenceBinding = ((ReferenceBinding)typeBinding).findSuperTypeWithSameErasure(this.binding.declaringClass)) == null) {
                    this.actualReceiverType = this.binding.declaringClass;
                }
                this.receiver.computeConversion(blockScope, this.actualReceiverType, this.actualReceiverType);
            }
        } else {
            if (!(this.receiver.isImplicitThis() || this.receiver.isSuper() || this.receiver instanceof NameReference && (((NameReference)this.receiver).bits & 4) != 0)) {
                blockScope.problemReporter().nonStaticAccessToStaticMethod(this, this.binding);
            }
            if (!this.receiver.isImplicitThis() && this.binding.declaringClass != this.actualReceiverType) {
                blockScope.problemReporter().indirectAccessToStaticMethod(this, this.binding);
            }
        }
        MessageSend.checkInvocationArguments(blockScope, this.receiver, this.actualReceiverType, this.binding, this.arguments, typeBindingArray, bl4, this);
        if (this.binding.isAbstract() && this.receiver.isSuper()) {
            blockScope.problemReporter().cannotDireclyInvokeAbstractMethod(this, this.binding);
        }
        if (this.isMethodUseDeprecated(this.binding, blockScope)) {
            blockScope.problemReporter().deprecatedMethod(this.binding, this);
        }
        if (this.actualReceiverType.isArrayType() && this.binding.parameters == NoParameters && blockScope.compilerOptions().complianceLevel >= 0x310000L && CharOperation.equals(this.binding.selector, CLONE)) {
            this.resolvedType = this.actualReceiverType;
        } else {
            TypeBinding typeBinding = this.binding.returnType;
            if (typeBinding != null) {
                typeBinding = typeBinding.capture(blockScope, this.sourceEnd);
            }
            this.resolvedType = typeBinding;
        }
        return this.resolvedType;
    }

    public void setActualReceiverType(ReferenceBinding referenceBinding) {
        if (referenceBinding == null) {
            return;
        }
        this.actualReceiverType = referenceBinding;
    }

    public void setExpectedType(TypeBinding typeBinding) {
        this.expectedType = typeBinding;
    }

    public void setDepth(int n2) {
        this.bits &= 0xFFFFE01F;
        if (n2 > 0) {
            this.bits |= (n2 & 0xFF) << 5;
        }
    }

    public void setFieldIndex(int n2) {
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2;
            int n3;
            this.receiver.traverse(aSTVisitor, blockScope);
            if (this.typeArguments != null) {
                n3 = 0;
                n2 = this.typeArguments.length;
                while (n3 < n2) {
                    this.typeArguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
            if (this.arguments != null) {
                n3 = this.arguments.length;
                n2 = 0;
                while (n2 < n3) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

