/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.MemberValuePair;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;

public class NormalAnnotation
extends Annotation {
    public MemberValuePair[] memberValuePairs;

    public NormalAnnotation(TypeReference typeReference, int n2) {
        this.type = typeReference;
        this.sourceStart = n2;
        this.sourceEnd = typeReference.sourceEnd;
    }

    public MemberValuePair[] memberValuePairs() {
        return this.memberValuePairs == null ? a : this.memberValuePairs;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        super.printExpression(n2, stringBuffer);
        stringBuffer.append('(');
        if (this.memberValuePairs != null) {
            int n3 = 0;
            int n4 = this.memberValuePairs.length;
            while (n3 < n4) {
                if (n3 > 0) {
                    stringBuffer.append(',');
                }
                this.memberValuePairs[n3].print(n2, stringBuffer);
                ++n3;
            }
        }
        stringBuffer.append(')');
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope) && this.memberValuePairs != null) {
            int n2 = this.memberValuePairs.length;
            int n3 = 0;
            while (n3 < n2) {
                this.memberValuePairs[n3].traverse(aSTVisitor, blockScope);
                ++n3;
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (aSTVisitor.visit(this, compilationUnitScope) && this.memberValuePairs != null) {
            int n2 = this.memberValuePairs.length;
            int n3 = 0;
            while (n3 < n2) {
                this.memberValuePairs[n3].traverse(aSTVisitor, compilationUnitScope);
                ++n3;
            }
        }
        aSTVisitor.endVisit(this, compilationUnitScope);
    }
}

