/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.CastExpression;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.ParameterizedQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.QualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.SingleTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class QualifiedAllocationExpression
extends AllocationExpression {
    public Expression enclosingInstance;
    public TypeDeclaration anonymousType;
    public ReferenceBinding superTypeBinding;

    public QualifiedAllocationExpression() {
    }

    public QualifiedAllocationExpression(TypeDeclaration typeDeclaration) {
        this.anonymousType = typeDeclaration;
        typeDeclaration.allocation = this;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.enclosingInstance != null) {
            flowInfo = this.enclosingInstance.analyseCode(blockScope, flowContext, flowInfo);
        }
        ReferenceBinding referenceBinding = this.superTypeBinding == null ? this.binding.declaringClass : this.superTypeBinding;
        this.checkCapturedLocalInitializationIfNecessary((ReferenceBinding)referenceBinding.erasure(), blockScope, flowInfo);
        if (this.arguments != null) {
            int n2 = 0;
            int n3 = this.arguments.length;
            while (n2 < n3) {
                flowInfo = this.arguments[n2].analyseCode(blockScope, flowContext, flowInfo);
                ++n2;
            }
        }
        if (this.anonymousType != null) {
            flowInfo = this.anonymousType.analyseCode(blockScope, flowContext, flowInfo);
        }
        TypeBinding[] typeBindingArray = this.binding.thrownExceptions;
        if (this.binding.thrownExceptions.length != 0) {
            flowContext.checkExceptionHandlers(typeBindingArray, (ASTNode)this, flowInfo, blockScope);
        }
        this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
        this.manageSyntheticAccessIfNecessary(blockScope, flowInfo);
        return flowInfo;
    }

    public Expression enclosingInstance() {
        return this.enclosingInstance;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream, boolean bl2) {
        int n2 = codeStream.position;
        ReferenceBinding referenceBinding = this.codegenBinding.declaringClass;
        codeStream.new_(referenceBinding);
        if (bl2) {
            codeStream.dup();
        }
        if (this.type != null) {
            codeStream.recordPositionsFrom(n2, this.type.sourceStart);
        } else {
            codeStream.ldc(String.valueOf(this.enumConstant.name));
            codeStream.generateInlinedValue(this.enumConstant.binding.id);
        }
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticEnclosingInstanceValues(blockScope, referenceBinding, this.enclosingInstance(), this);
        }
        this.generateArguments(this.binding, this.arguments, blockScope, codeStream);
        if (referenceBinding.isNestedType()) {
            codeStream.generateSyntheticOuterArgumentValues(blockScope, referenceBinding, this);
        }
        if (this.a == null) {
            codeStream.invokespecial(this.codegenBinding);
        } else {
            int n3 = 0;
            int n4 = this.a.parameters.length - this.codegenBinding.parameters.length;
            while (n3 < n4) {
                codeStream.aconst_null();
                ++n3;
            }
            codeStream.invokespecial(this.a);
        }
        codeStream.generateImplicitConversion(this.implicitConversion);
        codeStream.recordPositionsFrom(n2, this.sourceStart);
        if (this.anonymousType != null) {
            this.anonymousType.generateCode(blockScope, codeStream);
        }
    }

    public boolean isSuperAccess() {
        return this.anonymousType != null;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)this.binding.declaringClass.erasure();
        if (referenceBinding.isNestedType() && blockScope.enclosingSourceType().isLocalType()) {
            if (referenceBinding.isLocalType()) {
                ((LocalTypeBinding)referenceBinding).addInnerEmulationDependent(blockScope, this.enclosingInstance != null);
            } else {
                blockScope.propagateInnerEmulation(referenceBinding, this.enclosingInstance != null);
            }
        }
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        if (this.enclosingInstance != null) {
            this.enclosingInstance.printExpression(0, stringBuffer).append('.');
        }
        super.printExpression(0, stringBuffer);
        if (this.anonymousType != null) {
            this.anonymousType.print(n2, stringBuffer);
        }
        return stringBuffer;
    }

    public TypeBinding resolveType(BlockScope blockScope) {
        BaseTypes baseTypes;
        boolean bl2;
        boolean bl3;
        TypeBinding typeBinding;
        TypeBinding typeBinding2;
        block42: {
            block40: {
                boolean bl4;
                block44: {
                    block43: {
                        block41: {
                            if (this.anonymousType == null && this.enclosingInstance == null) {
                                return super.resolveType(blockScope);
                            }
                            this.constant = NotAConstant;
                            typeBinding2 = null;
                            typeBinding = null;
                            bl3 = false;
                            bl4 = false;
                            bl2 = false;
                            if (this.enclosingInstance == null) break block40;
                            if (this.enclosingInstance instanceof CastExpression) {
                                this.enclosingInstance.bits |= 0x20;
                                bl4 = true;
                            }
                            if ((typeBinding2 = this.enclosingInstance.resolveType(blockScope)) != null) break block41;
                            bl3 = true;
                            break block42;
                        }
                        if (!typeBinding2.isBaseType() && !typeBinding2.isArrayType()) break block43;
                        blockScope.problemReporter().illegalPrimitiveOrArrayTypeForEnclosingInstance(typeBinding2, this.enclosingInstance);
                        bl3 = true;
                        break block42;
                    }
                    if (!(this.type instanceof QualifiedTypeReference)) break block44;
                    blockScope.problemReporter().illegalUsageOfQualifiedTypeReference((QualifiedTypeReference)this.type);
                    bl3 = true;
                    break block42;
                }
                typeBinding = ((SingleTypeReference)this.type).resolveTypeEnclosing(blockScope, (ReferenceBinding)typeBinding2);
                if (typeBinding == null || !bl4) break block42;
                CastExpression.checkNeedForEnclosingInstanceCast(blockScope, this.enclosingInstance, typeBinding2, typeBinding);
                break block42;
            }
            if (this.type == null) {
                typeBinding = blockScope.enclosingSourceType();
            } else {
                typeBinding = this.type.resolveType(blockScope, true);
                if (typeBinding != null && this.type instanceof ParameterizedQualifiedTypeReference) {
                    ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
                    block0: while ((referenceBinding.modifiers & 8) == 0 && !referenceBinding.isRawType()) {
                        if ((referenceBinding = referenceBinding.enclosingType()) != null) continue;
                        baseTypes = (ParameterizedQualifiedTypeReference)this.type;
                        int n2 = ((ParameterizedQualifiedTypeReference)baseTypes).typeArguments.length - 2;
                        while (n2 >= 0) {
                            if (((ParameterizedQualifiedTypeReference)baseTypes).typeArguments[n2] != null) {
                                blockScope.problemReporter().illegalQualifiedParameterizedTypeAllocation(this.type, typeBinding);
                                break block0;
                            }
                            --n2;
                        }
                        break block0;
                    }
                }
            }
        }
        if (typeBinding == null) {
            bl3 = true;
        } else if (((ReferenceBinding)typeBinding).isFinal()) {
            if (this.anonymousType != null) {
                if (!typeBinding.isEnum()) {
                    blockScope.problemReporter().anonymousClassCannotExtendFinalClass(this.type, typeBinding);
                    bl3 = true;
                }
            } else if (!typeBinding.canBeInstantiated()) {
                blockScope.problemReporter().cannotInstantiate(this.type, typeBinding);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
        }
        if (this.typeArguments != null) {
            int n3 = this.typeArguments.length;
            this.genericTypeArguments = new TypeBinding[n3];
            int n4 = 0;
            while (n4 < n3) {
                TypeBinding typeBinding3 = this.typeArguments[n4].resolveType(blockScope, true);
                if (typeBinding3 == null) {
                    return null;
                }
                this.genericTypeArguments[n4] = typeBinding3;
                ++n4;
            }
        }
        TypeBinding[] typeBindingArray = NoParameters;
        if (this.arguments != null) {
            int n5 = this.arguments.length;
            typeBindingArray = new TypeBinding[n5];
            int n6 = 0;
            while (n6 < n5) {
                Expression expression = this.arguments[n6];
                if (expression instanceof CastExpression) {
                    expression.bits |= 0x20;
                    bl2 = true;
                }
                if ((typeBindingArray[n6] = expression.resolveType(blockScope)) == null) {
                    bl3 = true;
                }
                ++n6;
            }
        }
        if (bl3) {
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        if (this.anonymousType == null) {
            if (!typeBinding.canBeInstantiated()) {
                blockScope.problemReporter().cannotInstantiate(this.type, typeBinding);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
            baseTypes = (ReferenceBinding)typeBinding;
            this.binding = blockScope.getConstructor((ReferenceBinding)baseTypes, typeBindingArray, this);
            if (this.binding.isValidBinding()) {
                if (this.isMethodUseDeprecated(this.binding, blockScope)) {
                    blockScope.problemReporter().deprecatedMethod(this.binding, this);
                }
            } else {
                if (this.binding.declaringClass == null) {
                    this.binding.declaringClass = baseTypes;
                }
                blockScope.problemReporter().invalidConstructor(this, this.binding);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
            QualifiedAllocationExpression.checkInvocationArguments(blockScope, null, (TypeBinding)baseTypes, this.binding, this.arguments, typeBindingArray, bl2, this);
            ReferenceBinding referenceBinding = this.binding.declaringClass.enclosingType();
            if (referenceBinding != typeBinding2) {
                blockScope.compilationUnitScope().recordTypeConversion(referenceBinding, typeBinding2);
            }
            if (typeBinding2.isCompatibleWith(referenceBinding) || blockScope.isBoxingCompatibleWith(typeBinding2, referenceBinding)) {
                this.enclosingInstance.computeConversion(blockScope, referenceBinding, typeBinding2);
                this.resolvedType = typeBinding;
                return this.resolvedType;
            }
            blockScope.problemReporter().typeMismatchError(typeBinding2, referenceBinding, this.enclosingInstance);
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        if (typeBinding.isTypeVariable()) {
            typeBinding = new ProblemReferenceBinding(typeBinding.sourceName(), (ReferenceBinding)typeBinding, 9);
            blockScope.problemReporter().invalidType(this, typeBinding);
            return null;
        }
        if (this.type != null && typeBinding.isEnum()) {
            blockScope.problemReporter().cannotInstantiate(this.type, typeBinding);
            this.resolvedType = typeBinding;
            return this.resolvedType;
        }
        this.superTypeBinding = typeBinding.isInterface() ? blockScope.getJavaLangObject() : (ReferenceBinding)typeBinding;
        blockScope.addAnonymousType(this.anonymousType, (ReferenceBinding)typeBinding);
        this.anonymousType.resolve(blockScope);
        if ((typeBinding.tagBits & 0x40000000L) != 0L) {
            blockScope.problemReporter().superTypeCannotUseWildcard(this.anonymousType.binding, this.type, typeBinding);
        }
        if (!((Binding)((Object)(baseTypes = blockScope.getConstructor(this.superTypeBinding, typeBindingArray, this)))).isValidBinding()) {
            if (((MethodBinding)baseTypes).declaringClass == null) {
                ((MethodBinding)baseTypes).declaringClass = this.superTypeBinding;
            }
            blockScope.problemReporter().invalidConstructor(this, (MethodBinding)baseTypes);
            this.resolvedType = this.anonymousType.binding;
            return this.resolvedType;
        }
        if (this.enclosingInstance != null) {
            ReferenceBinding referenceBinding = ((MethodBinding)baseTypes).declaringClass.enclosingType();
            if (referenceBinding == null) {
                blockScope.problemReporter().unnecessaryEnclosingInstanceSpecification(this.enclosingInstance, (ReferenceBinding)typeBinding);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            if (!typeBinding2.isCompatibleWith(referenceBinding) && !blockScope.isBoxingCompatibleWith(typeBinding2, referenceBinding)) {
                blockScope.problemReporter().typeMismatchError(typeBinding2, referenceBinding, this.enclosingInstance);
                this.resolvedType = this.anonymousType.binding;
                return this.resolvedType;
            }
            this.enclosingInstance.computeConversion(blockScope, referenceBinding, typeBinding2);
        }
        if (this.arguments != null) {
            QualifiedAllocationExpression.checkInvocationArguments(blockScope, null, this.superTypeBinding, (MethodBinding)baseTypes, this.arguments, typeBindingArray, bl2, this);
        }
        this.binding = this.anonymousType.createDefaultConstructorWithBinding((MethodBinding)baseTypes);
        this.resolvedType = this.anonymousType.binding;
        return this.resolvedType;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            int n2;
            int n3;
            if (this.enclosingInstance != null) {
                this.enclosingInstance.traverse(aSTVisitor, blockScope);
            }
            if (this.typeArguments != null) {
                n3 = 0;
                n2 = this.typeArguments.length;
                while (n3 < n2) {
                    this.typeArguments[n3].traverse(aSTVisitor, blockScope);
                    ++n3;
                }
            }
            if (this.type != null) {
                this.type.traverse(aSTVisitor, blockScope);
            }
            if (this.arguments != null) {
                n3 = this.arguments.length;
                n2 = 0;
                while (n2 < n3) {
                    this.arguments[n2].traverse(aSTVisitor, blockScope);
                    ++n2;
                }
            }
            if (this.anonymousType != null) {
                this.anonymousType.traverse(aSTVisitor, blockScope);
            }
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

