/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.ArrayQualifiedTypeReference;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ProblemReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public class QualifiedTypeReference
extends TypeReference {
    public char[][] tokens;
    public long[] sourcePositions;

    public QualifiedTypeReference(char[][] cArray, long[] lArray) {
        this.tokens = cArray;
        this.sourcePositions = lArray;
        this.sourceStart = (int)(this.sourcePositions[0] >>> 32);
        this.sourceEnd = (int)(this.sourcePositions[this.sourcePositions.length - 1] & 0xFFFFFFFFL);
    }

    public TypeReference copyDims(int n2) {
        return new ArrayQualifiedTypeReference(this.tokens, n2, this.sourcePositions);
    }

    public TypeBinding findNextTypeBinding(int n2, Scope scope, PackageBinding packageBinding) {
        try {
            if (this.resolvedType == null) {
                this.resolvedType = scope.getType(this.tokens[n2], packageBinding);
            } else {
                this.resolvedType = scope.getMemberType(this.tokens[n2], (ReferenceBinding)this.resolvedType);
                if (this.resolvedType instanceof ProblemReferenceBinding) {
                    ProblemReferenceBinding problemReferenceBinding = (ProblemReferenceBinding)this.resolvedType;
                    this.resolvedType = new ProblemReferenceBinding(CharOperation.subarray(this.tokens, 0, n2 + 1), problemReferenceBinding.closestMatch, this.resolvedType.problemId());
                }
            }
            return this.resolvedType;
        }
        catch (AbortCompilation abortCompilation) {
            abortCompilation.updateContext(this, scope.referenceCompilationUnit().compilationResult);
            throw abortCompilation;
        }
    }

    public TypeBinding getTypeBinding(Scope scope) {
        if (this.resolvedType != null) {
            return this.resolvedType;
        }
        Binding binding = scope.getPackage(this.tokens);
        if (binding != null && !binding.isValidBinding()) {
            return (ReferenceBinding)binding;
        }
        PackageBinding packageBinding = binding == null ? null : (PackageBinding)binding;
        boolean bl2 = scope.kind == 3;
        TypeBinding typeBinding = null;
        int n2 = packageBinding == null ? 0 : packageBinding.compoundName.length;
        int n3 = this.tokens.length;
        while (n2 < n3) {
            boolean bl3;
            this.findNextTypeBinding(n2, scope, packageBinding);
            if (!this.resolvedType.isValidBinding()) {
                return this.resolvedType;
            }
            if (bl2 && ((ClassScope)scope).detectHierarchyCycle(this.resolvedType, this, null)) {
                return null;
            }
            ReferenceBinding referenceBinding = (ReferenceBinding)this.resolvedType;
            typeBinding = typeBinding != null ? (referenceBinding.isGenericType() ? scope.environment().createRawType(referenceBinding, (ReferenceBinding)typeBinding) : ((bl3 = typeBinding.isRawType()) && !referenceBinding.isStatic() ? scope.environment().createRawType((ReferenceBinding)referenceBinding.erasure(), (ReferenceBinding)typeBinding) : (bl3 || typeBinding.isParameterizedType() ? scope.environment().createParameterizedType((ReferenceBinding)referenceBinding.erasure(), null, (ReferenceBinding)typeBinding) : referenceBinding))) : (referenceBinding.isGenericType() ? (ReferenceBinding)scope.environment().convertToRawType(referenceBinding) : referenceBinding);
            ++n2;
        }
        this.resolvedType = typeBinding;
        return this.resolvedType;
    }

    public char[][] getTypeName() {
        return this.tokens;
    }

    public StringBuffer printExpression(int n2, StringBuffer stringBuffer) {
        int n3 = 0;
        while (n3 < this.tokens.length) {
            if (n3 > 0) {
                stringBuffer.append('.');
            }
            stringBuffer.append(this.tokens[n3]);
            ++n3;
        }
        return stringBuffer;
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        aSTVisitor.visit(this, blockScope);
        aSTVisitor.endVisit(this, blockScope);
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        aSTVisitor.visit(this, classScope);
        aSTVisitor.endVisit(this, classScope);
    }
}

