/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.SubRoutineStatement;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.codegen.Label;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InsideSubRoutineFlowContext;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.LocalVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public class SynchronizedStatement
extends SubRoutineStatement {
    public Expression expression;
    public Block block;
    public BlockScope scope;
    public boolean c;
    public LocalVariableBinding synchroVariable;
    public static final char[] a = " syncValue".toCharArray();

    public SynchronizedStatement(Expression expression, Block block, int n2, int n3) {
        this.expression = expression;
        this.block = block;
        this.sourceEnd = n3;
        this.sourceStart = n2;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        this.synchroVariable.useFlag = 1;
        this.c = !(flowInfo = this.block.analyseCode(this.scope, new InsideSubRoutineFlowContext(flowContext, this), this.expression.analyseCode(this.scope, flowContext, flowInfo))).isReachable();
        return flowInfo;
    }

    public boolean isSubRoutineEscaping() {
        return false;
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.b > 0) {
            this.d = NO_EXCEPTION_HANDLER;
            this.b = 0;
        }
        int n2 = codeStream.position;
        this.expression.generateCode(this.scope, codeStream, true);
        if (this.block.isEmptyBlock()) {
            if (this.synchroVariable.type == LongBinding || this.synchroVariable.type == DoubleBinding) {
                codeStream.dup2();
            } else {
                codeStream.dup();
            }
            codeStream.monitorenter();
            codeStream.monitorexit();
        } else {
            codeStream.store(this.synchroVariable, true);
            codeStream.monitorenter();
            this.enterAnyExceptionHandler(codeStream);
            this.block.generateCode(this.scope, codeStream);
            Label label = new Label(codeStream);
            if (!this.c) {
                codeStream.load(this.synchroVariable);
                codeStream.monitorexit();
                this.exitAnyExceptionHandler();
                codeStream.goto_(label);
                this.enterAnyExceptionHandler(codeStream);
            }
            this.placeAllAnyExceptionHandlers();
            codeStream.incrStackSize(1);
            codeStream.load(this.synchroVariable);
            codeStream.monitorexit();
            this.exitAnyExceptionHandler();
            codeStream.athrow();
            if (!this.c) {
                label.place();
            }
        }
        if (this.scope != blockScope) {
            codeStream.exitUserScope(this.scope);
        }
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void generateSubRoutineInvocation(BlockScope blockScope, CodeStream codeStream) {
        codeStream.load(this.synchroVariable);
        codeStream.monitorexit();
    }

    public void resolve(BlockScope blockScope) {
        this.scope = new BlockScope(blockScope);
        TypeBinding typeBinding = this.expression.resolveType(this.scope);
        if (typeBinding == null) {
            return;
        }
        switch (typeBinding.id) {
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                this.scope.problemReporter().invalidTypeToSynchronize(this.expression, typeBinding);
                break;
            }
            case 6: {
                this.scope.problemReporter().illegalVoidExpression(this.expression);
                break;
            }
            case 12: {
                this.scope.problemReporter().invalidNullToSynchronize(this.expression);
            }
        }
        this.synchroVariable = new LocalVariableBinding(a, typeBinding, 0, false);
        this.scope.addLocalVariable(this.synchroVariable);
        this.synchroVariable.setConstant(NotAConstant);
        this.expression.computeConversion(this.scope, typeBinding, typeBinding);
        this.block.resolveUsing(this.scope);
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        SynchronizedStatement.printIndent(n2, stringBuffer);
        stringBuffer.append("synchronized (");
        this.expression.printExpression(0, stringBuffer).append(')');
        stringBuffer.append('\n');
        return this.block.printStatement(n2 + 1, stringBuffer);
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (aSTVisitor.visit(this, blockScope)) {
            this.expression.traverse(aSTVisitor, this.scope);
            this.block.traverse(aSTVisitor, this.scope);
        }
        aSTVisitor.endVisit(this, blockScope);
    }
}

