/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.ast;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.ASTVisitor;
import org.eclipse.jdt.internal.compiler.ClassFile;
import org.eclipse.jdt.internal.compiler.CompilationResult;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Annotation;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Clinit;
import org.eclipse.jdt.internal.compiler.ast.CompilationUnitDeclaration;
import org.eclipse.jdt.internal.compiler.ast.ConstructorDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Expression;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.Javadoc;
import org.eclipse.jdt.internal.compiler.ast.MethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.QualifiedAllocationExpression;
import org.eclipse.jdt.internal.compiler.ast.SingleNameReference;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.SuperReference;
import org.eclipse.jdt.internal.compiler.ast.TypeParameter;
import org.eclipse.jdt.internal.compiler.ast.TypeReference;
import org.eclipse.jdt.internal.compiler.codegen.CodeStream;
import org.eclipse.jdt.internal.compiler.flow.FlowContext;
import org.eclipse.jdt.internal.compiler.flow.FlowInfo;
import org.eclipse.jdt.internal.compiler.flow.InitializationFlowContext;
import org.eclipse.jdt.internal.compiler.flow.UnconditionalFlowInfo;
import org.eclipse.jdt.internal.compiler.impl.ReferenceContext;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.BlockScope;
import org.eclipse.jdt.internal.compiler.lookup.ClassScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LocalTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MemberTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.NestedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.SyntheticArgumentBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.parser.Parser;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilationUnit;
import org.eclipse.jdt.internal.compiler.problem.AbortMethod;
import org.eclipse.jdt.internal.compiler.problem.AbortType;
import org.eclipse.jdt.internal.compiler.problem.ProblemSeverities;

public class TypeDeclaration
extends Statement
implements ProblemSeverities,
ReferenceContext {
    public static final char[] ANONYMOUS_EMPTY_NAME = new char[0];
    public int modifiers = 0;
    public int modifiersSourceStart;
    public Annotation[] annotations;
    public char[] name;
    public TypeReference superclass;
    public TypeReference[] superInterfaces;
    public FieldDeclaration[] fields;
    public AbstractMethodDeclaration[] methods;
    public TypeDeclaration[] memberTypes;
    public SourceTypeBinding binding;
    public ClassScope scope;
    public MethodScope initializerScope;
    public MethodScope staticInitializerScope;
    public boolean ignoreFurtherInvestigation = false;
    public int maxFieldCount;
    public int declarationSourceStart;
    public int declarationSourceEnd;
    public int bodyStart;
    public int bodyEnd;
    public boolean hasBeenGenerated = false;
    public CompilationResult compilationResult;
    public MethodDeclaration[] missingAbstractMethods;
    public Javadoc javadoc;
    public QualifiedAllocationExpression allocation;
    public TypeDeclaration enclosingType;
    public FieldBinding enumValuesSyntheticfield;
    public TypeParameter[] typeParameters;

    public TypeDeclaration(CompilationResult compilationResult) {
        this.compilationResult = compilationResult;
    }

    public void abort(int n2, IProblem iProblem) {
        switch (n2) {
            case 2: {
                throw new AbortCompilation(this.compilationResult, iProblem);
            }
            case 4: {
                throw new AbortCompilationUnit(this.compilationResult, iProblem);
            }
            case 16: {
                throw new AbortMethod(this.compilationResult, iProblem);
            }
        }
        throw new AbortType(this.compilationResult, iProblem);
    }

    public final void addClinit() {
        if (this.needClassInitMethod()) {
            AbstractMethodDeclaration[] abstractMethodDeclarationArray = this.methods;
            if (this.methods == null) {
                boolean bl2 = false;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[1];
            } else {
                int n2 = abstractMethodDeclarationArray.length;
                AbstractMethodDeclaration[] abstractMethodDeclarationArray2 = abstractMethodDeclarationArray;
                abstractMethodDeclarationArray = new AbstractMethodDeclaration[n2 + 1];
                System.arraycopy(abstractMethodDeclarationArray2, 0, abstractMethodDeclarationArray, 1, n2);
            }
            Clinit clinit = new Clinit(this.compilationResult);
            abstractMethodDeclarationArray[0] = clinit;
            clinit.declarationSourceStart = clinit.sourceStart = this.sourceStart;
            clinit.declarationSourceEnd = clinit.sourceEnd = this.sourceEnd;
            clinit.bodyEnd = this.sourceEnd;
            this.methods = abstractMethodDeclarationArray;
        }
    }

    public MethodDeclaration addMissingAbstractMethodFor(MethodBinding methodBinding) {
        MethodDeclaration[] methodDeclarationArray;
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n2 = typeBindingArray.length;
        MethodDeclaration methodDeclaration = new MethodDeclaration(this.compilationResult);
        methodDeclaration.selector = methodBinding.selector;
        methodDeclaration.sourceStart = this.sourceStart;
        methodDeclaration.sourceEnd = this.sourceEnd;
        methodDeclaration.modifiers = methodBinding.getAccessFlags() & 0xFFFFFBFF;
        if (n2 > 0) {
            methodDeclarationArray = "arg";
            methodDeclaration.arguments = new Argument[n2];
            Argument[] argumentArray = methodDeclaration.arguments;
            int n3 = n2;
            while (--n3 >= 0) {
                argumentArray[n3] = new Argument((String.valueOf(methodDeclarationArray) + n3).toCharArray(), 0L, null, 0);
            }
        }
        if (this.missingAbstractMethods == null) {
            this.missingAbstractMethods = new MethodDeclaration[]{methodDeclaration};
        } else {
            methodDeclarationArray = new MethodDeclaration[this.missingAbstractMethods.length + 1];
            System.arraycopy(this.missingAbstractMethods, 0, methodDeclarationArray, 1, this.missingAbstractMethods.length);
            methodDeclarationArray[0] = methodDeclaration;
            this.missingAbstractMethods = methodDeclarationArray;
        }
        methodDeclaration.binding = new MethodBinding(methodDeclaration.modifiers, methodBinding.selector, methodBinding.returnType, n2 == 0 ? NoParameters : typeBindingArray, methodBinding.thrownExceptions, this.binding);
        methodDeclaration.scope = new MethodScope(this.scope, methodDeclaration, true);
        methodDeclaration.bindArguments();
        return methodDeclaration;
    }

    public FlowInfo analyseCode(BlockScope blockScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return flowInfo;
        }
        try {
            if (flowInfo.isReachable()) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(blockScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(blockScope, flowInfo);
            this.a();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
        return flowInfo;
    }

    public void analyseCode(ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.a();
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(ClassScope classScope, FlowContext flowContext, FlowInfo flowInfo) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (flowInfo.isReachable()) {
                this.bits |= Integer.MIN_VALUE;
                LocalTypeBinding localTypeBinding = (LocalTypeBinding)this.binding;
                localTypeBinding.setConstantPoolName(classScope.compilationUnitScope().computeConstantPoolName(localTypeBinding));
            }
            this.manageEnclosingInstanceAccessIfNecessary(classScope, flowInfo);
            this.a();
            this.internalAnalyseCode(flowContext, flowInfo);
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public void analyseCode(CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            this.internalAnalyseCode(null, FlowInfo.initial(this.maxFieldCount));
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
        }
    }

    public boolean checkConstructors(Parser parser) {
        boolean bl2 = false;
        if (this.methods != null) {
            int n2 = this.methods.length;
            while (--n2 >= 0) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n2];
                if (!abstractMethodDeclaration.isConstructor()) continue;
                if (!CharOperation.equals(abstractMethodDeclaration.selector, this.name)) {
                    ConstructorDeclaration constructorDeclaration = (ConstructorDeclaration)abstractMethodDeclaration;
                    if (constructorDeclaration.constructorCall != null && !constructorDeclaration.constructorCall.isImplicitSuper()) continue;
                    MethodDeclaration methodDeclaration = parser.convertToMethodDeclaration(constructorDeclaration, this.compilationResult);
                    this.methods[n2] = methodDeclaration;
                    continue;
                }
                switch (this.kind()) {
                    case 2: {
                        parser.problemReporter().interfaceCannotHaveConstructors((ConstructorDeclaration)abstractMethodDeclaration);
                        break;
                    }
                    case 4: {
                        parser.problemReporter().annotationTypeDeclarationCannotHaveConstructor((ConstructorDeclaration)abstractMethodDeclaration);
                    }
                }
                bl2 = true;
            }
        }
        return bl2;
    }

    public CompilationResult compilationResult() {
        return this.compilationResult;
    }

    public ConstructorDeclaration createDefaultConstructor(boolean bl2, boolean bl3) {
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.isDefaultConstructor = true;
        constructorDeclaration.selector = this.name;
        if (this.modifiers != 0) {
            constructorDeclaration.modifiers = (this.bits & 0x400) != 0 && (this.modifiers & 2) != 0 ? 0 : this.modifiers & 7;
        }
        constructorDeclaration.declarationSourceStart = constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = constructorDeclaration.bodyEnd = this.sourceEnd;
        constructorDeclaration.declarationSourceEnd = constructorDeclaration.bodyEnd;
        if (bl2) {
            constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
            constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
            constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        }
        if (bl3) {
            if (this.methods == null) {
                this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
            } else {
                AbstractMethodDeclaration[] abstractMethodDeclarationArray = new AbstractMethodDeclaration[this.methods.length + 1];
                System.arraycopy(this.methods, 0, abstractMethodDeclarationArray, 1, this.methods.length);
                abstractMethodDeclarationArray[0] = constructorDeclaration;
                this.methods = abstractMethodDeclarationArray;
            }
        }
        return constructorDeclaration;
    }

    public MethodBinding createDefaultConstructorWithBinding(MethodBinding methodBinding) {
        int n2;
        CompilerModifiers[] compilerModifiersArray;
        String string = "$anonymous";
        TypeBinding[] typeBindingArray = methodBinding.parameters;
        int n3 = typeBindingArray.length;
        ConstructorDeclaration constructorDeclaration = new ConstructorDeclaration(this.compilationResult);
        constructorDeclaration.selector = new char[]{'x'};
        constructorDeclaration.sourceStart = this.sourceStart;
        constructorDeclaration.sourceEnd = this.sourceEnd;
        int n4 = this.modifiers & 7;
        if (methodBinding.isVarargs()) {
            n4 |= 0x80;
        }
        constructorDeclaration.modifiers = n4;
        constructorDeclaration.isDefaultConstructor = true;
        if (n3 > 0) {
            constructorDeclaration.arguments = new Argument[n3];
            compilerModifiersArray = constructorDeclaration.arguments;
            n2 = n3;
            while (--n2 >= 0) {
                compilerModifiersArray[n2] = new Argument((String.valueOf(string) + n2).toCharArray(), 0L, null, 0);
            }
        }
        constructorDeclaration.constructorCall = SuperReference.implicitSuperConstructorCall();
        constructorDeclaration.constructorCall.sourceStart = this.sourceStart;
        constructorDeclaration.constructorCall.sourceEnd = this.sourceEnd;
        if (n3 > 0) {
            constructorDeclaration.constructorCall.arguments = new Expression[n3];
            compilerModifiersArray = constructorDeclaration.constructorCall.arguments;
            n2 = n3;
            while (--n2 >= 0) {
                compilerModifiersArray[n2] = new SingleNameReference((String.valueOf(string) + n2).toCharArray(), 0L);
            }
        }
        if (this.methods == null) {
            this.methods = new AbstractMethodDeclaration[]{constructorDeclaration};
        } else {
            compilerModifiersArray = new AbstractMethodDeclaration[this.methods.length + 1];
            System.arraycopy(this.methods, 0, compilerModifiersArray, 1, this.methods.length);
            compilerModifiersArray[0] = constructorDeclaration;
            this.methods = compilerModifiersArray;
        }
        constructorDeclaration.binding = new MethodBinding(constructorDeclaration.modifiers, n3 == 0 ? NoParameters : typeBindingArray, methodBinding.thrownExceptions, this.binding);
        constructorDeclaration.scope = new MethodScope(this.scope, constructorDeclaration, true);
        constructorDeclaration.bindArguments();
        constructorDeclaration.constructorCall.resolve(constructorDeclaration.scope);
        if (this.binding.methods == null) {
            this.binding.methods = new MethodBinding[]{constructorDeclaration.binding};
        } else {
            compilerModifiersArray = new MethodBinding[this.binding.methods.length + 1];
            System.arraycopy(this.binding.methods, 0, compilerModifiersArray, 1, this.binding.methods.length);
            compilerModifiersArray[0] = constructorDeclaration.binding;
            this.binding.methods = compilerModifiersArray;
        }
        return constructorDeclaration.binding;
    }

    public FieldDeclaration declarationOf(FieldBinding fieldBinding) {
        if (fieldBinding != null && this.fields != null) {
            int n2 = 0;
            int n3 = this.fields.length;
            while (n2 < n3) {
                FieldDeclaration fieldDeclaration = this.fields[n2];
                if (fieldDeclaration.binding == fieldBinding) {
                    return fieldDeclaration;
                }
                ++n2;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOf(MemberTypeBinding memberTypeBinding) {
        if (memberTypeBinding != null && this.memberTypes != null) {
            int n2 = 0;
            int n3 = this.memberTypes.length;
            while (n2 < n3) {
                TypeDeclaration typeDeclaration = this.memberTypes[n2];
                if (typeDeclaration.binding == memberTypeBinding) {
                    return typeDeclaration;
                }
                ++n2;
            }
        }
        return null;
    }

    public AbstractMethodDeclaration declarationOf(MethodBinding methodBinding) {
        if (methodBinding != null && this.methods != null) {
            int n2 = 0;
            int n3 = this.methods.length;
            while (n2 < n3) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n2];
                if (abstractMethodDeclaration.binding == methodBinding) {
                    return abstractMethodDeclaration;
                }
                ++n2;
            }
        }
        return null;
    }

    public TypeDeclaration declarationOfType(char[][] cArray) {
        int n2 = cArray.length;
        if (n2 < 1 || !CharOperation.equals(cArray[0], this.name)) {
            return null;
        }
        if (n2 == 1) {
            return this;
        }
        char[][] cArray2 = new char[n2 - 1][];
        System.arraycopy(cArray, 1, cArray2, 0, n2 - 1);
        int n3 = 0;
        while (n3 < this.memberTypes.length) {
            TypeDeclaration typeDeclaration = this.memberTypes[n3].declarationOfType(cArray2);
            if (typeDeclaration != null) {
                return typeDeclaration;
            }
            ++n3;
        }
        return null;
    }

    public void generateCode(ClassFile classFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        this.hasBeenGenerated = true;
        if (this.ignoreFurtherInvestigation) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
            return;
        }
        try {
            int n2;
            int n3;
            ClassFile classFile2 = new ClassFile(this.binding, classFile, false);
            classFile2.addFieldInfos();
            if (this.binding.isMemberType()) {
                classFile2.recordEnclosingTypeAttributes(this.binding);
            }
            if (this.binding.isLocalType()) {
                classFile.recordNestedLocalAttribute(this.binding);
                classFile2.recordNestedLocalAttribute(this.binding);
            }
            if (this.memberTypes != null) {
                n3 = 0;
                n2 = this.memberTypes.length;
                while (n3 < n2) {
                    classFile2.recordNestedMemberAttribute(this.memberTypes[n3].binding);
                    this.memberTypes[n3].generateCode(this.scope, classFile2);
                    ++n3;
                }
            }
            classFile2.setForMethodInfos();
            if (this.methods != null) {
                n3 = 0;
                n2 = this.methods.length;
                while (n3 < n2) {
                    this.methods[n3].generateCode(this.scope, classFile2);
                    ++n3;
                }
            }
            classFile2.addSpecialMethods();
            if (this.ignoreFurtherInvestigation) {
                throw new AbortType(this.scope.referenceCompilationUnit().compilationResult, null);
            }
            classFile2.addAttributes();
            this.scope.referenceCompilationUnit().compilationResult.record(this.binding.constantPoolName(), classFile2);
        }
        catch (AbortType abortType) {
            if (this.binding == null) {
                return;
            }
            ClassFile.createProblemType(this, this.scope.referenceCompilationUnit().compilationResult);
        }
    }

    public void generateCode(BlockScope blockScope, CodeStream codeStream) {
        if ((this.bits & Integer.MIN_VALUE) == 0) {
            return;
        }
        if (this.hasBeenGenerated) {
            return;
        }
        int n2 = codeStream.position;
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(codeStream.classFile);
        codeStream.recordPositionsFrom(n2, this.sourceStart);
    }

    public void generateCode(ClassScope classScope, ClassFile classFile) {
        if (this.hasBeenGenerated) {
            return;
        }
        if (this.binding != null) {
            ((NestedTypeBinding)this.binding).computeSyntheticArgumentSlotSizes();
        }
        this.generateCode(classFile);
    }

    public void generateCode(CompilationUnitScope compilationUnitScope) {
        this.generateCode((ClassFile)null);
    }

    public boolean hasErrors() {
        return this.ignoreFurtherInvestigation;
    }

    public void internalAnalyseCode(FlowContext flowContext, FlowInfo flowInfo) {
        int n2;
        int n3;
        if (this.binding.isPrivate() && !this.binding.isUsed() && !this.scope.referenceCompilationUnit().compilationResult.hasSyntaxError) {
            this.scope.problemReporter().unusedPrivateType(this);
        }
        InitializationFlowContext initializationFlowContext = new InitializationFlowContext(null, this, this.initializerScope);
        InitializationFlowContext initializationFlowContext2 = new InitializationFlowContext(null, this, this.staticInitializerScope);
        FlowInfo flowInfo2 = flowInfo.copy().unconditionalInits().discardFieldInitializations();
        FlowInfo flowInfo3 = flowInfo.copy().unconditionalInits().discardFieldInitializations();
        if (this.fields != null) {
            n3 = 0;
            n2 = this.fields.length;
            while (n3 < n2) {
                FieldDeclaration fieldDeclaration = this.fields[n3];
                if (fieldDeclaration.isStatic()) {
                    if (!flowInfo3.isReachable()) {
                        fieldDeclaration.bits &= Integer.MAX_VALUE;
                    }
                    initializationFlowContext2.handledExceptions = AnyException;
                    if ((flowInfo3 = fieldDeclaration.analyseCode(this.staticInitializerScope, (FlowContext)initializationFlowContext2, flowInfo3)) == FlowInfo.DEAD_END) {
                        this.staticInitializerScope.problemReporter().initializerMustCompleteNormally(fieldDeclaration);
                        flowInfo3 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                } else {
                    if (!((FlowInfo)flowInfo2).isReachable()) {
                        fieldDeclaration.bits &= Integer.MAX_VALUE;
                    }
                    initializationFlowContext.handledExceptions = AnyException;
                    if ((flowInfo2 = fieldDeclaration.analyseCode(this.initializerScope, (FlowContext)initializationFlowContext, flowInfo2)) == FlowInfo.DEAD_END) {
                        this.initializerScope.problemReporter().initializerMustCompleteNormally(fieldDeclaration);
                        flowInfo2 = FlowInfo.initial(this.maxFieldCount).setReachMode(1);
                    }
                }
                ++n3;
            }
        }
        if (this.memberTypes != null) {
            n3 = 0;
            n2 = this.memberTypes.length;
            while (n3 < n2) {
                if (flowContext != null) {
                    this.memberTypes[n3].analyseCode(this.scope, flowContext, ((FlowInfo)flowInfo2).copy().setReachMode(flowInfo.reachMode()));
                } else {
                    this.memberTypes[n3].analyseCode(this.scope);
                }
                ++n3;
            }
        }
        if (this.methods != null) {
            UnconditionalFlowInfo unconditionalFlowInfo = flowInfo.copy().unconditionalInits().discardFieldInitializations();
            FlowInfo flowInfo4 = ((FlowInfo)flowInfo2).unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo);
            int n4 = 0;
            int n5 = this.methods.length;
            while (n4 < n5) {
                AbstractMethodDeclaration abstractMethodDeclaration = this.methods[n4];
                if (!abstractMethodDeclaration.ignoreFurtherInvestigation) {
                    if (abstractMethodDeclaration.isInitializationMethod()) {
                        if (abstractMethodDeclaration.isStatic()) {
                            abstractMethodDeclaration.analyseCode(this.scope, initializationFlowContext2, flowInfo3.unconditionalInits().discardNonFieldInitializations().addInitializationsFrom(unconditionalFlowInfo).setReachMode(flowInfo.reachMode()));
                        } else {
                            abstractMethodDeclaration.analyseCode(this.scope, initializationFlowContext, flowInfo4.copy().setReachMode(flowInfo.reachMode()));
                        }
                    } else {
                        abstractMethodDeclaration.analyseCode(this.scope, null, flowInfo.copy());
                    }
                }
                ++n4;
            }
        }
        if (this.binding.isEnum()) {
            this.enumValuesSyntheticfield = this.binding.addSyntheticFieldForEnumValues();
        }
    }

    public int kind() {
        switch (this.modifiers & 0x6200) {
            case 512: {
                return 2;
            }
            case 8704: {
                return 4;
            }
            case 16384: {
                return 3;
            }
        }
        return 1;
    }

    public void manageEnclosingInstanceAccessIfNecessary(BlockScope blockScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
        MethodScope methodScope = blockScope.methodScope();
        if (!methodScope.isStatic && !methodScope.isConstructorCall) {
            nestedTypeBinding.addSyntheticArgumentAndField(nestedTypeBinding.enclosingType());
        }
        if (nestedTypeBinding.isAnonymousType()) {
            NestedTypeBinding nestedTypeBinding2;
            SyntheticArgumentBinding syntheticArgumentBinding;
            ReferenceBinding referenceBinding;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)nestedTypeBinding.superclass.erasure();
            if (!(referenceBinding2.enclosingType() == null || referenceBinding2.isStatic() || referenceBinding2.isLocalType() && ((NestedTypeBinding)referenceBinding2).getSyntheticField(referenceBinding2.enclosingType(), true) == null)) {
                nestedTypeBinding.addSyntheticArgument(referenceBinding2.enclosingType());
            }
            if (!methodScope.isStatic && methodScope.isConstructorCall && blockScope.compilerOptions().complianceLevel >= 0x310000L && (referenceBinding = nestedTypeBinding.enclosingType()).isNestedType() && (syntheticArgumentBinding = (nestedTypeBinding2 = (NestedTypeBinding)referenceBinding).getSyntheticArgument(nestedTypeBinding2.enclosingType(), true)) != null) {
                nestedTypeBinding.addSyntheticArgumentAndField(syntheticArgumentBinding);
            }
        }
    }

    public void manageEnclosingInstanceAccessIfNecessary(ClassScope classScope, FlowInfo flowInfo) {
        if (!flowInfo.isReachable()) {
            return;
        }
        NestedTypeBinding nestedTypeBinding = (NestedTypeBinding)this.binding;
        nestedTypeBinding.addSyntheticArgumentAndField(this.binding.enclosingType());
    }

    public final boolean needClassInitMethod() {
        if ((this.bits & 1) != 0) {
            return true;
        }
        if (this.fields == null) {
            return false;
        }
        switch (this.kind()) {
            case 2: 
            case 4: {
                return true;
            }
        }
        int n2 = this.fields.length;
        while (--n2 >= 0) {
            FieldDeclaration fieldDeclaration = this.fields[n2];
            if ((fieldDeclaration.modifiers & 8) != 0) {
                return true;
            }
            if (fieldDeclaration.getKind() != 3) continue;
            return true;
        }
        return false;
    }

    public void parseMethod(Parser parser, CompilationUnitDeclaration compilationUnitDeclaration) {
        int n2;
        int n3;
        if (compilationUnitDeclaration.ignoreMethodBodies) {
            return;
        }
        if (this.memberTypes != null) {
            n3 = this.memberTypes.length;
            n2 = 0;
            while (n2 < n3) {
                this.memberTypes[n2].parseMethod(parser, compilationUnitDeclaration);
                ++n2;
            }
        }
        if (this.methods != null) {
            n3 = this.methods.length;
            n2 = 0;
            while (n2 < n3) {
                this.methods[n2].parseStatements(parser, compilationUnitDeclaration);
                ++n2;
            }
        }
        if (this.fields != null) {
            n3 = this.fields.length;
            n2 = 0;
            while (n2 < n3) {
                FieldDeclaration fieldDeclaration = this.fields[n2];
                switch (fieldDeclaration.getKind()) {
                    case 2: {
                        ((Initializer)fieldDeclaration).parseStatements(parser, this, compilationUnitDeclaration);
                    }
                }
                ++n2;
            }
        }
    }

    public StringBuffer print(int n2, StringBuffer stringBuffer) {
        if (this.javadoc != null) {
            this.javadoc.print(n2, stringBuffer);
        }
        if ((this.bits & 0x200) == 0) {
            TypeDeclaration.printIndent(n2, stringBuffer);
            this.printHeader(0, stringBuffer);
        }
        return this.printBody(n2, stringBuffer);
    }

    public StringBuffer printBody(int n2, StringBuffer stringBuffer) {
        int n3;
        stringBuffer.append(" {");
        if (this.memberTypes != null) {
            n3 = 0;
            while (n3 < this.memberTypes.length) {
                if (this.memberTypes[n3] != null) {
                    stringBuffer.append('\n');
                    this.memberTypes[n3].print(n2 + 1, stringBuffer);
                }
                ++n3;
            }
        }
        if (this.fields != null) {
            n3 = 0;
            while (n3 < this.fields.length) {
                if (this.fields[n3] != null) {
                    stringBuffer.append('\n');
                    this.fields[n3].print(n2 + 1, stringBuffer);
                }
                ++n3;
            }
        }
        if (this.methods != null) {
            n3 = 0;
            while (n3 < this.methods.length) {
                if (this.methods[n3] != null) {
                    stringBuffer.append('\n');
                    this.methods[n3].print(n2 + 1, stringBuffer);
                }
                ++n3;
            }
        }
        stringBuffer.append('\n');
        return TypeDeclaration.printIndent(n2, stringBuffer).append('}');
    }

    public StringBuffer printHeader(int n2, StringBuffer stringBuffer) {
        int n3;
        TypeDeclaration.printModifiers(this.modifiers, stringBuffer);
        if (this.annotations != null) {
            TypeDeclaration.printAnnotations(this.annotations, stringBuffer);
        }
        switch (this.kind()) {
            case 1: {
                stringBuffer.append("class ");
                break;
            }
            case 2: {
                stringBuffer.append("interface ");
                break;
            }
            case 3: {
                stringBuffer.append("enum ");
                break;
            }
            case 4: {
                stringBuffer.append("@interface ");
            }
        }
        stringBuffer.append(this.name);
        if (this.typeParameters != null) {
            stringBuffer.append("<");
            n3 = 0;
            while (n3 < this.typeParameters.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.typeParameters[n3].print(0, stringBuffer);
                ++n3;
            }
            stringBuffer.append(">");
        }
        if (this.superclass != null) {
            stringBuffer.append(" extends ");
            this.superclass.print(0, stringBuffer);
        }
        if (this.superInterfaces != null && this.superInterfaces.length > 0) {
            switch (this.kind()) {
                case 1: 
                case 3: {
                    stringBuffer.append(" implements ");
                    break;
                }
                case 2: 
                case 4: {
                    stringBuffer.append(" extends ");
                }
            }
            n3 = 0;
            while (n3 < this.superInterfaces.length) {
                if (n3 > 0) {
                    stringBuffer.append(", ");
                }
                this.superInterfaces[n3].print(0, stringBuffer);
                ++n3;
            }
        }
        return stringBuffer;
    }

    public StringBuffer printStatement(int n2, StringBuffer stringBuffer) {
        return this.print(n2, stringBuffer);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void resolve() {
        SourceTypeBinding sourceTypeBinding = this.binding;
        if (sourceTypeBinding == null) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
        try {
            ASTNode aSTNode;
            int n2;
            int n3;
            boolean bl2;
            block34: {
                boolean bl3 = this.staticInitializerScope.insideTypeAnnotation;
                try {
                    this.staticInitializerScope.insideTypeAnnotation = true;
                    TypeDeclaration.resolveAnnotations(this.staticInitializerScope, this.annotations, sourceTypeBinding);
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    this.staticInitializerScope.insideTypeAnnotation = bl3;
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                    this.staticInitializerScope.insideTypeAnnotation = bl3;
                    if ((this.bits & 8) == 0) break block34;
                    this.scope.problemReporter().undocumentedEmptyBlock(this.bodyStart - 1, this.bodyEnd);
                }
            }
            boolean bl4 = bl2 = this.scope.compilerOptions().getSeverity(0x100000000L) != -1 && sourceTypeBinding.isClass() && !sourceTypeBinding.isAbstract() && sourceTypeBinding.findSuperTypeErasingTo(37, false) != null;
            if (this.typeParameters != null && this.scope.getJavaLangThrowable().isSuperclassOf(sourceTypeBinding)) {
                this.scope.problemReporter().genericTypeCannotExtendThrowable(this);
            }
            this.maxFieldCount = 0;
            int n4 = -1;
            boolean bl5 = false;
            boolean bl6 = false;
            if (this.typeParameters != null) {
                n3 = 0;
                n2 = this.typeParameters.length;
                while (n3 < n2) {
                    this.typeParameters[n3].resolve(this.scope);
                    ++n3;
                }
            }
            if (this.memberTypes != null) {
                n3 = 0;
                n2 = this.memberTypes.length;
                while (n3 < n2) {
                    this.memberTypes[n3].resolve(this.scope);
                    ++n3;
                }
            }
            if (this.fields != null) {
                n3 = 0;
                n2 = this.fields.length;
                while (n3 < n2) {
                    block35: {
                        aSTNode = this.fields[n3];
                        switch (((FieldDeclaration)aSTNode).getKind()) {
                            case 3: {
                                bl5 = true;
                                if (!(((FieldDeclaration)aSTNode).initialization instanceof QualifiedAllocationExpression)) {
                                    bl6 = true;
                                }
                            }
                            case 1: {
                                FieldBinding fieldBinding = ((FieldDeclaration)aSTNode).binding;
                                if (fieldBinding == null) {
                                    if (((FieldDeclaration)aSTNode).initialization != null) {
                                        ((FieldDeclaration)aSTNode).initialization.resolve(((FieldDeclaration)aSTNode).isStatic() ? this.staticInitializerScope : this.initializerScope);
                                    }
                                    this.ignoreFurtherInvestigation = true;
                                    break block35;
                                } else {
                                    if (bl2 && (fieldBinding.modifiers & 0x18) == 24 && CharOperation.equals(TypeConstants.SERIALVERSIONUID, fieldBinding.name) && BaseTypes.LongBinding == fieldBinding.type) {
                                        bl2 = false;
                                    }
                                    ++this.maxFieldCount;
                                    n4 = ((FieldDeclaration)aSTNode).binding.id;
                                    break;
                                }
                            }
                            case 2: {
                                ((Initializer)aSTNode).lastVisibleFieldID = n4 + 1;
                            }
                        }
                        ((FieldDeclaration)aSTNode).resolve(((FieldDeclaration)aSTNode).isStatic() ? this.staticInitializerScope : this.initializerScope);
                    }
                    ++n3;
                }
            }
            if (bl2) {
                this.scope.problemReporter().missingSerialVersion(this);
            }
            if (this.kind() == 4) {
                if (this.superclass != null) {
                    this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperclass(this);
                }
                if (this.superInterfaces != null) {
                    this.scope.problemReporter().annotationTypeDeclarationCannotHaveSuperinterfaces(this);
                }
            }
            if (this.kind() == 3 && this.binding.isAbstract() && (!bl5 || bl6)) {
                n3 = 0;
                n2 = this.methods.length;
                while (n3 < n2) {
                    aSTNode = this.methods[n3];
                    if (((AbstractMethodDeclaration)aSTNode).isAbstract() && ((AbstractMethodDeclaration)aSTNode).binding != null) {
                        this.scope.problemReporter().enumAbstractMethodMustBeImplemented((AbstractMethodDeclaration)aSTNode);
                    }
                    ++n3;
                }
            }
            n3 = this.missingAbstractMethods == null ? 0 : this.missingAbstractMethods.length;
            int n5 = n2 = this.methods == null ? 0 : this.methods.length;
            if (n2 + n3 > 65535) {
                this.scope.problemReporter().tooManyMethods(this);
            }
            if (this.methods != null) {
                int n6 = 0;
                int n7 = this.methods.length;
                while (n6 < n7) {
                    this.methods[n6].resolve(this.scope);
                    ++n6;
                }
            }
            if (this.javadoc != null) {
                if (this.scope == null) return;
                this.javadoc.resolve(this.scope);
                return;
            }
            if (sourceTypeBinding == null) return;
            if (sourceTypeBinding.isLocalType()) return;
            this.scope.problemReporter().javadocMissing(this.sourceStart, this.sourceEnd, sourceTypeBinding.modifiers);
            return;
        }
        catch (AbortType abortType) {
            this.ignoreFurtherInvestigation = true;
            return;
        }
    }

    public void resolve(BlockScope blockScope) {
        if ((this.bits & 0x200) == 0) {
            blockScope.addLocalType(this);
        }
        if (this.binding != null) {
            blockScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
            this.resolve();
            this.a();
        }
    }

    public void resolve(ClassScope classScope) {
        if (this.binding != null && this.binding instanceof LocalTypeBinding) {
            classScope.referenceCompilationUnit().record((LocalTypeBinding)this.binding);
        }
        this.resolve();
        this.a();
    }

    public void resolve(CompilationUnitScope compilationUnitScope) {
        this.resolve();
        this.a();
    }

    public void tagAsHavingErrors() {
        this.ignoreFurtherInvestigation = true;
    }

    public void traverse(ASTVisitor aSTVisitor, CompilationUnitScope compilationUnitScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, compilationUnitScope)) {
                int n2;
                int n3;
                if (this.annotations != null) {
                    n3 = this.annotations.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.annotations[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n3 = this.superInterfaces.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.superInterfaces[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.typeParameters != null) {
                    n3 = this.typeParameters.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.typeParameters[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.memberTypes != null) {
                    n3 = this.memberTypes.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.memberTypes[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.fields != null) {
                    n3 = this.fields.length;
                    n2 = 0;
                    while (n2 < n3) {
                        FieldDeclaration fieldDeclaration = this.fields[n2];
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                        } else {
                            fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                        }
                        ++n2;
                    }
                }
                if (this.methods != null) {
                    n3 = this.methods.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.methods[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
            }
            aSTVisitor.endVisit(this, compilationUnitScope);
        }
        catch (AbortType abortType) {}
    }

    public void traverse(ASTVisitor aSTVisitor, BlockScope blockScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, blockScope)) {
                int n2;
                int n3;
                if (this.annotations != null) {
                    n3 = this.annotations.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.annotations[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n3 = this.superInterfaces.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.superInterfaces[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.typeParameters != null) {
                    n3 = this.typeParameters.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.typeParameters[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.memberTypes != null) {
                    n3 = this.memberTypes.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.memberTypes[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.fields != null) {
                    n3 = this.fields.length;
                    n2 = 0;
                    while (n2 < n3) {
                        FieldDeclaration fieldDeclaration = this.fields[n2];
                        if (!fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                        }
                        ++n2;
                    }
                }
                if (this.methods != null) {
                    n3 = this.methods.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.methods[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
            }
            aSTVisitor.endVisit(this, blockScope);
        }
        catch (AbortType abortType) {}
    }

    public void traverse(ASTVisitor aSTVisitor, ClassScope classScope) {
        if (this.ignoreFurtherInvestigation) {
            return;
        }
        try {
            if (aSTVisitor.visit(this, classScope)) {
                int n2;
                int n3;
                if (this.annotations != null) {
                    n3 = this.annotations.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.annotations[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.superclass != null) {
                    this.superclass.traverse(aSTVisitor, this.scope);
                }
                if (this.superInterfaces != null) {
                    n3 = this.superInterfaces.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.superInterfaces[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.typeParameters != null) {
                    n3 = this.typeParameters.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.typeParameters[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.memberTypes != null) {
                    n3 = this.memberTypes.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.memberTypes[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
                if (this.fields != null) {
                    n3 = this.fields.length;
                    n2 = 0;
                    while (n2 < n3) {
                        FieldDeclaration fieldDeclaration = this.fields[n2];
                        if (fieldDeclaration.isStatic()) {
                            fieldDeclaration.traverse(aSTVisitor, this.staticInitializerScope);
                        } else {
                            fieldDeclaration.traverse(aSTVisitor, this.initializerScope);
                        }
                        ++n2;
                    }
                }
                if (this.methods != null) {
                    n3 = this.methods.length;
                    n2 = 0;
                    while (n2 < n3) {
                        this.methods[n2].traverse(aSTVisitor, this.scope);
                        ++n2;
                    }
                }
            }
            aSTVisitor.endVisit(this, classScope);
        }
        catch (AbortType abortType) {}
    }

    public void a() {
        if (this.binding == null) {
            return;
        }
        TypeDeclaration typeDeclaration = this.scope.outerMostClassScope().referenceType();
        if (this.maxFieldCount > typeDeclaration.maxFieldCount) {
            typeDeclaration.maxFieldCount = this.maxFieldCount;
        } else {
            this.maxFieldCount = typeDeclaration.maxFieldCount;
        }
    }
}

