/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;

public class ClasspathJar
extends ClasspathLocation {
    private File file;
    private ZipFile zipFile;
    private boolean closeZipFileAtEnd;
    private Hashtable packageCache;

    public ClasspathJar(File file) throws IOException {
        this(file, true, null);
    }

    public ClasspathJar(File file, boolean bl2, AccessRuleSet accessRuleSet) {
        super(accessRuleSet);
        this.file = file;
        this.closeZipFileAtEnd = bl2;
    }

    public NameEnvironmentAnswer findClass(char[] cArray, String string, String string2) {
        if (!this.isPackage(string)) {
            return null;
        }
        try {
            ClassFileReader classFileReader = ClassFileReader.read(this.zipFile, string2);
            if (classFileReader != null) {
                return new NameEnvironmentAnswer(classFileReader, this.a(string2));
            }
        }
        catch (Exception exception) {}
        return null;
    }

    public void initialize() throws IOException {
        this.zipFile = new ZipFile(this.file);
    }

    public boolean isPackage(String string) {
        if (this.packageCache != null) {
            return this.packageCache.containsKey(string);
        }
        this.packageCache = new Hashtable(41);
        this.packageCache.put("", "");
        Enumeration<? extends ZipEntry> enumeration = this.zipFile.entries();
        block0: while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement().getName();
            int n2 = string2.lastIndexOf(47);
            while (n2 > 0) {
                String string3 = string2.substring(0, n2);
                if (this.packageCache.containsKey(string3)) continue block0;
                this.packageCache.put(string3, string3);
                n2 = string3.lastIndexOf(47);
            }
        }
        return this.packageCache.containsKey(string);
    }

    public void reset() {
        if (this.zipFile != null && this.closeZipFileAtEnd) {
            try {
                this.zipFile.close();
            }
            catch (IOException iOException) {}
            this.zipFile = null;
        }
        this.packageCache = null;
    }

    public String toString() {
        return "Classpath for jar file " + this.file.getPath();
    }

    public String normalizedPath() {
        String string = this.file.getPath();
        return string.substring(0, string.lastIndexOf(46));
    }

    public String getPath() {
        return this.file.getPath();
    }
}

