/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.batch;

import java.io.File;
import java.io.IOException;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.batch.ClasspathDirectory;
import org.eclipse.jdt.internal.compiler.batch.ClasspathJar;
import org.eclipse.jdt.internal.compiler.batch.ClasspathLocation;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.INameEnvironment;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class FileSystem
implements INameEnvironment,
SuffixConstants {
    public Classpath[] a;
    public String[] b;

    public FileSystem(String[] stringArray, String[] stringArray2, String string) {
        this(stringArray, stringArray2, string, null);
    }

    public FileSystem(String[] stringArray, String[] stringArray2, String string, int[] nArray) {
        int n2 = stringArray.length;
        this.a = new Classpath[n2];
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Classpath classpath = FileSystem.a(stringArray[n4], string, nArray == null ? 0 : nArray[n4], null);
            try {
                classpath.initialize();
                this.a[n3++] = classpath;
            }
            catch (IOException iOException) {}
            ++n4;
        }
        if (n3 != n2) {
            this.a = new Classpath[n3];
            System.arraycopy(this.a, 0, this.a, 0, n3);
        }
        this.initializeKnownFileNames(stringArray2);
    }

    public FileSystem(Classpath[] classpathArray, String[] stringArray) {
        int n2 = classpathArray.length;
        int n3 = 0;
        this.a = new Classpath[n2];
        int n4 = 0;
        while (n4 < n2) {
            Classpath classpath = classpathArray[n4];
            try {
                classpath.initialize();
                this.a[n3++] = classpath;
            }
            catch (IOException iOException) {}
            ++n4;
        }
        if (n3 != n2) {
            this.a = new Classpath[n3];
            System.arraycopy(this.a, 0, this.a, 0, n3);
        }
        this.initializeKnownFileNames(stringArray);
    }

    public static Classpath a(String string, String string2, int n2, AccessRuleSet accessRuleSet) {
        ClasspathLocation classpathLocation = null;
        File file = new File(FileSystem.convertPathSeparators(string));
        if (file.isDirectory()) {
            if (file.exists()) {
                classpathLocation = new ClasspathDirectory(file, string2, n2, accessRuleSet);
            }
        } else {
            String string3 = string.toLowerCase();
            if (string3.endsWith(".jar") || string3.endsWith(".zip")) {
                classpathLocation = new ClasspathJar(file, true, accessRuleSet);
            }
        }
        return classpathLocation;
    }

    private void initializeKnownFileNames(String[] stringArray) {
        this.b = new String[stringArray.length];
        int n2 = stringArray.length;
        while (--n2 >= 0) {
            String string = stringArray[n2];
            String string2 = null;
            if (string.lastIndexOf(".") != -1) {
                string = string.substring(0, string.lastIndexOf(46));
            }
            string = FileSystem.convertPathSeparators(string);
            int n3 = 0;
            while (n3 < this.a.length) {
                String string3 = this.a[n3].normalizedPath();
                if (this.a[n3] instanceof ClasspathDirectory && string.startsWith(string3) && (string2 == null || string3.length() < string2.length())) {
                    string2 = string3;
                }
                ++n3;
            }
            this.b[n2] = string2 == null ? string : string.substring(string2.length());
            string2 = null;
        }
    }

    public void cleanup() {
        int n2 = 0;
        int n3 = this.a.length;
        while (n2 < n3) {
            this.a[n2].reset();
            ++n2;
        }
    }

    private static String convertPathSeparators(String string) {
        return File.separatorChar == '/' ? string.replace('\\', '/') : string.replace('/', '\\');
    }

    private NameEnvironmentAnswer findClass(String string, char[] cArray) {
        String string2;
        int n2 = 0;
        int n3 = this.b.length;
        while (n2 < n3) {
            if (string.equals(this.b[n2])) {
                return null;
            }
            ++n2;
        }
        String string3 = String.valueOf(string) + ".class";
        String string4 = string.length() == cArray.length ? "" : string3.substring(0, string.length() - cArray.length - 1);
        String string5 = string2 = File.separatorChar == '/' ? string4 : string4.replace('/', File.separatorChar);
        if (string4 == string2) {
            int n4 = 0;
            int n5 = this.a.length;
            while (n4 < n5) {
                NameEnvironmentAnswer nameEnvironmentAnswer = this.a[n4].findClass(cArray, string4, string3);
                if (nameEnvironmentAnswer != null) {
                    return nameEnvironmentAnswer;
                }
                ++n4;
            }
        } else {
            String string6 = string3.replace('/', File.separatorChar);
            int n6 = 0;
            int n7 = this.a.length;
            while (n6 < n7) {
                NameEnvironmentAnswer nameEnvironmentAnswer;
                Classpath classpath = this.a[n6];
                NameEnvironmentAnswer nameEnvironmentAnswer2 = nameEnvironmentAnswer = classpath instanceof ClasspathJar ? classpath.findClass(cArray, string4, string3) : classpath.findClass(cArray, string2, string6);
                if (nameEnvironmentAnswer != null) {
                    return nameEnvironmentAnswer;
                }
                ++n6;
            }
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[][] cArray) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray, '/')), cArray[cArray.length - 1]);
        }
        return null;
    }

    public NameEnvironmentAnswer findType(char[] cArray, char[][] cArray2) {
        if (cArray != null) {
            return this.findClass(new String(CharOperation.concatWith(cArray2, cArray, '/')), cArray);
        }
        return null;
    }

    public ClasspathJar getClasspathJar(File file) throws IOException {
        return new ClasspathJar(file, true, null);
    }

    public boolean isPackage(char[][] cArray, char[] cArray2) {
        String string;
        String string2 = new String(CharOperation.concatWith(cArray, cArray2, '/'));
        String string3 = string = File.separatorChar == '/' ? string2 : string2.replace('/', File.separatorChar);
        if (string2 == string) {
            int n2 = 0;
            int n3 = this.a.length;
            while (n2 < n3) {
                if (this.a[n2].isPackage(string2)) {
                    return true;
                }
                ++n2;
            }
        } else {
            int n4 = 0;
            int n5 = this.a.length;
            while (n4 < n5) {
                Classpath classpath = this.a[n4];
                if (classpath instanceof ClasspathJar ? classpath.isPackage(string2) : classpath.isPackage(string)) {
                    return true;
                }
                ++n4;
            }
        }
        return false;
    }

    public static interface Classpath {
        public NameEnvironmentAnswer findClass(char[] var1, String var2, String var3);

        public boolean isPackage(String var1);

        public void reset();

        public String normalizedPath();

        public String getPath();

        public void initialize() throws IOException;
    }
}

