/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileConstants;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;

public abstract class ClassFileStruct
implements ClassFileConstants {
    public byte[] b;
    public int a;

    public ClassFileStruct(byte[] byArray, int n2) {
        this.b = byArray;
        this.a = n2;
    }

    public ClassFileStruct(byte[] byArray, int n2, boolean bl2) {
        this.b = byArray;
        this.a = n2;
    }

    public double doubleAt(int n2) {
        return Double.longBitsToDouble(this.i8At(n2));
    }

    public float floatAt(int n2) {
        return Float.intBitsToFloat(this.i4At(n2));
    }

    public int i1At(int n2) {
        return this.b[n2 + this.a];
    }

    public int i2At(int n2) {
        int n3 = n2 + this.a;
        return (this.b[n3++] << 8) + (this.b[n3] & 0xFF);
    }

    public int i4At(int n2) {
        int n3 = n2 + this.a;
        return ((this.b[n3++] & 0xFF) << 24) + ((this.b[n3++] & 0xFF) << 16) + ((this.b[n3++] & 0xFF) << 8) + (this.b[n3] & 0xFF);
    }

    public long i8At(int n2) {
        int n3 = n2 + this.a;
        return ((long)(this.b[n3++] & 0xFF) << 56) + ((long)(this.b[n3++] & 0xFF) << 48) + ((long)(this.b[n3++] & 0xFF) << 40) + ((long)(this.b[n3++] & 0xFF) << 32) + ((long)(this.b[n3++] & 0xFF) << 24) + ((long)(this.b[n3++] & 0xFF) << 16) + ((long)(this.b[n3++] & 0xFF) << 8) + (long)(this.b[n3++] & 0xFF);
    }

    public static String printTypeModifiers(int n2) {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        PrintWriter printWriter = new PrintWriter(byteArrayOutputStream);
        if ((n2 & 1) != 0) {
            printWriter.print("public ");
        }
        if ((n2 & 2) != 0) {
            printWriter.print("private ");
        }
        if ((n2 & 0x10) != 0) {
            printWriter.print("final ");
        }
        if ((n2 & 0x20) != 0) {
            printWriter.print("super ");
        }
        if ((n2 & 0x200) != 0) {
            printWriter.print("interface ");
        }
        if ((n2 & 0x400) != 0) {
            printWriter.print("abstract ");
        }
        printWriter.flush();
        return byteArrayOutputStream.toString();
    }

    public int u1At(int n2) {
        return this.b[n2 + this.a] & 0xFF;
    }

    public int u2At(int n2) {
        int n3 = n2 + this.a;
        return ((this.b[n3++] & 0xFF) << 8) + (this.b[n3] & 0xFF);
    }

    public long u4At(int n2) {
        int n3 = n2 + this.a;
        return (((long)this.b[n3++] & 0xFFL) << 24) + (long)((this.b[n3++] & 0xFF) << 16) + (long)((this.b[n3++] & 0xFF) << 8) + (long)(this.b[n3] & 0xFF);
    }

    public char[] utf8At(int n2, int n3) {
        int n4 = n3;
        char[] cArray = new char[n3];
        int n5 = 0;
        int n6 = this.a + n2;
        while (n4 != 0) {
            int n7 = this.b[n6++] & 0xFF;
            --n4;
            if ((0x80 & n7) != 0) {
                if ((n7 & 0x20) != 0) {
                    n4 -= 2;
                    n7 = (n7 & 0xF) << 12 | (this.b[n6++] & 0x3F) << 6 | this.b[n6++] & 0x3F;
                } else {
                    --n4;
                    n7 = (n7 & 0x1F) << 6 | this.b[n6++] & 0x3F;
                }
            }
            cArray[n5++] = (char)n7;
        }
        if (n5 != n3) {
            char[] cArray2 = cArray;
            cArray = new char[n5];
            System.arraycopy(cArray2, 0, cArray, 0, n5);
        }
        return cArray;
    }

    public void reset() {
        this.b = null;
    }

    public char[] utf8At(int n2, int n3, boolean bl2) throws ClassFormatException {
        int n4 = n3;
        char[] cArray = new char[n3];
        int n5 = 0;
        int n6 = this.a + n2;
        while (n4 != 0) {
            int n7 = this.b[n6++] & 0xFF;
            --n4;
            if ((0x80 & n7) != 0) {
                if (bl2) {
                    if ((0x40 & n7) == 0) {
                        throw new ClassFormatException(19);
                    }
                    if (n4 < 1) {
                        throw new ClassFormatException(19);
                    }
                }
                int n8 = this.b[n6++] & 0xFF;
                --n4;
                if (bl2 && (n8 & 0xC0) != 128) {
                    throw new ClassFormatException(19);
                }
                if ((n7 & 0x20) != 0) {
                    if (bl2 && n4 < 1) {
                        throw new ClassFormatException(19);
                    }
                    int n9 = this.b[n6++] & 0xFF;
                    --n4;
                    if (bl2 && (n9 & 0xC0) != 128) {
                        throw new ClassFormatException(19);
                    }
                    n7 = ((n7 & 0x1F) << 12) + ((n8 & 0x3F) << 6) + (n9 & 0x3F);
                    if (bl2 && n7 < 2048) {
                        throw new ClassFormatException(19);
                    }
                } else {
                    n7 = ((n7 & 0x1F) << 6) + (n8 & 0x3F);
                    if (bl2 && n7 != 0 && n7 < 128) {
                        throw new ClassFormatException(19);
                    }
                }
            } else if (bl2 && n7 == 0) {
                throw new ClassFormatException(19);
            }
            cArray[n5++] = (char)n7;
        }
        if (n5 != n3) {
            char[] cArray2 = cArray;
            cArray = new char[n5];
            System.arraycopy(cArray2, 0, cArray, 0, n5);
        }
        return cArray;
    }

    public static void verifyMethodNameAndSignature(char[] cArray, char[] cArray2) throws ClassFormatException {
        if (cArray.length == 0) {
            throw new ClassFormatException(27);
        }
        if (cArray[0] == '<') {
            if (new String(cArray).equals("<clinit>") || new String(cArray).equals("<init>")) {
                int n2 = cArray2.length;
                if (n2 <= 2 || cArray2[0] != '(' || cArray2[n2 - 2] != ')' || cArray2[n2 - 1] != 'V') {
                    throw new ClassFormatException(28);
                }
            } else {
                throw new ClassFormatException(27);
            }
        }
    }
}

