/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.classfmt;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileStruct;
import org.eclipse.jdt.internal.compiler.codegen.AttributeNamesConstants;
import org.eclipse.jdt.internal.compiler.codegen.ConstantPool;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;

public class MethodInfo
extends ClassFileStruct
implements IBinaryMethod,
AttributeNamesConstants,
Comparable {
    private static final char[][] noException = CharOperation.NO_CHAR_CHAR;
    private int accessFlags;
    private int attributeBytes;
    private int[] constantPoolOffsets;
    private char[] descriptor;
    private char[][] exceptionNames;
    private char[] name;
    private char[] signature;
    private int signatureUtf8Offset;
    private long tagBits;

    public MethodInfo(byte[] byArray, int[] nArray, int n2) {
        super(byArray, n2);
        this.constantPoolOffsets = nArray;
        this.accessFlags = -1;
        int n3 = this.u2At(6);
        int n4 = 8;
        this.signatureUtf8Offset = -1;
        int n5 = 0;
        while (n5 < n3) {
            int n6 = this.constantPoolOffsets[this.u2At(n4)] - this.a;
            char[] cArray = this.utf8At(n6 + 3, this.u2At(n6 + 1));
            if (cArray.length > 0) {
                switch (cArray[0]) {
                    case 'S': {
                        if (!CharOperation.equals(AttributeNamesConstants.SignatureName, cArray)) break;
                        this.signatureUtf8Offset = this.constantPoolOffsets[this.u2At(n4 + 6)] - this.a;
                        break;
                    }
                    case 'R': {
                        if (!CharOperation.equals(cArray, RuntimeVisibleAnnotationsName)) break;
                        this.decodeStandardAnnotations(n4);
                    }
                }
            }
            n4 = (int)((long)n4 + (6L + this.u4At(n4 + 2)));
            ++n5;
        }
        this.attributeBytes = n4;
    }

    public int compareTo(Object object) {
        if (!(object instanceof MethodInfo)) {
            throw new ClassCastException();
        }
        MethodInfo methodInfo = (MethodInfo)object;
        int n2 = new String(this.getSelector()).compareTo(new String(methodInfo.getSelector()));
        if (n2 != 0) {
            return n2;
        }
        return new String(this.getMethodDescriptor()).compareTo(new String(methodInfo.getMethodDescriptor()));
    }

    private int decodeAnnotation(int n2) {
        int n3 = n2;
        int n4 = this.constantPoolOffsets[this.u2At(n2)] - this.a;
        char[] cArray = this.utf8At(n4 + 3, this.u2At(n4 + 1));
        int n5 = this.u2At(n2 + 2);
        n3 += 4;
        if (cArray.length == 22 && CharOperation.equals(cArray, ConstantPool.JAVA_LANG_DEPRECATED)) {
            this.tagBits |= 0x200000000000L;
            return n3;
        }
        int n6 = 0;
        while (n6 < n5) {
            n3 += 2;
            n3 = this.decodeElementValue(n3);
            ++n6;
        }
        return n3;
    }

    private int decodeElementValue(int n2) {
        int n3 = n2;
        int n4 = this.u1At(n3);
        ++n3;
        switch (n4) {
            case 66: 
            case 67: 
            case 68: 
            case 70: 
            case 73: 
            case 74: 
            case 83: 
            case 90: 
            case 115: {
                n3 += 2;
                break;
            }
            case 101: {
                n3 += 4;
                break;
            }
            case 99: {
                n3 += 2;
                break;
            }
            case 64: {
                n3 = this.decodeAnnotation(n3);
                break;
            }
            case 91: {
                int n5 = this.u2At(n3);
                n3 += 2;
                int n6 = 0;
                while (n6 < n5) {
                    n3 = this.decodeElementValue(n3);
                    ++n6;
                }
                break;
            }
        }
        return n3;
    }

    private void decodeStandardAnnotations(int n2) {
        int n3 = this.u2At(n2 + 6);
        int n4 = n2 + 8;
        int n5 = 0;
        while (n5 < n3) {
            n4 = this.decodeAnnotation(n4);
            ++n5;
        }
    }

    public char[][] getArgumentNames() {
        return null;
    }

    public char[][] getExceptionTypeNames() {
        if (this.exceptionNames == null) {
            this.readExceptionAttributes();
        }
        return this.exceptionNames;
    }

    public char[] getGenericSignature() {
        if (this.signatureUtf8Offset != -1) {
            if (this.signature == null) {
                this.signature = this.utf8At(this.signatureUtf8Offset + 3, this.u2At(this.signatureUtf8Offset + 1));
            }
            return this.signature;
        }
        return null;
    }

    public char[] getMethodDescriptor() {
        if (this.descriptor == null) {
            int n2 = this.constantPoolOffsets[this.u2At(4)] - this.a;
            this.descriptor = this.utf8At(n2 + 3, this.u2At(n2 + 1));
        }
        return this.descriptor;
    }

    public int getModifiers() {
        if (this.accessFlags == -1) {
            this.accessFlags = this.u2At(0);
            this.readModifierRelatedAttributes();
        }
        return this.accessFlags;
    }

    public char[] getSelector() {
        if (this.name == null) {
            int n2 = this.constantPoolOffsets[this.u2At(2)] - this.a;
            this.name = this.utf8At(n2 + 3, this.u2At(n2 + 1));
        }
        return this.name;
    }

    public long getTagBits() {
        return this.tagBits;
    }

    public void a() {
        this.getModifiers();
        this.getSelector();
        this.getMethodDescriptor();
        this.getExceptionTypeNames();
        this.getGenericSignature();
        this.reset();
    }

    public boolean isClinit() {
        char[] cArray = this.getSelector();
        return cArray[0] == '<' && cArray.length == 8;
    }

    public boolean isConstructor() {
        char[] cArray = this.getSelector();
        return cArray[0] == '<' && cArray.length == 6;
    }

    public boolean isSynthetic() {
        return (this.getModifiers() & 0x1000) != 0;
    }

    private void readExceptionAttributes() {
        int n2 = this.u2At(6);
        int n3 = 8;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.constantPoolOffsets[this.u2At(n3)] - this.a;
            char[] cArray = this.utf8At(n5 + 3, this.u2At(n5 + 1));
            if (CharOperation.equals(cArray, ExceptionsName)) {
                int n6 = this.u2At(n3 + 6);
                n3 += 8;
                if (n6 == 0) {
                    this.exceptionNames = noException;
                } else {
                    this.exceptionNames = new char[n6][];
                    int n7 = 0;
                    while (n7 < n6) {
                        n5 = this.constantPoolOffsets[this.u2At(this.constantPoolOffsets[this.u2At(n3)] - this.a + 1)] - this.a;
                        this.exceptionNames[n7] = this.utf8At(n5 + 3, this.u2At(n5 + 1));
                        n3 += 2;
                        ++n7;
                    }
                }
            } else {
                n3 = (int)((long)n3 + (6L + this.u4At(n3 + 2)));
            }
            ++n4;
        }
        if (this.exceptionNames == null) {
            this.exceptionNames = noException;
        }
    }

    private void readModifierRelatedAttributes() {
        int n2 = this.u2At(6);
        int n3 = 8;
        int n4 = 0;
        while (n4 < n2) {
            int n5 = this.constantPoolOffsets[this.u2At(n3)] - this.a;
            char[] cArray = this.utf8At(n5 + 3, this.u2At(n5 + 1));
            if (cArray.length != 0) {
                switch (cArray[0]) {
                    case 'D': {
                        if (!CharOperation.equals(cArray, DeprecatedName)) break;
                        this.accessFlags |= 0x100000;
                        break;
                    }
                    case 'S': {
                        if (!CharOperation.equals(cArray, SyntheticName)) break;
                        this.accessFlags |= 0x1000;
                        break;
                    }
                    case 'A': {
                        if (!CharOperation.equals(cArray, AnnotationDefaultName)) break;
                        this.accessFlags |= 0x20000;
                    }
                }
            }
            n3 = (int)((long)n3 + (6L + this.u4At(n3 + 2)));
            ++n4;
        }
    }

    public void reset() {
        this.constantPoolOffsets = null;
        super.reset();
    }

    public int sizeInBytes() {
        return this.attributeBytes;
    }

    public String toString() {
        int n2 = this.getModifiers();
        char[] cArray = this.getGenericSignature();
        if (cArray == null) {
            cArray = this.getMethodDescriptor();
        }
        StringBuffer stringBuffer = new StringBuffer(this.getClass().getName());
        return stringBuffer.append("{").append(String.valueOf((n2 & 0x100000) != 0 ? "deprecated " : "") + ((n2 & 1) == 1 ? "public " : "") + ((n2 & 2) == 2 ? "private " : "") + ((n2 & 4) == 4 ? "protected " : "") + ((n2 & 8) == 8 ? "static " : "") + ((n2 & 0x10) == 16 ? "final " : "") + ((n2 & 0x40) == 64 ? "volatile " : "") + ((n2 & 0x80) == 128 ? "varargs " : "")).append(this.getSelector()).append(cArray).append("}").toString();
    }
}

