/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class FloatCache {
    private float[] keyTable;
    private int[] valueTable;
    private int elementSize = 0;

    public FloatCache() {
        this(13);
    }

    public FloatCache(int n2) {
        this.keyTable = new float[n2];
        this.valueTable = new int[n2];
    }

    public void clear() {
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            this.keyTable[n2] = 0.0f;
            this.valueTable[n2] = 0;
        }
        this.elementSize = 0;
    }

    public boolean containsKey(float f2) {
        if (f2 == 0.0f) {
            int n2 = 0;
            int n3 = this.elementSize;
            while (n2 < n3) {
                if (this.keyTable[n2] == 0.0f) {
                    int n4 = Float.floatToIntBits(f2);
                    int n5 = Float.floatToIntBits(this.keyTable[n2]);
                    if (n4 == Integer.MIN_VALUE && n5 == Integer.MIN_VALUE) {
                        return true;
                    }
                    if (n4 == 0 && n5 == 0) {
                        return true;
                    }
                }
                ++n2;
            }
        } else {
            int n6 = 0;
            int n7 = this.elementSize;
            while (n6 < n7) {
                if (this.keyTable[n6] == f2) {
                    return true;
                }
                ++n6;
            }
        }
        return false;
    }

    public int get(float f2) {
        if (f2 == 0.0f) {
            int n2 = 0;
            int n3 = this.elementSize;
            while (n2 < n3) {
                if (this.keyTable[n2] == 0.0f) {
                    int n4 = Float.floatToIntBits(f2);
                    int n5 = Float.floatToIntBits(this.keyTable[n2]);
                    if (n4 == Integer.MIN_VALUE && n5 == Integer.MIN_VALUE) {
                        return this.valueTable[n2];
                    }
                    if (n4 == 0 && n5 == 0) {
                        return this.valueTable[n2];
                    }
                }
                ++n2;
            }
        } else {
            int n6 = 0;
            int n7 = this.elementSize;
            while (n6 < n7) {
                if (this.keyTable[n6] == f2) {
                    return this.valueTable[n6];
                }
                ++n6;
            }
        }
        return -1;
    }

    public int put(float f2, int n2) {
        if (this.elementSize == this.keyTable.length) {
            this.keyTable = new float[this.elementSize * 2];
            System.arraycopy(this.keyTable, 0, this.keyTable, 0, this.elementSize);
            this.valueTable = new int[this.elementSize * 2];
            System.arraycopy(this.valueTable, 0, this.valueTable, 0, this.elementSize);
        }
        this.keyTable[this.elementSize] = f2;
        this.valueTable[this.elementSize] = n2;
        ++this.elementSize;
        return n2;
    }

    public String toString() {
        int n2 = this.elementSize;
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n3 = 0;
        while (n3 < n2) {
            if (this.keyTable[n3] != 0.0f || this.keyTable[n3] == 0.0f && this.valueTable[n3] != 0) {
                stringBuffer.append(this.keyTable[n3]).append("->").append(this.valueTable[n3]);
            }
            if (n3 < n2) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

