/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.codegen;

public class LongCache {
    public long[] keyTable;
    public int[] valueTable;
    public int a = 0;
    public int b;

    public LongCache() {
        this(13);
    }

    public LongCache(int n2) {
        this.b = (int)((double)n2 * 0.66);
        this.keyTable = new long[n2];
        this.valueTable = new int[n2];
    }

    public void clear() {
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            this.keyTable[n2] = 0L;
            this.valueTable[n2] = 0;
        }
        this.a = 0;
    }

    public boolean containsKey(long l2) {
        int n2 = this.hash(l2);
        while (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == l2) {
                return true;
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return false;
    }

    public int get(long l2) {
        int n2 = this.hash(l2);
        while (this.keyTable[n2] != 0L || this.keyTable[n2] == 0L && this.valueTable[n2] != 0) {
            if (this.keyTable[n2] == l2) {
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return -1;
    }

    public int hash(long l2) {
        return ((int)l2 & Integer.MAX_VALUE) % this.keyTable.length;
    }

    public int put(long l2, int n2) {
        int n3 = this.hash(l2);
        while (this.keyTable[n3] != 0L || this.keyTable[n3] == 0L && this.valueTable[n3] != 0) {
            if (this.keyTable[n3] == l2) {
                this.valueTable[n3] = n2;
                return this.valueTable[n3];
            }
            n3 = (n3 + 1) % this.keyTable.length;
        }
        this.keyTable[n3] = l2;
        this.valueTable[n3] = n2;
        if (++this.a > this.b) {
            this.rehash();
        }
        return n2;
    }

    private void rehash() {
        LongCache longCache = new LongCache(this.keyTable.length * 2);
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            long l2 = this.keyTable[n2];
            int n3 = this.valueTable[n2];
            if (l2 == 0L && (l2 != 0L || n3 == 0)) continue;
            longCache.put(l2, n3);
        }
        this.keyTable = longCache.keyTable;
        this.valueTable = longCache.valueTable;
        this.b = longCache.b;
    }

    public int size() {
        return this.a;
    }

    public String toString() {
        int n2 = this.size();
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n3 = 0;
        while (n3 < n2) {
            if (this.keyTable[n3] != 0L || this.keyTable[n3] == 0L && this.valueTable[n3] != 0) {
                stringBuffer.append(this.keyTable[n3]).append("->").append(this.valueTable[n3]);
            }
            if (n3 < n2) {
                stringBuffer.append(", ");
            }
            ++n3;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }
}

