/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.env;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.AccessRestriction;
import org.eclipse.jdt.internal.compiler.env.AccessRule;

public class AccessRuleSet {
    private AccessRule[] accessRules;
    public String messageTemplate;

    public AccessRuleSet(AccessRule[] accessRuleArray) {
        this.accessRules = accessRuleArray;
    }

    public AccessRuleSet(AccessRule[] accessRuleArray, String string) {
        this.accessRules = accessRuleArray;
        this.messageTemplate = string;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AccessRuleSet)) {
            return false;
        }
        AccessRuleSet accessRuleSet = (AccessRuleSet)object;
        if (!this.messageTemplate.equals(accessRuleSet.messageTemplate)) {
            return false;
        }
        int n2 = this.accessRules.length;
        if (n2 != accessRuleSet.accessRules.length) {
            return false;
        }
        int n3 = 0;
        while (n3 < n2) {
            if (!this.accessRules[n3].equals(accessRuleSet.accessRules[n3])) {
                return false;
            }
            ++n3;
        }
        return true;
    }

    public AccessRule[] getAccessRules() {
        return this.accessRules;
    }

    public AccessRestriction getViolatedRestriction(char[] cArray) {
        int n2 = 0;
        int n3 = this.accessRules.length;
        while (n2 < n3) {
            AccessRule accessRule = this.accessRules[n2];
            if (CharOperation.pathMatch(accessRule.pattern, cArray, true, '/')) {
                switch (accessRule.problemId) {
                    case 0x1000118: 
                    case 0x1000133: {
                        return new AccessRestriction(accessRule, this.messageTemplate);
                    }
                }
                return null;
            }
            ++n2;
        }
        return null;
    }

    public String toString() {
        return this.toString(true);
    }

    public String toString(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer(200);
        stringBuffer.append("AccessRuleSet {");
        if (bl2) {
            stringBuffer.append('\n');
        }
        int n2 = 0;
        int n3 = this.accessRules.length;
        while (n2 < n3) {
            if (bl2) {
                stringBuffer.append('\t');
            }
            AccessRule accessRule = this.accessRules[n2];
            stringBuffer.append(accessRule);
            if (bl2) {
                stringBuffer.append('\n');
            } else if (n2 < n3 - 1) {
                stringBuffer.append(", ");
            }
            ++n2;
        }
        stringBuffer.append("} [template:\"").append(this.messageTemplate).append("\"]");
        return stringBuffer.toString();
    }
}

