/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.impl;

import org.eclipse.jdt.internal.compiler.ast.OperatorIds;
import org.eclipse.jdt.internal.compiler.impl.BooleanConstant;
import org.eclipse.jdt.internal.compiler.impl.ByteConstant;
import org.eclipse.jdt.internal.compiler.impl.CharConstant;
import org.eclipse.jdt.internal.compiler.impl.DoubleConstant;
import org.eclipse.jdt.internal.compiler.impl.FloatConstant;
import org.eclipse.jdt.internal.compiler.impl.IntConstant;
import org.eclipse.jdt.internal.compiler.impl.LongConstant;
import org.eclipse.jdt.internal.compiler.impl.ShortConstant;
import org.eclipse.jdt.internal.compiler.impl.StringConstant;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.problem.ShouldNotImplement;
import org.eclipse.jdt.internal.compiler.util.Messages;

public abstract class Constant
implements TypeIds,
OperatorIds {
    public static final Constant NotAConstant = new DoubleConstant(Double.NaN);
    public static final IntConstant Zero = new IntConstant(0);
    public static final IntConstant Two = new IntConstant(2);
    public static final IntConstant One = new IntConstant(1);

    public boolean booleanValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "boolean"}));
    }

    public byte byteValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "byte"}));
    }

    public final Constant castTo(int n2) {
        if (this == NotAConstant) {
            return NotAConstant;
        }
        switch (n2) {
            case 0: {
                return this;
            }
            case 51: {
                return this;
            }
            case 55: {
                return Constant.fromValue((byte)this.longValue());
            }
            case 52: {
                return Constant.fromValue((byte)this.shortValue());
            }
            case 56: {
                return Constant.fromValue((byte)this.doubleValue());
            }
            case 57: {
                return Constant.fromValue((byte)this.floatValue());
            }
            case 50: {
                return Constant.fromValue((byte)this.charValue());
            }
            case 58: {
                return Constant.fromValue((byte)this.intValue());
            }
            case 115: {
                return Constant.fromValue((long)this.byteValue());
            }
            case 119: {
                return this;
            }
            case 116: {
                return Constant.fromValue((long)this.shortValue());
            }
            case 120: {
                return Constant.fromValue((long)this.doubleValue());
            }
            case 121: {
                return Constant.fromValue((long)this.floatValue());
            }
            case 114: {
                return Constant.fromValue((long)this.charValue());
            }
            case 122: {
                return Constant.fromValue((long)this.intValue());
            }
            case 67: {
                return Constant.fromValue((short)this.byteValue());
            }
            case 71: {
                return Constant.fromValue((short)this.longValue());
            }
            case 68: {
                return this;
            }
            case 72: {
                return Constant.fromValue((short)this.doubleValue());
            }
            case 73: {
                return Constant.fromValue((short)this.floatValue());
            }
            case 66: {
                return Constant.fromValue((short)this.charValue());
            }
            case 74: {
                return Constant.fromValue((short)this.intValue());
            }
            case 187: {
                return this;
            }
            case 131: {
                return Constant.fromValue((double)this.byteValue());
            }
            case 135: {
                return Constant.fromValue((double)this.longValue());
            }
            case 132: {
                return Constant.fromValue((double)this.shortValue());
            }
            case 136: {
                return this;
            }
            case 137: {
                return Constant.fromValue((double)this.floatValue());
            }
            case 130: {
                return Constant.fromValue((double)this.charValue());
            }
            case 138: {
                return Constant.fromValue((double)this.intValue());
            }
            case 147: {
                return Constant.fromValue((float)this.byteValue());
            }
            case 151: {
                return Constant.fromValue((float)this.longValue());
            }
            case 148: {
                return Constant.fromValue((float)this.shortValue());
            }
            case 152: {
                return Constant.fromValue((float)this.doubleValue());
            }
            case 153: {
                return this;
            }
            case 146: {
                return Constant.fromValue((float)this.charValue());
            }
            case 154: {
                return Constant.fromValue((float)this.intValue());
            }
            case 85: {
                return this;
            }
            case 35: {
                return Constant.fromValue((char)this.byteValue());
            }
            case 39: {
                return Constant.fromValue((char)this.longValue());
            }
            case 36: {
                return Constant.fromValue((char)this.shortValue());
            }
            case 40: {
                return Constant.fromValue((char)this.doubleValue());
            }
            case 41: {
                return Constant.fromValue((char)this.floatValue());
            }
            case 34: {
                return this;
            }
            case 42: {
                return Constant.fromValue((char)this.intValue());
            }
            case 163: {
                return Constant.fromValue((int)this.byteValue());
            }
            case 167: {
                return Constant.fromValue((int)this.longValue());
            }
            case 164: {
                return Constant.fromValue((int)this.shortValue());
            }
            case 168: {
                return Constant.fromValue((int)this.doubleValue());
            }
            case 169: {
                return Constant.fromValue((int)this.floatValue());
            }
            case 162: {
                return Constant.fromValue((int)this.charValue());
            }
            case 170: {
                return this;
            }
        }
        return NotAConstant;
    }

    public char charValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "char"}));
    }

    public static final Constant computeConstantOperation(Constant constant, int n2, int n3) {
        switch (n3) {
            case 11: {
                return Constant.fromValue(!constant.booleanValue());
            }
            case 14: {
                return Constant.computeConstantOperationPLUS(Zero, 10, constant, n2);
            }
            case 13: {
                switch (n2) {
                    case 9: {
                        float f2 = constant.floatValue();
                        if (f2 != 0.0f) break;
                        if (Float.floatToIntBits(f2) == 0) {
                            return Constant.fromValue(-0.0f);
                        }
                        return Constant.fromValue(0.0f);
                    }
                    case 8: {
                        double d2 = constant.doubleValue();
                        if (d2 != 0.0) break;
                        if (Double.doubleToLongBits(d2) == 0L) {
                            return Constant.fromValue(-0.0);
                        }
                        return Constant.fromValue(0.0);
                    }
                }
                return Constant.computeConstantOperationMINUS(Zero, 10, constant, n2);
            }
            case 12: {
                switch (n2) {
                    case 2: {
                        return Constant.fromValue((int)(~constant.charValue()));
                    }
                    case 3: {
                        return Constant.fromValue((int)(~constant.byteValue()));
                    }
                    case 4: {
                        return Constant.fromValue((int)(~constant.shortValue()));
                    }
                    case 10: {
                        return Constant.fromValue(~constant.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() ^ 0xFFFFFFFFFFFFFFFFL);
                    }
                }
                return NotAConstant;
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperation(Constant constant, int n2, int n3, Constant constant2, int n4) {
        switch (n3) {
            case 2: {
                return Constant.computeConstantOperationAND(constant, n2, constant2, n4);
            }
            case 0: {
                return Constant.computeConstantOperationAND_AND(constant, n2, constant2, n4);
            }
            case 9: {
                return Constant.computeConstantOperationDIVIDE(constant, n2, constant2, n4);
            }
            case 6: {
                return Constant.computeConstantOperationGREATER(constant, n2, constant2, n4);
            }
            case 7: {
                return Constant.computeConstantOperationGREATER_EQUAL(constant, n2, constant2, n4);
            }
            case 10: {
                return Constant.computeConstantOperationLEFT_SHIFT(constant, n2, constant2, n4);
            }
            case 4: {
                return Constant.computeConstantOperationLESS(constant, n2, constant2, n4);
            }
            case 5: {
                return Constant.computeConstantOperationLESS_EQUAL(constant, n2, constant2, n4);
            }
            case 13: {
                return Constant.computeConstantOperationMINUS(constant, n2, constant2, n4);
            }
            case 15: {
                return Constant.computeConstantOperationMULTIPLY(constant, n2, constant2, n4);
            }
            case 3: {
                return Constant.computeConstantOperationOR(constant, n2, constant2, n4);
            }
            case 1: {
                return Constant.computeConstantOperationOR_OR(constant, n2, constant2, n4);
            }
            case 14: {
                return Constant.computeConstantOperationPLUS(constant, n2, constant2, n4);
            }
            case 16: {
                return Constant.computeConstantOperationREMAINDER(constant, n2, constant2, n4);
            }
            case 17: {
                return Constant.computeConstantOperationRIGHT_SHIFT(constant, n2, constant2, n4);
            }
            case 19: {
                return Constant.computeConstantOperationUNSIGNED_RIGHT_SHIFT(constant, n2, constant2, n4);
            }
            case 8: {
                return Constant.computeConstantOperationXOR(constant, n2, constant2, n4);
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationAND(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 5: {
                return Constant.fromValue(constant.booleanValue() & constant2.booleanValue());
            }
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() & constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() & constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() & constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() & constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() & constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() & constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() & constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() & constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() & constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() & constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() & constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() & constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() & constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() & constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() & constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() & constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() & constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() & (long)constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() & (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() & (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() & (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() & constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationAND_AND(Constant constant, int n2, Constant constant2, int n3) {
        return Constant.fromValue(constant.booleanValue() && constant2.booleanValue());
    }

    public static final Constant computeConstantOperationDIVIDE(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() / constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() / constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() / constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() / constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() / constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() / (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() / constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() / (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() / (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() / (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() / (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() / (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() / (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() / (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() / (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() / (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() / (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() / constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() / constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() / constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() / constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() / constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() / constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() / constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() / constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() / constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() / constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() / constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() / constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() / constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() / constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() / constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() / constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() / (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() / constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() / constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() / (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() / (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() / (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() / constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationEQUAL_EQUAL(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 5: {
                if (n3 != 5) break;
                return Constant.fromValue(constant.booleanValue() == constant2.booleanValue());
            }
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() == constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() == constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() == constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() == constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() == constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() == (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() == constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() == (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() == (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() == (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() == (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() == (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() == (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() == (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() == (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() == (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() == (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() == constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() == constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() == constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() == constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() == constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() == constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() == constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() == constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() == constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() == constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() == constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() == constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() == constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() == constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() == constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() == (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() == constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() == constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() == (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() == (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() == (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() == constant2.longValue());
                    }
                }
                break;
            }
            case 11: {
                if (n3 != 11) break;
                return Constant.fromValue(((StringConstant)constant).compileTimeEqual((StringConstant)constant2));
            }
            case 12: {
                if (n3 == 11) {
                    return Constant.fromValue(false);
                }
                if (n3 != 12) break;
                return Constant.fromValue(true);
            }
        }
        return Constant.fromValue(false);
    }

    public static final Constant computeConstantOperationGREATER(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() > constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() > constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() > constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() > constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() > constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() > (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() > constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() > (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() > (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() > (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() > (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() > (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() > (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() > (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() > (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() > (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() > (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() > constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() > constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() > constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() > constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() > constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() > constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() > constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() > constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() > constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() > constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() > constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() > constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() > constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() > constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() > constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() > constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() > (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() > constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() > constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() > (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() > (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() > (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() > constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationGREATER_EQUAL(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() >= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() >= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() >= (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() >= (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() >= (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() >= (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() >= (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() >= (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() >= (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() >= (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() >= (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() >= (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() >= (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() >= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() >= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() >= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() >= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() >= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() >= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() >= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() >= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() >= constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() >= (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() >= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() >= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() >= (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() >= (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() >= (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() >= constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLEFT_SHIFT(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() << constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() << constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() << constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() << constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.charValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() << constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() << constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() << constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() << constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.byteValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() << constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() << constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() << constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() << constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.shortValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() << constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() << constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() << constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() << constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.intValue() << (int)constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() << constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() << constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() << constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() << constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() << (int)constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLESS(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() < constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() < constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() < constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() < constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() < constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() < (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() < constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() < (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() < (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() < (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() < (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() < (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() < (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() < (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() < (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() < (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() < (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() < constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() < constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() < constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() < constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() < constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() < constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() < constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() < constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() < constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() < constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() < constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() < constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() < constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() < constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() < constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() < constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() < (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() < constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() < constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() < (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() < (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() < (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() < constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationLESS_EQUAL(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() <= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() <= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() <= (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() <= (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() <= (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() <= (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() <= (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() <= (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() <= (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() <= (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() <= (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() <= (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() <= (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() <= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() <= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() <= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() <= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() <= constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() <= constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() <= constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() <= constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() <= constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() <= (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() <= constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() <= constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() <= (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() <= (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() <= (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() <= constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationMINUS(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() - constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() - constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() - constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() - constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() - constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() - (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() - constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() - (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() - (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() - (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() - (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() - (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() - (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() - (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() - (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() - (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() - (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() - constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() - constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() - constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() - constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() - constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() - constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() - constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() - constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() - constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() - constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() - constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() - constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() - constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() - constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() - constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() - constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() - (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() - constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() - constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() - (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() - (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() - (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() - constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationMULTIPLY(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() * constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() * constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() * constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() * constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() * constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() * (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() * constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() * (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() * (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() * (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() * (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() * (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() * (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() * (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() * (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() * (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() * (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() * constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() * constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() * constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() * constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() * constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() * constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() * constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() * constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() * constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() * constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() * constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() * constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() * constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() * constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() * constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() * constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() * (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() * constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() * constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() * (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() * (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() * (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() * constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationOR(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 5: {
                return Constant.fromValue(constant.booleanValue() | constant2.booleanValue());
            }
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() | constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() | constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() | constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() | constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() | constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() | constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() | constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() | constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() | constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() | constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() | constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() | constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() | constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() | constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() | constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() | constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() | constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() | (long)constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() | (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() | (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() | (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() | constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationOR_OR(Constant constant, int n2, Constant constant2, int n3) {
        return Constant.fromValue(constant.booleanValue() || constant2.booleanValue());
    }

    public static final Constant computeConstantOperationPLUS(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 1: {
                if (n3 == 11) {
                    return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                }
            }
            case 5: {
                if (n3 != 11) break;
                return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
            }
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() + constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() + constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() + constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() + constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() + constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() + constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() + (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() + constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() + (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() + (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() + (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() + (float)constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() + (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() + (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() + (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() + (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() + (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() + (double)constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() + constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() + constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() + constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() + constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() + constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() + constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() + constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() + constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() + constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() + constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() + constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() + constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() + constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() + constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() + constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() + constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() + constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() + constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() + (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() + constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() + constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() + (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() + (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() + (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() + constant2.longValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 11: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 9: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 8: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 3: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 4: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 10: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 7: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 5: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
                break;
            }
            case 12: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 9: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 8: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 3: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 4: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 10: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 7: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                    case 11: {
                        return Constant.fromValue(String.valueOf(constant.stringValue()) + constant2.stringValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationREMAINDER(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() % constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.charValue() % constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.charValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() % constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() % constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() % constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 9: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.floatValue() % (float)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.floatValue() % constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.floatValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.floatValue() % (float)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.floatValue() % (float)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.floatValue() % (float)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.floatValue() % (float)constant2.longValue());
                    }
                }
                break;
            }
            case 8: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.doubleValue() % (double)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue(constant.doubleValue() % (double)constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue(constant.doubleValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.doubleValue() % (double)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.doubleValue() % (double)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.doubleValue() % (double)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.doubleValue() % (double)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() % constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.byteValue() % constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.byteValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() % constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() % constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() % constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() % constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.shortValue() % constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.shortValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() % constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() % constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() % constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() % constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.intValue() % constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.intValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() % constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() % constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() % constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() % constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() % (long)constant2.charValue());
                    }
                    case 9: {
                        return Constant.fromValue((float)constant.longValue() % constant2.floatValue());
                    }
                    case 8: {
                        return Constant.fromValue((double)constant.longValue() % constant2.doubleValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() % (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() % (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() % (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() % constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationRIGHT_SHIFT(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() >> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() >> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.charValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() >> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() >> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.byteValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() >> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() >> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.shortValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() >> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() >> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.intValue() >> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() >> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() >> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() >> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() >> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() >> (int)constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationUNSIGNED_RIGHT_SHIFT(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.charValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.byteValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.shortValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.intValue() >>> (int)constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() >>> constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() >>> constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() >>> constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() >>> constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() >>> (int)constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public static final Constant computeConstantOperationXOR(Constant constant, int n2, Constant constant2, int n3) {
        switch (n2) {
            case 5: {
                return Constant.fromValue(constant.booleanValue() ^ constant2.booleanValue());
            }
            case 2: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.charValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.charValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.charValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.charValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.charValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 3: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.byteValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.byteValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.byteValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.byteValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.byteValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 4: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.shortValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.shortValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.shortValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.shortValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.shortValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 10: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.intValue() ^ constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.intValue() ^ constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.intValue() ^ constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.intValue() ^ constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue((long)constant.intValue() ^ constant2.longValue());
                    }
                }
                break;
            }
            case 7: {
                switch (n3) {
                    case 2: {
                        return Constant.fromValue(constant.longValue() ^ (long)constant2.charValue());
                    }
                    case 3: {
                        return Constant.fromValue(constant.longValue() ^ (long)constant2.byteValue());
                    }
                    case 4: {
                        return Constant.fromValue(constant.longValue() ^ (long)constant2.shortValue());
                    }
                    case 10: {
                        return Constant.fromValue(constant.longValue() ^ (long)constant2.intValue());
                    }
                    case 7: {
                        return Constant.fromValue(constant.longValue() ^ constant2.longValue());
                    }
                }
            }
        }
        return NotAConstant;
    }

    public double doubleValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "double"}));
    }

    public float floatValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "float"}));
    }

    public static Constant fromValue(byte by2) {
        return new ByteConstant(by2);
    }

    public static Constant fromValue(char c2) {
        return new CharConstant(c2);
    }

    public static Constant fromValue(double d2) {
        return new DoubleConstant(d2);
    }

    public static Constant fromValue(float f2) {
        return new FloatConstant(f2);
    }

    public static Constant fromValue(int n2) {
        return new IntConstant(n2);
    }

    public static Constant fromValue(long l2) {
        return new LongConstant(l2);
    }

    public static Constant fromValue(String string) {
        return new StringConstant(string);
    }

    public static Constant fromValue(short s2) {
        return new ShortConstant(s2);
    }

    public static Constant fromValue(boolean bl2) {
        return new BooleanConstant(bl2);
    }

    public int intValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "int"}));
    }

    public long longValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotCastedInto, new String[]{this.typeName(), "long"}));
    }

    public short shortValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotConvertedTo, new String[]{this.typeName(), "short"}));
    }

    public String stringValue() {
        throw new ShouldNotImplement(Messages.bind(Messages.constant_cannotConvertedTo, new String[]{this.typeName(), "String"}));
    }

    public String toString() {
        if (this == NotAConstant) {
            return "(Constant) NotAConstant";
        }
        return super.toString();
    }

    public abstract int typeID();

    public String typeName() {
        switch (this.typeID()) {
            case 10: {
                return "int";
            }
            case 3: {
                return "byte";
            }
            case 4: {
                return "short";
            }
            case 2: {
                return "char";
            }
            case 9: {
                return "float";
            }
            case 8: {
                return "double";
            }
            case 5: {
                return "boolean";
            }
            case 7: {
                return "long";
            }
            case 11: {
                return "java.lang.String";
            }
            case 12: {
                return "null";
            }
        }
        return "unknown";
    }
}

