/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.ArrayList;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.env.IBinaryField;
import org.eclipse.jdt.internal.compiler.env.IBinaryMethod;
import org.eclipse.jdt.internal.compiler.env.IBinaryType;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CompilationUnitScope;
import org.eclipse.jdt.internal.compiler.lookup.FieldBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.MethodBinding;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.SignatureWrapper;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;
import org.eclipse.jdt.internal.compiler.problem.AbortCompilation;

public final class BinaryTypeBinding
extends ReferenceBinding {
    private ReferenceBinding superclass;
    private ReferenceBinding enclosingType;
    private ReferenceBinding[] superInterfaces;
    private FieldBinding[] fields;
    private MethodBinding[] methods;
    private ReferenceBinding[] memberTypes;
    public TypeVariableBinding[] typeVariables;
    private LookupEnvironment environment;

    public static ReferenceBinding resolveType(ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment, boolean bl2) {
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)referenceBinding).a(lookupEnvironment, bl2);
        }
        if (referenceBinding.isParameterizedType()) {
            return ((ParameterizedTypeBinding)referenceBinding).b();
        }
        if (referenceBinding.isWildcard()) {
            return ((WildcardBinding)referenceBinding).b();
        }
        if (bl2) {
            return (ReferenceBinding)lookupEnvironment.convertToRawType(referenceBinding);
        }
        return referenceBinding;
    }

    public static TypeBinding resolveType(TypeBinding typeBinding, LookupEnvironment lookupEnvironment, ParameterizedTypeBinding parameterizedTypeBinding, int n2) {
        switch (typeBinding.kind()) {
            case 260: {
                return ((ParameterizedTypeBinding)typeBinding).b();
            }
            case 516: {
                return ((WildcardBinding)typeBinding).b();
            }
            case 68: {
                BinaryTypeBinding.resolveType(((ArrayBinding)typeBinding).leafComponentType, lookupEnvironment, parameterizedTypeBinding, n2);
                break;
            }
            case 4100: {
                ((TypeVariableBinding)typeBinding).a(lookupEnvironment);
                break;
            }
            case 2052: {
                if (parameterizedTypeBinding != null) break;
                return lookupEnvironment.convertToRawType(typeBinding);
            }
            default: {
                if (!(typeBinding instanceof UnresolvedReferenceBinding)) break;
                return ((UnresolvedReferenceBinding)typeBinding).a(lookupEnvironment, parameterizedTypeBinding == null);
            }
        }
        return typeBinding;
    }

    public static ReferenceBinding a(ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment, boolean bl2) {
        if (referenceBinding instanceof UnresolvedReferenceBinding) {
            return ((UnresolvedReferenceBinding)referenceBinding).a(lookupEnvironment, bl2);
        }
        if (referenceBinding.isParameterizedType()) {
            BinaryTypeBinding.a(((ParameterizedTypeBinding)referenceBinding).type, lookupEnvironment, false);
        } else if (referenceBinding.isWildcard()) {
            BinaryTypeBinding.resolveType(((WildcardBinding)referenceBinding).g, lookupEnvironment, null, 0);
        }
        return referenceBinding;
    }

    public BinaryTypeBinding(PackageBinding packageBinding, IBinaryType iBinaryType, LookupEnvironment lookupEnvironment) {
        this.compoundName = CharOperation.splitOn('/', iBinaryType.getName());
        this.computeId();
        this.tagBits |= 0x40L;
        this.environment = lookupEnvironment;
        this.fPackage = packageBinding;
        this.b = iBinaryType.getFileName();
        char[] cArray = lookupEnvironment.globalOptions.sourceLevel >= 0x310000L ? iBinaryType.getGenericSignature() : null;
        this.typeVariables = cArray != null && cArray.length > 0 && cArray[0] == '<' ? null : NoTypeVariables;
        char[] cArray2 = this.compoundName[this.compoundName.length - 1];
        int n2 = CharOperation.lastIndexOf('$', cArray2) + 1;
        if (n2 == 0) {
            this.sourceName = cArray2;
        } else {
            this.sourceName = new char[cArray2.length - n2];
            System.arraycopy(cArray2, n2, this.sourceName, 0, this.sourceName.length);
        }
        this.modifiers = iBinaryType.getModifiers();
        if (iBinaryType.isAnonymous()) {
            this.tagBits |= 0x34L;
        } else if (iBinaryType.isLocal()) {
            this.tagBits |= 0x14L;
        } else if (iBinaryType.isMember()) {
            this.tagBits |= 0xCL;
        }
        char[] cArray3 = iBinaryType.getEnclosingTypeName();
        if (cArray3 != null) {
            this.enclosingType = lookupEnvironment.a(cArray3, 0, -1, true);
            this.tagBits |= 0xCL;
            this.tagBits |= 0x8000000L;
            if (this.enclosingType().isStrictfp()) {
                this.modifiers |= 0x800;
            }
            if (this.enclosingType().isDeprecated()) {
                this.modifiers |= 0x200000;
            }
        }
    }

    public FieldBinding[] availableFields() {
        if ((this.tagBits & 0x1000L) != 0L) {
            return this.fields;
        }
        FieldBinding[] fieldBindingArray = new FieldBinding[this.fields.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.fields.length) {
            try {
                fieldBindingArray[n2] = this.resolveTypeFor(this.fields[n3]);
                ++n2;
            }
            catch (AbortCompilation abortCompilation) {}
            ++n3;
        }
        if (n2 < fieldBindingArray.length) {
            FieldBinding[] fieldBindingArray2 = fieldBindingArray;
            fieldBindingArray = new FieldBinding[n2];
            System.arraycopy(fieldBindingArray2, 0, fieldBindingArray, 0, n2);
        }
        return fieldBindingArray;
    }

    public MethodBinding[] availableMethods() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.methods;
        }
        MethodBinding[] methodBindingArray = new MethodBinding[this.methods.length];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.methods.length) {
            try {
                methodBindingArray[n2] = this.a(this.methods[n3]);
                ++n2;
            }
            catch (AbortCompilation abortCompilation) {}
            ++n3;
        }
        if (n2 < methodBindingArray.length) {
            MethodBinding[] methodBindingArray2 = methodBindingArray;
            methodBindingArray = new MethodBinding[n2];
            System.arraycopy(methodBindingArray2, 0, methodBindingArray, 0, n2);
        }
        return methodBindingArray;
    }

    public void a(IBinaryType iBinaryType, boolean bl2) {
        int n2;
        int n3;
        Object object;
        Object object2;
        this.typeVariables = NoTypeVariables;
        this.superInterfaces = NoSuperInterfaces;
        long l2 = this.environment.globalOptions.sourceLevel;
        char[] cArray = null;
        if (l2 >= 0x310000L) {
            cArray = iBinaryType.getGenericSignature();
            this.tagBits |= iBinaryType.getTagBits();
        }
        if (cArray == null) {
            object2 = iBinaryType.getSuperclassName();
            if (object2 != null) {
                this.superclass = this.environment.a((char[])object2, 0, -1, false);
                this.tagBits |= 0x2000000L;
            }
            this.superInterfaces = NoSuperInterfaces;
            object = iBinaryType.getInterfaceNames();
            if (object != null && (n3 = ((char[][])object).length) > 0) {
                this.superInterfaces = new ReferenceBinding[n3];
                int n4 = 0;
                while (n4 < n3) {
                    this.superInterfaces[n4] = this.environment.a(object[n4], 0, -1, false);
                    ++n4;
                }
                this.tagBits |= 0x4000000L;
            }
        } else {
            object2 = new SignatureWrapper(cArray);
            if (object2.signature[object2.start] == '<') {
                ++object2.start;
                this.typeVariables = this.createTypeVariables((SignatureWrapper)object2, this);
                ++object2.start;
                this.tagBits |= 0x1000000L;
                this.modifiers |= 0x40000000;
            }
            this.superclass = (ReferenceBinding)this.environment.a((SignatureWrapper)object2, NoTypeVariables, this);
            this.tagBits |= 0x2000000L;
            this.superInterfaces = NoSuperInterfaces;
            if (!object2.atEnd()) {
                object = new ArrayList(2);
                do {
                    object.add(this.environment.a((SignatureWrapper)object2, NoTypeVariables, this));
                } while (!object2.atEnd());
                this.superInterfaces = new ReferenceBinding[object.size()];
                object.toArray(this.superInterfaces);
                this.tagBits |= 0x4000000L;
            }
        }
        this.memberTypes = NoMemberTypes;
        object2 = iBinaryType.getMemberTypes();
        if (object2 != null && (n2 = ((char[])object2).length) > 0) {
            this.memberTypes = new ReferenceBinding[n2];
            n3 = 0;
            while (n3 < n2) {
                this.memberTypes[n3] = this.environment.a(object2[n3].getName(), 0, -1, false);
                ++n3;
            }
            this.tagBits |= 0x10000000L;
        }
        if (bl2) {
            this.createFields(iBinaryType.getFields(), l2);
            this.createMethods(iBinaryType.getMethods(), l2);
        } else {
            this.fields = NoFields;
            this.methods = NoMethods;
        }
    }

    private void createFields(IBinaryField[] iBinaryFieldArray, long l2) {
        int n2;
        this.fields = NoFields;
        if (iBinaryFieldArray != null && (n2 = iBinaryFieldArray.length) > 0) {
            this.fields = new FieldBinding[n2];
            boolean bl2 = l2 >= 0x310000L;
            boolean bl3 = this.isViewedAsDeprecated();
            int n3 = 0;
            while (n3 < n2) {
                IBinaryField iBinaryField = iBinaryFieldArray[n3];
                char[] cArray = bl2 ? iBinaryField.getGenericSignature() : null;
                TypeBinding typeBinding = cArray == null ? this.environment.a(iBinaryField.getTypeName(), 0, -1, false, this) : this.environment.a(new SignatureWrapper(cArray), NoTypeVariables, this);
                FieldBinding fieldBinding = new FieldBinding(iBinaryField.getName(), typeBinding, iBinaryField.getModifiers() | 0x2000000, this, iBinaryField.getConstant());
                fieldBinding.id = n3;
                if (bl2) {
                    fieldBinding.tagBits |= iBinaryField.getTagBits();
                }
                if (bl3 && !fieldBinding.isDeprecated()) {
                    fieldBinding.modifiers |= 0x200000;
                }
                if (cArray != null) {
                    fieldBinding.modifiers |= 0x40000000;
                }
                this.fields[n3] = fieldBinding;
                ++n3;
            }
        }
    }

    private MethodBinding createMethod(IBinaryMethod iBinaryMethod, long l2) {
        Object object;
        Object object2;
        Object object3;
        char[] cArray;
        int n2 = iBinaryMethod.getModifiers() | 0x2000000;
        if (l2 < 0x310000L) {
            n2 &= 0xFFFFFF7F;
        }
        ReferenceBinding[] referenceBindingArray = NoExceptions;
        TypeBinding[] typeBindingArray = NoParameters;
        TypeVariableBinding[] typeVariableBindingArray = NoTypeVariables;
        TypeBinding typeBinding = null;
        boolean bl2 = l2 >= 0x310000L;
        char[] cArray2 = cArray = bl2 ? iBinaryMethod.getGenericSignature() : null;
        if (cArray == null) {
            char[][] cArray3;
            int n3;
            object3 = iBinaryMethod.getMethodDescriptor();
            int n4 = 0;
            object2 = 0;
            while ((object = object3[++object2]) != 41) {
                if (object == 91) continue;
                ++n4;
                if (object != 76) continue;
                while ((object = object3[++object2]) != 59) {
                }
            }
            int n5 = iBinaryMethod.isConstructor() && this.isMemberType() && !this.isStatic() ? 1 : 0;
            int n6 = n4 - n5;
            if (n6 > 0) {
                typeBindingArray = new TypeBinding[n6];
                object2 = 1;
                int n7 = 0;
                n3 = 0;
                while (n3 < n4) {
                    Object object4;
                    do {
                        object4 = object3[++n7];
                        object = object4;
                    } while (object4 == 91);
                    if (object == 76) {
                        Object object5;
                        do {
                            object5 = object3[++n7];
                            object = object5;
                        } while (object5 != 59);
                    }
                    if (n3 >= n5) {
                        typeBindingArray[n3 - n5] = this.environment.a((char[])object3, (int)object2, n7, false, this);
                    }
                    object2 = n7 + 1;
                    ++n3;
                }
            }
            if ((cArray3 = iBinaryMethod.getExceptionTypeNames()) != null && (n6 = cArray3.length) > 0) {
                referenceBindingArray = new ReferenceBinding[n6];
                n3 = 0;
                while (n3 < n6) {
                    referenceBindingArray[n3] = this.environment.a(cArray3[n3], 0, -1, false);
                    ++n3;
                }
            }
            if (!iBinaryMethod.isConstructor()) {
                typeBinding = this.environment.a((char[])object3, object2 + 1, -1, false, this);
            }
        } else {
            Object object6;
            n2 |= 0x40000000;
            object3 = new SignatureWrapper(cArray);
            if (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '<') {
                ++((SignatureWrapper)object3).start;
                typeVariableBindingArray = this.createTypeVariables((SignatureWrapper)object3, this);
                ++((SignatureWrapper)object3).start;
            }
            if (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '(') {
                ++((SignatureWrapper)object3).start;
                if (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == ')') {
                    ++((SignatureWrapper)object3).start;
                } else {
                    object6 = new ArrayList(2);
                    while (((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] != ')') {
                        object6.add(this.environment.a((SignatureWrapper)object3, typeVariableBindingArray, this));
                    }
                    ++((SignatureWrapper)object3).start;
                    typeBindingArray = new TypeBinding[object6.size()];
                    object6.toArray(typeBindingArray);
                }
            }
            if (!iBinaryMethod.isConstructor()) {
                typeBinding = this.environment.a((SignatureWrapper)object3, typeVariableBindingArray, this);
            }
            if (!((SignatureWrapper)object3).atEnd() && ((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '^') {
                object6 = new ArrayList(2);
                do {
                    ++((SignatureWrapper)object3).start;
                    object6.add(this.environment.a((SignatureWrapper)object3, typeVariableBindingArray, this));
                } while (!((SignatureWrapper)object3).atEnd() && ((SignatureWrapper)object3).signature[((SignatureWrapper)object3).start] == '^');
                referenceBindingArray = new ReferenceBinding[object6.size()];
                object6.toArray(referenceBindingArray);
            } else {
                object6 = iBinaryMethod.getExceptionTypeNames();
                if (object6 != null && (object = ((char[][])object6).length) > 0) {
                    referenceBindingArray = new ReferenceBinding[object];
                    object2 = 0;
                    while (object2 < object) {
                        referenceBindingArray[object2] = this.environment.a((char[])object6[object2], 0, -1, false);
                        ++object2;
                    }
                }
            }
        }
        Object object7 = object3 = iBinaryMethod.isConstructor() ? new MethodBinding(n2, typeBindingArray, referenceBindingArray, this) : new MethodBinding(n2, iBinaryMethod.getSelector(), typeBinding, typeBindingArray, referenceBindingArray, this);
        if (bl2) {
            ((MethodBinding)object3).tagBits |= iBinaryMethod.getTagBits();
        }
        ((MethodBinding)object3).typeVariables = typeVariableBindingArray;
        Object object8 = 0;
        object = typeVariableBindingArray.length;
        while (object8 < object) {
            typeVariableBindingArray[object8].declaringElement = object3;
            ++object8;
        }
        return object3;
    }

    private void createMethods(IBinaryMethod[] iBinaryMethodArray, long l2) {
        Object object;
        int n2;
        int n3 = 0;
        int n4 = 0;
        int n5 = -1;
        int[] nArray = null;
        if (iBinaryMethodArray != null) {
            n2 = n3 = (n4 = iBinaryMethodArray.length);
            while (--n2 >= 0) {
                IBinaryMethod iBinaryMethod = iBinaryMethodArray[n2];
                if ((iBinaryMethod.getModifiers() & 0x1000) != 0) {
                    if (nArray == null) {
                        nArray = new int[iBinaryMethodArray.length];
                    }
                    nArray[n2] = -1;
                    --n3;
                    continue;
                }
                if (n5 != -1 || ((Object)(object = (Object)iBinaryMethod.getSelector())).length != 8 || object[0] != 60) continue;
                n5 = n2;
                --n3;
            }
        }
        if (n3 == 0) {
            this.methods = NoMethods;
            return;
        }
        n2 = this.isViewedAsDeprecated();
        this.methods = new MethodBinding[n3];
        if (n3 == n4) {
            int n6 = 0;
            while (n6 < n4) {
                object = this.createMethod(iBinaryMethodArray[n6], l2);
                if (n2 != 0 && !((MethodBinding)object).isDeprecated()) {
                    ((MethodBinding)object).modifiers |= 0x200000;
                }
                this.methods[n6] = object;
                ++n6;
            }
        } else {
            int n7 = 0;
            int n8 = 0;
            while (n7 < n4) {
                if (n5 != n7 && (nArray == null || nArray[n7] != -1)) {
                    MethodBinding methodBinding = this.createMethod(iBinaryMethodArray[n7], l2);
                    if (n2 != 0 && !methodBinding.isDeprecated()) {
                        methodBinding.modifiers |= 0x200000;
                    }
                    this.methods[n8++] = methodBinding;
                }
                ++n7;
            }
        }
    }

    private TypeVariableBinding[] createTypeVariables(SignatureWrapper signatureWrapper, Binding binding) {
        int n2;
        char[] cArray = signatureWrapper.signature;
        int n3 = 0;
        int n4 = cArray.length;
        int n5 = 0;
        ArrayList<TypeVariableBinding> arrayList = new ArrayList<TypeVariableBinding>(1);
        n3 = 0;
        boolean bl2 = true;
        int n6 = 1;
        block5: while (n6 < n4) {
            switch (cArray[n6]) {
                case '<': {
                    ++n3;
                    break;
                }
                case '>': {
                    if (--n3 >= 0) break;
                    break block5;
                }
                case ';': {
                    if (n3 != 0 || n6 + 1 >= n4 || cArray[n6 + 1] == ':') break;
                    bl2 = true;
                    break;
                }
                default: {
                    if (!bl2) break;
                    bl2 = false;
                    n2 = CharOperation.indexOf(':', cArray, n6);
                    char[] cArray2 = CharOperation.subarray(cArray, n6, n2);
                    arrayList.add(new TypeVariableBinding(cArray2, binding, n5++));
                }
            }
            ++n6;
        }
        TypeVariableBinding[] typeVariableBindingArray = new TypeVariableBinding[n5];
        arrayList.toArray(typeVariableBindingArray);
        n2 = 0;
        while (n2 < n5) {
            this.initializeTypeVariable(typeVariableBindingArray[n2], typeVariableBindingArray, signatureWrapper);
            ++n2;
        }
        return typeVariableBindingArray;
    }

    public ReferenceBinding enclosingType() {
        if ((this.tagBits & 0x8000000L) == 0L) {
            return this.enclosingType;
        }
        this.enclosingType = BinaryTypeBinding.a(this.enclosingType, this.environment, false);
        this.tagBits &= 0xFFFFFFFFF7FFFFFFL;
        this.enclosingType = BinaryTypeBinding.resolveType(this.enclosingType, this.environment, false);
        return this.enclosingType;
    }

    public FieldBinding[] fields() {
        if ((this.tagBits & 0x1000L) != 0L) {
            return this.fields;
        }
        int n2 = this.fields.length;
        while (--n2 >= 0) {
            this.resolveTypeFor(this.fields[n2]);
        }
        this.tagBits |= 0x1000L;
        return this.fields;
    }

    public char[] genericTypeSignature() {
        return this.computeGenericTypeSignature(this.typeVariables);
    }

    public MethodBinding getExactConstructor(TypeBinding[] typeBindingArray) {
        int n2 = typeBindingArray.length;
        int n3 = this.methods.length;
        block0: while (--n3 >= 0) {
            MethodBinding methodBinding = this.methods[n3];
            if (methodBinding.selector != TypeConstants.INIT || methodBinding.parameters.length != n2) continue;
            this.a(methodBinding);
            TypeBinding[] typeBindingArray2 = methodBinding.parameters;
            int n4 = 0;
            while (n4 < n2) {
                if (typeBindingArray2[n4] != typeBindingArray[n4]) continue block0;
                ++n4;
            }
            return methodBinding;
        }
        return null;
    }

    public MethodBinding getExactMethod(char[] cArray, TypeBinding[] typeBindingArray, CompilationUnitScope compilationUnitScope) {
        int n2 = typeBindingArray.length;
        int n3 = cArray.length;
        boolean bl2 = true;
        int n4 = this.methods.length;
        block0: while (--n4 >= 0) {
            MethodBinding methodBinding = this.methods[n4];
            if (methodBinding.selector.length != n3 || !CharOperation.equals(methodBinding.selector, cArray)) continue;
            bl2 = false;
            if (methodBinding.parameters.length != n2) continue;
            this.a(methodBinding);
            TypeBinding[] typeBindingArray2 = methodBinding.parameters;
            int n5 = 0;
            while (n5 < n2) {
                if (typeBindingArray2[n5] != typeBindingArray[n5]) continue block0;
                ++n5;
            }
            return methodBinding;
        }
        if (bl2) {
            if (this.isInterface()) {
                if (this.superInterfaces().length == 1) {
                    if (compilationUnitScope != null) {
                        compilationUnitScope.b(this.superInterfaces[0]);
                    }
                    return this.superInterfaces[0].getExactMethod(cArray, typeBindingArray, compilationUnitScope);
                }
            } else if (this.superclass() != null) {
                if (compilationUnitScope != null) {
                    compilationUnitScope.b(this.superclass);
                }
                return this.superclass.getExactMethod(cArray, typeBindingArray, compilationUnitScope);
            }
        }
        return null;
    }

    public FieldBinding getField(char[] cArray, boolean bl2) {
        int n2 = cArray.length;
        int n3 = this.fields.length;
        while (--n3 >= 0) {
            char[] cArray2 = this.fields[n3].name;
            if (cArray2.length != n2 || !CharOperation.equals(cArray2, cArray)) continue;
            return bl2 ? this.resolveTypeFor(this.fields[n3]) : this.fields[n3];
        }
        return null;
    }

    public ReferenceBinding getMemberType(char[] cArray) {
        int n2 = this.memberTypes.length;
        while (--n2 >= 0) {
            ReferenceBinding referenceBinding = this.memberTypes[n2];
            if (referenceBinding instanceof UnresolvedReferenceBinding) {
                char[] cArray2 = referenceBinding.sourceName;
                int n3 = this.compoundName[this.compoundName.length - 1].length + 1;
                if (cArray2.length != n3 + cArray.length || !CharOperation.fragmentEquals(cArray, cArray2, n3, true)) continue;
                this.memberTypes[n2] = BinaryTypeBinding.resolveType(referenceBinding, this.environment, false);
                return this.memberTypes[n2];
            }
            if (!CharOperation.equals(cArray, referenceBinding.sourceName)) continue;
            return referenceBinding;
        }
        return null;
    }

    public MethodBinding[] getMethods(char[] cArray) {
        MethodBinding methodBinding;
        int n2 = 0;
        int n3 = -1;
        int n4 = cArray.length;
        int n5 = 0;
        int n6 = this.methods.length;
        while (n5 < n6) {
            methodBinding = this.methods[n5];
            if (methodBinding.selector.length == n4 && CharOperation.equals(methodBinding.selector, cArray)) {
                this.a(methodBinding);
                ++n2;
                n3 = n5;
            }
            ++n5;
        }
        if (n2 == 1) {
            return new MethodBinding[]{this.methods[n3]};
        }
        if (n2 > 0) {
            MethodBinding[] methodBindingArray = new MethodBinding[n2];
            n2 = 0;
            n6 = 0;
            while (n6 <= n3) {
                methodBinding = this.methods[n6];
                if (methodBinding.selector.length == n4 && CharOperation.equals(methodBinding.selector, cArray)) {
                    methodBindingArray[n2++] = methodBinding;
                }
                ++n6;
            }
            return methodBindingArray;
        }
        return NoMethods;
    }

    public boolean hasMemberTypes() {
        return this.memberTypes.length > 0;
    }

    public TypeVariableBinding getTypeVariable(char[] cArray) {
        TypeVariableBinding typeVariableBinding = super.getTypeVariable(cArray);
        typeVariableBinding.a(this.environment);
        return typeVariableBinding;
    }

    private void initializeTypeVariable(TypeVariableBinding typeVariableBinding, TypeVariableBinding[] typeVariableBindingArray, SignatureWrapper signatureWrapper) {
        ReferenceBinding referenceBinding;
        int n2 = CharOperation.indexOf(':', signatureWrapper.signature, signatureWrapper.start);
        signatureWrapper.start = n2 + 1;
        ReferenceBinding referenceBinding2 = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            referenceBinding = this.environment.getType(JAVA_LANG_OBJECT);
        } else {
            referenceBinding2 = referenceBinding = (ReferenceBinding)this.environment.a(signatureWrapper, typeVariableBindingArray, this);
        }
        typeVariableBinding.modifiers |= 0x2000000;
        typeVariableBinding.superclass = referenceBinding;
        ReferenceBinding[] referenceBindingArray = null;
        if (signatureWrapper.signature[signatureWrapper.start] == ':') {
            ArrayList<TypeBinding> arrayList = new ArrayList<TypeBinding>(2);
            do {
                ++signatureWrapper.start;
                arrayList.add(this.environment.a(signatureWrapper, typeVariableBindingArray, this));
            } while (signatureWrapper.signature[signatureWrapper.start] == ':');
            referenceBindingArray = new ReferenceBinding[arrayList.size()];
            arrayList.toArray(referenceBindingArray);
        }
        ReferenceBinding[] referenceBindingArray2 = typeVariableBinding.superInterfaces = referenceBindingArray == null ? NoSuperInterfaces : referenceBindingArray;
        if (referenceBinding2 == null) {
            referenceBinding2 = typeVariableBinding.superInterfaces.length == 0 ? null : typeVariableBinding.superInterfaces[0];
            typeVariableBinding.modifiers |= 0x200;
        }
        typeVariableBinding.firstBound = referenceBinding2;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        switch (typeBinding.kind()) {
            case 516: {
                return ((WildcardBinding)typeBinding).boundCheck(this);
            }
            case 1028: {
                return typeBinding.erasure() == this;
            }
        }
        return false;
    }

    public boolean isGenericType() {
        return this.typeVariables != NoTypeVariables;
    }

    public int kind() {
        if (this.typeVariables != NoTypeVariables) {
            return 2052;
        }
        return 4;
    }

    public ReferenceBinding[] memberTypes() {
        if ((this.tagBits & 0x10000000L) == 0L) {
            return this.memberTypes;
        }
        int n2 = this.memberTypes.length;
        while (--n2 >= 0) {
            this.memberTypes[n2] = BinaryTypeBinding.a(this.memberTypes[n2], this.environment, false);
        }
        this.tagBits &= 0xFFFFFFFFEFFFFFFFL;
        n2 = this.memberTypes.length;
        while (--n2 >= 0) {
            this.memberTypes[n2] = BinaryTypeBinding.resolveType(this.memberTypes[n2], this.environment, false);
        }
        return this.memberTypes;
    }

    public MethodBinding[] methods() {
        if ((this.tagBits & 0x2000L) != 0L) {
            return this.methods;
        }
        int n2 = this.methods.length;
        while (--n2 >= 0) {
            this.a(this.methods[n2]);
        }
        this.tagBits |= 0x2000L;
        return this.methods;
    }

    private FieldBinding resolveTypeFor(FieldBinding fieldBinding) {
        if ((fieldBinding.modifiers & 0x2000000) == 0) {
            return fieldBinding;
        }
        fieldBinding.type = BinaryTypeBinding.resolveType(fieldBinding.type, this.environment, null, 0);
        fieldBinding.modifiers &= 0xFDFFFFFF;
        return fieldBinding;
    }

    public MethodBinding a(MethodBinding methodBinding) {
        if ((methodBinding.modifiers & 0x2000000) == 0) {
            return methodBinding;
        }
        if (!methodBinding.isConstructor()) {
            methodBinding.returnType = BinaryTypeBinding.resolveType(methodBinding.returnType, this.environment, null, 0);
        }
        int n2 = methodBinding.parameters.length;
        while (--n2 >= 0) {
            methodBinding.parameters[n2] = BinaryTypeBinding.resolveType(methodBinding.parameters[n2], this.environment, null, 0);
        }
        n2 = methodBinding.thrownExceptions.length;
        while (--n2 >= 0) {
            methodBinding.thrownExceptions[n2] = BinaryTypeBinding.resolveType(methodBinding.thrownExceptions[n2], this.environment, true);
        }
        n2 = methodBinding.typeVariables.length;
        while (--n2 >= 0) {
            methodBinding.typeVariables[n2].a(this.environment);
        }
        methodBinding.modifiers &= 0xFDFFFFFF;
        return methodBinding;
    }

    public ReferenceBinding superclass() {
        if ((this.tagBits & 0x2000000L) == 0L) {
            return this.superclass;
        }
        this.superclass = BinaryTypeBinding.a(this.superclass, this.environment, true);
        this.tagBits &= 0xFFFFFFFFFDFFFFFFL;
        this.superclass = BinaryTypeBinding.resolveType(this.superclass, this.environment, true);
        return this.superclass;
    }

    public ReferenceBinding[] superInterfaces() {
        if ((this.tagBits & 0x4000000L) == 0L) {
            return this.superInterfaces;
        }
        int n2 = this.superInterfaces.length;
        while (--n2 >= 0) {
            this.superInterfaces[n2] = BinaryTypeBinding.a(this.superInterfaces[n2], this.environment, true);
        }
        this.tagBits &= 0xFFFFFFFFFBFFFFFFL;
        n2 = this.superInterfaces.length;
        while (--n2 >= 0) {
            this.superInterfaces[n2] = BinaryTypeBinding.resolveType(this.superInterfaces[n2], this.environment, true);
        }
        return this.superInterfaces;
    }

    public TypeVariableBinding[] typeVariables() {
        if ((this.tagBits & 0x1000000L) == 0L) {
            return this.typeVariables;
        }
        int n2 = this.typeVariables.length;
        while (--n2 >= 0) {
            this.typeVariables[n2].a(this.environment);
        }
        this.tagBits &= 0xFFFFFFFFFEFFFFFFL;
        return this.typeVariables;
    }

    public String toString() {
        int n2;
        int n3;
        StringBuffer stringBuffer = new StringBuffer();
        if (this.isDeprecated()) {
            stringBuffer.append("deprecated ");
        }
        if (this.isPublic()) {
            stringBuffer.append("public ");
        }
        if (this.isProtected()) {
            stringBuffer.append("protected ");
        }
        if (this.isPrivate()) {
            stringBuffer.append("private ");
        }
        if (this.isAbstract() && this.isClass()) {
            stringBuffer.append("abstract ");
        }
        if (this.isStatic() && this.isNestedType()) {
            stringBuffer.append("static ");
        }
        if (this.isFinal()) {
            stringBuffer.append("final ");
        }
        if (this.isEnum()) {
            stringBuffer.append("enum ");
        } else if (this.isAnnotationType()) {
            stringBuffer.append("@interface ");
        } else if (this.isClass()) {
            stringBuffer.append("class ");
        } else {
            stringBuffer.append("interface ");
        }
        stringBuffer.append(this.compoundName != null ? CharOperation.toString(this.compoundName) : "UNNAMED TYPE");
        stringBuffer.append("\n\textends ");
        stringBuffer.append(this.superclass != null ? this.superclass.debugName() : "NULL TYPE");
        if (this.superInterfaces != null) {
            if (this.superInterfaces != NoSuperInterfaces) {
                stringBuffer.append("\n\timplements : ");
                n3 = 0;
                n2 = this.superInterfaces.length;
                while (n3 < n2) {
                    if (n3 > 0) {
                        stringBuffer.append(", ");
                    }
                    stringBuffer.append(this.superInterfaces[n3] != null ? this.superInterfaces[n3].debugName() : "NULL TYPE");
                    ++n3;
                }
            }
        } else {
            stringBuffer.append("NULL SUPERINTERFACES");
        }
        if (this.enclosingType != null) {
            stringBuffer.append("\n\tenclosing type : ");
            stringBuffer.append(this.enclosingType.debugName());
        }
        if (this.fields != null) {
            if (this.fields != NoFields) {
                stringBuffer.append("\n/*   fields   */");
                n3 = 0;
                n2 = this.fields.length;
                while (n3 < n2) {
                    stringBuffer.append(this.fields[n3] != null ? "\n" + this.fields[n3].toString() : "\nNULL FIELD");
                    ++n3;
                }
            }
        } else {
            stringBuffer.append("NULL FIELDS");
        }
        if (this.methods != null) {
            if (this.methods != NoMethods) {
                stringBuffer.append("\n/*   methods   */");
                n3 = 0;
                n2 = this.methods.length;
                while (n3 < n2) {
                    stringBuffer.append(this.methods[n3] != null ? "\n" + this.methods[n3].toString() : "\nNULL METHOD");
                    ++n3;
                }
            }
        } else {
            stringBuffer.append("NULL METHODS");
        }
        if (this.memberTypes != null) {
            if (this.memberTypes != NoMemberTypes) {
                stringBuffer.append("\n/*   members   */");
                n3 = 0;
                n2 = this.memberTypes.length;
                while (n3 < n2) {
                    stringBuffer.append(this.memberTypes[n3] != null ? "\n" + this.memberTypes[n3].toString() : "\nNULL TYPE");
                    ++n3;
                }
            }
        } else {
            stringBuffer.append("NULL MEMBER TYPES");
        }
        stringBuffer.append("\n\n\n");
        return stringBuffer.toString();
    }

    public MethodBinding[] a() {
        return this.methods;
    }
}

