/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.Substitution;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public class CaptureBinding
extends TypeVariableBinding {
    public TypeBinding lowerBound;
    public WildcardBinding wildcard;
    public ReferenceBinding sourceType;
    public int position;

    public CaptureBinding(WildcardBinding wildcardBinding, ReferenceBinding referenceBinding, int n2) {
        super(WILDCARD_CAPTURE_NAME, null, 0);
        this.wildcard = wildcardBinding;
        this.modifiers = 0x40000001;
        this.fPackage = wildcardBinding.fPackage;
        this.sourceType = referenceBinding;
        this.position = n2;
    }

    public char[] computeUniqueKey(boolean bl2) {
        StringBuffer stringBuffer = new StringBuffer();
        if (bl2) {
            stringBuffer.append(this.sourceType.computeUniqueKey(false));
            stringBuffer.append('&');
        }
        stringBuffer.append(WILDCARD_CAPTURE);
        stringBuffer.append(this.wildcard.computeUniqueKey(false));
        stringBuffer.append(this.position);
        stringBuffer.append(';');
        int n2 = stringBuffer.length();
        char[] cArray = new char[n2];
        stringBuffer.getChars(0, n2, cArray, 0);
        return cArray;
    }

    public String debugName() {
        if (this.wildcard != null) {
            return String.valueOf(String.valueOf(TypeConstants.WILDCARD_CAPTURE_NAME)) + this.wildcard.debugName();
        }
        return super.debugName();
    }

    public char[] genericTypeSignature() {
        if (this.genericTypeSignature == null) {
            this.genericTypeSignature = CharOperation.concat(WILDCARD_CAPTURE, this.wildcard.genericTypeSignature());
        }
        return this.genericTypeSignature;
    }

    public void initializeBounds(ParameterizedTypeBinding parameterizedTypeBinding) {
        int n2;
        ReferenceBinding[] referenceBindingArray;
        ReferenceBinding[] referenceBindingArray2;
        TypeVariableBinding typeVariableBinding = this.wildcard.typeVariable();
        ReferenceBinding referenceBinding = typeVariableBinding.superclass;
        ReferenceBinding referenceBinding2 = (ReferenceBinding)Scope.substitute((Substitution)parameterizedTypeBinding, referenceBinding);
        if (referenceBinding2 == this) {
            referenceBinding2 = referenceBinding;
        }
        if ((referenceBindingArray2 = Scope.substitute((Substitution)parameterizedTypeBinding, referenceBindingArray = typeVariableBinding.superInterfaces())) != referenceBindingArray) {
            int n3 = 0;
            n2 = referenceBindingArray2.length;
            while (n3 < n2) {
                if (referenceBindingArray2[n3] == this) {
                    referenceBindingArray2[n3] = referenceBindingArray[n3];
                }
                ++n3;
            }
        }
        TypeBinding typeBinding = this.wildcard.bound;
        switch (this.wildcard.boundKind) {
            case 1: {
                if (this.wildcard.bound.isInterface()) {
                    this.superclass = referenceBinding2;
                    if (referenceBindingArray2 == NoSuperInterfaces) {
                        this.superInterfaces = new ReferenceBinding[]{(ReferenceBinding)typeBinding};
                    } else {
                        n2 = referenceBindingArray2.length;
                        ReferenceBinding[] referenceBindingArray3 = referenceBindingArray2;
                        referenceBindingArray2 = new ReferenceBinding[n2 + 1];
                        System.arraycopy(referenceBindingArray3, 0, referenceBindingArray2, 1, n2);
                        referenceBindingArray2[0] = (ReferenceBinding)typeBinding;
                        this.superInterfaces = Scope.greaterLowerBound(referenceBindingArray2);
                    }
                } else {
                    this.superclass = this.wildcard.bound.isArrayType() ? referenceBinding2 : (ReferenceBinding)typeBinding;
                    this.superInterfaces = referenceBindingArray2;
                }
                this.firstBound = typeBinding;
                if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 0: {
                this.superclass = referenceBinding2;
                this.superInterfaces = referenceBindingArray2;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
                break;
            }
            case 2: {
                this.superclass = referenceBinding2;
                if (typeVariableBinding.firstBound == referenceBinding2 || typeBinding == referenceBinding2) {
                    this.firstBound = referenceBinding2;
                }
                this.superInterfaces = referenceBindingArray2;
                this.lowerBound = typeBinding;
                if ((typeBinding.tagBits & 0x20000000L) != 0L) break;
                this.tagBits &= 0xFFFFFFFFDFFFFFFFL;
            }
        }
    }

    public boolean isCapture() {
        return true;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (this.firstBound != null && this.firstBound.isArrayType() && this.firstBound.isCompatibleWith(typeBinding)) {
            return true;
        }
        if (typeBinding.isWildcard()) {
            return ((WildcardBinding)typeBinding).boundCheck(this);
        }
        return false;
    }

    public char[] readableName() {
        if (this.wildcard != null) {
            return CharOperation.concat(TypeConstants.WILDCARD_CAPTURE_NAME, this.wildcard.readableName());
        }
        return super.readableName();
    }

    public char[] shortReadableName() {
        if (this.wildcard != null) {
            return CharOperation.concat(TypeConstants.WILDCARD_CAPTURE_NAME, this.wildcard.shortReadableName());
        }
        return super.shortReadableName();
    }

    public String toString() {
        if (this.wildcard != null) {
            return String.valueOf(String.valueOf(TypeConstants.WILDCARD_CAPTURE_NAME)) + this.wildcard.toString();
        }
        return super.toString();
    }
}

