/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.ArrayBinding;
import org.eclipse.jdt.internal.compiler.lookup.InvocationSite;
import org.eclipse.jdt.internal.compiler.lookup.MethodScope;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.SourceTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.VariableBinding;

public class FieldBinding
extends VariableBinding {
    public ReferenceBinding declaringClass;

    public FieldBinding() {
        super(null, null, 0, null);
    }

    public FieldBinding(char[] cArray, TypeBinding typeBinding, int n2, ReferenceBinding referenceBinding, Constant constant) {
        super(cArray, typeBinding, n2, constant);
        this.declaringClass = referenceBinding;
    }

    public FieldBinding(FieldDeclaration fieldDeclaration, TypeBinding typeBinding, int n2, ReferenceBinding referenceBinding) {
        this(fieldDeclaration.name, typeBinding, n2, referenceBinding, null);
        fieldDeclaration.binding = this;
    }

    public FieldBinding(FieldBinding fieldBinding, ReferenceBinding referenceBinding) {
        super(fieldBinding.name, fieldBinding.type, fieldBinding.modifiers, fieldBinding.constant());
        this.declaringClass = referenceBinding;
        this.id = fieldBinding.id;
    }

    public final int kind() {
        return 1;
    }

    public final boolean canBeSeenBy(PackageBinding packageBinding) {
        if (this.isPublic()) {
            return true;
        }
        if (this.isPrivate()) {
            return false;
        }
        return packageBinding == this.declaringClass.getPackage();
    }

    public final boolean canBeSeenBy(TypeBinding typeBinding, InvocationSite invocationSite, Scope scope) {
        if (this.isPublic()) {
            return true;
        }
        SourceTypeBinding sourceTypeBinding = scope.enclosingSourceType();
        if (sourceTypeBinding == this.declaringClass && sourceTypeBinding == typeBinding) {
            return true;
        }
        if (this.isProtected()) {
            if (sourceTypeBinding == this.declaringClass) {
                return true;
            }
            if (sourceTypeBinding.fPackage == this.declaringClass.fPackage) {
                return true;
            }
            ReferenceBinding referenceBinding = sourceTypeBinding;
            int n2 = 0;
            ReferenceBinding referenceBinding2 = (ReferenceBinding)typeBinding.erasure();
            ReferenceBinding referenceBinding3 = (ReferenceBinding)this.declaringClass.erasure();
            do {
                if (referenceBinding.findSuperTypeWithSameErasure(referenceBinding3) != null) {
                    if (invocationSite.isSuperAccess()) {
                        return true;
                    }
                    if (typeBinding instanceof ArrayBinding) {
                        return false;
                    }
                    if (this.isStatic()) {
                        if (n2 > 0) {
                            invocationSite.setDepth(n2);
                        }
                        return true;
                    }
                    if (referenceBinding == referenceBinding2 || referenceBinding2.findSuperTypeWithSameErasure(referenceBinding) != null) {
                        if (n2 > 0) {
                            invocationSite.setDepth(n2);
                        }
                        return true;
                    }
                }
                ++n2;
            } while ((referenceBinding = referenceBinding.enclosingType()) != null);
            return false;
        }
        if (this.isPrivate()) {
            if (!(typeBinding == this.declaringClass || typeBinding.isTypeVariable() && ((TypeVariableBinding)typeBinding).isErasureBoundTo(this.declaringClass.erasure()))) {
                return false;
            }
            if (sourceTypeBinding != this.declaringClass) {
                ReferenceBinding referenceBinding = sourceTypeBinding;
                ReferenceBinding referenceBinding4 = referenceBinding.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                ReferenceBinding referenceBinding5 = (ReferenceBinding)this.declaringClass.erasure();
                referenceBinding4 = referenceBinding5.enclosingType();
                while (referenceBinding4 != null) {
                    referenceBinding5 = referenceBinding4;
                    referenceBinding4 = referenceBinding4.enclosingType();
                }
                if (referenceBinding != referenceBinding5) {
                    return false;
                }
            }
            return true;
        }
        if (sourceTypeBinding.fPackage != this.declaringClass.fPackage) {
            return false;
        }
        if (typeBinding instanceof ArrayBinding) {
            return false;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        PackageBinding packageBinding = this.declaringClass.fPackage;
        do {
            if (this.declaringClass == referenceBinding) {
                return true;
            }
            if (packageBinding == referenceBinding.fPackage) continue;
            return false;
        } while ((referenceBinding = referenceBinding.superclass()) != null);
        return false;
    }

    public char[] computeUniqueKey(boolean bl2) {
        char[] cArray;
        char[] cArray2 = this.declaringClass == null ? CharOperation.NO_CHAR : this.declaringClass.computeUniqueKey(false);
        int n2 = cArray2.length;
        int n3 = this.name.length;
        if (this.type == null) {
            char[] cArray3 = new char[1];
            cArray = cArray3;
            cArray3[0] = 86;
        } else {
            cArray = this.type.computeUniqueKey(false);
        }
        char[] cArray4 = cArray;
        int n4 = cArray4.length;
        char[] cArray5 = new char[n2 + 1 + n3 + 1 + n4];
        int n5 = 0;
        System.arraycopy(cArray2, 0, cArray5, n5, n2);
        n5 += n2;
        cArray5[n5++] = 46;
        System.arraycopy(this.name, 0, cArray5, n5, n3);
        n5 += n3;
        cArray5[n5++] = 41;
        System.arraycopy(cArray4, 0, cArray5, n5, n4);
        return cArray5;
    }

    public char[] genericSignature() {
        if ((this.modifiers & 0x40000000) == 0) {
            return null;
        }
        return this.type.genericTypeSignature();
    }

    public final int getAccessFlags() {
        return this.modifiers & 0xFFFF;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public long getAnnotationTagBits() {
        FieldBinding fieldBinding = this.original();
        if ((fieldBinding.tagBits & 0x200000000L) != 0L) return fieldBinding.tagBits;
        if (!(fieldBinding.declaringClass instanceof SourceTypeBinding)) return fieldBinding.tagBits;
        TypeDeclaration typeDeclaration = ((SourceTypeBinding)fieldBinding.declaringClass).scope.referenceContext;
        FieldDeclaration fieldDeclaration = typeDeclaration.declarationOf(fieldBinding);
        if (fieldDeclaration == null) return fieldBinding.tagBits;
        MethodScope methodScope = this.isStatic() ? typeDeclaration.staticInitializerScope : typeDeclaration.initializerScope;
        FieldBinding fieldBinding2 = methodScope.initializedField;
        int n2 = methodScope.lastVisibleFieldID;
        try {
            methodScope.initializedField = fieldBinding;
            methodScope.lastVisibleFieldID = fieldBinding.id;
            ASTNode.resolveAnnotations(methodScope, fieldDeclaration.annotations, fieldBinding);
        }
        catch (Throwable throwable) {
            Object var7_8 = null;
            methodScope.initializedField = fieldBinding2;
            methodScope.lastVisibleFieldID = n2;
            throw throwable;
        }
        {
            Object var7_9 = null;
            methodScope.initializedField = fieldBinding2;
            methodScope.lastVisibleFieldID = n2;
            return fieldBinding.tagBits;
        }
    }

    public final boolean isDefault() {
        return !this.isPublic() && !this.isProtected() && !this.isPrivate();
    }

    public final boolean isDeprecated() {
        return (this.modifiers & 0x100000) != 0;
    }

    public final boolean isPrivate() {
        return (this.modifiers & 2) != 0;
    }

    public final boolean isUsed() {
        return (this.modifiers & 0x8000000) != 0;
    }

    public final boolean isProtected() {
        return (this.modifiers & 4) != 0;
    }

    public final boolean isPublic() {
        return (this.modifiers & 1) != 0;
    }

    public final boolean isStatic() {
        return (this.modifiers & 8) != 0;
    }

    public final boolean isSynthetic() {
        return (this.modifiers & 0x1000) != 0;
    }

    public final boolean isTransient() {
        return (this.modifiers & 0x80) != 0;
    }

    public final boolean isViewedAsDeprecated() {
        return (this.modifiers & 0x300000) != 0;
    }

    public final boolean isVolatile() {
        return (this.modifiers & 0x40) != 0;
    }

    public FieldBinding original() {
        return this;
    }

    public FieldDeclaration sourceField() {
        SourceTypeBinding sourceTypeBinding;
        try {
            sourceTypeBinding = (SourceTypeBinding)this.declaringClass;
        }
        catch (ClassCastException classCastException) {
            return null;
        }
        FieldDeclaration[] fieldDeclarationArray = sourceTypeBinding.scope.referenceContext.fields;
        if (fieldDeclarationArray != null) {
            int n2 = fieldDeclarationArray.length;
            while (--n2 >= 0) {
                if (this != fieldDeclarationArray[n2].binding) continue;
                return fieldDeclarationArray[n2];
            }
        }
        return null;
    }
}

