/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import java.util.Map;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.CaptureBinding;
import org.eclipse.jdt.internal.compiler.lookup.LookupEnvironment;
import org.eclipse.jdt.internal.compiler.lookup.PackageBinding;
import org.eclipse.jdt.internal.compiler.lookup.ParameterizedTypeBinding;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.Scope;
import org.eclipse.jdt.internal.compiler.lookup.TagBits;
import org.eclipse.jdt.internal.compiler.lookup.TypeConstants;
import org.eclipse.jdt.internal.compiler.lookup.TypeIds;
import org.eclipse.jdt.internal.compiler.lookup.TypeVariableBinding;
import org.eclipse.jdt.internal.compiler.lookup.UnresolvedReferenceBinding;
import org.eclipse.jdt.internal.compiler.lookup.WildcardBinding;

public abstract class TypeBinding
extends Binding
implements BaseTypes,
TagBits,
TypeConstants,
TypeIds {
    public int id = Integer.MAX_VALUE;
    public long tagBits = 0L;

    public static final TypeBinding wellKnownType(Scope scope, int n2) {
        switch (n2) {
            case 5: {
                return BooleanBinding;
            }
            case 3: {
                return ByteBinding;
            }
            case 2: {
                return CharBinding;
            }
            case 4: {
                return ShortBinding;
            }
            case 8: {
                return DoubleBinding;
            }
            case 9: {
                return FloatBinding;
            }
            case 10: {
                return IntBinding;
            }
            case 7: {
                return LongBinding;
            }
            case 1: {
                return scope.getJavaLangObject();
            }
            case 11: {
                return scope.getJavaLangString();
            }
        }
        return null;
    }

    public int kind() {
        return 4;
    }

    public boolean canBeInstantiated() {
        return !this.isBaseType();
    }

    public TypeBinding capture(Scope scope, int n2) {
        return this;
    }

    public void collectSubstitutes(Scope scope, TypeBinding typeBinding, Map map, int n2) {
    }

    public abstract char[] constantPoolName();

    public String debugName() {
        return new String(this.readableName());
    }

    public int dimensions() {
        return 0;
    }

    public ReferenceBinding enclosingType() {
        return null;
    }

    public TypeBinding erasure() {
        return this;
    }

    public TypeBinding genericCast(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return null;
        }
        TypeBinding typeBinding2 = typeBinding.erasure();
        if (typeBinding2 == this.erasure()) {
            return null;
        }
        return typeBinding2;
    }

    public char[] genericTypeSignature() {
        return this.signature();
    }

    public abstract PackageBinding getPackage();

    public final boolean isAnonymousType() {
        return (this.tagBits & 0x20L) != 0L;
    }

    public boolean isAnnotationType() {
        return false;
    }

    public final boolean isArrayType() {
        return (this.tagBits & 1L) != 0L;
    }

    public final boolean isBaseType() {
        return (this.tagBits & 2L) != 0L;
    }

    public boolean isBoundParameterizedType() {
        return (this.tagBits & 0x800000L) != 0L;
    }

    public boolean isCapture() {
        return false;
    }

    public boolean isClass() {
        return false;
    }

    public abstract boolean isCompatibleWith(TypeBinding var1);

    public boolean isEnum() {
        return false;
    }

    public boolean isEquivalentTo(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        if (typeBinding == null) {
            return false;
        }
        if (typeBinding.isWildcard()) {
            return ((WildcardBinding)typeBinding).boundCheck(this);
        }
        return false;
    }

    public boolean isGenericType() {
        return false;
    }

    public final boolean isHierarchyInconsistent() {
        return (this.tagBits & 0x8000L) != 0L;
    }

    public boolean isInterface() {
        return false;
    }

    public boolean isIntersectingWith(TypeBinding typeBinding) {
        return this == typeBinding;
    }

    public boolean isIntersectionType() {
        return false;
    }

    public final boolean isLocalType() {
        return (this.tagBits & 0x10L) != 0L;
    }

    public final boolean isMemberType() {
        return (this.tagBits & 8L) != 0L;
    }

    public final boolean isNestedType() {
        return (this.tagBits & 4L) != 0L;
    }

    public final boolean isNumericType() {
        switch (this.id) {
            case 2: 
            case 3: 
            case 4: 
            case 7: 
            case 8: 
            case 9: 
            case 10: {
                return true;
            }
        }
        return false;
    }

    public boolean isParameterizedType() {
        return false;
    }

    public boolean isProvablyDistinctFrom(TypeBinding typeBinding, int n2) {
        if (this == typeBinding) {
            return false;
        }
        if (n2 > 1) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
        }
        switch (this.kind()) {
            case 516: 
            case 4100: {
                return false;
            }
            case 260: {
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                if (parameterizedTypeBinding.type.isProvablyDistinctFrom(typeBinding.erasure(), n2)) {
                    return true;
                }
                switch (typeBinding.kind()) {
                    case 1028: 
                    case 2052: {
                        return false;
                    }
                    case 260: {
                        TypeBinding[] typeBindingArray = parameterizedTypeBinding.arguments;
                        if (typeBindingArray == null) {
                            return false;
                        }
                        ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                        TypeBinding[] typeBindingArray2 = parameterizedTypeBinding2.arguments;
                        if (typeBindingArray2 == null) {
                            return false;
                        }
                        int n3 = 0;
                        int n4 = typeBindingArray.length;
                        while (n3 < n4) {
                            if (typeBindingArray[n3].isProvablyDistinctFrom(typeBindingArray2[n3], n2 + 1)) {
                                return true;
                            }
                            ++n3;
                        }
                        return false;
                    }
                }
                break;
            }
            case 1028: {
                return this.erasure().isProvablyDistinctFrom(typeBinding.erasure(), 0);
            }
            case 2052: {
                return this != typeBinding.erasure();
            }
        }
        return this != typeBinding;
    }

    public boolean isRawType() {
        return false;
    }

    public boolean isReifiable() {
        TypeBinding typeBinding = this.leafComponentType();
        if (!(typeBinding instanceof ReferenceBinding)) {
            return true;
        }
        ReferenceBinding referenceBinding = (ReferenceBinding)typeBinding;
        do {
            switch (referenceBinding.kind()) {
                case 516: 
                case 2052: 
                case 4100: {
                    return false;
                }
                case 260: {
                    if (!referenceBinding.isBoundParameterizedType()) break;
                    return false;
                }
                case 1028: {
                    return true;
                }
            }
            if (!referenceBinding.isStatic()) continue;
            return true;
        } while ((referenceBinding = referenceBinding.enclosingType()) != null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    public boolean isTypeArgumentContainedBy(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (typeBinding.kind()) {
            case 516: {
                WildcardBinding wildcardBinding;
                TypeBinding typeBinding2 = this;
                TypeBinding typeBinding3 = this;
                switch (this.kind()) {
                    case 516: {
                        wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                typeBinding3 = wildcardBinding.bound;
                                typeBinding2 = null;
                                break;
                            }
                            case 2: {
                                typeBinding3 = wildcardBinding;
                                typeBinding2 = wildcardBinding.bound;
                                break;
                            }
                            case 0: {
                                typeBinding3 = wildcardBinding;
                                typeBinding2 = null;
                                break;
                            }
                        }
                        break;
                    }
                    case 4100: {
                        if (!this.isCapture()) break;
                        CaptureBinding captureBinding = (CaptureBinding)this;
                        if (captureBinding.lowerBound == null) break;
                        typeBinding2 = captureBinding.lowerBound;
                        break;
                    }
                }
                wildcardBinding = (WildcardBinding)typeBinding;
                if (wildcardBinding.otherBounds != null) {
                    return false;
                }
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        if (wildcardBinding.bound == this) {
                            return true;
                        }
                        if (typeBinding3 == null) return false;
                        if (!typeBinding3.isCompatibleWith(wildcardBinding.bound)) return false;
                        return true;
                    }
                    case 2: {
                        if (wildcardBinding.bound == this) {
                            return true;
                        }
                        if (typeBinding2 == null) return false;
                        if (!wildcardBinding.bound.isCompatibleWith(typeBinding2)) return false;
                        return true;
                    }
                }
                return true;
            }
            case 260: {
                int n2;
                TypeBinding[] typeBindingArray;
                ReferenceBinding referenceBinding;
                if (!this.isParameterizedType()) {
                    return false;
                }
                ParameterizedTypeBinding parameterizedTypeBinding = (ParameterizedTypeBinding)this;
                ParameterizedTypeBinding parameterizedTypeBinding2 = (ParameterizedTypeBinding)typeBinding;
                if (parameterizedTypeBinding.type != parameterizedTypeBinding2.type) {
                    return false;
                }
                if (!parameterizedTypeBinding.isStatic() && (referenceBinding = this.enclosingType()) != null) {
                    typeBindingArray = parameterizedTypeBinding2.enclosingType();
                    if (typeBindingArray == null) {
                        return false;
                    }
                    if ((typeBindingArray.tagBits & 0x40000000L) == 0L ? referenceBinding != typeBindingArray : !referenceBinding.isEquivalentTo(parameterizedTypeBinding2.enclosingType())) {
                        return false;
                    }
                }
                int n3 = parameterizedTypeBinding.arguments == null ? 0 : parameterizedTypeBinding.arguments.length;
                typeBindingArray = parameterizedTypeBinding2.arguments;
                int n4 = n2 = typeBindingArray == null ? 0 : typeBindingArray.length;
                if (n2 != n3) {
                    return false;
                }
                int n5 = 0;
                while (n5 < n3) {
                    TypeBinding typeBinding4 = parameterizedTypeBinding.arguments[n5];
                    TypeBinding typeBinding5 = typeBindingArray[n5];
                    if (typeBinding4 != typeBinding5) {
                        int n6 = typeBinding4.kind();
                        if (typeBinding5.kind() != n6) {
                            return false;
                        }
                        block17 : switch (n6) {
                            case 260: {
                                if (!typeBinding4.isTypeArgumentContainedBy(typeBinding5)) return false;
                                break;
                            }
                            case 516: {
                                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding4;
                                WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding5;
                                switch (wildcardBinding.boundKind) {
                                    case 1: {
                                        if (wildcardBinding2.boundKind != 0) return false;
                                        if (wildcardBinding.bound != wildcardBinding.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                    case 2: {
                                        break;
                                    }
                                    case 0: {
                                        if (wildcardBinding2.boundKind != 1) return false;
                                        if (wildcardBinding2.bound != wildcardBinding2.typeVariable().upperBound()) return false;
                                        break block17;
                                    }
                                }
                            }
                            default: {
                                return false;
                            }
                        }
                    }
                    ++n5;
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeArgumentIntersecting(TypeBinding typeBinding) {
        if (this == typeBinding) {
            return true;
        }
        switch (this.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                switch (typeBinding.kind()) {
                    case 4100: {
                        return true;
                    }
                    case 516: {
                        TypeBinding typeBinding2 = null;
                        TypeBinding typeBinding3 = null;
                        WildcardBinding wildcardBinding = (WildcardBinding)this;
                        switch (wildcardBinding.boundKind) {
                            case 1: {
                                typeBinding3 = wildcardBinding.bound;
                                break;
                            }
                            case 2: {
                                typeBinding2 = wildcardBinding.bound;
                            }
                        }
                        TypeBinding typeBinding4 = null;
                        TypeBinding typeBinding5 = null;
                        WildcardBinding wildcardBinding2 = (WildcardBinding)typeBinding;
                        switch (wildcardBinding2.boundKind) {
                            case 1: {
                                typeBinding5 = wildcardBinding2.bound;
                                break;
                            }
                            case 2: {
                                typeBinding4 = wildcardBinding2.bound;
                            }
                        }
                        if (typeBinding2 != null) {
                            if (typeBinding4 != null) {
                                return true;
                            }
                            if (typeBinding5 != null) {
                                return typeBinding2.isCompatibleWith(typeBinding5);
                            }
                            return true;
                        }
                        if (typeBinding3 != null) {
                            if (typeBinding3.isTypeVariable()) {
                                return true;
                            }
                            if (typeBinding4 != null) {
                                return typeBinding4.isCompatibleWith(typeBinding3);
                            }
                            if (typeBinding5 != null) {
                                if (typeBinding3.isInterface()) {
                                    if (typeBinding5.isInterface()) {
                                        return true;
                                    }
                                    if (typeBinding5.isArrayType() || typeBinding5 instanceof ReferenceBinding && ((ReferenceBinding)typeBinding5).isFinal()) {
                                        return typeBinding5.isCompatibleWith(typeBinding3);
                                    }
                                    return true;
                                }
                                if (typeBinding5.isInterface()) {
                                    if (typeBinding3.isArrayType() || typeBinding3 instanceof ReferenceBinding && ((ReferenceBinding)typeBinding3).isFinal()) {
                                        return typeBinding3.isCompatibleWith(typeBinding5);
                                    }
                                } else {
                                    return typeBinding3.isCompatibleWith(typeBinding5);
                                }
                                return true;
                            }
                            return true;
                        }
                        return true;
                    }
                }
                WildcardBinding wildcardBinding = (WildcardBinding)this;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        return typeBinding.isCompatibleWith(wildcardBinding.bound);
                    }
                    case 2: {
                        return wildcardBinding.bound.isCompatibleWith(typeBinding);
                    }
                }
                return true;
            }
        }
        switch (typeBinding.kind()) {
            case 4100: {
                return true;
            }
            case 516: {
                WildcardBinding wildcardBinding = (WildcardBinding)typeBinding;
                switch (wildcardBinding.boundKind) {
                    case 1: {
                        return this.isCompatibleWith(wildcardBinding.bound);
                    }
                    case 2: {
                        return wildcardBinding.bound.isCompatibleWith(this);
                    }
                }
                return true;
            }
        }
        return false;
    }

    public boolean isTypeVariable() {
        return false;
    }

    public boolean isUnboundWildcard() {
        return false;
    }

    public boolean isUncheckedException(boolean bl2) {
        return false;
    }

    public boolean isWildcard() {
        return false;
    }

    /*
     * Unable to fully structure code
     */
    public boolean needsUncheckedConversion(TypeBinding var1_1) {
        if (this == var1_1) {
            return false;
        }
        if (!((var1_1 = var1_1.leafComponentType()) instanceof ReferenceBinding)) {
            return false;
        }
        var2_2 = this.leafComponentType();
        if (!(var2_2 instanceof ReferenceBinding)) {
            return false;
        }
        var3_3 = ((ReferenceBinding)var2_2).findSuperTypeWithSameErasure(var1_1);
        if (var3_3 != null) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            if (var1_1.isGenericType()) {
                return true;
            }
            if (var1_1.isBoundParameterizedType()) {
                return true;
            }
            if (var3_3.isStatic() || (var3_3 = var3_3.enclosingType()) == null || (var1_1 = var1_1.enclosingType()) == null) break;
lbl16:
            // 2 sources

            ** while (var3_3.isRawType())
        }
lbl17:
        // 2 sources

        return false;
    }

    public TypeBinding leafComponentType() {
        return this;
    }

    public char[] qualifiedPackageName() {
        PackageBinding packageBinding = this.getPackage();
        return packageBinding == null || packageBinding.compoundName == CharOperation.NO_CHAR_CHAR ? CharOperation.NO_CHAR : packageBinding.readableName();
    }

    public abstract char[] qualifiedSourceName();

    public char[] signature() {
        return this.constantPoolName();
    }

    public abstract char[] sourceName();

    public void swapUnresolved(UnresolvedReferenceBinding unresolvedReferenceBinding, ReferenceBinding referenceBinding, LookupEnvironment lookupEnvironment) {
    }

    public TypeVariableBinding[] typeVariables() {
        return NoTypeVariables;
    }
}

