/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.lookup;

import org.eclipse.jdt.internal.compiler.impl.Constant;
import org.eclipse.jdt.internal.compiler.lookup.Binding;
import org.eclipse.jdt.internal.compiler.lookup.TypeBinding;

public abstract class VariableBinding
extends Binding {
    public int modifiers;
    public TypeBinding type;
    public char[] name;
    private Constant constant;
    public int id;
    public long tagBits;

    public VariableBinding(char[] cArray, TypeBinding typeBinding, int n2, Constant constant) {
        this.name = cArray;
        this.type = typeBinding;
        this.modifiers = n2;
        this.constant = constant;
    }

    public Constant constant() {
        return this.constant;
    }

    public final boolean isBlankFinal() {
        return (this.modifiers & 0x4000000) != 0;
    }

    public boolean isConstantValue() {
        return this.constant != Constant.NotAConstant;
    }

    public final boolean isFinal() {
        return (this.modifiers & 0x10) != 0;
    }

    public char[] readableName() {
        return this.name;
    }

    public void setConstant(Constant constant) {
        this.constant = constant;
    }

    public String toString() {
        String string = this.type != null ? this.type.debugName() : "UNDEFINED TYPE";
        string = String.valueOf(string) + " ";
        string = String.valueOf(string) + (this.name != null ? new String(this.name) : "UNNAMED FIELD");
        return string;
    }
}

