/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.ast.ASTNode;
import org.eclipse.jdt.internal.compiler.ast.Argument;
import org.eclipse.jdt.internal.compiler.ast.Block;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.LocalDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Statement;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;
import org.eclipse.jdt.internal.compiler.lookup.BaseTypes;
import org.eclipse.jdt.internal.compiler.lookup.CompilerModifiers;
import org.eclipse.jdt.internal.compiler.parser.RecoveredElement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredInitializer;
import org.eclipse.jdt.internal.compiler.parser.RecoveredLocalVariable;
import org.eclipse.jdt.internal.compiler.parser.RecoveredMethod;
import org.eclipse.jdt.internal.compiler.parser.RecoveredStatement;
import org.eclipse.jdt.internal.compiler.parser.RecoveredType;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;

public class RecoveredBlock
extends RecoveredStatement
implements CompilerModifiers,
TerminalTokens,
BaseTypes {
    public Block blockDeclaration;
    public RecoveredStatement[] statements;
    public int statementCount;
    public boolean preserveContent = false;
    public RecoveredLocalVariable pendingArgument;

    public RecoveredBlock(Block block, RecoveredElement recoveredElement, int n2) {
        super(block, recoveredElement, n2);
        this.blockDeclaration = block;
        this.foundOpeningBrace = true;
    }

    public RecoveredElement add(Block block, int n2) {
        if (this.blockDeclaration.sourceEnd != 0 && block.sourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(block, n2);
        }
        RecoveredBlock recoveredBlock = new RecoveredBlock(block, (RecoveredElement)this, n2);
        if (this.pendingArgument != null) {
            recoveredBlock.a(this.pendingArgument);
            this.pendingArgument = null;
        }
        this.a(recoveredBlock);
        if (block.sourceEnd == 0) {
            return recoveredBlock;
        }
        return this;
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n2) {
        return this.add(localDeclaration, n2, false);
    }

    public RecoveredElement add(LocalDeclaration localDeclaration, int n2, boolean bl2) {
        if (this.blockDeclaration.sourceEnd != 0 && localDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (bl2) {
                return this;
            }
            return this.parent.add(localDeclaration, n2);
        }
        RecoveredLocalVariable recoveredLocalVariable = new RecoveredLocalVariable(localDeclaration, (RecoveredElement)this, n2);
        if (localDeclaration instanceof Argument) {
            this.pendingArgument = recoveredLocalVariable;
            return this;
        }
        this.a(recoveredLocalVariable);
        if (localDeclaration.declarationSourceEnd == 0) {
            return recoveredLocalVariable;
        }
        return this;
    }

    public RecoveredElement add(Statement statement, int n2) {
        return this.add(statement, n2, false);
    }

    public RecoveredElement add(Statement statement, int n2, boolean bl2) {
        if (this.blockDeclaration.sourceEnd != 0 && statement.sourceStart > this.blockDeclaration.sourceEnd) {
            if (bl2) {
                return this;
            }
            return this.parent.add(statement, n2);
        }
        RecoveredStatement recoveredStatement = new RecoveredStatement(statement, this, n2);
        this.a(recoveredStatement);
        if (statement.sourceEnd == 0) {
            return recoveredStatement;
        }
        return this;
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2) {
        return this.add(typeDeclaration, n2, false);
    }

    public RecoveredElement add(TypeDeclaration typeDeclaration, int n2, boolean bl2) {
        if (this.blockDeclaration.sourceEnd != 0 && typeDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            if (bl2) {
                return this;
            }
            return this.parent.add(typeDeclaration, n2);
        }
        RecoveredType recoveredType = new RecoveredType(typeDeclaration, (RecoveredElement)this, n2);
        this.a(recoveredType);
        if (typeDeclaration.declarationSourceEnd == 0) {
            return recoveredType;
        }
        return this;
    }

    public void a(RecoveredStatement recoveredStatement) {
        if (this.statements == null) {
            this.statements = new RecoveredStatement[5];
            this.statementCount = 0;
        } else if (this.statementCount == this.statements.length) {
            this.statements = new RecoveredStatement[2 * this.statementCount];
            System.arraycopy(this.statements, 0, this.statements, 0, this.statementCount);
        }
        this.statements[this.statementCount++] = recoveredStatement;
    }

    public ASTNode parseTree() {
        return this.blockDeclaration;
    }

    public String toString(int n2) {
        StringBuffer stringBuffer = new StringBuffer(this.tabString(n2));
        stringBuffer.append("Recovered block:\n");
        this.blockDeclaration.print(n2 + 1, stringBuffer);
        if (this.statements != null) {
            int n3 = 0;
            while (n3 < this.statementCount) {
                stringBuffer.append("\n");
                stringBuffer.append(this.statements[n3].toString(n2 + 1));
                ++n3;
            }
        }
        return stringBuffer.toString();
    }

    public Block updatedBlock() {
        if (!this.preserveContent || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.statementCount) {
            Statement statement = this.statements[n3].updatedStatement();
            if (statement != null) {
                statementArray[n2++] = statement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n2];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n2);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        return this.blockDeclaration;
    }

    public Statement updatedStatement() {
        return this.updatedBlock();
    }

    public RecoveredElement updateOnClosingBrace(int n2, int n3) {
        if (--this.bracketBalance <= 0 && this.parent != null) {
            this.updateSourceEndIfNecessary(n2, n3);
            RecoveredMethod recoveredMethod = this.enclosingMethod();
            if (recoveredMethod != null && recoveredMethod.methodBody == this) {
                return this.parent.updateOnClosingBrace(n2, n3);
            }
            RecoveredInitializer recoveredInitializer = this.enclosingInitializer();
            if (recoveredInitializer != null && recoveredInitializer.initializerBody == this) {
                return this.parent.updateOnClosingBrace(n2, n3);
            }
            return this.parent;
        }
        return this;
    }

    public RecoveredElement updateOnOpeningBrace(int n2, int n3) {
        Block block = new Block(0);
        block.sourceStart = this.parser().scanner.startPosition;
        return this.add(block, 1);
    }

    public void updateParseTree() {
        this.updatedBlock();
    }

    public Statement updateStatement() {
        if (this.blockDeclaration.sourceEnd != 0 || this.statementCount == 0) {
            return null;
        }
        Statement[] statementArray = new Statement[this.statementCount];
        int n2 = 0;
        int n3 = 0;
        while (n3 < this.statementCount) {
            Statement statement = this.statements[n3].updatedStatement();
            if (statement != null) {
                statementArray[n2++] = statement;
            }
            ++n3;
        }
        if (n2 == 0) {
            return null;
        }
        if (n2 != this.statementCount) {
            this.blockDeclaration.statements = new Statement[n2];
            System.arraycopy(statementArray, 0, this.blockDeclaration.statements, 0, n2);
        } else {
            this.blockDeclaration.statements = statementArray;
        }
        return this.blockDeclaration;
    }

    public RecoveredElement add(FieldDeclaration fieldDeclaration, int n2) {
        char[][] cArray;
        if ((fieldDeclaration.modifiers & 0xFFFFFFEF) != 0 || fieldDeclaration.type == null || (cArray = fieldDeclaration.type.getTypeName()).length == 1 && CharOperation.equals(cArray[0], VoidBinding.sourceName())) {
            this.updateSourceEndIfNecessary(this.previousAvailableLineEnd(fieldDeclaration.declarationSourceStart - 1));
            return this.parent.add(fieldDeclaration, n2);
        }
        if (this.blockDeclaration.sourceEnd != 0 && fieldDeclaration.declarationSourceStart > this.blockDeclaration.sourceEnd) {
            return this.parent.add(fieldDeclaration, n2);
        }
        return this;
    }
}

