/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser.diagnose;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.InvalidInputException;
import org.eclipse.jdt.internal.compiler.parser.Scanner;
import org.eclipse.jdt.internal.compiler.parser.TerminalTokens;
import org.eclipse.jdt.internal.compiler.parser.diagnose.RangeUtil;

public class LexStream
implements TerminalTokens {
    public static final int IS_AFTER_JUMP = 1;
    public static final int LBRACE_MISSING = 2;
    private int tokenCacheIndex;
    private int tokenCacheEOFIndex;
    private Token[] tokenCache;
    private int currentIndex = -1;
    private Scanner scanner;
    private int[] intervalStartToSkip;
    private int[] intervalEndToSkip;
    private int[] intervalFlagsToSkip;
    private int previousInterval = -1;

    public LexStream(int n2, Scanner scanner, int[] nArray, int[] nArray2, int[] nArray3, int n3, int n4, int n5) {
        this.tokenCache = new Token[n2];
        this.tokenCacheIndex = 0;
        this.tokenCacheEOFIndex = Integer.MAX_VALUE;
        this.tokenCache[0] = new Token(this);
        this.tokenCache[0].b = n3;
        this.tokenCache[0].g = CharOperation.NO_CHAR;
        this.tokenCache[0].a = n4;
        this.tokenCache[0].c = n4;
        this.tokenCache[0].e = 0;
        this.intervalStartToSkip = nArray;
        this.intervalEndToSkip = nArray2;
        this.intervalFlagsToSkip = nArray3;
        scanner.resetTo(n4, n5);
        this.scanner = scanner;
    }

    private void readTokenFromScanner() {
        int n2 = this.tokenCache.length;
        boolean bl2 = true;
        while (bl2) {
            try {
                Token token;
                int n3;
                int n4;
                int n5 = this.scanner.getNextToken();
                if (n5 != 66) {
                    n4 = this.scanner.getCurrentTokenStartPosition();
                    if (RangeUtil.isInInterval(n4, n3 = this.scanner.getCurrentTokenEndPosition(), this.intervalStartToSkip, this.intervalEndToSkip)) continue;
                    token = new Token(this);
                    token.b = n5;
                    token.g = this.scanner.getCurrentTokenSource();
                    token.a = n4;
                    token.c = n3;
                    token.e = this.scanner.getLineNumber(n3);
                    int n6 = RangeUtil.getPreviousInterval(n4, n3, this.intervalStartToSkip, this.intervalEndToSkip);
                    if (n6 != this.previousInterval && (this.intervalFlagsToSkip[this.previousInterval + 1] & 2) == 0) {
                        token.d = 1;
                        if ((this.intervalFlagsToSkip[n6] & 1) != 0) {
                            token.d |= 2;
                        }
                    }
                    this.previousInterval = n6;
                    this.tokenCache[++this.tokenCacheIndex % n2] = token;
                    bl2 = false;
                    continue;
                }
                n4 = this.scanner.getCurrentTokenStartPosition();
                n3 = this.scanner.getCurrentTokenEndPosition();
                token = new Token(this);
                token.b = n5;
                token.g = CharOperation.NO_CHAR;
                token.a = n4;
                token.c = n3;
                token.e = this.scanner.getLineNumber(n3);
                this.tokenCache[++this.tokenCacheIndex % n2] = token;
                this.tokenCacheEOFIndex = this.tokenCacheIndex;
                bl2 = false;
            }
            catch (InvalidInputException invalidInputException) {}
        }
    }

    public Token token(int n2) {
        if (n2 < 0) {
            Token token = new Token(this);
            token.b = 66;
            token.g = CharOperation.NO_CHAR;
            return token;
        }
        if (this.tokenCacheEOFIndex >= 0 && n2 > this.tokenCacheEOFIndex) {
            return this.token(this.tokenCacheEOFIndex);
        }
        int n3 = this.tokenCache.length;
        if (n2 > this.tokenCacheIndex) {
            int n4 = n2 - this.tokenCacheIndex;
            while (n4-- != 0) {
                this.readTokenFromScanner();
            }
        } else if (this.tokenCacheIndex - n3 >= n2) {
            return null;
        }
        return this.tokenCache[n2 % n3];
    }

    public int getToken() {
        this.currentIndex = this.next(this.currentIndex);
        return this.currentIndex;
    }

    public int previous(int n2) {
        return n2 > 0 ? n2 - 1 : 0;
    }

    public int next(int n2) {
        return n2 < this.tokenCacheEOFIndex ? n2 + 1 : this.tokenCacheEOFIndex;
    }

    public boolean afterEol(int n2) {
        return n2 < 1 ? true : this.line(n2 - 1) < this.line(n2);
    }

    public void reset() {
        this.currentIndex = -1;
    }

    public void reset(int n2) {
        this.currentIndex = this.previous(n2);
    }

    public int badtoken() {
        return 0;
    }

    public int kind(int n2) {
        return this.token((int)n2).b;
    }

    public char[] name(int n2) {
        return this.token((int)n2).g;
    }

    public int line(int n2) {
        return this.token((int)n2).e;
    }

    public int start(int n2) {
        return this.token((int)n2).a;
    }

    public int end(int n2) {
        return this.token((int)n2).c;
    }

    public int flags(int n2) {
        return this.token((int)n2).d;
    }

    public boolean isInsideStream(int n2) {
        if (this.tokenCacheEOFIndex >= 0 && n2 > this.tokenCacheEOFIndex) {
            return false;
        }
        if (n2 > this.tokenCacheIndex) {
            return true;
        }
        return this.tokenCacheIndex - this.tokenCache.length < n2;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = new String(this.scanner.source);
        if (this.currentIndex < 0) {
            stringBuffer.append(string);
        } else {
            Token token = this.token(this.currentIndex);
            int n2 = token.b;
            int n3 = token.a;
            int n4 = token.c;
            int n5 = -1;
            int n6 = 0;
            while (n6 < this.intervalStartToSkip.length) {
                int n7 = this.intervalStartToSkip[n6];
                int n8 = this.intervalEndToSkip[n6];
                if (n3 >= n5 && n4 <= n7) {
                    stringBuffer.append(string.substring(n5 + 1, n3));
                    stringBuffer.append('<');
                    stringBuffer.append('#');
                    stringBuffer.append(string.substring(n3, n4 + 1));
                    stringBuffer.append('#');
                    stringBuffer.append('>');
                    stringBuffer.append(string.substring(n4 + 1, n7));
                } else {
                    stringBuffer.append(string.substring(n5 + 1, n7));
                }
                stringBuffer.append('<');
                stringBuffer.append('@');
                stringBuffer.append(string.substring(n7, n8 + 1));
                stringBuffer.append('@');
                stringBuffer.append('>');
                n5 = n8;
                ++n6;
            }
            if (n3 >= n5) {
                stringBuffer.append(string.substring(n5 + 1, n3));
                stringBuffer.append('<');
                stringBuffer.append('#');
                if (n2 == 66) {
                    stringBuffer.append("EOF#>");
                } else {
                    stringBuffer.append(string.substring(n3, n4 + 1));
                    stringBuffer.append('#');
                    stringBuffer.append('>');
                    stringBuffer.append(string.substring(n4 + 1));
                }
            } else {
                stringBuffer.append(string.substring(n5 + 1));
            }
        }
        return stringBuffer.toString();
    }

    public class Token {
        public int b;
        public char[] g;
        public int a;
        public int c;
        public int e;
        public int d;
        public final LexStream f;

        public Token(LexStream lexStream) {
            this.f = lexStream;
        }

        public String toString() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append(this.g).append('[').append(this.b).append(']');
            stringBuffer.append('{').append(this.a).append(',').append(this.c).append('}').append(this.e);
            return stringBuffer.toString();
        }
    }
}

