/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.parser.diagnose;

import org.eclipse.jdt.internal.compiler.ast.AbstractMethodDeclaration;
import org.eclipse.jdt.internal.compiler.ast.FieldDeclaration;
import org.eclipse.jdt.internal.compiler.ast.Initializer;
import org.eclipse.jdt.internal.compiler.ast.TypeDeclaration;

public class RangeUtil {
    public static final int NO_FLAG = 0;
    public static final int LBRACE_MISSING = 1;
    public static final int IGNORE = 2;

    public static boolean containsErrorInSignature(AbstractMethodDeclaration abstractMethodDeclaration) {
        return abstractMethodDeclaration.sourceEnd + 1 == abstractMethodDeclaration.bodyStart || abstractMethodDeclaration.bodyEnd == abstractMethodDeclaration.declarationSourceEnd;
    }

    public static int[][] computeDietRange(TypeDeclaration[] typeDeclarationArray) {
        if (typeDeclarationArray == null || typeDeclarationArray.length == 0) {
            return new int[3][0];
        }
        RangeResult rangeResult = new RangeResult();
        RangeUtil.computeDietRange0(typeDeclarationArray, rangeResult);
        return rangeResult.a();
    }

    private static void computeDietRange0(TypeDeclaration[] typeDeclarationArray, RangeResult rangeResult) {
        int n2 = 0;
        while (n2 < typeDeclarationArray.length) {
            FieldDeclaration[] fieldDeclarationArray;
            int n3;
            AbstractMethodDeclaration[] abstractMethodDeclarationArray;
            TypeDeclaration[] typeDeclarationArray2 = typeDeclarationArray[n2].memberTypes;
            if (typeDeclarationArray2 != null && typeDeclarationArray2.length > 0) {
                RangeUtil.computeDietRange0(typeDeclarationArray[n2].memberTypes, rangeResult);
            }
            if ((abstractMethodDeclarationArray = typeDeclarationArray[n2].methods) != null) {
                int n4 = abstractMethodDeclarationArray.length;
                n3 = 0;
                while (n3 < n4) {
                    AbstractMethodDeclaration abstractMethodDeclaration = abstractMethodDeclarationArray[n3];
                    if (RangeUtil.containsIgnoredBody(abstractMethodDeclaration)) {
                        if (RangeUtil.containsErrorInSignature(abstractMethodDeclaration)) {
                            abstractMethodDeclaration.errorInSignature = true;
                            rangeResult.a(abstractMethodDeclaration.declarationSourceStart, abstractMethodDeclaration.declarationSourceEnd, 2);
                        } else {
                            int n5 = abstractMethodDeclaration.sourceEnd + 1 == abstractMethodDeclaration.bodyStart ? 1 : 0;
                            rangeResult.a(abstractMethodDeclaration.bodyStart, abstractMethodDeclaration.bodyEnd, n5);
                        }
                    }
                    ++n3;
                }
            }
            if ((fieldDeclarationArray = typeDeclarationArray[n2].fields) != null) {
                n3 = fieldDeclarationArray.length;
                int n6 = 0;
                while (n6 < n3) {
                    if (fieldDeclarationArray[n6] instanceof Initializer) {
                        Initializer initializer = (Initializer)fieldDeclarationArray[n6];
                        if (initializer.declarationSourceEnd == initializer.bodyEnd && initializer.declarationSourceStart != initializer.declarationSourceEnd) {
                            initializer.errorInSignature = true;
                            rangeResult.a(initializer.declarationSourceStart, initializer.declarationSourceEnd, 2);
                        } else {
                            rangeResult.a(initializer.bodyStart, initializer.bodyEnd);
                        }
                    }
                    ++n6;
                }
            }
            ++n2;
        }
    }

    public static boolean isInInterval(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            if (nArray[n5] <= n2 && nArray2[n5] >= n3) {
                return true;
            }
            if (nArray[n5] > n3) {
                return false;
            }
            ++n5;
        }
        return false;
    }

    public static int getPreviousInterval(int n2, int n3, int[] nArray, int[] nArray2) {
        int n4 = nArray.length;
        int n5 = 0;
        while (n5 < n4) {
            if (nArray[n5] > n3) {
                return n5 - 1;
            }
            ++n5;
        }
        return n4 - 1;
    }

    public static boolean containsIgnoredBody(AbstractMethodDeclaration abstractMethodDeclaration) {
        return !abstractMethodDeclaration.isDefaultConstructor() && !abstractMethodDeclaration.isClinit() && (abstractMethodDeclaration.modifiers & 0x1000000) == 0;
    }

    public static class RangeResult {
        private static final int INITIAL_SIZE = 10;
        public int c = 0;
        public int[] d = new int[10];
        public int[] b = new int[10];
        public int[] a = new int[10];

        public void a(int n2, int n3) {
            this.a(n2, n3, 0);
        }

        public void a(int n2, int n3, int n4) {
            if (this.c >= this.d.length) {
                this.d = new int[this.c * 2];
                System.arraycopy(this.d, 0, this.d, 0, this.c);
                this.b = new int[this.c * 2];
                System.arraycopy(this.b, 0, this.b, 0, this.c);
                this.a = new int[this.c * 2];
                System.arraycopy(this.a, 0, this.a, 0, this.c);
            }
            this.d[this.c] = n2;
            this.b[this.c] = n3;
            this.a[this.c] = n4;
            ++this.c;
        }

        public int[][] a() {
            int[] nArray = new int[this.c];
            int[] nArray2 = new int[this.c];
            int[] nArray3 = new int[this.c];
            System.arraycopy(this.d, 0, nArray, 0, this.c);
            System.arraycopy(this.b, 0, nArray2, 0, this.c);
            System.arraycopy(this.a, 0, nArray3, 0, this.c);
            if (nArray.length > 1) {
                this.quickSort(nArray, nArray2, nArray3, 0, nArray.length - 1);
            }
            return new int[][]{nArray, nArray2, nArray3};
        }

        private void quickSort(int[] nArray, int[] nArray2, int[] nArray3, int n2, int n3) {
            int n4 = n2;
            int n5 = n3;
            int n6 = nArray[(n2 + n3) / 2];
            while (true) {
                if (this.compare(nArray[n2], n6) < 0) {
                    ++n2;
                    continue;
                }
                while (this.compare(n6, nArray[n3]) < 0) {
                    --n3;
                }
                if (n2 <= n3) {
                    int n7 = nArray[n2];
                    nArray[n2] = nArray[n3];
                    nArray[n3] = n7;
                    n7 = nArray2[n2];
                    nArray2[n2] = nArray2[n3];
                    nArray2[n3] = n7;
                    n7 = nArray3[n2];
                    nArray3[n2] = nArray3[n3];
                    nArray3[n3] = n7;
                    ++n2;
                    --n3;
                }
                if (n2 > n3) break;
            }
            if (n4 < n3) {
                this.quickSort(nArray, nArray2, nArray3, n4, n3);
            }
            if (n2 < n5) {
                this.quickSort(nArray, nArray2, nArray3, n2, n5);
            }
        }

        private int compare(int n2, int n3) {
            return n2 - n3;
        }
    }
}

