/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.problem;

import java.util.Enumeration;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.core.compiler.IProblem;
import org.eclipse.jdt.internal.compiler.IProblemFactory;
import org.eclipse.jdt.internal.compiler.problem.DefaultProblem;
import org.eclipse.jdt.internal.compiler.util.HashtableOfInt;
import org.eclipse.jdt.internal.compiler.util.Util;

public class DefaultProblemFactory
implements IProblemFactory {
    public HashtableOfInt messageTemplates;
    private Locale locale;
    private static HashtableOfInt DEFAULT_LOCALE_TEMPLATES;
    private static final char[] DOUBLE_QUOTES;
    private static final char[] SINGLE_QUOTE;

    static {
        DOUBLE_QUOTES = "''".toCharArray();
        SINGLE_QUOTE = "'".toCharArray();
    }

    public DefaultProblemFactory() {
        this(Locale.getDefault());
    }

    public DefaultProblemFactory(Locale locale) {
        this.locale = locale;
        if (Locale.getDefault().equals(locale)) {
            if (DEFAULT_LOCALE_TEMPLATES == null) {
                DEFAULT_LOCALE_TEMPLATES = DefaultProblemFactory.loadMessageTemplates(locale);
            }
            this.messageTemplates = DEFAULT_LOCALE_TEMPLATES;
        } else {
            this.messageTemplates = DefaultProblemFactory.loadMessageTemplates(locale);
        }
    }

    public IProblem createProblem(char[] cArray, int n2, String[] stringArray, String[] stringArray2, int n3, int n4, int n5, int n6) {
        return new DefaultProblem(cArray, this.getLocalizedMessage(n2, stringArray2), n2, stringArray, n3, n4, n5, n6);
    }

    private static final int keyFromID(int n2) {
        return n2 + 1;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public final String getLocalizedMessage(int n2, String[] stringArray) {
        StringBuffer stringBuffer;
        block11: {
            String string = (String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(n2 & 0xFFFFFF));
            if (string == null) {
                return "Unable to retrieve the error message for problem id: " + (n2 & 0xFFFFFF) + ". Check compiler resources.";
            }
            char[] cArray = CharOperation.replace(string.toCharArray(), DOUBLE_QUOTES, SINGLE_QUOTE);
            if (stringArray == null) {
                return new String(cArray);
            }
            int n3 = cArray.length;
            int n4 = 0;
            int n5 = n3;
            stringBuffer = null;
            if ((n2 & Integer.MIN_VALUE) != 0) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(10 + n3 + stringArray.length * 20);
                }
                stringBuffer.append((String)this.messageTemplates.get(DefaultProblemFactory.keyFromID(514)));
            }
            while ((n5 = CharOperation.indexOf('{', cArray, n4)) > -1) {
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(n3 + stringArray.length * 20);
                }
                stringBuffer.append(cArray, n4, n5 - n4);
                n4 = CharOperation.indexOf('}', cArray, n5 + 1);
                if (n4 > -1) {
                    int n6 = -1;
                    String string2 = new String(cArray, n5 + 1, n4 - n5 - 1);
                    try {
                        n6 = Integer.parseInt(string2);
                        stringBuffer.append(stringArray[n6]);
                    }
                    catch (NumberFormatException numberFormatException) {
                        stringBuffer.append(cArray, n5 + 1, n4 - n5);
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        return "Cannot bind message for problem (id: " + (n2 & 0xFFFFFF) + ") \"" + string + "\" with arguments: {" + Util.toString(stringArray) + "}";
                    }
                    ++n4;
                    continue;
                }
                stringBuffer.append(cArray, n5, n3);
                break block11;
            }
            if (stringBuffer == null) {
                return new String(cArray);
            }
            stringBuffer.append(cArray, n4, n3 - n4);
        }
        return stringBuffer.toString();
    }

    public final String localizedMessage(IProblem iProblem) {
        return this.getLocalizedMessage(iProblem.getID(), iProblem.getArguments());
    }

    public static HashtableOfInt loadMessageTemplates(Locale locale) {
        ResourceBundle resourceBundle = null;
        String string = "org.eclipse.jdt.internal.compiler.problem.messages";
        try {
            resourceBundle = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            System.out.println("Missing resource : " + string.replace('.', '/') + ".properties for locale " + locale);
            throw missingResourceException;
        }
        HashtableOfInt hashtableOfInt = new HashtableOfInt(700);
        Enumeration<String> enumeration = resourceBundle.getKeys();
        while (enumeration.hasMoreElements()) {
            String string2 = enumeration.nextElement();
            try {
                int n2 = Integer.parseInt(string2);
                hashtableOfInt.put(DefaultProblemFactory.keyFromID(n2), resourceBundle.getString(string2));
            }
            catch (NumberFormatException numberFormatException) {
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return hashtableOfInt;
    }
}

