/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.lookup.ReferenceBinding;

public final class HashtableOfType {
    public char[][] keyTable;
    public ReferenceBinding[] valueTable;
    public int elementSize = 0;
    public int a;

    public HashtableOfType() {
        this(3);
    }

    public HashtableOfType(int n2) {
        this.a = n2;
        int n3 = (int)((float)n2 * 1.75f);
        if (this.a == n3) {
            ++n3;
        }
        this.keyTable = new char[n3][];
        this.valueTable = new ReferenceBinding[n3];
    }

    public boolean containsKey(char[] cArray) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return true;
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return false;
    }

    public ReferenceBinding get(char[] cArray) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        return null;
    }

    public ReferenceBinding put(char[] cArray, ReferenceBinding referenceBinding) {
        char[] cArray2;
        int n2 = CharOperation.hashCode(cArray) % this.valueTable.length;
        int n3 = cArray.length;
        while ((cArray2 = this.keyTable[n2]) != null) {
            if (cArray2.length == n3 && CharOperation.equals(cArray2, cArray)) {
                this.valueTable[n2] = referenceBinding;
                return this.valueTable[n2];
            }
            n2 = (n2 + 1) % this.keyTable.length;
        }
        this.keyTable[n2] = cArray;
        this.valueTable[n2] = referenceBinding;
        if (++this.elementSize > this.a) {
            this.rehash();
        }
        return referenceBinding;
    }

    private void rehash() {
        HashtableOfType hashtableOfType = new HashtableOfType(this.elementSize < 100 ? 100 : this.elementSize * 2);
        int n2 = this.keyTable.length;
        while (--n2 >= 0) {
            char[] cArray = this.keyTable[n2];
            if (cArray == null) continue;
            hashtableOfType.put(cArray, this.valueTable[n2]);
        }
        this.keyTable = hashtableOfType.keyTable;
        this.valueTable = hashtableOfType.valueTable;
        this.a = hashtableOfType.a;
    }

    public int size() {
        return this.elementSize;
    }

    public String toString() {
        String string = "";
        int n2 = 0;
        int n3 = this.valueTable.length;
        while (n2 < n3) {
            ReferenceBinding referenceBinding = this.valueTable[n2];
            if (referenceBinding != null) {
                string = String.valueOf(string) + referenceBinding.toString() + "\n";
            }
            ++n2;
        }
        return string;
    }
}

