/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.compiler.util;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;

public class Util
implements SuffixConstants {
    private static final int DEFAULT_READING_SIZE = 8192;
    public static String LINE_SEPARATOR = System.getProperty("line.separator");

    public static char[] bytesToChar(byte[] byArray, String string) throws IOException {
        return Util.getInputStreamAsCharArray(new ByteArrayInputStream(byArray), byArray.length, string);
    }

    public static byte[] getFileByteContent(File file) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                byArray = Util.getInputStreamAsByteArray(bufferedInputStream, (int)file.length());
                Object var2_3 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var2_4 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static char[] getFileCharContent(File file, String string) throws IOException {
        char[] cArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                cArray = Util.getInputStreamAsCharArray(bufferedInputStream, (int)file.length(), string);
                Object var3_4 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return cArray;
    }

    public static byte[] getInputStreamAsByteArray(InputStream inputStream, int n2) throws IOException {
        byte[] byArray;
        if (n2 == -1) {
            byArray = new byte[]{};
            int n3 = 0;
            int n4 = -1;
            do {
                int n5;
                if (n3 + (n5 = Math.max(inputStream.available(), 8192)) > byArray.length) {
                    byte[] byArray2 = byArray;
                    byArray = new byte[n3 + n5];
                    System.arraycopy(byArray2, 0, byArray, 0, n3);
                }
                if ((n4 = inputStream.read(byArray, n3, n5)) <= 0) continue;
                n3 += n4;
            } while (n4 != -1);
            if (n3 < byArray.length) {
                byte[] byArray3 = byArray;
                byArray = new byte[n3];
                System.arraycopy(byArray3, 0, byArray, 0, n3);
            }
        } else {
            byArray = new byte[n2];
            int n6 = 0;
            int n7 = 0;
            while (n7 != -1 && n6 != n2) {
                n7 = inputStream.read(byArray, n6 += n7, n2 - n6);
            }
        }
        return byArray;
    }

    public static char[] getInputStreamAsCharArray(InputStream inputStream, int n2, String string) throws IOException {
        char[] cArray;
        InputStreamReader inputStreamReader = null;
        InputStreamReader inputStreamReader2 = inputStreamReader = string == null ? new InputStreamReader(inputStream) : new InputStreamReader(inputStream, string);
        if (n2 == -1) {
            int n3;
            cArray = CharOperation.NO_CHAR;
            int n4 = 0;
            int n5 = -1;
            do {
                if (n4 + (n3 = Math.max(inputStream.available(), 8192)) > cArray.length) {
                    char[] cArray2 = cArray;
                    cArray = new char[n4 + n3];
                    System.arraycopy(cArray2, 0, cArray, 0, n4);
                }
                if ((n5 = inputStreamReader.read(cArray, n4, n3)) <= 0) continue;
                n4 += n5;
            } while (n5 != -1);
            n3 = 0;
            if (n4 > 0 && "UTF-8".equals(string) && cArray[0] == '\ufeff') {
                --n4;
                n3 = 1;
            }
            if (n4 < cArray.length) {
                char[] cArray3 = cArray;
                cArray = new char[n4];
                System.arraycopy(cArray3, n3, cArray, 0, n4);
            }
        } else {
            cArray = new char[n2];
            int n6 = 0;
            int n7 = 0;
            while (n7 != -1 && n6 != n2) {
                n7 = inputStreamReader.read(cArray, n6 += n7, n2 - n6);
            }
            int n8 = 0;
            if (n2 > 0 && "UTF-8".equals(string) && cArray[0] == '\ufeff') {
                --n6;
                n8 = 1;
            }
            if (n6 != n2) {
                char[] cArray4 = cArray;
                cArray = new char[n6];
                System.arraycopy(cArray4, n8, cArray, 0, n6);
            }
        }
        return cArray;
    }

    public static byte[] getZipEntryByteContent(ZipEntry zipEntry, ZipFile zipFile) throws IOException {
        byte[] byArray;
        block5: {
            BufferedInputStream bufferedInputStream = null;
            try {
                bufferedInputStream = new BufferedInputStream(zipFile.getInputStream(zipEntry));
                byArray = Util.getInputStreamAsByteArray(bufferedInputStream, (int)zipEntry.getSize());
                Object var3_4 = null;
                if (bufferedInputStream == null) break block5;
            }
            catch (Throwable throwable) {
                block6: {
                    Object var3_5 = null;
                    if (bufferedInputStream == null) break block6;
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException) {}
                }
                throw throwable;
            }
            try {
                ((InputStream)bufferedInputStream).close();
            }
            catch (IOException iOException) {}
        }
        return byArray;
    }

    public static final boolean isArchiveFileName(String string) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 < (n2 = SUFFIX_JAR.length)) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            char c2 = string.charAt(n3 - n4 - 1);
            if (c2 != SUFFIX_jar[n5 = n2 - n4 - 1] && c2 != SUFFIX_JAR[n5]) {
                n2 = SUFFIX_ZIP.length;
                if (n3 < n2) {
                    return false;
                }
                int n6 = 0;
                while (n6 < n2) {
                    c2 = string.charAt(n3 - n6 - 1);
                    if (c2 != SUFFIX_zip[n5 = n2 - n6 - 1] && c2 != SUFFIX_ZIP[n5]) {
                        return false;
                    }
                    ++n6;
                }
                return true;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isClassFileName(char[] cArray) {
        int n2;
        int n3 = cArray == null ? 0 : cArray.length;
        if (n3 < (n2 = SUFFIX_CLASS.length)) {
            return false;
        }
        int n4 = 0;
        int n5 = n3 - n2;
        while (n4 < n2) {
            char c2 = cArray[n5 + n4];
            if (c2 != SUFFIX_class[n4] && c2 != SUFFIX_CLASS[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isClassFileName(String string) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 < (n2 = SUFFIX_CLASS.length)) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            char c2 = string.charAt(n3 - n4 - 1);
            if (c2 != SUFFIX_class[n5 = n2 - n4 - 1] && c2 != SUFFIX_CLASS[n5]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isExcluded(char[] cArray, char[][] cArray2, char[][] cArray3, boolean bl2) {
        int n2;
        int n3;
        block9: {
            if (cArray2 == null && cArray3 == null) {
                return false;
            }
            if (cArray2 != null) {
                n3 = 0;
                n2 = cArray2.length;
                while (n3 < n2) {
                    int n4;
                    int n5;
                    char[] cArray4;
                    char[] cArray5 = cArray4 = cArray2[n3];
                    if (bl2 && (n5 = CharOperation.lastIndexOf('/', cArray4)) != -1 && n5 != cArray4.length - 1 && ((n4 = CharOperation.indexOf('*', cArray4, n5)) == -1 || n4 >= cArray4.length - 1 || cArray4[n4 + 1] != '*')) {
                        cArray5 = CharOperation.subarray(cArray4, 0, n5);
                    }
                    if (!CharOperation.pathMatch(cArray5, cArray, true, '/')) {
                        ++n3;
                        continue;
                    }
                    break block9;
                }
                return true;
            }
        }
        if (bl2) {
            cArray = CharOperation.concat(cArray, new char[]{'*'}, '/');
        }
        if (cArray3 != null) {
            n3 = 0;
            n2 = cArray3.length;
            while (n3 < n2) {
                if (CharOperation.pathMatch(cArray3[n3], cArray, true, '/')) {
                    return true;
                }
                ++n3;
            }
        }
        return false;
    }

    public static final boolean isJavaFileName(char[] cArray) {
        int n2;
        int n3 = cArray == null ? 0 : cArray.length;
        if (n3 < (n2 = SUFFIX_JAVA.length)) {
            return false;
        }
        int n4 = 0;
        int n5 = n3 - n2;
        while (n4 < n2) {
            char c2 = cArray[n5 + n4];
            if (c2 != SUFFIX_java[n4] && c2 != SUFFIX_JAVA[n4]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static final boolean isJavaFileName(String string) {
        int n2;
        int n3 = string == null ? 0 : string.length();
        if (n3 < (n2 = SUFFIX_JAVA.length)) {
            return false;
        }
        int n4 = 0;
        while (n4 < n2) {
            int n5;
            char c2 = string.charAt(n3 - n4 - 1);
            if (c2 != SUFFIX_java[n5 = n2 - n4 - 1] && c2 != SUFFIX_JAVA[n5]) {
                return false;
            }
            ++n4;
        }
        return true;
    }

    public static Boolean toBoolean(boolean bl2) {
        if (bl2) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public static String toString(Object[] objectArray) {
        return Util.toString(objectArray, new Displayable(){

            public String displayString(Object object) {
                if (object == null) {
                    return "null";
                }
                return object.toString();
            }
        });
    }

    public static String toString(Object[] objectArray, Displayable displayable) {
        if (objectArray == null) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer(10);
        int n2 = 0;
        while (n2 < objectArray.length) {
            if (n2 > 0) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(displayable.displayString(objectArray[n2]));
            ++n2;
        }
        return stringBuffer.toString();
    }

    public static interface Displayable {
        public String displayString(Object var1);
    }
}

