/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Date;
import org.hsqldb.ByteArray;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.Trace;

public class BinaryServerRowOutput
extends DatabaseRowOutput {
    public int a;
    private ByteArrayOutputStream byteOut;

    public BinaryServerRowOutput() throws IOException {
        super(new ByteArrayOutputStream());
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public BinaryServerRowOutput(int n2) throws IOException {
        super(new ByteArrayOutputStream(n2));
        this.byteOut = (ByteArrayOutputStream)this.out;
    }

    public void writeIntData(int n2) throws IOException {
        this.writeInt(n2);
    }

    public void writePos(int n2) throws IOException {
        this.writeInt(n2);
        while (this.byteOut.size() < this.a) {
            this.write(0);
        }
    }

    public void writeSize(int n2) throws IOException {
        this.a = n2;
        this.writeInt(n2);
    }

    public void writeType(int n2) throws IOException {
        this.writeShort(n2);
    }

    public void writeString(String string) throws IOException {
        byte[] byArray = string.getBytes("utf-8");
        this.writeInt(byArray.length);
        this.write(byArray);
    }

    public byte[] toByteArray() throws IOException {
        byte[] byArray = this.byteOut.toByteArray();
        this.byteOut.reset();
        return byArray;
    }

    public void writeFieldType(int n2) throws IOException {
        this.writeByte(1);
    }

    public void writeNull(int n2) throws IOException {
        this.writeByte(0);
    }

    public void writeChar(String string, int n2) throws IOException {
        this.writeString(string);
    }

    public void writeSmallint(Number number) throws IOException, SQLException {
        this.writeShort(number.intValue());
    }

    public void writeInteger(Number number) throws IOException, SQLException {
        this.writeInt(number.intValue());
    }

    public void writeBigint(Number number) throws IOException, SQLException {
        this.writeLong(number.longValue());
    }

    public void writeReal(Double d2, int n2) throws IOException, SQLException {
        this.writeLong(Double.doubleToLongBits(d2));
    }

    public void writeDecimal(BigDecimal bigDecimal) throws IOException, SQLException {
        int n2 = bigDecimal.scale();
        BigInteger bigInteger = bigDecimal.unscaledValue();
        byte[] byArray = bigInteger.toByteArray();
        this.writeByteArray(byArray);
        this.writeInt(n2);
    }

    public void writeBit(Boolean bl2) throws IOException, SQLException {
        this.writeBoolean(bl2);
    }

    public void writeDate(java.sql.Date date) throws IOException, SQLException {
        this.writeLong(date.getTime());
    }

    public void writeTime(Time time) throws IOException, SQLException {
        this.writeLong(time.getTime());
    }

    public void writeTimestamp(Timestamp timestamp) throws IOException, SQLException {
        this.writeLong(((Date)timestamp).getTime());
        this.writeInt(timestamp.getNanos());
    }

    public void writeOther(Object object) throws IOException, SQLException {
        byte[] byArray = ByteArray.a(object);
        this.writeByteArray(byArray);
    }

    public void writeBinary(byte[] byArray, int n2) throws IOException, SQLException {
        this.writeByteArray(byArray);
    }

    public void writeByteArray(byte[] byArray) throws IOException {
        this.writeInt(byArray.length);
        this.write(byArray, 0, byArray.length);
    }

    public static int getSize(CachedRow cachedRow) throws SQLException {
        Object[] objectArray = cachedRow.d();
        int[] nArray = cachedRow.b().t();
        return BinaryServerRowOutput.getSize(objectArray, objectArray.length, nArray);
    }

    private static int getSize(Object[] objectArray, int n2, int[] nArray) throws SQLException {
        int n3 = 0;
        int n4 = 0;
        while (n4 < n2) {
            Object object = objectArray[n4];
            ++n3;
            if (object != null) {
                switch (nArray[n4]) {
                    case -1: 
                    case 1: 
                    case 12: 
                    case 100: {
                        n3 += BinaryServerRowOutput.getUTFSize((String)object);
                        break;
                    }
                    case -6: 
                    case 5: {
                        n3 += 2;
                        break;
                    }
                    case 4: {
                        n3 += 4;
                        break;
                    }
                    case -5: 
                    case 6: 
                    case 7: 
                    case 8: {
                        n3 += 8;
                        break;
                    }
                    case 2: 
                    case 3: {
                        n3 += 8;
                        n3 += ((BigDecimal)object).unscaledValue().toByteArray().length;
                        break;
                    }
                    case -7: {
                        ++n3;
                        break;
                    }
                    case 91: 
                    case 92: {
                        n3 += 8;
                        break;
                    }
                    case 93: {
                        n3 += 12;
                        break;
                    }
                    case -4: 
                    case -3: 
                    case -2: {
                        n3 += 4;
                        n3 += ((byte[])object).length;
                        break;
                    }
                    case 1111: {
                        n3 += 4;
                        n3 += ByteArray.a(object).length;
                        break;
                    }
                    default: {
                        throw Trace.error(20, nArray[n4]);
                    }
                }
            }
            ++n4;
        }
        return n3;
    }

    private static int getUTFSize(String string) {
        int n2 = string == null ? 0 : string.length();
        int n3 = 4;
        int n4 = 0;
        while (n4 < n2) {
            char c2 = string.charAt(n4);
            n3 = c2 >= '\u0001' && c2 <= '\u007f' ? ++n3 : (c2 > '\u07ff' ? (n3 += 3) : (n3 += 2));
            ++n4;
        }
        return n3;
    }
}

