/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import org.hsqldb.BinaryDatabaseRowInput;
import org.hsqldb.BinaryDatabaseRowOutput;
import org.hsqldb.BinaryServerRowInput;
import org.hsqldb.BinaryServerRowOutput;
import org.hsqldb.CacheFree;
import org.hsqldb.CachedRow;
import org.hsqldb.DatabaseFile;
import org.hsqldb.DatabaseRowInput;
import org.hsqldb.DatabaseRowInputInterface;
import org.hsqldb.DatabaseRowOutput;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.Table;
import org.hsqldb.Trace;

public class Cache {
    private HsqlDatabaseProperties props;
    private boolean newCacheType;
    private final int cacheLength;
    private final int writerLength;
    private final int maxCacheSize;
    private final int multiplierMask;
    private CachedRow[] rData;
    private CachedRow[] rWriter;
    private CachedRow rFirst;
    private CachedRow rLastChecked;
    public String sName;
    public int iFreePos;
    public DatabaseFile rFile;
    private static final int FREE_POS_POS = 16;
    private static final int INITIAL_FREE_POS = 32;
    private static final int MAX_FREE_COUNT = 1024;
    private CacheFree fRoot;
    private int iFreeCount;
    private int iCacheSize;

    public Cache(String string, HsqlDatabaseProperties hsqlDatabaseProperties) {
        this.props = hsqlDatabaseProperties;
        int n2 = 0;
        try {
            n2 = hsqlDatabaseProperties.getIntegerProperty("hsqldb.cache_scale", 0);
        }
        catch (NumberFormatException numberFormatException) {
            Trace.c("bad value for hsqldb.cache_scale in properties file");
        }
        if (n2 == 0) {
            n2 = 15;
        } else if (n2 < 8) {
            n2 = 8;
        } else if (n2 > 16) {
            n2 = 16;
        }
        this.cacheLength = 1 << n2;
        this.writerLength = this.cacheLength - 3;
        this.maxCacheSize = this.cacheLength * 3;
        this.multiplierMask = this.cacheLength - 1;
        this.sName = string;
        this.rData = new CachedRow[this.cacheLength];
        this.rWriter = new CachedRow[this.writerLength];
    }

    public void a(boolean bl2) throws SQLException {
        try {
            boolean bl3 = false;
            File file = new File(this.sName);
            if (file.exists() && file.length() > 16L) {
                bl3 = true;
            }
            this.rFile = new DatabaseFile(this.sName, bl2 ? "r" : "rw", 2048);
            if (bl3) {
                this.rFile.readSeek(16L);
                this.iFreePos = this.rFile.readInteger();
            } else {
                this.iFreePos = 32;
                this.props.setProperty("hsqldb.cache_version", "1.7.0");
            }
            String string = this.props.getProperty("hsqldb.cache_version", "1.6.0");
            if (string.equals("1.7.0")) {
                this.newCacheType = true;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " opening " + this.sName);
        }
    }

    public void b() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.seek(16L);
            this.rFile.writeInteger(this.iFreePos);
            this.saveAll();
            boolean bl2 = this.rFile.length() < 32L;
            this.rFile.close();
            this.rFile = null;
            if (bl2) {
                new File(this.sName).delete();
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " closing " + this.sName);
        }
    }

    public void e() throws SQLException {
        if (this.rFile == null) {
            return;
        }
        try {
            this.rFile.close();
            this.rFile = null;
        }
        catch (Exception exception) {
            throw Trace.error(29, "error " + exception + " in shutdown " + this.sName);
        }
    }

    public void a(CachedRow cachedRow) throws SQLException {
        ++this.iFreeCount;
        CacheFree cacheFree = new CacheFree();
        cacheFree.c = cachedRow.e;
        cacheFree.b = cachedRow.f;
        if (this.iFreeCount > 1024) {
            this.iFreeCount = 0;
        } else {
            cacheFree.a = this.fRoot;
        }
        this.fRoot = cacheFree;
        this.remove(cachedRow);
    }

    public void setStorageSize(CachedRow cachedRow) throws SQLException {
        Table table = cachedRow.b();
        int n2 = 8 + 32 * table.a();
        n2 = this.newCacheType ? (n2 += BinaryServerRowOutput.getSize(cachedRow)) : (n2 += BinaryDatabaseRowOutput.getSize(cachedRow));
        cachedRow.f = n2 = (n2 + 7) / 8 * 8;
    }

    public void b(CachedRow cachedRow) throws SQLException {
        int n2;
        CachedRow cachedRow2;
        int n3;
        this.setStorageSize(cachedRow);
        int n4 = n3 = cachedRow.f;
        CacheFree cacheFree = this.fRoot;
        CacheFree cacheFree2 = null;
        int n5 = this.iFreePos;
        while (cacheFree != null) {
            if (Trace.TRACE) {
                Trace.a();
            }
            if (cacheFree.b >= n4) {
                n5 = cacheFree.c;
                if ((n4 = cacheFree.b - n4) < 8) {
                    if (cacheFree2 == null) {
                        this.fRoot = cacheFree.a;
                    } else {
                        cacheFree2.a = cacheFree.a;
                    }
                    --this.iFreeCount;
                    break;
                }
                cacheFree.b = n4;
                cacheFree.c += n3;
                break;
            }
            cacheFree2 = cacheFree;
            cacheFree = cacheFree.a;
        }
        cachedRow.b(n5);
        if (n5 == this.iFreePos) {
            this.iFreePos += n4;
        }
        if ((cachedRow2 = this.rData[n2 = n5 >> 3 & this.multiplierMask]) == null) {
            cachedRow2 = this.rFirst;
        }
        cachedRow.a(cachedRow2);
        ++this.iCacheSize;
        this.rData[n2] = cachedRow;
        this.rFirst = cachedRow;
    }

    public CachedRow makeRow(int n2, Table table) throws SQLException {
        CachedRow cachedRow = null;
        try {
            this.rFile.readSeek(n2);
            int n3 = this.rFile.readInteger();
            byte[] byArray = new byte[n3];
            this.rFile.read(byArray);
            DatabaseRowInput databaseRowInput = this.newCacheType ? new BinaryServerRowInput(byArray, n2) : new BinaryDatabaseRowInput(byArray, n2);
            cachedRow = new CachedRow(table, (DatabaseRowInputInterface)((Object)databaseRowInput));
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            throw Trace.error(29, "reading: " + iOException);
        }
        return cachedRow;
    }

    public CachedRow a(int n2, Table table) throws SQLException {
        CachedRow cachedRow;
        CachedRow cachedRow2;
        int n3 = n2 >> 3 & this.multiplierMask;
        CachedRow cachedRow3 = cachedRow2 = this.rData[n3];
        int n4 = 0;
        while (cachedRow2 != null) {
            n4 = cachedRow2.e;
            if (n4 == n2) {
                return cachedRow2;
            }
            if ((n4 >> 3 & this.multiplierMask) != n3 || (cachedRow2 = cachedRow2.b) == cachedRow3) break;
        }
        if ((cachedRow = this.rData[n3]) == null) {
            cachedRow = this.rFirst;
        }
        if ((cachedRow2 = this.makeRow(n2, table)) != null) {
            cachedRow2.a(cachedRow);
            ++this.iCacheSize;
            this.rData[cachedRow2.e >> 3 & this.multiplierMask] = cachedRow2;
            this.rFirst = cachedRow2;
            table.a(cachedRow2, false);
        }
        return cachedRow2;
    }

    public void a() throws SQLException {
        if (this.iCacheSize < this.maxCacheSize) {
            return;
        }
        int n2 = 0;
        int n3 = 0;
        while (n3++ < this.cacheLength && this.iCacheSize > this.maxCacheSize / 2 && n2 < this.writerLength) {
            CachedRow cachedRow = this.getWorst();
            if (cachedRow == null) {
                return;
            }
            if (cachedRow.f()) {
                cachedRow.a = CachedRow.d;
                this.rWriter[n2++] = cachedRow;
                continue;
            }
            if (cachedRow.g()) continue;
            this.remove(cachedRow);
        }
        if (n2 != 0) {
            this.saveSorted(n2);
        }
        int n4 = 0;
        while (n4 < n2) {
            CachedRow cachedRow = this.rWriter[n4];
            if (!cachedRow.g()) {
                this.remove(cachedRow);
            }
            this.rWriter[n4] = null;
            ++n4;
        }
    }

    public void remove(CachedRow cachedRow) throws SQLException {
        int n2;
        if (cachedRow == this.rLastChecked) {
            this.rLastChecked = this.rLastChecked.b;
            if (this.rLastChecked == cachedRow) {
                this.rLastChecked = null;
            }
        }
        if (this.rData[n2 = cachedRow.e >> 3 & this.multiplierMask] == cachedRow) {
            CachedRow cachedRow2;
            this.rFirst = cachedRow2 = cachedRow.b;
            if (cachedRow2 == cachedRow || (cachedRow2.e >> 3 & this.multiplierMask) != n2) {
                cachedRow2 = null;
            }
            this.rData[n2] = cachedRow2;
        }
        if (cachedRow == this.rFirst) {
            this.rFirst = this.rFirst.b;
            if (cachedRow == this.rFirst) {
                this.rFirst = null;
            }
        }
        cachedRow.a();
        --this.iCacheSize;
    }

    private CachedRow getWorst() throws SQLException {
        CachedRow cachedRow;
        if (this.rLastChecked == null) {
            this.rLastChecked = this.rFirst;
        }
        if ((cachedRow = this.rLastChecked) == null) {
            return null;
        }
        CachedRow cachedRow2 = cachedRow;
        int n2 = CachedRow.d;
        int n3 = 0;
        while (n3 < 6) {
            int n4 = cachedRow.a;
            if (n4 < n2) {
                cachedRow2 = cachedRow;
                n2 = n4;
            }
            cachedRow = cachedRow.b;
            ++n3;
        }
        this.rLastChecked = cachedRow.b;
        return cachedRow2;
    }

    public void saveAll() throws SQLException {
        if (this.rFirst == null) {
            return;
        }
        CachedRow cachedRow = this.rFirst;
        block0: while (true) {
            int n2 = 0;
            CachedRow cachedRow2 = cachedRow;
            do {
                if (!cachedRow.f()) continue;
                this.rWriter[n2++] = cachedRow;
            } while ((cachedRow = cachedRow.b) != cachedRow2 && n2 < this.writerLength);
            if (n2 == 0) {
                return;
            }
            this.saveSorted(n2);
            int n3 = 0;
            while (true) {
                if (n3 >= n2) continue block0;
                this.rWriter[n3] = null;
                ++n3;
            }
            break;
        }
    }

    public void saveRow(CachedRow cachedRow) throws IOException, SQLException {
        this.rFile.seek(cachedRow.e);
        DatabaseRowOutput databaseRowOutput = this.newCacheType ? new BinaryServerRowOutput(cachedRow.f) : new BinaryDatabaseRowOutput(cachedRow.f);
        cachedRow.a(databaseRowOutput);
        this.rFile.write(databaseRowOutput.toByteArray());
    }

    private void saveSorted(int n2) throws SQLException {
        Cache.sort(this.rWriter, 0, n2 - 1);
        try {
            int n3 = 0;
            while (n3 < n2) {
                this.saveRow(this.rWriter[n3]);
                ++n3;
            }
        }
        catch (Exception exception) {
            throw Trace.error(29, "saveSorted " + exception);
        }
    }

    private static final void sort(CachedRow[] cachedRowArray, int n2, int n3) throws SQLException {
        int n4;
        int n5;
        while (n3 - n2 > 10) {
            n5 = n3 + n2 >> 1;
            if (cachedRowArray[n2].e > cachedRowArray[n3].e) {
                Cache.swap(cachedRowArray, n2, n3);
            }
            if (cachedRowArray[n5].e < cachedRowArray[n2].e) {
                Cache.swap(cachedRowArray, n2, n5);
            } else if (cachedRowArray[n5].e > cachedRowArray[n3].e) {
                Cache.swap(cachedRowArray, n5, n3);
            }
            n4 = n3 - 1;
            Cache.swap(cachedRowArray, n5, n4);
            int n6 = cachedRowArray[n4].e;
            n5 = n2;
            while (true) {
                if (cachedRowArray[++n5].e < n6) {
                    continue;
                }
                while (cachedRowArray[--n4].e > n6) {
                }
                if (n5 >= n4) break;
                Cache.swap(cachedRowArray, n5, n4);
            }
            Cache.swap(cachedRowArray, n5, n3 - 1);
            Cache.sort(cachedRowArray, n2, n5 - 1);
            n2 = n5 + 1;
        }
        n5 = n2 + 1;
        while (n5 <= n3) {
            CachedRow cachedRow = cachedRowArray[n5];
            n4 = n5 - 1;
            while (n4 >= n2 && cachedRowArray[n4].e > cachedRow.e) {
                cachedRowArray[n4 + 1] = cachedRowArray[n4];
                --n4;
            }
            cachedRowArray[n4 + 1] = cachedRow;
            ++n5;
        }
    }

    private static void swap(CachedRow[] cachedRowArray, int n2, int n3) {
        CachedRow cachedRow = cachedRowArray[n2];
        cachedRowArray[n2] = cachedRowArray[n3];
        cachedRowArray[n3] = cachedRow;
    }

    public int f() {
        return this.iFreePos;
    }
}

