/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.hsqldb.Cache;
import org.hsqldb.Column;
import org.hsqldb.Constraint;
import org.hsqldb.DatabaseInformation;
import org.hsqldb.DatabaseScript;
import org.hsqldb.HsqlDatabaseProperties;
import org.hsqldb.HsqlName;
import org.hsqldb.Index;
import org.hsqldb.Library;
import org.hsqldb.Log;
import org.hsqldb.Parser;
import org.hsqldb.Record;
import org.hsqldb.Result;
import org.hsqldb.Select;
import org.hsqldb.Session;
import org.hsqldb.Table;
import org.hsqldb.TableWorks;
import org.hsqldb.TextTable;
import org.hsqldb.Tokenizer;
import org.hsqldb.Trace;
import org.hsqldb.Trigger;
import org.hsqldb.TriggerDef;
import org.hsqldb.User;
import org.hsqldb.UserManager;
import org.hsqldb.View;
import org.hsqldb.jdbcConnection;

public class Database {
    private String sName;
    private UserManager aAccess;
    private Vector tTable;
    private DatabaseInformation dInfo;
    public Logger a;
    public boolean b;
    private boolean bShutdown;
    private Hashtable hAlias;
    private boolean bIgnoreCase;
    private boolean bReferentialIntegrity;
    private Vector cSession;
    private HsqlDatabaseProperties databaseProperties;
    private Session sysSession;
    private static final int CALL = 1;
    private static final int CHECKPOINT = 2;
    private static final int COMMIT = 3;
    private static final int CONNECT = 4;
    private static final int CREATE = 5;
    private static final int DELETE = 6;
    private static final int DISCONNECT = 7;
    private static final int DROP = 8;
    private static final int GRANT = 9;
    private static final int INSERT = 10;
    private static final int REVOKE = 11;
    private static final int ROLLBACK = 12;
    private static final int SAVEPOINT = 13;
    private static final int SCRIPT = 14;
    private static final int SELECT = 15;
    private static final int SET = 16;
    private static final int SHUTDOWN = 17;
    private static final int UPDATE = 18;
    private static final int SEMICOLON = 19;
    private static final int ALTER = 20;
    private static final Hashtable hCommands = new Hashtable(37);

    public Database(String string) throws SQLException {
        if (Trace.TRACE) {
            Trace.b();
        }
        this.sName = string;
        this.open();
    }

    private void open() throws SQLException {
        this.tTable = new Vector();
        this.aAccess = new UserManager();
        this.cSession = new Vector();
        this.hAlias = new Hashtable();
        this.a = new Logger(this);
        this.bReferentialIntegrity = true;
        Library.a(this.hAlias);
        this.dInfo = new DatabaseInformation(this, this.tTable, this.aAccess);
        boolean bl2 = false;
        this.sysSession = new Session(this, new User(null, null, true, null), true, false, 0);
        this.a(this.sysSession);
        this.databaseProperties = new HsqlDatabaseProperties(this.sName);
        if (this.sName.equals(".")) {
            bl2 = true;
            this.databaseProperties.setProperty("sql.strict_fk", true);
        } else {
            bl2 = this.a.a(this, this.sysSession, this.sName);
        }
        HsqlName.a = 0;
        Library.a(this.databaseProperties.isPropertyTrue("sql.month"));
        Parser.a(this.databaseProperties.isPropertyTrue("sql.enforce_size"));
        Column.c(this.databaseProperties.isPropertyTrue("sql.compare_in_locale"));
        Record.gcFrequency = this.databaseProperties.getIntegerProperty("hsqldb.gc_interval", 0);
        if (bl2) {
            this.d("CREATE USER SA PASSWORD \"\" ADMIN", this.sysSession);
        }
        this.aAccess.b("PUBLIC", "CLASS \"java.lang.Math\"", 15);
        this.aAccess.b("PUBLIC", "CLASS \"org.hsqldb.Library\"", 15);
    }

    public String g() {
        return this.sName;
    }

    public HsqlDatabaseProperties c() {
        return this.databaseProperties;
    }

    public boolean f() {
        return this.bShutdown;
    }

    public synchronized Session a(String string, String string2) throws SQLException {
        int n2;
        User user = this.aAccess.a(string.toUpperCase(), string2.toUpperCase());
        int n3 = n2 = this.cSession.size();
        int n4 = 0;
        while (n4 < n2) {
            if (this.cSession.elementAt(n4) == null) {
                n3 = n4;
                break;
            }
            ++n4;
        }
        Session session = new Session(this, user, true, this.b, n3);
        this.a.a(session, "CONNECT USER " + string + " PASSWORD \"" + string2 + "\"");
        this.a(session);
        return session;
    }

    public void a(Session session) {
        int n2 = this.cSession.size();
        int n3 = session.b();
        if (n3 >= n2) {
            this.cSession.setSize(n3 + 1);
        }
        this.cSession.setElementAt(session, n3);
    }

    public byte[] a(String string, String string2, String string3) {
        Result result = null;
        try {
            Session session = this.a(string, string2);
            result = this.d(string3, session);
            this.d("DISCONNECT", session);
        }
        catch (SQLException sQLException) {
            result = new Result(sQLException.getMessage(), sQLException.getErrorCode());
        }
        catch (Exception exception) {
            result = new Result(exception.getMessage(), 40);
        }
        try {
            return result.b();
        }
        catch (Exception exception) {
            return new byte[0];
        }
    }

    public synchronized Result d(String string, Session session) {
        if (Record.gcFrequency != 0 && Record.memoryRecords > Record.gcFrequency) {
            System.gc();
            Trace.c("gc at " + Record.memoryRecords);
            Record.memoryRecords = 0;
        }
        if (Trace.TRACE) {
            Trace.b(string);
        }
        Result result = null;
        try {
            Tokenizer tokenizer = new Tokenizer(string);
            Parser parser = new Parser(this, tokenizer, session);
            this.a.a();
            Trace.a(session != null, 33);
            Trace.a(!this.bShutdown, 4);
            while (true) {
                tokenizer.e();
                session.d(false);
                String string2 = tokenizer.o();
                if (string2.length() != 0) {
                    Integer n2 = (Integer)hCommands.get(string2);
                    if (n2 == null) {
                        throw Trace.error(11, string2);
                    }
                    int n3 = n2;
                    switch (n3) {
                        case 15: {
                            result = parser.f();
                            break;
                        }
                        case 10: {
                            result = parser.d();
                            break;
                        }
                        case 18: {
                            result = parser.b();
                            break;
                        }
                        case 6: {
                            result = parser.a();
                            break;
                        }
                        case 1: {
                            result = parser.e();
                            break;
                        }
                        case 16: {
                            result = this.processSet(tokenizer, session);
                            break;
                        }
                        case 3: {
                            result = this.processCommit(tokenizer, session);
                            session.d(true);
                            break;
                        }
                        case 12: {
                            result = this.processRollback(tokenizer, session);
                            session.d(true);
                            break;
                        }
                        case 13: {
                            result = this.processSavepoint(tokenizer, session);
                            session.d(true);
                            break;
                        }
                        case 5: {
                            result = this.processCreate(tokenizer, session);
                            break;
                        }
                        case 20: {
                            result = this.processAlter(tokenizer, session);
                            break;
                        }
                        case 8: {
                            result = this.processDrop(tokenizer, session);
                            break;
                        }
                        case 9: {
                            result = this.processGrantOrRevoke(tokenizer, session, true);
                            break;
                        }
                        case 11: {
                            result = this.processGrantOrRevoke(tokenizer, session, false);
                            break;
                        }
                        case 4: {
                            result = this.processConnect(tokenizer, session);
                            break;
                        }
                        case 7: {
                            result = this.processDisconnect(session);
                            break;
                        }
                        case 14: {
                            result = this.processScript(tokenizer, session);
                            break;
                        }
                        case 17: {
                            result = this.processShutdown(tokenizer, session);
                            break;
                        }
                        case 2: {
                            result = this.processCheckpoint(session);
                            break;
                        }
                    }
                    if (!session.d()) continue;
                    this.a.a(session, tokenizer.a());
                    continue;
                }
                break;
            }
        }
        catch (SQLException sQLException) {
            result = new Result(sQLException.getMessage() + " in statement [" + string + "]", sQLException.getErrorCode());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            String string3 = Trace.b(40) + " " + exception;
            result = new Result(string3 + " in statement [" + string + "]", 40);
        }
        catch (OutOfMemoryError outOfMemoryError) {
            outOfMemoryError.printStackTrace();
            result = new Result("out of memory", 40);
        }
        return result == null ? new Result() : result;
    }

    public void i() {
        this.b = true;
    }

    public Vector a() {
        return this.tTable;
    }

    public UserManager h() {
        return this.aAccess;
    }

    public void a(boolean bl2) {
        this.bReferentialIntegrity = bl2;
    }

    public boolean b() {
        return this.bReferentialIntegrity;
    }

    public Hashtable e() {
        return this.hAlias;
    }

    public String b(String string) {
        String string2 = (String)this.hAlias.get(string);
        return string2 == null ? string : string2;
    }

    public Table c(String string, Session session) throws SQLException {
        Table table = this.b(string, session);
        if (table == null) {
            table = this.dInfo.a(string, session);
        }
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    public Table a(String string, Session session) throws SQLException {
        Table table = this.b(string, session);
        if (table == null) {
            throw Trace.error(22, string);
        }
        return table;
    }

    public Table a(String string) {
        int n2 = 0;
        int n3 = this.tTable.size();
        while (n2 < n3) {
            Table table = (Table)this.tTable.elementAt(n2);
            if (table.e(string)) {
                return table;
            }
            ++n2;
        }
        return null;
    }

    public Table b(String string, Session session) {
        int n2 = 0;
        int n3 = this.tTable.size();
        while (n2 < n3) {
            Table table = (Table)this.tTable.elementAt(n2);
            if (table.a(string, session)) {
                return table;
            }
            ++n2;
        }
        return null;
    }

    public Result a(boolean bl2, boolean bl3, boolean bl4, Session session) throws SQLException {
        return DatabaseScript.a(this, bl2, bl3, bl4, session);
    }

    public void c(Table table) throws SQLException {
        this.tTable.addElement(table);
    }

    public boolean d() {
        return this.bIgnoreCase;
    }

    private Result processScript(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.o();
        if (tokenizer.p()) {
            string = (String)tokenizer.g();
            Log.a(this, string, true, session);
            return new Result();
        }
        tokenizer.j();
        return this.a(false, true, false, session);
    }

    private Result processCreate(Tokenizer tokenizer, Session session) throws SQLException {
        session.j();
        session.c();
        String string = tokenizer.o();
        boolean bl2 = false;
        if (string.equals("TEMP")) {
            bl2 = true;
            string = tokenizer.o();
            Trace.a(string.equals("TABLE") || string.equals("MEMORY") || string.equals("TEXT"), 11, string);
            session.d(false);
        } else {
            session.j();
            session.c();
            session.d(true);
        }
        if (string.equals("TABLE")) {
            int n2 = bl2 ? 1 : 2;
            this.processCreateTable(tokenizer, session, n2);
        } else if (string.equals("MEMORY")) {
            tokenizer.a("TABLE");
            int n3 = bl2 ? 1 : 2;
            this.processCreateTable(tokenizer, session, n3);
        } else if (string.equals("CACHED")) {
            tokenizer.a("TABLE");
            this.processCreateTable(tokenizer, session, 3);
        } else if (string.equals("TEXT")) {
            tokenizer.a("TABLE");
            int n4 = bl2 ? 4 : 5;
            this.processCreateTable(tokenizer, session, n4);
        } else if (string.equals("VIEW")) {
            this.processCreateView(tokenizer, session);
        } else if (string.equals("TRIGGER")) {
            this.processCreateTrigger(tokenizer, session);
        } else if (string.equals("USER")) {
            String string2 = tokenizer.d();
            tokenizer.a("PASSWORD");
            String string3 = tokenizer.d();
            boolean bl3 = tokenizer.o().equals("ADMIN");
            this.aAccess.a(string2, string3, bl3);
        } else if (string.equals("ALIAS")) {
            String string4 = tokenizer.o();
            string = tokenizer.o();
            Trace.a(string.equals("FOR"), 11, string);
            string = tokenizer.o();
            if (string.startsWith("org.hsql.Library.")) {
                string = "org.hsqldb.Library." + string.substring("org.hsql.Library.".length());
            } else if (string.equals("java.lang.Math.abs")) {
                string = "org.hsqldb.Library.abs";
            }
            this.hAlias.put(string4, string);
        } else {
            boolean bl4 = false;
            if (string.equals("UNIQUE")) {
                bl4 = true;
                string = tokenizer.o();
            }
            if (!string.equals("INDEX")) {
                throw Trace.error(11, string);
            }
            String string5 = tokenizer.l();
            boolean bl5 = tokenizer.n();
            tokenizer.a("ON");
            Table table = this.c(tokenizer.l(), session);
            this.addIndexOn(tokenizer, session, string5, bl5, table, bl4);
        }
        return new Result();
    }

    private int[] processColumnList(Tokenizer tokenizer, Table table) throws SQLException {
        Object object;
        Hashtable<String, String> hashtable;
        Vector<String> vector;
        block3: {
            vector = new Vector<String>();
            hashtable = new Hashtable<String, String>();
            tokenizer.a("(");
            do {
                String string = tokenizer.l();
                vector.addElement(string);
                hashtable.put(string, string);
                object = tokenizer.o();
                if (((String)object).equals(")")) break block3;
            } while (((String)object).equals(","));
            throw Trace.error(11, (String)object);
        }
        int n2 = vector.size();
        if (n2 != hashtable.size()) {
            throw Trace.error(27, "duplicate column in list");
        }
        object = new int[n2];
        int n3 = 0;
        while (n3 < n2) {
            object[n3] = table.g((String)vector.elementAt(n3));
            ++n3;
        }
        return object;
    }

    private void addIndexOn(Tokenizer tokenizer, Session session, String string, boolean bl2, Table table, boolean bl3) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        HsqlName hsqlName = HsqlName.isReservedName(string) ? HsqlName.makeAutoName("USER", string) : new HsqlName(string, bl2);
        if (this.findIndex(string) != null) {
            throw Trace.error(23);
        }
        session.n();
        session.d(!table.p());
        TableWorks tableWorks = new TableWorks(table);
        tableWorks.a(nArray, hsqlName, bl3);
    }

    private Index findIndex(String string) {
        Table table = this.findTableForIndex(string);
        if (table == null) {
            return null;
        }
        return table.d(string);
    }

    private Table findTableForIndex(String string) {
        int n2 = 0;
        int n3 = this.tTable.size();
        while (n2 < n3) {
            Table table = (Table)this.tTable.elementAt(n2);
            if (table.d(string) != null) {
                return table;
            }
            ++n2;
        }
        return null;
    }

    public int a(Table table) {
        int n2 = 0;
        int n3 = this.tTable.size();
        while (n2 < n3) {
            Table table2 = (Table)this.tTable.elementAt(n2);
            if (table2 == table) {
                return n2;
            }
            ++n2;
        }
        return -1;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processCreateTrigger(Tokenizer tokenizer, Session session) throws SQLException {
        boolean bl2 = false;
        boolean bl3 = false;
        int n2 = TriggerDef.getDefaultQueueSize();
        String string = tokenizer.l();
        String string2 = tokenizer.o();
        String string3 = tokenizer.o();
        tokenizer.a("ON");
        String string4 = tokenizer.o();
        Table table = this.c(string4, session);
        if (table.m()) {
            throw Trace.error(55);
        }
        session.d(!table.p());
        String string5 = tokenizer.o();
        if (string5.equals("FOR")) {
            string5 = tokenizer.o();
            if (!string5.equals("EACH")) throw Trace.error(12, string5);
            string5 = tokenizer.o();
            if (!string5.equals("ROW")) throw Trace.error(12, string5);
            bl2 = true;
            string5 = tokenizer.o();
        }
        if (string5.equals("NOWAIT")) {
            bl3 = true;
            string5 = tokenizer.o();
        }
        if (string5.equals("QUEUE")) {
            n2 = Integer.parseInt(tokenizer.o());
            string5 = tokenizer.o();
        }
        if (!string5.equals("CALL")) {
            throw Trace.error(12, string5);
        }
        String string6 = tokenizer.o();
        try {
            Class<?> clazz = Class.forName(string6);
            Trigger trigger = (Trigger)clazz.newInstance();
            TriggerDef triggerDef = new TriggerDef(string, string2, string3, bl2, table, trigger, "\"" + string6 + "\"", bl3, n2);
            if (!triggerDef.isValid()) {
                String string7 = "Error in parsing trigger command ";
                throw Trace.error(11, string7);
            }
            table.a(triggerDef);
            triggerDef.start();
            return;
        }
        catch (Exception exception) {
            String string8 = "Exception in loading trigger class " + exception.getMessage();
            throw Trace.error(13, string8);
        }
    }

    private Column processCreateColumn(Tokenizer tokenizer, Table table) throws SQLException {
        String string;
        String string2;
        boolean bl2 = false;
        boolean bl3 = false;
        String string3 = string2 = tokenizer.o();
        boolean bl4 = tokenizer.n();
        String string4 = tokenizer.o();
        int n2 = Column.a(string4);
        Trace.a(!string3.equals(""), 27, string3);
        if (string4.equals("IDENTITY")) {
            bl2 = true;
            bl3 = true;
        }
        if (n2 == 12 && this.bIgnoreCase) {
            n2 = 100;
        }
        string2 = tokenizer.o();
        if (n2 == 8 && string2.equals("PRECISION")) {
            string2 = tokenizer.o();
        }
        String string5 = "";
        if (string2.equals("(")) {
            do {
                if ((string2 = tokenizer.o()).equals(")")) continue;
                string5 = string5 + string2;
            } while (!string2.equals(")"));
            string2 = tokenizer.o();
        }
        int n3 = 0;
        int n4 = 0;
        int n5 = string5.indexOf(",");
        if (n5 != -1) {
            string = string5.substring(n5 + 1, string5.length());
            string5 = string5.substring(0, n5);
            try {
                n4 = Integer.parseInt(string.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        if (string5.trim().length() > 0) {
            try {
                n3 = Integer.parseInt(string5.trim());
            }
            catch (NumberFormatException numberFormatException) {
                throw Trace.error(11, string5);
            }
        }
        string = null;
        if (string2.equals("DEFAULT")) {
            String string6 = tokenizer.o();
            if (tokenizer.p() && n2 != -2 && n2 != 1111) {
                Object object = tokenizer.g();
                if (object != null) {
                    string = String.valueOf(object);
                    try {
                        Column.a((Object)string, n2);
                    }
                    catch (Exception exception) {
                        throw Trace.error(46, string);
                    }
                    String string7 = (String)Parser.a(string, n2, n3, false);
                    if (!string.equals(string7)) {
                        throw Trace.error(46, string);
                    }
                }
            } else {
                throw Trace.error(46, string6);
            }
            string2 = tokenizer.o();
        }
        boolean bl5 = true;
        if (string2.equals("NULL")) {
            string2 = tokenizer.o();
        } else if (string2.equals("NOT")) {
            tokenizer.a("NULL");
            bl5 = false;
            string2 = tokenizer.o();
        }
        if (string2.equals("IDENTITY")) {
            bl2 = true;
            string2 = tokenizer.o();
            bl3 = true;
        }
        if (string2.equals("PRIMARY")) {
            tokenizer.a("KEY");
            bl3 = true;
        } else {
            tokenizer.j();
        }
        return new Column(new HsqlName(string3, bl4), bl5, n2, n3, n4, bl2, bl3, string);
    }

    private void processCreateTable(Tokenizer tokenizer, Session session, int n2) throws SQLException {
        Object object;
        String string = tokenizer.l();
        boolean bl2 = tokenizer.n();
        if (DatabaseInformation.a(string) || this.b(string, session) != null) {
            throw Trace.error(21, string);
        }
        Table table = n2 == 4 || n2 == 5 ? new TextTable(this, new HsqlName(string, bl2), n2, session) : new Table(this, new HsqlName(string, bl2), n2, session);
        tokenizer.a("(");
        int[] nArray = null;
        int n3 = 0;
        boolean bl3 = false;
        while (true) {
            string = tokenizer.o();
            bl2 = tokenizer.n();
            if (string.equals("CONSTRAINT") || string.equals("PRIMARY") || string.equals("FOREIGN") || string.equals("UNIQUE")) {
                tokenizer.j();
                bl3 = true;
                break;
            }
            tokenizer.j();
            object = this.processCreateColumn(tokenizer, table);
            table.a((Column)object);
            if (((Column)object).g()) {
                Trace.a(nArray == null, 24, "column " + n3);
                nArray = new int[]{n3};
            }
            if ((string = tokenizer.o()).equals(")")) break;
            if (!string.equals(",")) {
                throw Trace.error(11, string);
            }
            ++n3;
        }
        try {
            Object object2;
            int n4;
            HsqlName hsqlName;
            TempConstraint tempConstraint;
            block21: {
                object = new Vector();
                tempConstraint = new TempConstraint(this, null, nArray, null, null, 1, false);
                hsqlName = null;
                ((Vector)object).addElement(tempConstraint);
                if (bl3) {
                    n4 = 0;
                    do {
                        string = tokenizer.o();
                        HsqlName hsqlName2 = null;
                        ++n4;
                        if (string.equals("CONSTRAINT")) {
                            hsqlName2 = new HsqlName(tokenizer.l(), tokenizer.n());
                            string = tokenizer.o();
                        }
                        if (string.equals("PRIMARY")) {
                            tokenizer.a("KEY");
                            hsqlName = hsqlName2;
                            object2 = this.processColumnList(tokenizer, table);
                            TempConstraint tempConstraint2 = (TempConstraint)((Vector)object).elementAt(0);
                            Trace.a(tempConstraint2.b == null, 24);
                            tempConstraint2.b = object2;
                        } else if (string.equals("UNIQUE")) {
                            object2 = this.processColumnList(tokenizer, table);
                            if (hsqlName2 == null) {
                                hsqlName2 = HsqlName.makeAutoName("CT");
                            }
                            tempConstraint = new TempConstraint(this, hsqlName2, (int[])object2, null, null, 2, false);
                            ((Vector)object).addElement(tempConstraint);
                        } else if (string.equals("FOREIGN")) {
                            tokenizer.a("KEY");
                            tempConstraint = this.a(tokenizer, session, table, hsqlName2);
                            if (tempConstraint.a == null) {
                                object2 = (TempConstraint)((Vector)object).elementAt(0);
                                tempConstraint.a = ((TempConstraint)object2).b;
                                if (tempConstraint.a == null) {
                                    throw Trace.error(26, "table has no primary key");
                                }
                            }
                            table.a(tempConstraint.b, tempConstraint.d, tempConstraint.a);
                            ((Vector)object).addElement(tempConstraint);
                        }
                        string = tokenizer.o();
                        if (string.equals(")")) break block21;
                    } while (string.equals(","));
                    throw Trace.error(11, string);
                }
            }
            session.n();
            tempConstraint = (TempConstraint)((Vector)object).elementAt(0);
            table.a(hsqlName, tempConstraint.b);
            n4 = 0;
            int n5 = 1;
            while (n5 < ((Vector)object).size()) {
                tempConstraint = (TempConstraint)((Vector)object).elementAt(n5);
                if (tempConstraint.c == 2) {
                    object2 = new TableWorks(table);
                    ((TableWorks)object2).a(tempConstraint.b, tempConstraint.f);
                    table = ((TableWorks)object2).a();
                }
                if (tempConstraint.c == 0) {
                    object2 = new TableWorks(table);
                    ((TableWorks)object2).a(tempConstraint.b, tempConstraint.a, tempConstraint.f, tempConstraint.d, tempConstraint.e);
                    table = ((TableWorks)object2).a();
                }
                ++n5;
            }
            this.c(table);
        }
        catch (SQLException sQLException) {
            this.b(table);
            throw sQLException;
        }
    }

    public TempConstraint a(Tokenizer tokenizer, Session session, Table table, HsqlName hsqlName) throws SQLException {
        int[] nArray = this.processColumnList(tokenizer, table);
        tokenizer.a("REFERENCES");
        String string = tokenizer.o();
        Table table2 = table.e(string) ? table : this.c(string, session);
        int[] nArray2 = null;
        String string2 = tokenizer.o();
        tokenizer.j();
        if (string2.equals("(")) {
            nArray2 = this.processColumnList(tokenizer, table2);
        } else {
            Index index = table2.v();
            if (index != null && (nArray2 = index.f())[0] == table2.g()) {
                throw Trace.error(26, string + " has no primary key");
            }
        }
        string2 = tokenizer.o();
        boolean bl2 = false;
        if (string2.equals("ON")) {
            tokenizer.a("DELETE");
            tokenizer.a("CASCADE");
            bl2 = true;
        } else {
            tokenizer.j();
        }
        if (hsqlName == null) {
            hsqlName = HsqlName.makeAutoName("FK");
        }
        return new TempConstraint(this, hsqlName, nArray, table2, nArray2, 0, bl2);
    }

    private void processCreateView(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.l();
        int n2 = tokenizer.c();
        if (this.b(string, session) != null) {
            throw Trace.error(52, string);
        }
        View view = new View(this, new HsqlName(string, tokenizer.n()));
        tokenizer.a("AS");
        tokenizer.e();
        tokenizer.a("SELECT");
        Parser parser = new Parser(this, tokenizer, session);
        int n3 = session.l();
        Select select = parser.c();
        if (select.e != null) {
            throw Trace.error(22);
        }
        select.b();
        Result result = select.b(1);
        view.h(tokenizer.a());
        view.a(result);
        session.n();
        this.tTable.addElement(view);
        tokenizer.a(n2);
    }

    private void processRenameTable(Tokenizer tokenizer, Session session, String string) throws SQLException {
        String string2 = tokenizer.l();
        boolean bl2 = tokenizer.n();
        Table table = this.a(string);
        if (table == null || !table.a(string, session)) {
            throw Trace.error(22, string);
        }
        Table table2 = this.a(string2);
        if (table2 != null && table2.a(table2.r().d, session)) {
            throw Trace.error(21, string);
        }
        session.n();
        session.d(!table.p());
        table.a(string2, bl2);
    }

    private Result processAlter(Tokenizer tokenizer, Session session) throws SQLException {
        session.j();
        session.c();
        session.d(true);
        String string = tokenizer.o();
        if (string.equals("TABLE")) {
            this.processAlterTable(tokenizer, session);
        } else if (string.equals("INDEX")) {
            this.processAlterIndex(tokenizer, session);
        } else {
            throw Trace.error(11, string);
        }
        return new Result();
    }

    private void processAlterTable(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.o();
        Table table = this.a(string, session);
        TableWorks tableWorks = new TableWorks(table);
        String string2 = tokenizer.o();
        session.d(!table.p());
        if (string2.equals("RENAME")) {
            tokenizer.a("TO");
            this.processRenameTable(tokenizer, session, string);
            return;
        }
        if (string2.equals("ADD")) {
            string2 = tokenizer.o();
            if (string2.equals("CONSTRAINT")) {
                HsqlName hsqlName = new HsqlName(tokenizer.l(), tokenizer.n());
                string2 = tokenizer.o();
                if (string2.equals("FOREIGN")) {
                    tokenizer.a("KEY");
                    TempConstraint tempConstraint = this.a(tokenizer, session, table, hsqlName);
                    table.a(tempConstraint.b, tempConstraint.d, tempConstraint.a);
                    session.n();
                    tableWorks.a(tempConstraint.b, tempConstraint.a, tempConstraint.f, tempConstraint.d, tempConstraint.e);
                    return;
                }
                if (string2.equals("UNIQUE")) {
                    int[] nArray = this.processColumnList(tokenizer, table);
                    session.n();
                    tableWorks.a(nArray, hsqlName);
                    return;
                }
                throw Trace.error(11, string2);
            }
            if (string2.equals("COLUMN")) {
                int n2 = table.g();
                Column column = this.processCreateColumn(tokenizer, table);
                string2 = tokenizer.o();
                if (string2.equals("BEFORE")) {
                    string2 = tokenizer.l();
                    n2 = table.g(string2);
                } else {
                    tokenizer.j();
                }
                if (column.e() || column.g() || !table.o() && !column.f() && column.d() == null) {
                    throw Trace.error(58);
                }
                session.n();
                tableWorks.a(column, n2, 1);
                return;
            }
        } else {
            if (string2.equals("DROP")) {
                string2 = tokenizer.o();
                if (string2.equals("CONSTRAINT")) {
                    String string3 = tokenizer.l();
                    session.n();
                    tableWorks.b(string3);
                    return;
                }
                if (string2.equals("COLUMN")) {
                    string2 = tokenizer.l();
                    int n3 = table.g(string2);
                    session.n();
                    tableWorks.a(null, n3, -1);
                    return;
                }
                throw Trace.error(11, string2);
            }
            throw Trace.error(11, string2);
        }
    }

    private void processAlterIndex(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.l();
        tokenizer.a("RENAME");
        tokenizer.a("TO");
        String string2 = tokenizer.l();
        boolean bl2 = tokenizer.n();
        Table table = this.findTableForIndex(string);
        if (table == null || !table.a(table.r().d, session)) {
            throw Trace.error(26, string);
        }
        Table table2 = this.findTableForIndex(string2);
        if (table2 != null && table2.a(table2.r().d, session)) {
            throw Trace.error(23, string);
        }
        if (HsqlName.isReservedName(string)) {
            throw Trace.error(56, string);
        }
        if (HsqlName.isReservedName(string2)) {
            throw Trace.error(49, string);
        }
        session.d(!table.p());
        session.n();
        table.d(string).a(string2, bl2);
    }

    private Result processDrop(Tokenizer tokenizer, Session session) throws SQLException {
        session.j();
        session.c();
        session.d(true);
        String string = tokenizer.o();
        if (string.equals("TABLE") || string.equals("VIEW")) {
            boolean bl2 = string.equals("VIEW");
            String string2 = tokenizer.o();
            boolean bl3 = false;
            string = tokenizer.o();
            if (string.equals("IF")) {
                tokenizer.a("EXISTS");
                bl3 = true;
            } else {
                tokenizer.j();
                Table table = this.c(string2, session);
                session.d(!table.p());
            }
            this.a(string2, bl3, bl2, session);
            session.n();
        } else if (string.equals("USER")) {
            this.aAccess.a(tokenizer.d());
        } else if (string.equals("TRIGGER")) {
            this.dropTrigger(tokenizer.o(), session);
        } else if (string.equals("INDEX")) {
            String string3 = tokenizer.l();
            Table table = this.findTableForIndex(string3);
            if (table == null || !table.a(table.r().d, session)) {
                throw Trace.error(26, string3);
            }
            table.a(string3, (Hashtable)null);
            session.n();
            session.d(!table.p());
            TableWorks tableWorks = new TableWorks(table);
            tableWorks.a(string3);
        } else {
            throw Trace.error(11, string);
        }
        return new Result();
    }

    private Result processGrantOrRevoke(Tokenizer tokenizer, Session session, boolean bl2) throws SQLException {
        Object object;
        String string;
        String string2;
        session.j();
        session.c();
        session.d(true);
        int n2 = 0;
        do {
            string = tokenizer.o();
            n2 |= UserManager.b(string);
        } while ((string2 = tokenizer.o()).equals(","));
        if (!string2.equals("ON")) {
            throw Trace.error(11, string2);
        }
        string = tokenizer.o();
        if (string.equals("CLASS")) {
            string = string + " \"" + tokenizer.o() + "\"";
        } else {
            object = this.c(string, session);
            session.d(!((Table)object).p());
        }
        tokenizer.a("TO");
        object = tokenizer.d();
        if (bl2) {
            this.aAccess.b((String)object, string, n2);
            String string3 = "GRANT";
        } else {
            this.aAccess.a((String)object, string, n2);
            String string4 = "REVOKE";
        }
        return new Result();
    }

    private Result processConnect(Tokenizer tokenizer, Session session) throws SQLException {
        tokenizer.a("USER");
        String string = tokenizer.d();
        tokenizer.a("PASSWORD");
        String string2 = tokenizer.d();
        User user = this.aAccess.a(string, string2);
        session.n();
        session.a(user);
        return new Result();
    }

    private Result processDisconnect(Session session) throws SQLException {
        if (!session.h()) {
            session.p();
            this.cSession.setElementAt(null, session.b());
        }
        return new Result();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Result processSet(Tokenizer tokenizer, Session session) throws SQLException {
        session.d(true);
        String string = tokenizer.o();
        if (string.equals("PASSWORD")) {
            session.j();
            session.b(tokenizer.d());
            return new Result();
        } else if (string.equals("READONLY")) {
            session.n();
            session.b(this.processTrueOrFalse(tokenizer));
            return new Result();
        } else if (string.equals("LOGSIZE")) {
            session.c();
            int n2 = Integer.parseInt(tokenizer.o());
            this.a.a(n2);
            return new Result();
        } else if (string.equals("IGNORECASE")) {
            session.c();
            this.bIgnoreCase = this.processTrueOrFalse(tokenizer);
            return new Result();
        } else if (string.equals("MAXROWS")) {
            int n3 = Integer.parseInt(tokenizer.o());
            session.a(n3);
            return new Result();
        } else if (string.equals("AUTOCOMMIT")) {
            session.c(this.processTrueOrFalse(tokenizer));
            return new Result();
        } else if (string.equals("TABLE")) {
            session.j();
            Table table = this.c(tokenizer.o(), session);
            string = tokenizer.o();
            session.d(!table.p());
            if (string.equals("SOURCE")) {
                if (!table.p()) {
                    session.c();
                }
                string = tokenizer.o();
                if (!tokenizer.n()) {
                    throw Trace.error(7);
                }
                boolean bl2 = false;
                if (tokenizer.o().equals("DESC")) {
                    bl2 = true;
                } else {
                    tokenizer.j();
                }
                table.setDataSource(string, bl2, session);
                return new Result();
            } else if (string.equals("READONLY")) {
                session.c();
                table.a(this.processTrueOrFalse(tokenizer));
                return new Result();
            } else {
                if (!string.equals("INDEX")) throw Trace.error(11, string);
                session.c();
                tokenizer.o();
                table.c((String)tokenizer.g());
            }
            return new Result();
        } else if (string.equals("REFERENTIAL_INTEGRITY")) {
            session.c();
            this.bReferentialIntegrity = this.processTrueOrFalse(tokenizer);
            return new Result();
        } else {
            if (!string.equals("WRITE_DELAY")) throw Trace.error(11, string);
            session.c();
            boolean bl3 = this.processTrueOrFalse(tokenizer);
            this.a.a(bl3);
        }
        return new Result();
    }

    private boolean processTrueOrFalse(Tokenizer tokenizer) throws SQLException {
        String string = tokenizer.o();
        if (string.equals("TRUE")) {
            return true;
        }
        if (string.equals("FALSE")) {
            return false;
        }
        throw Trace.error(11, string);
    }

    private Result processCommit(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.o();
        if (!string.equals("WORK")) {
            tokenizer.j();
        }
        session.n();
        return new Result();
    }

    private Result processRollback(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.o();
        if (string.equals("TO")) {
            String string2 = tokenizer.o();
            if (!string2.equals("SAVEPOINT")) {
                throw Trace.error(11, string2);
            }
            string2 = tokenizer.o();
            if (string2.length() == 0) {
                throw Trace.error(11, string2);
            }
            session.a(string2);
            return new Result();
        }
        if (!string.equals("WORK")) {
            tokenizer.j();
        }
        session.e();
        return new Result();
    }

    private Result processSavepoint(Tokenizer tokenizer, Session session) throws SQLException {
        String string = tokenizer.o();
        if (string.length() == 0) {
            throw Trace.error(11, string);
        }
        session.c(string);
        return new Result();
    }

    public void finalize() {
        try {
            this.close(-1);
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    private void close(int n2) throws SQLException {
        this.a.b(n2);
        if (n2 == 1) {
            this.open();
            this.a.b(0);
        }
        this.bShutdown = true;
        jdbcConnection.a(this);
    }

    private Result processShutdown(Tokenizer tokenizer, Session session) throws SQLException {
        if (!session.h()) {
            session.c();
        }
        int n2 = 0;
        String string = tokenizer.o();
        if (string.equals("IMMEDIATELY")) {
            n2 = -1;
        } else if (string.equals("COMPACT")) {
            n2 = 1;
        } else {
            tokenizer.j();
        }
        int n3 = 1;
        int n4 = this.cSession.size();
        while (n3 < n4) {
            Session session2 = (Session)this.cSession.elementAt(n3);
            if (session2 != null) {
                session2.p();
            }
            ++n3;
        }
        this.cSession.removeAllElements();
        this.close(n2);
        this.processDisconnect(session);
        return new Result();
    }

    private Result processCheckpoint(Session session) throws SQLException {
        session.c();
        session.j();
        Logger.a(this.a);
        return new Result();
    }

    public void b(Session session) {
        int n2 = 0;
        while (n2 < this.tTable.size()) {
            Table table = (Table)this.tTable.elementAt(n2);
            if (table.p() && table.s() == session) {
                this.tTable.removeElementAt(n2);
            }
            ++n2;
        }
    }

    public void a(String string, boolean bl2, boolean bl3, Session session) throws SQLException {
        Table table = null;
        int n2 = -1;
        int n3 = -1;
        Enumeration enumeration = null;
        Constraint constraint = null;
        Table table2 = null;
        boolean bl4 = false;
        boolean bl5 = false;
        int n4 = 0;
        while (n4 < this.tTable.size()) {
            table = (Table)this.tTable.elementAt(n4);
            if (table.a(string, session) && bl3 == table.m()) {
                n2 = n4;
                break;
            }
            table = null;
            ++n4;
        }
        if (n2 == -1) {
            if (bl2) {
                return;
            }
            throw Trace.error(bl3 ? 53 : 22, string);
        }
        enumeration = table.n().elements();
        while (enumeration.hasMoreElements()) {
            constraint = (Constraint)enumeration.nextElement();
            if (constraint.d() != 1) continue;
            table2 = constraint.f();
            bl4 = table2 != null;
            boolean bl6 = bl5 = bl4 && table.equals(table2);
            if (!bl4 || bl5) continue;
            int n5 = 0;
            while (n5 < this.tTable.size()) {
                if (table2.equals(this.tTable.elementAt(n5))) {
                    n3 = n5;
                    break;
                }
                ++n5;
            }
            if (n3 == -1) continue;
            throw Trace.error(8, constraint.g().d + " table: " + table2.r().d);
        }
        if (table.j()) {
            table.setDataSource("", false, session);
        }
        this.tTable.removeElementAt(n2);
        this.b(table);
    }

    public void b(Table table) {
        int n2 = 0;
        while (n2 < this.tTable.size()) {
            Vector vector = ((Table)this.tTable.elementAt(n2)).n();
            int n3 = vector.size() - 1;
            while (n3 >= 0) {
                Constraint constraint = (Constraint)vector.elementAt(n3);
                Table table2 = constraint.f();
                if (table == table2) {
                    vector.removeElementAt(n3);
                }
                --n3;
            }
            ++n2;
        }
    }

    private void dropTrigger(String string, Session session) throws SQLException {
        boolean bl2 = false;
        int n2 = 0;
        int n3 = this.tTable.size();
        while (n2 < n3) {
            Table table = (Table)this.tTable.elementAt(n2);
            int n4 = TriggerDef.numTrigs();
            int n5 = 0;
            while (n5 < n4) {
                Vector vector = table.a[n5];
                int n6 = vector.size() - 1;
                while (n6 >= 0) {
                    TriggerDef triggerDef = (TriggerDef)vector.elementAt(n6);
                    if (triggerDef.i.equals(string)) {
                        session.d(!triggerDef.a.p());
                        vector.removeElementAt(n6);
                        bl2 = true;
                        if (Trace.TRACE) {
                            Trace.b("Trigger dropped " + string);
                        }
                    }
                    --n6;
                }
                ++n5;
            }
            ++n2;
        }
        Trace.a(bl2, 43, string);
    }

    static {
        hCommands.put("ALTER", new Integer(20));
        hCommands.put("CALL", new Integer(1));
        hCommands.put("CHECKPOINT", new Integer(2));
        hCommands.put("COMMIT", new Integer(3));
        hCommands.put("CONNECT", new Integer(4));
        hCommands.put("CREATE", new Integer(5));
        hCommands.put("DELETE", new Integer(6));
        hCommands.put("DISCONNECT", new Integer(7));
        hCommands.put("DROP", new Integer(8));
        hCommands.put("GRANT", new Integer(9));
        hCommands.put("INSERT", new Integer(10));
        hCommands.put("REVOKE", new Integer(11));
        hCommands.put("ROLLBACK", new Integer(12));
        hCommands.put("SAVEPOINT", new Integer(13));
        hCommands.put("SCRIPT", new Integer(14));
        hCommands.put("SELECT", new Integer(15));
        hCommands.put("SET", new Integer(16));
        hCommands.put("SHUTDOWN", new Integer(17));
        hCommands.put("UPDATE", new Integer(18));
        hCommands.put(";", new Integer(19));
    }

    public class Logger {
        private Log lLog;
        private final Database this$0;

        public Logger(Database database) {
            this.this$0 = database;
        }

        public boolean a(Database database, Session session, String string) throws SQLException {
            this.lLog = new Log(database, session, string);
            boolean bl2 = this.lLog.g();
            return bl2;
        }

        public void b(int n2) throws SQLException {
            if (this.lLog == null) {
                return;
            }
            this.lLog.f();
            switch (n2) {
                case -1: {
                    this.lLog.e();
                    break;
                }
                case 0: {
                    this.lLog.c(false);
                    break;
                }
                case 1: {
                    this.lLog.c(true);
                }
            }
            this.lLog = null;
        }

        public boolean b() {
            return this.lLog != null;
        }

        public Cache c() throws SQLException {
            if (this.lLog != null) {
                return this.lLog.b();
            }
            return null;
        }

        public void a() throws SQLException {
            if (this.lLog != null && this.lLog.b() != null) {
                this.lLog.b().a();
            }
        }

        public void a(Session session, String string) throws SQLException {
            if (this.lLog != null) {
                this.lLog.a(session, string);
            }
        }

        private void checkpoint() throws SQLException {
            if (this.lLog != null) {
                this.lLog.c();
            }
        }

        public void a(int n2) {
            if (this.lLog != null) {
                this.lLog.a(n2);
            }
        }

        public void a(boolean bl2) {
            if (this.lLog != null) {
                this.lLog.b(bl2);
            }
        }

        public Cache a(String string, String string2, boolean bl2, boolean bl3) throws SQLException {
            return this.lLog.a(string, string2, bl2, bl3);
        }

        public void a(String string) throws SQLException {
            this.lLog.a(string);
        }

        public static void a(Logger logger) throws SQLException {
            logger.checkpoint();
        }
    }

    private class TempConstraint {
        public HsqlName f;
        public int[] b;
        public Table d;
        public int[] a;
        public int c;
        public boolean e;
        private final Database this$0;

        public TempConstraint(Database database, HsqlName hsqlName, int[] nArray, Table table, int[] nArray2, int n2, boolean bl2) {
            this.this$0 = database;
            this.f = hsqlName;
            this.c = n2;
            this.b = nArray;
            this.d = table;
            this.a = nArray2;
            this.e = bl2;
        }
    }
}

